/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.AddtlInfo;
import com.ibm.nzna.projects.common.quest.oa.AddtlInfoGraphic;
import com.ibm.nzna.projects.common.quest.oa.ConditionWriter;
import com.ibm.nzna.projects.common.quest.oa.CountryWriter;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import java.util.Vector;

class ActionInfoWriter {
    private static final String SCHEMA = "oa";

    static String getSQL(AddtlInfo addtlInfo) {
        String string;
        switch (addtlInfo.getRecStatus()) {
            case 2: {
                string = ActionInfoWriter.getInsertSQL(addtlInfo, SCHEMA);
                break;
            }
            case 1: {
                string = ActionInfoWriter.getUpdateSQL(addtlInfo, SCHEMA);
                break;
            }
            case 3: {
                string = ActionInfoWriter.getDeleteSQL(addtlInfo, SCHEMA);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(AddtlInfo addtlInfo, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO " + string + ".actionAddInfo " + "(actionAddInfoInd, actionInd, sortOrder, addInfo, " + "titleInd, redirectFlag, languageInd, lastTranslated, " + "docClassInd, dbUser, changedTime) " + "VALUES (");
        stringBuffer.append(addtlInfo.getInd()).append(',');
        stringBuffer.append(addtlInfo.getParentInd()).append(',');
        stringBuffer.append(addtlInfo.getSortOrder()).append(',');
        stringBuffer.append("'To be updated by PreparedStatement'").append(',');
        if (addtlInfo.getParentTitleInd() == 0) {
            stringBuffer.append("null").append(',');
        } else {
            stringBuffer.append(addtlInfo.getParentTitleInd()).append(',');
        }
        stringBuffer.append(DatabaseUtil.booleanToDB(addtlInfo.getRedirectFlag())).append(',');
        stringBuffer.append(addtlInfo.getLanguage().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.timestampToDB(addtlInfo.getLastTranslationDate())).append(',');
        stringBuffer.append(addtlInfo.getDocClass().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(addtlInfo.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        if (addtlInfo.getLanguage().getInd() == 1) {
            stringBuffer.append(CountryWriter.getInsertSQL(string + ".actionInfoCountry", addtlInfo.getInd(), addtlInfo.getCountryList(), addtlInfo.getDbUser()));
            stringBuffer.append(ConditionWriter.getInsertSQL(string + ".actionInfoCond", addtlInfo.getInd(), addtlInfo.getConditions(), addtlInfo.getDbUser()));
        }
        stringBuffer.append(ActionInfoWriter.getEmbeddedInsertSQL(addtlInfo, string));
        return stringBuffer.toString();
    }

    static String getUpdateSQL(AddtlInfo addtlInfo, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE FROM " + string + ".actionInfoCountry WHERE actionAddInfoInd = " + addtlInfo.getInd());
        stringBuffer.append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM " + string + ".actionInfoCond WHERE actionAddInfoInd = " + addtlInfo.getInd());
        stringBuffer.append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM " + string + ".actionAddInfo WHERE actionAddInfoInd = " + addtlInfo.getInd());
        stringBuffer.append(SqlRunner.END_DELIM);
        stringBuffer.append(ActionInfoWriter.getInsertSQL(addtlInfo, string));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(AddtlInfo addtlInfo, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(CountryWriter.getDeleteSQL(string + ".actionInfoCountry", "actionAddInfoInd", addtlInfo.getInd()));
        stringBuffer.append(ConditionWriter.getDeleteSQL(string + ".actionInfoCond", "actionAddInfoInd", addtlInfo.getInd()));
        stringBuffer.append(ActionInfoWriter.getEmbeddedDeleteSQL(addtlInfo, string));
        stringBuffer.append("DELETE FROM " + string + ".actionAddInfo WHERE actionAddInfoInd=").append(addtlInfo.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getEmbeddedInsertSQL(AddtlInfo addtlInfo, String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(250);
        Vector vector = addtlInfo.getEmbeddedDocInds();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                int n2 = (Integer)vector.elementAt(n);
                stringBuffer.append("INSERT INTO " + string + ".actionInfoLinks VALUES(");
                stringBuffer.append(addtlInfo.getInd()).append(',');
                stringBuffer.append(n2).append(',');
                stringBuffer.append(DatabaseUtil.stringToDB(addtlInfo.getDbUser())).append(',');
                stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
                ++n;
            }
        }
        if ((vector = addtlInfo.getEmbeddedGraphics()) != null) {
            n = 0;
            while (n < vector.size()) {
                AddtlInfoGraphic addtlInfoGraphic = (AddtlInfoGraphic)vector.elementAt(n);
                stringBuffer.append("INSERT INTO " + string + ".actionInfoGraphic VALUES(");
                stringBuffer.append(addtlInfo.getInd()).append(',');
                stringBuffer.append(addtlInfoGraphic.getGraphicInd()).append(',');
                stringBuffer.append(addtlInfoGraphic.getLanguage().getInd()).append(',');
                stringBuffer.append(DatabaseUtil.timestampToDB(addtlInfoGraphic.getLastTranslationDate())).append(',');
                stringBuffer.append(addtlInfoGraphic.getDocClass().getInd()).append(',');
                stringBuffer.append(DatabaseUtil.stringToDB(addtlInfo.getDbUser())).append(',');
                stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    static String getEmbeddedUpdateSQL(AddtlInfo addtlInfo, String string) {
        return ActionInfoWriter.getEmbeddedDeleteSQL(addtlInfo, string) + ActionInfoWriter.getEmbeddedInsertSQL(addtlInfo, string);
    }

    static String getEmbeddedDeleteSQL(AddtlInfo addtlInfo, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE FROM " + string + ".actionInfoLinks WHERE actionAddInfoInd=").append(addtlInfo.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM " + string + ".actionInfoGraphic WHERE actionAddInfoInd=").append(addtlInfo.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteAllForActionSQL(int n) {
        return ActionInfoWriter.getDeleteAllForActionSQL(n, SCHEMA);
    }

    static String getDeleteAllForActionSQL(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE from " + string + ".actioninfocond where actionaddinfoind in " + "(select distinct actionaddinfoind " + "from " + string + ".actionaddinfo where actionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".actioninfocountry where actionaddinfoind in " + "(select distinct actionaddinfoind " + "from " + string + ".actionaddinfo where actionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".actioninfolinks where actionaddinfoind in " + "(select distinct actionaddinfoind " + "from " + string + ".actionaddinfo where actionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".actioninfographic where actionaddinfoind in " + "(select distinct actionaddinfoind " + "from " + string + ".actionaddinfo where actionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".actionaddinfo where actionind=").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    ActionInfoWriter() {
    }
}

