/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.ConditionWriter;
import com.ibm.nzna.projects.common.quest.oa.CountryWriter;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.Title;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.shared.util.LogSystem;

class ActionTitleWriter {
    private static final String SCHEMA = "oa";

    static String getSQL(Title title) {
        String string;
        switch (title.getRecStatus()) {
            case 2: {
                ActionTitleWriter.log("Saving Action Title for INSERT");
                string = ActionTitleWriter.getInsertSQL(title, SCHEMA);
                break;
            }
            case 1: {
                ActionTitleWriter.log("Saving Action Title for UPDATE");
                string = ActionTitleWriter.getUpdateSQL(title, SCHEMA);
                break;
            }
            case 3: {
                ActionTitleWriter.log("Saving Action Title for DELETE");
                string = ActionTitleWriter.getDeleteSQL(title, SCHEMA);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(Title title, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO " + string + ".actionTitle " + "(actionTitleInd, actionInd, sortOrder, title, languageInd, " + "lastTranslated, docClassInd, dbUser, changedTime) " + "VALUES (");
        stringBuffer.append(title.getInd()).append(',');
        stringBuffer.append(title.getParentInd()).append(',');
        stringBuffer.append(title.getSortOrder()).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(title.getTitle())).append(',');
        stringBuffer.append(title.getLanguage().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.timestampToDB(title.getLastTranslationDate())).append(',');
        stringBuffer.append(title.getDocClass().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(title.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        if (title.getLanguage().getInd() == 1) {
            stringBuffer.append(CountryWriter.getInsertSQL(string + ".actionTitleCountry", title.getInd(), title.getCountryList(), title.getDbUser()));
            stringBuffer.append(ConditionWriter.getInsertSQL(string + ".actionTitleCond", title.getInd(), title.getConditions(), title.getDbUser()));
        }
        return stringBuffer.toString();
    }

    static String getUpdateSQL(Title title, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE FROM " + string + ".actionTitleCountry WHERE ACTIONTITLEIND = " + title.getInd());
        stringBuffer.append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM " + string + ".actionTitleCond WHERE ACTIONTITLEIND = " + title.getInd());
        stringBuffer.append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM " + string + ".actionTitle WHERE ACTIONTITLEIND = " + title.getInd());
        stringBuffer.append(SqlRunner.END_DELIM);
        stringBuffer.append(ActionTitleWriter.getInsertSQL(title, string));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(Title title, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(CountryWriter.getDeleteSQL(string + ".actionTitleCountry", "actionTitleInd", title.getInd()));
        stringBuffer.append(ConditionWriter.getDeleteSQL(string + ".actionTitleCond", "actionTitleInd", title.getInd()));
        stringBuffer.append("DELETE FROM " + string + ".actionTitle WHERE actionTitleInd=").append(title.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteAllForActionSQL(int n) {
        return ActionTitleWriter.getDeleteAllForActionSQL(n, SCHEMA);
    }

    static String getDeleteAllForActionSQL(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE from " + string + ".actiontitlecond where actiontitleind in " + "(select distinct actiontitleind " + "from " + string + ".actiontitle where actionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".actiontitlecountry where actiontitleind in " + "(select distinct actiontitleind " + "from " + string + ".actiontitle where actionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".actiontitle where actionind=").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    private static void log(String string) {
        if (LogSystem.getInstance() != null) {
            LogSystem.log(1, string);
        }
    }

    ActionTitleWriter() {
    }
}

