/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.Action;
import com.ibm.nzna.projects.common.quest.oa.AddtlInfo;
import com.ibm.nzna.projects.common.quest.oa.AddtlInfoGraphic;
import com.ibm.nzna.projects.common.quest.oa.ConditionReader;
import com.ibm.nzna.projects.common.quest.oa.CountryReader;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.Question;
import com.ibm.nzna.projects.common.quest.type.TypeDocClassRec;
import com.ibm.nzna.projects.common.quest.type.TypeLanguageRec;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

class AddtlInfoReader {
    private static final String ACTIVE_SCHEMA = "oa";
    private static final String DRAFT_SCHEMA = "oadraft";

    static void readActionAddtlInfo(Connection connection, int n, Action action) throws SQLException {
        AddtlInfoReader.readActionAddtlInfo(connection, action, n, ACTIVE_SCHEMA);
    }

    static void readActionDraftAddtlInfo(Connection connection, int n, Action action) throws SQLException {
        AddtlInfoReader.readActionAddtlInfo(connection, action, n, DRAFT_SCHEMA);
    }

    private static void readActionAddtlInfo(Connection connection, Action action, int n, String string) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + "actionAddInfoInd, sortOrder, addInfo, titleInd, " + "redirectFlag, languageInd, lastTranslated, docClassInd, " + "created, dbUser, changedTime " + "FROM " + string + ".actionAddInfo " + "WHERE actionInd=" + action.getInd() + " " + "ORDER BY sortOrder, languageInd " + "FOR FETCH ONLY");
        Vector<AddtlInfo> vector = new Vector<AddtlInfo>();
        while (resultSet.next()) {
            AddtlInfo addtlInfo = new AddtlInfo(resultSet.getInt(1));
            addtlInfo.setParentInd(action.getInd());
            addtlInfo.setSortOrder(resultSet.getShort(2));
            addtlInfo.setAddtlInfo(resultSet.getString(3));
            addtlInfo.setParentTitleInd(resultSet.getInt(4));
            addtlInfo.setRedirectFlag(DatabaseUtil.booleanFromDB(resultSet.getString(5)));
            addtlInfo.setLanguage(new TypeLanguageRec(resultSet.getShort(6), ""));
            addtlInfo.setLastTranslationDate(DatabaseUtil.timestampFromDB(resultSet.getString(7)));
            addtlInfo.setDocClass(new TypeDocClassRec(resultSet.getShort(8), ""));
            addtlInfo.setCreationTime(DatabaseUtil.timestampFromDB(resultSet.getString(9)));
            addtlInfo.setDbUser(resultSet.getString(10).trim());
            addtlInfo.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(11)));
            if (n != 1) {
                addtlInfo.setEmbeddedDocInds(AddtlInfoReader.readEmbeddedDocs(connection, string + ".actionInfoLinks", "actionAddInfoInd", addtlInfo.getInd()));
                addtlInfo.setEmbeddedGraphics(AddtlInfoReader.readEmbeddedGraphics(connection, string + ".actionInfoGraphic", "actionAddInfoInd", addtlInfo.getInd()));
            }
            addtlInfo.setTextUpdated(false);
            addtlInfo.updateRecStatus(0);
            vector.addElement(addtlInfo);
        }
        resultSet.close();
        statement.close();
        action.setAdditionalInfo(vector);
        if (vector.size() > 0) {
            ConditionReader.readAllActionAddtlInfoConditions(connection, action, string, true);
            CountryReader.readAllActionAddtlInfoCountries(connection, action, string, true);
        }
    }

    static void readActionAddtlInfo(Connection connection, Action action, int n, int n2) throws SQLException {
        if (n == 0) {
            AddtlInfoReader.readActionAddtlInfo(connection, action, n2, ACTIVE_SCHEMA);
        } else {
            AddtlInfoReader.readActionAddtlInfo(connection, action, n, n2, ACTIVE_SCHEMA);
        }
    }

    static void readActionDraftAddtlInfo(Connection connection, Action action, int n, int n2) throws SQLException {
        if (n == 0) {
            AddtlInfoReader.readActionAddtlInfo(connection, action, n2, DRAFT_SCHEMA);
        } else {
            AddtlInfoReader.readActionAddtlInfo(connection, action, n, n2, DRAFT_SCHEMA);
        }
    }

    private static void readActionAddtlInfo(Connection connection, Action action, int n, int n2, String string) throws SQLException {
        Statement statement = null;
        Statement statement2 = connection.createStatement();
        ResultSet resultSet = statement2.executeQuery("SELECT DISTINCT actionAddInfoInd, sortOrder " + "FROM " + string + ".actionAddInfo " + "WHERE actionInd=" + action.getInd() + " " + "ORDER BY sortOrder " + "FOR FETCH ONLY");
        Vector<AddtlInfo> vector = new Vector<AddtlInfo>();
        while (resultSet.next()) {
            if (statement == null) {
                statement = connection.prepareStatement("SELECT " + "actionAddInfoInd, sortOrder, addInfo, titleInd, " + "redirectFlag, languageInd, lastTranslated, docClassInd, " + "created, dbUser, changedTime " + "FROM " + string + ".actionAddInfo " + "WHERE actionAddInfoInd=? " + "AND languageInd=? " + "FOR FETCH ONLY");
            }
            int n3 = resultSet.getInt(1);
            statement.setInt(1, n3);
            statement.setInt(2, n);
            ResultSet resultSet2 = statement.executeQuery();
            if (!resultSet2.next()) {
                statement.setInt(1, n3);
                statement.setInt(2, 1);
                resultSet2 = statement.executeQuery();
                resultSet2.next();
            }
            AddtlInfo addtlInfo = new AddtlInfo(resultSet2.getInt(1));
            addtlInfo.setParentInd(action.getInd());
            addtlInfo.setSortOrder(resultSet2.getShort(2));
            addtlInfo.setAddtlInfo(resultSet2.getString(3));
            addtlInfo.setParentTitleInd(resultSet2.getInt(4));
            addtlInfo.setRedirectFlag(DatabaseUtil.booleanFromDB(resultSet2.getString(5)));
            addtlInfo.setLanguage(new TypeLanguageRec(resultSet2.getShort(6), ""));
            addtlInfo.setLastTranslationDate(DatabaseUtil.timestampFromDB(resultSet2.getString(7)));
            addtlInfo.setDocClass(new TypeDocClassRec(resultSet2.getShort(8), ""));
            addtlInfo.setCreationTime(DatabaseUtil.timestampFromDB(resultSet2.getString(9)));
            addtlInfo.setDbUser(resultSet2.getString(10).trim());
            addtlInfo.setChangedTime(DatabaseUtil.timestampFromDB(resultSet2.getString(11)));
            resultSet2.close();
            if (n2 != 1) {
                addtlInfo.setEmbeddedDocInds(AddtlInfoReader.readEmbeddedDocs(connection, string + ".actionInfoLinks", "actionAddInfoInd", addtlInfo.getInd()));
                addtlInfo.setEmbeddedGraphics(AddtlInfoReader.readEmbeddedGraphics(connection, string + ".actionInfoGraphic", "actionAddInfoInd", addtlInfo.getInd()));
            }
            addtlInfo.setTextUpdated(false);
            addtlInfo.updateRecStatus(0);
            vector.addElement(addtlInfo);
        }
        resultSet.close();
        statement2.close();
        if (statement != null) {
            statement.close();
        }
        action.setAdditionalInfo(vector);
        if (vector.size() > 0) {
            ConditionReader.readAllActionAddtlInfoConditions(connection, action, string, false);
            CountryReader.readAllActionAddtlInfoCountries(connection, action, string, false);
        }
    }

    static void readQuestionAddtlInfo(Connection connection, Question question, int n) throws SQLException {
        AddtlInfoReader.readQuestionAddtlInfo(connection, question, n, ACTIVE_SCHEMA);
    }

    static void readQuestionDraftAddtlInfo(Connection connection, Question question, int n) throws SQLException {
        AddtlInfoReader.readQuestionAddtlInfo(connection, question, n, DRAFT_SCHEMA);
    }

    private static void readQuestionAddtlInfo(Connection connection, Question question, int n, String string) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + "questionAddInfoInd, sortOrder, addInfo, titleInd, " + "languageInd, lastTranslated, docClassInd, " + "created, dbUser, changedTime " + "FROM " + string + ".questionAddInfo " + "WHERE questionInd=" + question.getInd() + " " + "ORDER BY sortOrder, languageInd " + "FOR FETCH ONLY");
        Vector<AddtlInfo> vector = new Vector<AddtlInfo>();
        while (resultSet.next()) {
            AddtlInfo addtlInfo = new AddtlInfo(resultSet.getInt(1));
            addtlInfo.setParentInd(question.getInd());
            addtlInfo.setSortOrder(resultSet.getShort(2));
            addtlInfo.setAddtlInfo(resultSet.getString(3));
            addtlInfo.setParentTitleInd(resultSet.getInt(4));
            addtlInfo.setLanguage(new TypeLanguageRec(resultSet.getShort(5), ""));
            addtlInfo.setLastTranslationDate(DatabaseUtil.timestampFromDB(resultSet.getString(6)));
            addtlInfo.setDocClass(new TypeDocClassRec(resultSet.getShort(7), ""));
            addtlInfo.setCreationTime(DatabaseUtil.timestampFromDB(resultSet.getString(8)));
            addtlInfo.setDbUser(resultSet.getString(9).trim());
            addtlInfo.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(10)));
            if (n != 1) {
                addtlInfo.setEmbeddedDocInds(AddtlInfoReader.readEmbeddedDocs(connection, string + ".questionInfoLinks", "questionAddInfoInd", addtlInfo.getInd()));
                addtlInfo.setEmbeddedGraphics(AddtlInfoReader.readEmbeddedGraphics(connection, string + ".questionInfoGrphic", "questionAddInfoInd", addtlInfo.getInd()));
            }
            addtlInfo.setTextUpdated(false);
            addtlInfo.updateRecStatus(0);
            vector.addElement(addtlInfo);
        }
        resultSet.close();
        statement.close();
        question.setAdditionalInfo(vector);
        if (vector.size() > 0) {
            ConditionReader.readAllQuestionAddtlInfoConditions(connection, question, string, true);
            CountryReader.readAllQuestionAddtlInfoCountries(connection, question, string, true);
        }
    }

    static void readQuestionAddtlInfo(Connection connection, Question question, int n, int n2) throws SQLException {
        if (n == 0) {
            AddtlInfoReader.readQuestionAddtlInfo(connection, question, n2, ACTIVE_SCHEMA);
        } else {
            AddtlInfoReader.readQuestionAddtlInfo(connection, question, n, n2, ACTIVE_SCHEMA);
        }
    }

    static void readQuestionDraftAddtlInfo(Connection connection, Question question, int n, int n2) throws SQLException {
        if (n == 0) {
            AddtlInfoReader.readQuestionAddtlInfo(connection, question, n2, DRAFT_SCHEMA);
        } else {
            AddtlInfoReader.readQuestionAddtlInfo(connection, question, n, n2, DRAFT_SCHEMA);
        }
    }

    private static void readQuestionAddtlInfo(Connection connection, Question question, int n, int n2, String string) throws SQLException {
        Statement statement = null;
        Statement statement2 = connection.createStatement();
        ResultSet resultSet = statement2.executeQuery("SELECT DISTINCT questionAddInfoInd, sortOrder " + "FROM " + string + ".questionAddInfo " + "WHERE questionInd=" + question.getInd() + " " + "ORDER BY sortOrder " + "FOR FETCH ONLY");
        Vector<AddtlInfo> vector = new Vector<AddtlInfo>();
        while (resultSet.next()) {
            if (statement == null) {
                statement = connection.prepareStatement("SELECT " + "questionAddInfoInd, sortOrder, addInfo, titleInd, " + "languageInd, lastTranslated, docClassInd, " + "created, dbUser, changedTime " + "FROM " + string + ".questionAddInfo " + "WHERE questionAddInfoInd=? " + "AND languageInd=? " + "FOR FETCH ONLY");
            }
            int n3 = resultSet.getInt(1);
            statement.setInt(1, n3);
            statement.setInt(2, n);
            ResultSet resultSet2 = statement.executeQuery();
            if (!resultSet2.next()) {
                statement.setInt(1, n3);
                statement.setInt(2, 1);
                resultSet2 = statement.executeQuery();
                resultSet2.next();
            }
            AddtlInfo addtlInfo = new AddtlInfo(resultSet2.getInt(1));
            addtlInfo.setParentInd(question.getInd());
            addtlInfo.setSortOrder(resultSet2.getShort(2));
            addtlInfo.setAddtlInfo(resultSet2.getString(3));
            addtlInfo.setParentTitleInd(resultSet2.getInt(4));
            addtlInfo.setLanguage(new TypeLanguageRec(resultSet2.getShort(5), ""));
            addtlInfo.setLastTranslationDate(DatabaseUtil.timestampFromDB(resultSet2.getString(6)));
            addtlInfo.setDocClass(new TypeDocClassRec(resultSet2.getShort(7), ""));
            addtlInfo.setCreationTime(DatabaseUtil.timestampFromDB(resultSet2.getString(8)));
            addtlInfo.setDbUser(resultSet2.getString(9).trim());
            addtlInfo.setChangedTime(DatabaseUtil.timestampFromDB(resultSet2.getString(10)));
            resultSet2.close();
            if (n2 != 1) {
                addtlInfo.setEmbeddedDocInds(AddtlInfoReader.readEmbeddedDocs(connection, string + ".questionInfoLinks", "questionAddInfoInd", addtlInfo.getInd()));
                addtlInfo.setEmbeddedGraphics(AddtlInfoReader.readEmbeddedGraphics(connection, string + ".questionInfoGrphic", "questionAddInfoInd", addtlInfo.getInd()));
            }
            addtlInfo.setTextUpdated(false);
            addtlInfo.updateRecStatus(0);
            vector.addElement(addtlInfo);
        }
        resultSet.close();
        statement2.close();
        if (statement != null) {
            statement.close();
        }
        question.setAdditionalInfo(vector);
        if (vector.size() > 0) {
            ConditionReader.readAllQuestionAddtlInfoConditions(connection, question, string, false);
            CountryReader.readAllQuestionAddtlInfoCountries(connection, question, string, false);
        }
    }

    private static Vector readEmbeddedDocs(Connection connection, String string, String string2, int n) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT docInd " + "FROM " + string + " " + "WHERE " + string2 + "=" + n);
        Vector<Integer> vector = new Vector<Integer>(1, 3);
        while (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            vector.addElement(new Integer(n2));
        }
        statement.close();
        return vector;
    }

    private static Vector readEmbeddedGraphics(Connection connection, String string, String string2, int n) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT a.graphicInd, a.languageInd, a.lastTranslated, a.docClassInd, b.filename " + "FROM    " + string + " a, TIGRIS.GRAPHICS B " + "WHERE A." + string2 + "=" + n + " AND " + "      A.GRAPHICIND = B.GRAPHICIND FOR FETCH ONLY");
        Vector<AddtlInfoGraphic> vector = new Vector<AddtlInfoGraphic>(1, 3);
        while (resultSet.next()) {
            AddtlInfoGraphic addtlInfoGraphic = new AddtlInfoGraphic(resultSet.getInt(1));
            addtlInfoGraphic.setLanguage(new TypeLanguageRec(resultSet.getShort(2), ""));
            addtlInfoGraphic.setLastTranslationDate(DatabaseUtil.timestampFromDB(resultSet.getString(3)));
            addtlInfoGraphic.setDocClass(new TypeDocClassRec(resultSet.getShort(4), ""));
            addtlInfoGraphic.setFilename(resultSet.getString(5).trim());
            vector.addElement(addtlInfoGraphic);
        }
        statement.close();
        return vector;
    }

    AddtlInfoReader() {
    }
}

