/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.oa.AnswerConcl;
import com.ibm.nzna.projects.common.quest.oa.ConditionalObject;
import com.ibm.nzna.projects.common.quest.oa.HashList;
import com.ibm.nzna.projects.common.quest.oa.Title;
import com.ibm.nzna.shared.util.LogSystem;
import java.sql.Connection;
import java.util.Vector;

public class Answer
extends ConditionalObject {
    static final long serialVersionUID = 1000000L;
    int answerInd_ = 0;
    int questionInd_ = 0;
    Vector titles_ = null;
    Vector conclusions_ = null;
    boolean draft_ = false;
    int activeAnswerInd_ = 0;
    int draftAnswerInd_ = 0;

    void setDraft(boolean bl) {
        this.draft_ = bl;
    }

    public boolean isDraft() {
        return this.draft_;
    }

    public int getActiveAnswerInd() {
        return this.activeAnswerInd_;
    }

    void setActiveAnswerInd(int n) {
        this.activeAnswerInd_ = n;
        this.setDraft(true);
    }

    int getDraftAnswerInd() {
        return this.draftAnswerInd_;
    }

    void setDraftAnswerInd(int n) {
        this.draftAnswerInd_ = n;
    }

    boolean assignDatabaseKeys() {
        boolean bl = this.assignMyDatabaseKey();
        if (this.titles_ != null) {
            int n = 0;
            while (n < this.titles_.size() && bl) {
                Title title = (Title)this.titles_.elementAt(n);
                bl = this.isDraft() ? title.assignDatabaseKeyForAnswerDraft() : title.assignDatabaseKeyForAnswer();
                ++n;
            }
        }
        return bl;
    }

    void assignDatabaseKeys(Connection connection) throws Exception {
        this.assignMyDatabaseKey(connection);
        if (this.titles_ != null) {
            int n = 0;
            while (n < this.titles_.size()) {
                Title title = (Title)this.titles_.elementAt(n);
                if (this.isDraft()) {
                    title.assignDatabaseKeyForAnswerDraft(connection);
                } else {
                    title.assignDatabaseKeyForAnswer(connection);
                }
                ++n;
            }
        }
    }

    private boolean assignMyDatabaseKey() {
        boolean bl = true;
        if (this.answerInd_ == 0 && this.valid()) {
            if (this.isDraft()) {
                LogSystem.log(1, "Getting database key for draft Answer");
                this.answerInd_ = Counter.getCounter(LogSystem.getInstance(), "DANSRIND");
            } else {
                LogSystem.log(1, "Getting database key for Answer");
                this.answerInd_ = Counter.getCounter(LogSystem.getInstance(), "ANSWERIND");
            }
            if (this.answerInd_ == 0) {
                LogSystem.log(2, "Failed to get database key for Answer");
                bl = false;
            }
        }
        return bl;
    }

    private void assignMyDatabaseKey(Connection connection) throws Exception {
        if (this.answerInd_ == 0) {
            this.answerInd_ = this.isDraft() ? Counter.getCounter(connection, "DANSRIND") : Counter.getCounter(connection, "ANSWERIND");
            if (this.answerInd_ == 0) {
                throw new Exception("Failed to get database key for Answer");
            }
        }
    }

    public boolean objectModified() {
        ConditionalObject conditionalObject;
        int n;
        int n2;
        boolean bl = super.modified();
        if (this.titles_ != null) {
            n2 = 1;
            n = 0;
            while (n < this.titles_.size() && !bl) {
                conditionalObject = (Title)this.titles_.elementAt(n);
                if (conditionalObject.valid()) {
                    conditionalObject.setSortOrder(n2++);
                }
                bl = bl || conditionalObject.modified();
                ++n;
            }
        }
        if (this.conclusions_ != null) {
            n2 = 1;
            n = 0;
            while (n < this.conclusions_.size() && !bl) {
                conditionalObject = (AnswerConcl)this.conclusions_.elementAt(n);
                bl = bl || conditionalObject.modified();
                ++n;
            }
        }
        return bl;
    }

    public boolean getArchived() {
        return false;
    }

    public int getInd() {
        return this.answerInd_;
    }

    void setInd(int n) {
        this.answerInd_ = n;
    }

    int getParentInd() {
        return this.questionInd_;
    }

    void setParentInd(int n) {
        this.questionInd_ = n;
    }

    public Vector getTitles() {
        return this.titles_;
    }

    public void setTitles(Vector vector) {
        this.titles_ = vector;
    }

    public Title getDefaultTitle() {
        if (this.titles_ != null && this.titles_.size() > 0) {
            return (Title)this.titles_.lastElement();
        }
        return null;
    }

    public Vector getConclusions() {
        if (this.conclusions_ == null) {
            this.conclusions_ = new Vector();
        }
        return this.conclusions_;
    }

    public void setConclusions(Vector vector) {
        this.conclusions_ = vector;
    }

    public Object clone() {
        Answer answer = (Answer)super.clone();
        answer.titles_ = (Vector)this.titles_.clone();
        answer.conclusions_ = (Vector)this.conclusions_.clone();
        return answer;
    }

    public boolean equals(Object object) {
        if (this.getInd() == 0) {
            throw new IllegalStateException("equals(): Answer is new");
        }
        return object instanceof Answer && ((Answer)object).getInd() == this.getInd();
    }

    public int hashCode() {
        if (this.getInd() == 0) {
            throw new IllegalStateException("hashCode(): Answer is new");
        }
        return this.getInd();
    }

    public HashList getAllQuestions() {
        HashList hashList = new HashList();
        this.getAllQuestions(hashList);
        return hashList;
    }

    public void getAllQuestions(HashList hashList) {
        ConditionalObject conditionalObject;
        int n;
        super.getAllQuestions(hashList);
        if (this.titles_ != null) {
            n = 0;
            while (n < this.titles_.size()) {
                conditionalObject = (Title)this.titles_.elementAt(n);
                conditionalObject.getAllQuestions(hashList);
                ++n;
            }
        }
        if (this.conclusions_ != null) {
            n = 0;
            while (n < this.conclusions_.size()) {
                conditionalObject = (AnswerConcl)this.conclusions_.elementAt(n);
                int n2 = ((AnswerConcl)conditionalObject).getToQuestionInd();
                hashList.put(new Integer(n2));
                ++n;
            }
        }
    }

    public String toString() {
        if (this.titles_ != null && this.titles_.size() > 0) {
            return this.titles_.elementAt(this.titles_.size() - 1).toString();
        }
        return "Answer " + this.getInd();
    }

    void resetNew() {
        ConditionalObject conditionalObject;
        int n;
        if (this.isDraft()) {
            this.setActiveAnswerInd(this.getInd());
            this.setInd(0);
            this.updateRecStatus(0);
            this.updateRecStatus(2);
        } else {
            this.setDraftAnswerInd(this.getInd());
            this.setInd(this.getActiveAnswerInd());
            if (this.getInd() == 0) {
                this.updateRecStatus(0);
                this.updateRecStatus(2);
            } else {
                this.updateRecStatus(1);
                this.getConditions().setModified(true);
            }
        }
        if (this.titles_ != null) {
            n = 0;
            while (n < this.titles_.size()) {
                conditionalObject = (Title)this.titles_.elementAt(n);
                ((Title)conditionalObject).resetNew();
                ++n;
            }
        }
        if (this.conclusions_ != null) {
            n = 0;
            while (n < this.conclusions_.size()) {
                conditionalObject = (AnswerConcl)this.conclusions_.elementAt(n);
                ((AnswerConcl)conditionalObject).resetNew();
                ++n;
            }
        }
    }

    void setRecNoChange() {
        ConditionalObject conditionalObject;
        int n;
        super.setRecNoChange();
        if (this.titles_ != null) {
            n = 0;
            while (n < this.titles_.size()) {
                conditionalObject = (Title)this.titles_.elementAt(n);
                conditionalObject.setRecNoChange();
                ++n;
            }
        }
        if (this.conclusions_ != null) {
            n = 0;
            while (n < this.conclusions_.size()) {
                conditionalObject = (AnswerConcl)this.conclusions_.elementAt(n);
                conditionalObject.setRecNoChange();
                ++n;
            }
        }
    }

    void updateTypeRecData() {
        ConditionalObject conditionalObject;
        int n;
        super.updateTypeRecData();
        if (this.titles_ != null) {
            n = 0;
            while (n < this.titles_.size()) {
                conditionalObject = (Title)this.titles_.elementAt(n);
                ((Title)conditionalObject).updateTypeRecData();
                ++n;
            }
        }
        if (this.conclusions_ != null) {
            n = 0;
            while (n < this.conclusions_.size()) {
                conditionalObject = (AnswerConcl)this.conclusions_.elementAt(n);
                conditionalObject.updateTypeRecData();
                ++n;
            }
        }
    }

    public Answer() {
        this.updateRecStatus(2);
    }

    Answer(int n) {
        this.answerInd_ = n;
        this.updateRecStatus(0);
    }
}

