/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.AnswerConcl;
import com.ibm.nzna.projects.common.quest.oa.ConditionTerm;
import com.ibm.nzna.projects.common.quest.oa.Conditions;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.VectorUtil;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import java.util.Vector;

class AnswerConclWriter {
    private static final String SCHEMA = "oa";

    static String getSQL(AnswerConcl answerConcl) {
        String string;
        switch (answerConcl.getRecStatus()) {
            case 2: {
                string = AnswerConclWriter.getInsertSQL(answerConcl, SCHEMA);
                break;
            }
            case 1: {
                string = AnswerConclWriter.getUpdateSQL(answerConcl, SCHEMA);
                break;
            }
            case 3: {
                string = AnswerConclWriter.getDeleteSQL(answerConcl, SCHEMA);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(AnswerConcl answerConcl, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO " + string + ".answerConcl " + "(fromAnswerInd, toAnswerInd, docClassInd, dbUser, changedTime) " + "VALUES (");
        stringBuffer.append(answerConcl.getFromAnswerInd()).append(',');
        stringBuffer.append(answerConcl.getToAnswerInd()).append(',');
        stringBuffer.append(answerConcl.getDocClass().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(answerConcl.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        stringBuffer.append(AnswerConclWriter.getConditionsInsertSQL(answerConcl, string));
        stringBuffer.append(AnswerConclWriter.getCountriesInsertSQL(answerConcl, string));
        return stringBuffer.toString();
    }

    static String getUpdateSQL(AnswerConcl answerConcl, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("UPDATE " + string + ".answerConcl SET");
        stringBuffer.append(" docClassInd=").append(answerConcl.getDocClass().getInd());
        stringBuffer.append(",dbUser=").append(DatabaseUtil.stringToDB(answerConcl.getDbUser()));
        stringBuffer.append(",changedTime=CURRENT TIMESTAMP");
        stringBuffer.append(" WHERE fromAnswerInd=").append(answerConcl.getFromAnswerInd()).append("   AND toAnswerInd=").append(answerConcl.getToAnswerInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append(AnswerConclWriter.getConditionsUpdateSQL(answerConcl, string));
        stringBuffer.append(AnswerConclWriter.getCountriesUpdateSQL(answerConcl, string));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(AnswerConcl answerConcl, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(AnswerConclWriter.getConditionsDeleteSQL(answerConcl, string));
        stringBuffer.append(AnswerConclWriter.getCountriesDeleteSQL(answerConcl, string));
        stringBuffer.append("DELETE FROM " + string + ".answerConcl").append(" WHERE fromAnswerInd=").append(answerConcl.getFromAnswerInd()).append(" AND toAnswerInd=").append(answerConcl.getToAnswerInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    private static String getConditionsInsertSQL(AnswerConcl answerConcl, String string) {
        String string2 = "";
        Conditions conditions = answerConcl.getConditions();
        if (conditions != null && conditions.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer(250);
            Vector vector = conditions.getTerms();
            int n = 0;
            while (n < vector.size()) {
                ConditionTerm conditionTerm = (ConditionTerm)vector.elementAt(n);
                stringBuffer.append("INSERT INTO " + string + ".answerConclCond VALUES (");
                stringBuffer.append(answerConcl.getFromAnswerInd()).append(',');
                stringBuffer.append(answerConcl.getToAnswerInd()).append(',');
                stringBuffer.append(n + 1).append(',');
                stringBuffer.append(conditionTerm.getQuestionInd()).append(',');
                if (conditionTerm.getAnswerInd() == 0) {
                    stringBuffer.append("null,");
                } else {
                    stringBuffer.append(conditionTerm.getAnswerInd()).append(',');
                }
                stringBuffer.append(DatabaseUtil.stringToDB(conditionTerm.getOperators())).append(',');
                stringBuffer.append(DatabaseUtil.stringToDB(answerConcl.getDbUser())).append(',');
                stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
                ++n;
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private static String getConditionsUpdateSQL(AnswerConcl answerConcl, String string) {
        if (answerConcl.getConditions().isModified()) {
            return AnswerConclWriter.getConditionsDeleteSQL(answerConcl, string) + AnswerConclWriter.getConditionsInsertSQL(answerConcl, string);
        }
        return "";
    }

    private static String getConditionsDeleteSQL(AnswerConcl answerConcl, String string) {
        return "DELETE FROM " + string + ".answerConclCond" + " WHERE fromAnswerInd=" + answerConcl.getFromAnswerInd() + " AND toAnswerInd=" + answerConcl.getToAnswerInd() + SqlRunner.END_DELIM;
    }

    private static String getCountriesInsertSQL(AnswerConcl answerConcl, String string) {
        String string2 = "";
        Vector vector = answerConcl.getCountryList();
        if (vector != null && vector.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer(250);
            int n = 0;
            while (n < vector.size()) {
                TypeCountryCodeRec typeCountryCodeRec = (TypeCountryCodeRec)vector.elementAt(n);
                stringBuffer.append("INSERT INTO " + string + ".answerConclCountry VALUES (").append(answerConcl.getFromAnswerInd()).append(',').append(answerConcl.getToAnswerInd()).append(',').append(typeCountryCodeRec.getInd()).append(',').append(DatabaseUtil.stringToDB(answerConcl.getDbUser())).append(',').append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
                ++n;
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private static String getCountriesUpdateSQL(AnswerConcl answerConcl, String string) {
        if (!VectorUtil.vectorsEqual(answerConcl.getCountryList(), answerConcl.getOriginalCountryList())) {
            return AnswerConclWriter.getCountriesDeleteSQL(answerConcl, string) + AnswerConclWriter.getCountriesInsertSQL(answerConcl, string);
        }
        return "";
    }

    private static String getCountriesDeleteSQL(AnswerConcl answerConcl, String string) {
        return "DELETE FROM " + string + ".answerConclCountry" + " WHERE fromAnswerInd=" + answerConcl.getFromAnswerInd() + " AND toAnswerInd=" + answerConcl.getToAnswerInd() + SqlRunner.END_DELIM;
    }

    static String getDeleteAllForQuestionSQL(int n) {
        return AnswerConclWriter.getDeleteAllForQuestionSQL(n, SCHEMA);
    }

    static String getDeleteAllForQuestionSQL(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE from " + string + ".answerconclcond where fromanswerind in " + "(select distinct answerind " + "from " + string + ".answer where questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".answerconclcountry where fromanswerind in  " + "(select distinct answerind " + "from " + string + ".answer where questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".answerconcl where fromanswerind in  " + "(select distinct answerind " + "from " + string + ".answer where questionind=").append(n).append(')').append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteAllForAnswerSQL(int n) {
        return AnswerConclWriter.getDeleteAllForAnswerSQL(n, SCHEMA);
    }

    static String getDeleteAllForAnswerSQL(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE from " + string + ".answerconclcond where fromanswerind=").append(n).append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".answerconclcountry where fromanswerind=").append(n).append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from " + string + ".answerconcl where fromanswerind=").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    AnswerConclWriter() {
    }
}

