/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.Edge;
import com.ibm.nzna.projects.common.quest.oa.EdgeGroup;
import com.ibm.nzna.projects.common.quest.oa.EdgeWriter;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import java.util.Vector;

class EdgeGroupWriter {
    static String getSQL(EdgeGroup edgeGroup) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(EdgeGroupWriter.getEdgeGroupSQL(edgeGroup));
        if (edgeGroup.valid()) {
            stringBuffer.append(EdgeGroupWriter.getObjectSQL(edgeGroup));
        }
        return stringBuffer.toString();
    }

    static String getObjectSQL(EdgeGroup edgeGroup) {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = edgeGroup.getEdges();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                Edge edge = (Edge)vector.elementAt(n);
                if (edge.valid()) {
                    edge.setEdgeGroupInd(edgeGroup.getInd());
                    edge.setDbUser(edgeGroup.getDbUser());
                }
                stringBuffer.append(EdgeWriter.getSQL(edge));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    static String getEdgeGroupSQL(EdgeGroup edgeGroup) {
        String string;
        switch (edgeGroup.getRecStatus()) {
            case 2: {
                string = EdgeGroupWriter.getInsertSQL(edgeGroup);
                break;
            }
            case 1: {
                string = EdgeGroupWriter.getUpdateSQL(edgeGroup);
                break;
            }
            case 3: {
                string = EdgeGroupWriter.getDeleteSQL(edgeGroup);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(EdgeGroup edgeGroup) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO oa.edgeGroup (edgeGroupInd, symptomInd, headNodeInd, tailNodeInd, xPos, yPos, cxPos, cyPos, zOrder, dbUser, changedTime) VALUES (");
        stringBuffer.append(edgeGroup.getInd()).append(',');
        stringBuffer.append(edgeGroup.getSymptomInd()).append(',');
        stringBuffer.append(edgeGroup.getHeadNodeInd()).append(',');
        if (edgeGroup.getHeadNodeInd() == 0) {
            throw new IllegalStateException("Head Node indicator is 0 -- the Node was probably not put in the Symptom's Vector of Nodes");
        }
        stringBuffer.append(edgeGroup.getTailNodeInd()).append(',');
        if (edgeGroup.getTailNodeInd() == 0) {
            throw new IllegalStateException("Tail Node indicator is 0 -- the Node was probably not put in the Symptom's Vector of Nodes");
        }
        stringBuffer.append(edgeGroup.getXPos()).append(',');
        stringBuffer.append(edgeGroup.getYPos()).append(',');
        stringBuffer.append(edgeGroup.getcXPos()).append(',');
        stringBuffer.append(edgeGroup.getcYPos()).append(',');
        stringBuffer.append(edgeGroup.getZOrder()).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(edgeGroup.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getUpdateSQL(EdgeGroup edgeGroup) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("UPDATE oa.edgeGroup SET");
        stringBuffer.append(" xPos=").append(edgeGroup.getXPos());
        stringBuffer.append(",yPos=").append(edgeGroup.getYPos());
        stringBuffer.append(",cxPos=").append(edgeGroup.getcXPos());
        stringBuffer.append(",cyPos=").append(edgeGroup.getcYPos());
        stringBuffer.append(",zOrder=").append(edgeGroup.getZOrder());
        stringBuffer.append(",dbUser=").append(DatabaseUtil.stringToDB(edgeGroup.getDbUser()));
        stringBuffer.append(",changedTime=CURRENT TIMESTAMP");
        stringBuffer.append(" WHERE edgeGroupInd=").append(edgeGroup.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteSQL(EdgeGroup edgeGroup) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(EdgeWriter.getDeleteAllForEdgeGroupSQL(edgeGroup.getInd()));
        stringBuffer.append("DELETE FROM oa.edgeGroup WHERE edgeGroupInd=").append(edgeGroup.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteAllForSymptomSQL(int n) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(EdgeWriter.getDeleteAllForSymptomSQL(n));
        stringBuffer.append("DELETE from oa.edgegroup where symptomind=").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    EdgeGroupWriter() {
    }
}

