/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.ConditionReader;
import com.ibm.nzna.projects.common.quest.oa.CountryReader;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.Edge;
import com.ibm.nzna.projects.common.quest.oa.EdgeAlist;
import com.ibm.nzna.projects.common.quest.oa.EdgeGroup;
import com.ibm.nzna.projects.common.quest.oa.EdgeObject;
import com.ibm.nzna.projects.common.quest.oa.EdgePreanswer;
import com.ibm.nzna.projects.common.quest.oa.EdgeReturn;
import com.ibm.nzna.projects.common.quest.oa.EdgeUnanswer;
import com.ibm.nzna.projects.common.quest.oa.Symptom;
import com.ibm.nzna.projects.common.quest.type.TypeDocClassRec;
import com.ibm.nzna.shared.pom.PersistentRec;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

class EdgeReader {
    static void readAllEdgesForSymptom(Connection connection, Symptom symptom, int n) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT e.edgeInd, e.edgeType, e.answerInd, e.docClassInd, " + "e.created, e.dbUser, e.changedTime, g.edgeGroupInd " + "FROM   oa.edge e, oa.edgeGroup g " + "WHERE  e.edgeGroupInd = g.edgeGroupInd " + "AND    g.symptomInd =" + symptom.getInd() + " " + "ORDER BY g.edgeGroupInd " + "FOR FETCH ONLY");
        int n2 = 0;
        int n3 = -99;
        Vector<Edge> vector = null;
        EdgeGroup edgeGroup = null;
        while (resultSet.next()) {
            n2 = resultSet.getInt(8);
            if (n2 != n3) {
                if (vector != null) {
                    edgeGroup.setEdges(vector);
                }
                vector = new Vector<Edge>(2, 5);
                n3 = n2;
                edgeGroup = EdgeGroup.findEdgeGroupInVector(n2, symptom.getEdgeGroups());
            }
            Edge edge = new Edge();
            edge.setInd(resultSet.getInt(1));
            edge.setEdgeType(resultSet.getShort(2));
            edge.setAnswerInd(resultSet.getInt(3));
            edge.setQuestionInd(edgeGroup.getHeadNode().getOAObjectInd());
            edge.setEdgeGroupInd(edgeGroup.getInd());
            edge.setDocClass(new TypeDocClassRec(resultSet.getShort(4), ""));
            edge.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(5)));
            edge.setDbUser(resultSet.getString(6).trim());
            edge.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(7)));
            if (n != 1) {
                EdgeReader.readDefaultAnswerTitle(connection, edge);
            }
            edge.updateRecStatus(0);
            vector.addElement(edge);
        }
        resultSet.close();
        statement.close();
        if (vector != null) {
            edgeGroup.setEdges(vector);
        }
        ConditionReader.readAllEdgeConditions(connection, symptom, "oa");
        CountryReader.readAllEdgeCountries(connection, symptom, "oa");
        EdgeReader.readPreanswerTableForAllEdges(connection, symptom);
    }

    private static void readDefaultAnswerTitle(Connection connection, Edge edge) throws SQLException {
        if (edge.getEdgeType() == 1) {
            edge.setDefaultAnswerTitle("OTHER");
        } else {
            Statement statement = connection.createStatement();
            int n = edge.getAnswerInd();
            ResultSet resultSet = statement.executeQuery("SELECT title " + "FROM oa.answerTitle " + "WHERE answerInd=" + n + " " + "AND sortOrder=(" + "SELECT MAX(sortOrder) " + "FROM oa.answerTitle " + "WHERE answerInd=" + n + ") " + "FOR FETCH ONLY");
            if (resultSet.next()) {
                edge.setDefaultAnswerTitle(resultSet.getString(1));
            } else {
                edge.setDefaultAnswerTitle("N/A");
            }
            resultSet.close();
            statement.close();
        }
    }

    private static void readPreanswerTableForAllEdges(Connection connection, Symptom symptom) throws SQLException {
        Statement statement = connection.createStatement();
        Statement statement2 = null;
        ResultSet resultSet = statement.executeQuery("SELECT " + "ep.edgePreanswerInd, ep.preanswerType, " + "ep.answerInd, ep.actionInd, ep.questionInd, ep.nodeInd, " + "ep.edgeInd " + "FROM oa.edgePreanswer ep, oa.edge e, oa.edgeGroup eg " + "WHERE ep.edgeInd = e.edgeInd " + " AND  e.edgeGroupInd = eg.edgeGroupInd " + " AND  eg.symptomInd = " + symptom.getInd() + " " + "ORDER BY ep.edgeInd " + "FOR FETCH ONLY");
        while (resultSet.next()) {
            Edge edge = symptom.getEdgeByInd(resultSet.getInt(7));
            int n = resultSet.getInt(1);
            short s = resultSet.getShort(2);
            switch (s) {
                case 0: {
                    if (statement2 == null) {
                        statement2 = connection.prepareStatement("SELECT questionInd FROM oa.answer WHERE answerInd=? FOR FETCH ONLY");
                    }
                    int n2 = resultSet.getInt(3);
                    statement2.setInt(1, n2);
                    Object object = statement2.executeQuery();
                    object.next();
                    int n3 = object.getInt(1);
                    object.close();
                    EdgePreanswer edgePreanswer = new EdgePreanswer(n3, n2);
                    edgePreanswer.setInd(n);
                    edgePreanswer.setEdgeInd(edge.getInd());
                    edgePreanswer.updateRecStatus(0);
                    edge.addPreanswer(edgePreanswer);
                    break;
                }
                case 1: {
                    int n2 = resultSet.getInt(4);
                    Object object = new EdgeAlist(n2);
                    ((EdgeObject)object).setInd(n);
                    ((EdgeObject)object).setEdgeInd(edge.getInd());
                    ((PersistentRec)object).updateRecStatus(0);
                    edge.addActionList((EdgeAlist)object);
                    break;
                }
                case 2: {
                    int n2 = resultSet.getInt(5);
                    Object object = new EdgeUnanswer(n2);
                    ((EdgeObject)object).setInd(n);
                    ((EdgeObject)object).setEdgeInd(edge.getInd());
                    ((PersistentRec)object).updateRecStatus(0);
                    edge.addUnanswer((EdgeUnanswer)object);
                    break;
                }
                case 3: {
                    int n2 = resultSet.getInt(6);
                    Object object = new EdgeReturn(symptom.getNodeByInd(n2));
                    ((EdgeObject)object).setInd(n);
                    ((EdgeObject)object).setEdgeInd(edge.getInd());
                    ((PersistentRec)object).updateRecStatus(0);
                    edge.setReturnNode((EdgeReturn)object);
                    edge.originalReturnNode = object;
                    break;
                }
            }
        }
        resultSet.close();
        statement.close();
        if (statement2 != null) {
            statement2.close();
        }
    }

    EdgeReader() {
    }
}

