/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.ConditionWriter;
import com.ibm.nzna.projects.common.quest.oa.CountryWriter;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.Edge;
import com.ibm.nzna.projects.common.quest.oa.EdgeAlist;
import com.ibm.nzna.projects.common.quest.oa.EdgeObject;
import com.ibm.nzna.projects.common.quest.oa.EdgePreanswer;
import com.ibm.nzna.projects.common.quest.oa.EdgeReturn;
import com.ibm.nzna.projects.common.quest.oa.EdgeUnanswer;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import java.util.Vector;

class EdgeWriter {
    static String getSQL(Edge edge) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(EdgeWriter.getEdgeSQL(edge));
        if (edge.getRecStatus() != 3) {
            stringBuffer.append(EdgeWriter.getPreanswerTableSQL(edge));
        }
        return stringBuffer.toString();
    }

    static String getEdgeSQL(Edge edge) {
        String string;
        switch (edge.getRecStatus()) {
            case 2: {
                string = EdgeWriter.getInsertSQL(edge);
                break;
            }
            case 1: {
                string = EdgeWriter.getUpdateSQL(edge);
                break;
            }
            case 3: {
                string = EdgeWriter.getDeleteSQL(edge);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(Edge edge) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO oa.edge (edgeInd, edgeGroupInd, edgeType, answerInd, docClassInd, dbUser, changedTime) VALUES (");
        stringBuffer.append(edge.getInd()).append(',');
        stringBuffer.append(edge.getEdgeGroupInd()).append(',');
        stringBuffer.append(edge.getEdgeType()).append(',');
        if (edge.getEdgeType() == 0) {
            stringBuffer.append(edge.getAnswerInd()).append(',');
        } else {
            stringBuffer.append("NULL,");
        }
        stringBuffer.append(edge.getDocClass().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(edge.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getInsertSQL("oa.edgeCountry", edge.getInd(), edge.getCountryList(), edge.getDbUser()));
        stringBuffer.append(ConditionWriter.getInsertSQL("oa.edgeCond", edge.getInd(), edge.getConditions(), edge.getDbUser()));
        return stringBuffer.toString();
    }

    static String getUpdateSQL(Edge edge) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("UPDATE oa.edge SET");
        stringBuffer.append(" docClassInd=").append(edge.getDocClass().getInd());
        stringBuffer.append(",dbUser=").append(DatabaseUtil.stringToDB(edge.getDbUser()));
        stringBuffer.append(",changedTime=CURRENT TIMESTAMP");
        stringBuffer.append(" WHERE edgeInd=").append(edge.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getUpdateSQL("oa.edgeCountry", "edgeInd", edge.getInd(), edge.getCountryList(), edge.getOriginalCountryList(), edge.getDbUser()));
        stringBuffer.append(ConditionWriter.getUpdateSQL("oa.edgeCond", "edgeInd", edge.getInd(), edge.getConditions(), edge.getDbUser()));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(Edge edge) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(CountryWriter.getDeleteSQL("oa.edgeCountry", "edgeInd", edge.getInd()));
        stringBuffer.append(ConditionWriter.getDeleteSQL("oa.edgeCond", "edgeInd", edge.getInd()));
        stringBuffer.append("DELETE FROM oa.edgePreanswer where edgeInd=").append(edge.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM oa.edge WHERE edgeInd=").append(edge.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getPreanswerTableSQL(Edge edge) {
        String string;
        int n;
        EdgeObject edgeObject;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = edge.getPreanswers();
        if (vector != null) {
            n2 = 0;
            while (n2 < vector.size()) {
                edgeObject = (EdgePreanswer)vector.elementAt(n2);
                n = edgeObject.getRecStatus();
                if (n == 3) {
                    stringBuffer.append(EdgeWriter.deleteFromPreanswerTable(edgeObject.getInd()));
                } else if (n == 2) {
                    string = 0 + ", " + ((EdgePreanswer)edgeObject).getAnswerInd() + ",NULL,NULL,NULL";
                    stringBuffer.append(EdgeWriter.insertIntoPreanswerTable(edge, edgeObject.getInd(), string));
                }
                ++n2;
            }
        }
        if ((vector = edge.getActionList()) != null) {
            n2 = 0;
            while (n2 < vector.size()) {
                edgeObject = (EdgeAlist)vector.elementAt(n2);
                n = edgeObject.getRecStatus();
                if (n == 3) {
                    stringBuffer.append(EdgeWriter.deleteFromPreanswerTable(edgeObject.getInd()));
                } else if (n == 2) {
                    string = 1 + ", NULL," + ((EdgeAlist)edgeObject).getActionInd() + ",NULL,NULL";
                    stringBuffer.append(EdgeWriter.insertIntoPreanswerTable(edge, edgeObject.getInd(), string));
                }
                ++n2;
            }
        }
        if ((vector = edge.getUnanswers()) != null) {
            n2 = 0;
            while (n2 < vector.size()) {
                edgeObject = (EdgeUnanswer)vector.elementAt(n2);
                n = edgeObject.getRecStatus();
                if (n == 3) {
                    stringBuffer.append(EdgeWriter.deleteFromPreanswerTable(edgeObject.getInd()));
                } else if (n == 2) {
                    string = 2 + ", NULL,NULL," + ((EdgeUnanswer)edgeObject).getQuestionInd() + ",NULL";
                    stringBuffer.append(EdgeWriter.insertIntoPreanswerTable(edge, edgeObject.getInd(), string));
                }
                ++n2;
            }
        }
        EdgeReturn edgeReturn = edge.getReturnNode();
        if (edge.originalReturnNode != null && edge.originalReturnNode != edgeReturn) {
            stringBuffer.append(EdgeWriter.deleteFromPreanswerTable(edge.originalReturnNode.getInd()));
        }
        if (edgeReturn != null) {
            int n3 = edgeReturn.getRecStatus();
            if (n3 == 3) {
                stringBuffer.append(EdgeWriter.deleteFromPreanswerTable(edgeReturn.getInd()));
            } else if (n3 == 2) {
                String string2 = 3 + ", NULL,NULL,NULL," + edgeReturn.getNodeInd();
                stringBuffer.append(EdgeWriter.insertIntoPreanswerTable(edge, edgeReturn.getInd(), string2));
            }
        }
        return stringBuffer.toString();
    }

    private static String insertIntoPreanswerTable(Edge edge, int n, String string) {
        String string2 = DatabaseUtil.stringToDB(edge.getDbUser());
        return "INSERT INTO oa.edgePreanswer VALUES (" + n + "," + edge.getInd() + "," + string + "," + string2 + "," + "CURRENT TIMESTAMP" + ")" + SqlRunner.END_DELIM;
    }

    private static String deleteFromPreanswerTable(int n) {
        return "DELETE FROM oa.edgePreanswer WHERE edgePreanswerInd=" + n + SqlRunner.END_DELIM;
    }

    static String getDeleteAllForSymptomSQL(int n) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE from oa.edgeCond where edgeind in (select distinct edgeind from oa.edge e, oa.edgegroup g where e.edgegroupind = g.edgegroupind and   g.symptomind = ").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oa.edgeCountry where edgeind in (select distinct edgeind from oa.edge e, oa.edgegroup g where e.edgegroupind = g.edgegroupind and   g.symptomind = ").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oa.edgePreanswer where edgeind in (select distinct edgeind from oa.edge e, oa.edgegroup g where e.edgegroupind = g.edgegroupind and   g.symptomind = ").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oa.edge where edgegroupind in (select distinct edgegroupind from oa.edgegroup where symptomind=").append(n).append(')').append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteAllForEdgeGroupSQL(int n) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE from oa.edgeCond where edgeind in (select distinct edgeind from oa.edgegroup where edgegroupind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oa.edgeCountry where edgeind in (select distinct edgeind from oa.edgegroup where edgegroupind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oa.edgePreanswer where edgeind in (select distinct edgeind from oa.edgegroup where edgegroupind=").append(n).append(')').append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oa.edge where edgegroupind = ").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    EdgeWriter() {
    }
}

