/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.oa.LanguageText;
import com.ibm.nzna.projects.common.quest.oa.LinkDraft;
import com.ibm.nzna.projects.common.quest.oa.LinkWriter;
import com.ibm.nzna.projects.common.quest.oa.OAInterface;
import com.ibm.nzna.projects.common.quest.oa.OAMode;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.Vector;

public abstract class Link
extends PersistentRec
implements OAInterface {
    static final short LINK_TYPE_QUEST = 0;
    static final short LINK_TYPE_EXTERNAL = 1;
    protected int linkInd_ = 0;
    protected Vector titles_ = null;
    protected boolean archived_ = false;
    protected String creationTime_ = "";
    protected String dbuser_ = "";
    protected String changedTime_ = "";
    private boolean openDraft_;

    public abstract String getUrlString();

    private void initFromOtherLink(Link link) {
        this.titles_ = link.titles_;
        this.archived_ = link.archived_;
        this.dbuser_ = link.dbuser_;
        this.creationTime_ = "";
        this.changedTime_ = "";
        if (this.titles_ != null) {
            int n = 0;
            while (n < this.titles_.size()) {
                LanguageText languageText = (LanguageText)this.titles_.elementAt(n);
                languageText.updateRecStatus(2);
                ++n;
            }
        }
    }

    public boolean assignDatabaseKeys() {
        boolean bl = true;
        boolean bl2 = false;
        if (this instanceof LinkDraft) {
            bl2 = true;
        }
        if (this.linkInd_ == 0 && this.valid()) {
            if (bl2) {
                LogSystem.log(1, "Getting database key for LinkDraft");
                this.linkInd_ = Counter.getCounter(LogSystem.getInstance(), "DLINKIND");
            } else {
                LogSystem.log(1, "Getting database key for Link");
                this.linkInd_ = Counter.getCounter(LogSystem.getInstance(), "LINKIND");
            }
            if (this.linkInd_ == 0) {
                LogSystem.log(2, "Failed to get database key for Link");
                bl = false;
            }
        }
        return bl;
    }

    void assignDatabaseKeys(Connection connection) throws Exception {
        boolean bl = false;
        if (this instanceof LinkDraft) {
            bl = true;
        }
        if (this.linkInd_ == 0) {
            this.linkInd_ = bl ? Counter.getCounter(connection, "DLINKIND") : Counter.getCounter(connection, "LINKIND");
            if (this.linkInd_ == 0) {
                throw new Exception("Failed to get database key for Link");
            }
        }
    }

    public int getInd() {
        return this.linkInd_;
    }

    void setInd(int n) {
        this.linkInd_ = n;
    }

    public Vector getLinkTitles() {
        return this.titles_;
    }

    public void setLinkTitles(Vector vector) {
        this.titles_ = vector;
    }

    public boolean isArchived() {
        return this.archived_;
    }

    public void setArchived(boolean bl) {
        this.archived_ = bl;
        this.updateRecStatus(1);
    }

    public String getCreationTime() {
        return this.creationTime_;
    }

    public void setCreationTime(String string) {
        this.creationTime_ = string;
    }

    public String getDbUser() {
        return this.dbuser_;
    }

    public void setDbUser(String string) {
        this.dbuser_ = string.toUpperCase();
    }

    public String getChangedTime() {
        return this.changedTime_;
    }

    public void setChangedTime(String string) {
        this.changedTime_ = string;
    }

    public boolean hasOpenDraft() {
        return this.openDraft_;
    }

    void setOpenDraft(boolean bl) {
        this.openDraft_ = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int writeToDatabase() {
        int n;
        block9: {
            SQLMethod sQLMethod;
            block8: {
                LogSystem.log(2, ">>> Starting Link.writeToDatabase()");
                if (!this.assignDatabaseKeys()) {
                    return -1;
                }
                sQLMethod = new SQLMethod(1, "Link.writeToDatabase()", 5);
                n = 0;
                StoredProcRec storedProcRec = null;
                try {
                    try {
                        CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.sqlRunner", 2);
                        String string = LinkWriter.getSQL(this);
                        if (string.length() == 0) {
                            LogSystem.log(1, "No changes to be written");
                            int n2 = 0;
                            Object var5_8 = null;
                            sQLMethod.close();
                            return n2;
                        }
                        String string2 = Text.replaceAllStrInStr(string, SqlRunner.END_DELIM, "\n");
                        LogSystem.log(1, "Starting to send statements to SQLRUNNER");
                        LogSystem.log(1, string2);
                        callableStatement.registerOutParameter(1, -4);
                        callableStatement.registerOutParameter(2, -4);
                        callableStatement.setBytes(1, string.getBytes());
                        callableStatement.execute();
                        storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 2);
                        callableStatement.close();
                        if (storedProcRec == null) {
                            LogSystem.log(2, "StoredProcRec is null - error status unknown");
                        }
                        if (storedProcRec == null || !storedProcRec.error) break block8;
                        LogSystem.log(2, storedProcRec.errorStr);
                        n = storedProcRec.sqlCode;
                        if (n == 0) {
                            n = -1;
                        }
                    }
                    catch (Exception exception) {
                        sQLMethod.rollBack();
                        LogSystem.log(3, exception);
                        n = -1;
                        Object var5_10 = null;
                        sQLMethod.close();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_11 = null;
                    sQLMethod.close();
                    throw throwable;
                }
            }
            Object var5_9 = null;
            sQLMethod.close();
        }
        LogSystem.log(2, ">>> Link.writeToDatabase() complete");
        return n;
    }

    public static Link readFromDatabase(int n, int n2) {
        LogSystem.log(2, ">>> Starting Link.readFromDatabase()");
        SQLMethod sQLMethod = new SQLMethod(1, "Link.readFromDatabase()", 5);
        StoredProcRec storedProcRec = null;
        Link link = null;
        try {
            CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.OAReader", 7);
            callableStatement.registerOutParameter(6, -4);
            callableStatement.registerOutParameter(7, -4);
            callableStatement.setInt(1, n);
            callableStatement.setInt(2, 3);
            callableStatement.setInt(3, 0);
            callableStatement.setInt(4, n2);
            callableStatement.setInt(5, OAMode.getMode());
            callableStatement.execute();
            link = (Link)StoredProcUtil.getObjectFromStatement(callableStatement, 6);
            storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 7);
            callableStatement.close();
            if (storedProcRec == null) {
                LogSystem.log(2, "StoredProcRec is null - error status unknown");
            }
            if (storedProcRec != null && storedProcRec.error) {
                LogSystem.log(2, storedProcRec.errorStr);
            } else if (link != null) {
                link.updateTypeRecData();
            } else {
                LogSystem.log(2, "No object found for indicator " + n);
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(3, exception);
        }
        sQLMethod.close();
        LogSystem.log(2, ">>> Link.readFromDatabase() completed");
        return link;
    }

    void updateTypeRecData() {
        if (this.titles_ != null) {
            int n = 0;
            while (n < this.titles_.size()) {
                LanguageText languageText = (LanguageText)this.titles_.elementAt(n);
                languageText.updateTypeRecData();
                ++n;
            }
        }
    }

    public Link() {
        this.updateRecStatus(2);
    }

    public Link(String string) {
        this.linkInd_ = 0;
        if (this.titles_ == null) {
            this.titles_ = new Vector();
        }
        this.titles_.addElement(new LanguageText(string));
        this.updateRecStatus(2);
    }

    public Link(int n) {
        this.linkInd_ = n;
    }

    Link(Link link) {
        this.setInd(0);
        this.initFromOtherLink(link);
        this.updateRecStatus(2);
    }

    Link(LinkDraft linkDraft) {
        this.setInd(linkDraft.getActiveLinkInd());
        this.initFromOtherLink(linkDraft.asLink());
        if (this.linkInd_ == 0) {
            this.updateRecStatus(2);
        } else {
            this.updateRecStatus(1);
        }
    }
}

