/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.ExternalLink;
import com.ibm.nzna.projects.common.quest.oa.ExternalLinkDraft;
import com.ibm.nzna.projects.common.quest.oa.LanguageText;
import com.ibm.nzna.projects.common.quest.oa.Link;
import com.ibm.nzna.projects.common.quest.oa.LinkDraft;
import com.ibm.nzna.projects.common.quest.oa.LinkReader;
import com.ibm.nzna.projects.common.quest.oa.PendingDraftException;
import com.ibm.nzna.projects.common.quest.oa.QuestLink;
import com.ibm.nzna.projects.common.quest.oa.QuestLinkDraft;
import com.ibm.nzna.projects.common.quest.type.TypeLanguageRec;
import com.ibm.nzna.projects.common.quest.type.TypeWorkRec;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class LinkDraftReader {
    public static LinkDraft readFromDB(Connection connection, int n, int n2) throws SQLException {
        Link link;
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + "l.linkType, l.docInd, d.lndocid, l.url, l.urlValid, " + "l.activeLinkInd, l.maintLock, l.startDate, l.stopDate, l.recycled, " + "l.archived, l.created, l.dbUser, l.changedTime, l.typeWorkInd, " + "l.comments " + "FROM " + "oadraft.link l LEFT OUTER JOIN tigris.documents d " + "ON l.docInd=d.docInd " + "WHERE linkInd=" + n + " " + "FOR FETCH ONLY");
        if (!resultSet.next()) {
            link = null;
            statement.close();
        } else {
            Link link2;
            short s = resultSet.getShort(1);
            if (s == 0) {
                QuestLinkDraft questLinkDraft = new QuestLinkDraft(n);
                questLinkDraft.setDocInd(resultSet.getInt(2));
                String string = resultSet.getString(3);
                if (string != null) {
                    questLinkDraft.setLNDocId(string.trim());
                }
                questLinkDraft.setActiveLinkInd(resultSet.getInt(6));
                questLinkDraft.setMaintLock(DatabaseUtil.booleanFromDB(resultSet.getString(7)));
                questLinkDraft.setStartDate(resultSet.getString(8));
                questLinkDraft.setStopDate(resultSet.getString(9));
                questLinkDraft.setRecycled(DatabaseUtil.booleanFromDB(resultSet.getString(10)));
                link = questLinkDraft;
                link2 = questLinkDraft.asLink();
            } else {
                ExternalLinkDraft externalLinkDraft = new ExternalLinkDraft(n);
                externalLinkDraft.setUrl(resultSet.getString(4));
                externalLinkDraft.setUrlValid(DatabaseUtil.booleanFromDB(resultSet.getString(5)));
                externalLinkDraft.setActiveLinkInd(resultSet.getInt(6));
                externalLinkDraft.setMaintLock(DatabaseUtil.booleanFromDB(resultSet.getString(7)));
                externalLinkDraft.setStartDate(resultSet.getString(8));
                externalLinkDraft.setStopDate(resultSet.getString(9));
                externalLinkDraft.setRecycled(DatabaseUtil.booleanFromDB(resultSet.getString(10)));
                link = externalLinkDraft;
                link2 = externalLinkDraft.asLink();
            }
            link2.setArchived(DatabaseUtil.booleanFromDB(resultSet.getString(11)));
            link2.setCreationTime(DatabaseUtil.timestampFromDB(resultSet.getString(12)));
            link2.setDbUser(resultSet.getString(13).trim());
            link2.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(14)));
            link.setTypeWorkRequired(new TypeWorkRec(resultSet.getShort(15), ""));
            link.setComments(resultSet.getString(16));
            if (resultSet.wasNull()) {
                link.setComments("");
            }
            statement.close();
            if (n2 == 0) {
                LinkDraftReader.readLinkTitles(connection, link2);
            } else {
                LinkDraftReader.readLinkTitles(connection, link2, n2);
            }
            link2.updateRecStatus(0);
        }
        return link;
    }

    static void readLinkTitles(Connection connection, Link link, int n) throws SQLException {
        String string;
        Statement statement = connection.createStatement();
        String string2 = string = "SELECT " + "languageInd, lastTranslated, title, " + "dbUser, changedTime " + "FROM oadraft.linkTitle " + "WHERE linkInd=" + link.getInd();
        ResultSet resultSet = statement.executeQuery(string2 = string2 + " AND languageInd=" + n + " FOR FETCH ONLY");
        if (!resultSet.next()) {
            string2 = string;
            string2 = string2 + " AND languageInd=1 FOR FETCH ONLY";
            resultSet = statement.executeQuery(string2);
            resultSet.next();
        }
        TypeLanguageRec typeLanguageRec = new TypeLanguageRec(resultSet.getShort(1), "");
        String string3 = resultSet.getString(3);
        LanguageText languageText = new LanguageText(string3, typeLanguageRec);
        languageText.setLastTranslationDate(DatabaseUtil.timestampFromDB(resultSet.getString(2)));
        languageText.setDbUser(resultSet.getString(4));
        languageText.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(5)));
        languageText.updateRecStatus(0);
        Vector<LanguageText> vector = new Vector<LanguageText>(1);
        vector.addElement(languageText);
        resultSet.close();
        statement.close();
        link.setLinkTitles(vector);
    }

    static void readLinkTitles(Connection connection, Link link) throws SQLException {
        Statement statement = connection.createStatement();
        String string = "SELECT " + "languageInd, lastTranslated, title, " + "dbUser, changedTime " + "FROM oadraft.linkTitle " + "WHERE linkInd=" + link.getInd() + " " + "ORDER BY languageInd " + "FOR FETCH ONLY";
        ResultSet resultSet = statement.executeQuery(string);
        Vector<LanguageText> vector = new Vector<LanguageText>();
        while (resultSet.next()) {
            TypeLanguageRec typeLanguageRec = new TypeLanguageRec(resultSet.getShort(1), "");
            String string2 = resultSet.getString(3);
            LanguageText languageText = new LanguageText(string2, typeLanguageRec);
            languageText.setLastTranslationDate(DatabaseUtil.timestampFromDB(resultSet.getString(2)));
            languageText.setDbUser(resultSet.getString(4));
            languageText.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(5)));
            languageText.updateRecStatus(0);
            vector.addElement(languageText);
        }
        resultSet.close();
        statement.close();
        link.setLinkTitles(vector);
    }

    public static LinkDraft getDraft(Connection connection, int n, int n2) throws SQLException, PendingDraftException {
        Statement statement = connection.createStatement();
        LinkDraft linkDraft = null;
        ResultSet resultSet = statement.executeQuery("SELECT linkInd " + "FROM oadraft.link " + "WHERE stopDate IS NULL AND activeLinkInd=" + n + " " + "FOR FETCH ONLY");
        if (resultSet.next()) {
            int n3 = resultSet.getInt(1);
            resultSet.close();
            linkDraft = LinkDraftReader.readFromDB(connection, n3, n2);
        } else {
            resultSet.close();
            Link link = LinkReader.readFromDB(connection, n, n2);
            if (link != null) {
                if (link.hasOpenDraft()) {
                    throw new PendingDraftException();
                }
                if (link instanceof QuestLink) {
                    QuestLinkDraft questLinkDraft = new QuestLinkDraft((QuestLink)link);
                    linkDraft = questLinkDraft;
                } else {
                    ExternalLinkDraft externalLinkDraft = new ExternalLinkDraft((ExternalLink)link);
                    linkDraft = externalLinkDraft;
                }
                statement.executeUpdate("UPDATE oa.link " + "SET openDraft='Y' " + "WHERE linkInd=" + n);
            }
        }
        statement.close();
        return linkDraft;
    }
}

