/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.ExternalLink;
import com.ibm.nzna.projects.common.quest.oa.LanguageText;
import com.ibm.nzna.projects.common.quest.oa.Link;
import com.ibm.nzna.projects.common.quest.oa.LinkDraft;
import com.ibm.nzna.projects.common.quest.oa.QuestLink;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import java.util.Vector;

class LinkDraftWriter {
    static String getSQL(LinkDraft linkDraft) {
        String string;
        Link link = linkDraft.asLink();
        switch (link.getRecStatus()) {
            case 2: {
                string = LinkDraftWriter.getInsertSQL(linkDraft);
                break;
            }
            case 1: {
                string = LinkDraftWriter.getUpdateSQL(linkDraft);
                break;
            }
            case 3: {
                string = LinkDraftWriter.getDeleteSQL(linkDraft);
                break;
            }
            default: {
                string = "";
            }
        }
        if (link.getRecStatus() != 3) {
            string = string + LinkDraftWriter.getLinkTitleSQL(link);
        }
        if (!link.modified() && string.length() > 0) {
            string = string + "UPDATE oadraft.link " + "SET changedTime=CURRENT TIMESTAMP " + "WHERE linkInd=" + link.getInd() + SqlRunner.END_DELIM;
        }
        return string;
    }

    static String getInsertSQL(LinkDraft linkDraft) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(250);
        Link link = linkDraft.asLink();
        stringBuffer.append("INSERT INTO oadraft.link (linkInd, activeLinkInd, linkType, docInd, url, urlValid, typeWorkInd, comments, maintLock, startDate, stopDate, recycled, archived, dbUser, created, changedTime) VALUES (");
        stringBuffer.append(link.getInd()).append(',');
        if (linkDraft.getActiveLinkInd() == 0) {
            stringBuffer.append("NULL,");
        } else {
            stringBuffer.append(linkDraft.getActiveLinkInd()).append(',');
        }
        if (linkDraft instanceof ExternalLink) {
            object = (ExternalLink)((Object)linkDraft);
            stringBuffer.append(1).append(',');
            stringBuffer.append("NULL").append(',');
            stringBuffer.append(DatabaseUtil.stringToDB(((ExternalLink)object).getUrl())).append(',');
            stringBuffer.append(DatabaseUtil.booleanToDB(((ExternalLink)object).isUrlValid())).append(',');
        } else {
            object = (QuestLink)((Object)linkDraft);
            stringBuffer.append(0).append(',');
            stringBuffer.append(((QuestLink)object).getDocInd()).append(',');
            stringBuffer.append("NULL,NULL,");
        }
        stringBuffer.append(linkDraft.getTypeWorkRequired().getInd()).append(',');
        object = linkDraft.getComments();
        if (object == null || ((String)object).length() == 0) {
            stringBuffer.append("NULL,");
        } else {
            stringBuffer.append(DatabaseUtil.stringToDB((String)object)).append(',');
        }
        stringBuffer.append(DatabaseUtil.booleanToDB(linkDraft.getMaintLock())).append(',');
        stringBuffer.append("CURRENT DATE").append(',');
        stringBuffer.append("NULL").append(',');
        stringBuffer.append(DatabaseUtil.booleanToDB(linkDraft.isRecycled())).append(',');
        stringBuffer.append(DatabaseUtil.booleanToDB(link.isArchived())).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(link.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP, CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getUpdateSQL(LinkDraft linkDraft) {
        StringBuffer stringBuffer = new StringBuffer(250);
        Link link = linkDraft.asLink();
        stringBuffer.append("UPDATE oadraft.link SET");
        stringBuffer.append(" typeWorkInd=").append(linkDraft.getTypeWorkRequired().getInd());
        stringBuffer.append(",comments=");
        String string = linkDraft.getComments();
        if (string == null || string.length() == 0) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append(DatabaseUtil.stringToDB(string));
        }
        stringBuffer.append(",maintLock=").append(DatabaseUtil.booleanToDB(linkDraft.getMaintLock()));
        stringBuffer.append(",recycled=").append(DatabaseUtil.booleanToDB(linkDraft.isRecycled()));
        stringBuffer.append(",archived=").append(DatabaseUtil.booleanToDB(link.isArchived()));
        stringBuffer.append(",dbUser=").append(DatabaseUtil.stringToDB(link.getDbUser()));
        stringBuffer.append(",changedTime=CURRENT TIMESTAMP");
        if (linkDraft instanceof ExternalLink) {
            ExternalLink externalLink = (ExternalLink)((Object)linkDraft);
            stringBuffer.append(",url=").append(DatabaseUtil.stringToDB(externalLink.getUrl()));
            stringBuffer.append(",urlValid=").append(DatabaseUtil.booleanToDB(externalLink.isUrlValid()));
        }
        stringBuffer.append(" WHERE linkInd=").append(link.getInd());
        stringBuffer.append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteSQL(LinkDraft linkDraft) {
        StringBuffer stringBuffer = new StringBuffer(250);
        Link link = linkDraft.asLink();
        stringBuffer.append("DELETE FROM oadraft.linkTitle WHERE linkInd=").append(link.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE FROM oadraft.link WHERE linkInd=").append(link.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getLinkTitleSQL(Link link) {
        String string = "";
        Vector vector = link.getLinkTitles();
        int n = 0;
        while (n < vector.size()) {
            LanguageText languageText = (LanguageText)vector.elementAt(n);
            switch (languageText.getRecStatus()) {
                case 2: {
                    string = string + LinkDraftWriter.getLinkTitleInsertSQL(link, languageText);
                    break;
                }
                case 1: {
                    string = string + LinkDraftWriter.getLinkTitleUpdateSQL(link, languageText);
                    break;
                }
                case 3: {
                    string = string + LinkDraftWriter.getLinkTitleDeleteSQL(link, languageText);
                    break;
                }
            }
            ++n;
        }
        return string;
    }

    static String getLinkTitleInsertSQL(Link link, LanguageText languageText) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO oadraft.linkTitle (linkInd, languageInd, lastTranslated, title, dbUser, changedTime) VALUES(");
        stringBuffer.append(link.getInd()).append(',');
        stringBuffer.append(languageText.getLanguage().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.timestampToDB(languageText.getLastTranslationDate())).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(languageText.getText())).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(link.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getLinkTitleUpdateSQL(Link link, LanguageText languageText) {
        return "UPDATE oadraft.linkTitle SET" + " title=" + DatabaseUtil.stringToDB(languageText.getText()) + ",lastTranslated=" + DatabaseUtil.timestampToDB(languageText.getLastTranslationDate()) + ",dbUser=" + DatabaseUtil.timestampToDB(link.getDbUser()) + ",changedTime=CURRENT TIMESTAMP " + "WHERE linkInd=" + link.getInd() + "  AND languageInd=" + languageText.getLanguage().getInd() + SqlRunner.END_DELIM;
    }

    static String getLinkTitleDeleteSQL(Link link, LanguageText languageText) {
        return "DELETE FROM oadraft.linkTitle " + "WHERE linkInd=" + link.getInd() + "  AND languageInd=" + languageText.getLanguage().getInd() + SqlRunner.END_DELIM;
    }

    LinkDraftWriter() {
    }
}

