/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.oa.LanguageText;
import com.ibm.nzna.projects.common.quest.oa.Link;
import com.ibm.nzna.projects.common.quest.oa.LinkGroupDraft;
import com.ibm.nzna.projects.common.quest.oa.LinkGroupWriter;
import com.ibm.nzna.projects.common.quest.oa.OAInterface;
import com.ibm.nzna.projects.common.quest.oa.OAMode;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.Vector;

public class LinkGroup
extends PersistentRec
implements OAInterface {
    static final long serialVersionUID = 1000000L;
    protected int linkGroupInd_ = 0;
    protected Vector links_ = null;
    protected Vector titles_ = null;
    protected boolean archived_ = false;
    protected String creationTime_ = "";
    protected String dbuser_ = "";
    protected String changedTime_ = "";
    protected boolean openDraft_ = false;

    private void initFromOtherLinkGroup(LinkGroup linkGroup) {
        this.links_ = linkGroup.links_;
        this.titles_ = linkGroup.titles_;
        this.archived_ = linkGroup.archived_;
        this.dbuser_ = linkGroup.dbuser_;
        this.creationTime_ = "";
        this.changedTime_ = "";
        if (this.titles_ != null) {
            int n = 0;
            while (n < this.titles_.size()) {
                LanguageText languageText = (LanguageText)this.titles_.elementAt(n);
                languageText.updateRecStatus(2);
                ++n;
            }
        }
    }

    public Vector getLinks() {
        return this.links_;
    }

    public void setLinks(Vector vector) {
        this.links_ = vector;
        this.updateRecStatus(1);
    }

    public Vector getLinkGroupTitles() {
        return this.titles_;
    }

    public void setLinkGroupTitles(Vector vector) {
        this.titles_ = vector;
    }

    public boolean assignDatabaseKeys() {
        boolean bl = true;
        if (this.linkGroupInd_ == 0 && this.valid()) {
            LogSystem.log(1, "Getting database key for LinkGroup");
            this.linkGroupInd_ = Counter.getCounter(LogSystem.getInstance(), "LINKGRPIND");
            if (this.linkGroupInd_ == 0) {
                LogSystem.log(2, "Failed to get database key for LinkGroup");
                bl = false;
            }
        }
        return bl;
    }

    void assignDatabaseKeys(Connection connection) throws Exception {
        if (this.linkGroupInd_ == 0) {
            this.linkGroupInd_ = Counter.getCounter(connection, "LINKGRPIND");
            if (this.linkGroupInd_ == 0) {
                throw new Exception("Failed to get database key for LinkGroup");
            }
        }
    }

    public int getInd() {
        return this.linkGroupInd_;
    }

    void setInd(int n) {
        this.linkGroupInd_ = n;
    }

    public boolean isArchived() {
        return this.archived_;
    }

    public void setArchived(boolean bl) {
        this.archived_ = bl;
        this.updateRecStatus(1);
    }

    public String getCreationTime() {
        return this.creationTime_;
    }

    public void setCreationTime(String string) {
        this.creationTime_ = string;
    }

    public String getDbUser() {
        return this.dbuser_;
    }

    public void setDbUser(String string) {
        this.dbuser_ = string.toUpperCase();
    }

    public String getChangedTime() {
        return this.changedTime_;
    }

    public void setChangedTime(String string) {
        this.changedTime_ = string;
    }

    public boolean hasOpenDraft() {
        return this.openDraft_;
    }

    void setOpenDraft(boolean bl) {
        this.openDraft_ = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int writeToDatabase() {
        LogSystem.log(2, ">>> Starting LinkGroup.writeToDatabase()");
        if (!this.assignDatabaseKeys()) {
            return -1;
        }
        int n2 = 0;
        while (this.links_ != null && n2 < this.links_.size()) {
            Link link = (Link)this.links_.elementAt(n2);
            if (link.getInd() == 0) {
                LogSystem.log(2, "Link " + n2 + " does not have a valid indicator");
                return -1;
            }
            ++n2;
        }
        SQLMethod sQLMethod = new SQLMethod(1, "LinkGroup.writeToDatabase()", 5);
        int n = 0;
        StoredProcRec storedProcRec = null;
        try {
            block9: {
                try {
                    CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.sqlRunner", 2);
                    String string = LinkGroupWriter.getSQL(this);
                    if (string.length() == 0) {
                        LogSystem.log(1, "No changes to be written");
                        int n3 = 0;
                        Object var5_10 = null;
                        sQLMethod.close();
                        return n3;
                    }
                    String string2 = Text.replaceAllStrInStr(string, SqlRunner.END_DELIM, "\n");
                    LogSystem.log(1, "Starting to send statements to SQLRUNNER");
                    LogSystem.log(1, string2);
                    callableStatement.registerOutParameter(1, -4);
                    callableStatement.registerOutParameter(2, -4);
                    callableStatement.setBytes(1, string.getBytes());
                    callableStatement.execute();
                    storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 2);
                    callableStatement.close();
                    if (storedProcRec == null) {
                        LogSystem.log(2, "StoredProcRec is null - error status unknown");
                    }
                    if (storedProcRec == null || !storedProcRec.error) break block9;
                    LogSystem.log(2, storedProcRec.errorStr);
                    n = storedProcRec.sqlCode;
                    if (n != 0) break block9;
                    n = -1;
                }
                catch (Exception exception) {
                    sQLMethod.rollBack();
                    LogSystem.log(3, exception);
                    n = -1;
                    Object var5_12 = null;
                    sQLMethod.close();
                }
            }
            Object var5_11 = null;
            sQLMethod.close();
        }
        catch (Throwable throwable) {
            Object var5_13 = null;
            sQLMethod.close();
            throw throwable;
        }
        LogSystem.log(2, ">>> LinkGroup.writeToDatabase() complete");
        return n;
    }

    public static LinkGroup readFromDatabase(int n, int n2) {
        LogSystem.log(2, ">>> Starting LinkGroup.readFromDatabase()");
        SQLMethod sQLMethod = new SQLMethod(1, "LinkGroup.readFromDatabase()", 5);
        StoredProcRec storedProcRec = null;
        LinkGroup linkGroup = null;
        try {
            CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.OAReader", 7);
            callableStatement.registerOutParameter(6, -4);
            callableStatement.registerOutParameter(7, -4);
            callableStatement.setInt(1, n);
            callableStatement.setInt(2, 4);
            callableStatement.setInt(3, 0);
            callableStatement.setInt(4, n2);
            callableStatement.setInt(5, OAMode.getMode());
            callableStatement.execute();
            linkGroup = (LinkGroup)StoredProcUtil.getObjectFromStatement(callableStatement, 6);
            storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 7);
            callableStatement.close();
            if (storedProcRec == null) {
                LogSystem.log(2, "StoredProcRec is null - error status unknown");
            }
            if (storedProcRec != null && storedProcRec.error) {
                LogSystem.log(2, storedProcRec.errorStr);
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(3, exception);
        }
        sQLMethod.close();
        LogSystem.log(2, ">>> LinkGroup.readFromDatabase() completed");
        if (linkGroup != null) {
            linkGroup.updateTypeRecData();
        } else {
            LogSystem.log(2, "No object found for indicator " + n);
        }
        return linkGroup;
    }

    void updateTypeRecData() {
        if (this.titles_ != null) {
            int n = 0;
            while (n < this.titles_.size()) {
                LanguageText languageText = (LanguageText)this.titles_.elementAt(n);
                languageText.updateTypeRecData();
                ++n;
            }
        }
    }

    public LinkGroup(String string) {
        this.linkGroupInd_ = 0;
        if (this.titles_ == null) {
            this.titles_ = new Vector();
        }
        this.titles_.addElement(new LanguageText(string));
        this.updateRecStatus(2);
    }

    public LinkGroup(int n) {
        this.linkGroupInd_ = n;
    }

    LinkGroup(LinkGroup linkGroup) {
        this.setInd(0);
        this.initFromOtherLinkGroup(linkGroup);
        this.updateRecStatus(2);
    }

    LinkGroup(LinkGroupDraft linkGroupDraft) {
        this.setInd(linkGroupDraft.getActiveLinkGroupInd());
        this.initFromOtherLinkGroup(linkGroupDraft);
        if (this.linkGroupInd_ == 0) {
            this.updateRecStatus(2);
        } else {
            this.updateRecStatus(1);
        }
    }
}

