/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.oa.Action;
import com.ibm.nzna.projects.common.quest.oa.ActionDraft;
import com.ibm.nzna.projects.common.quest.oa.OAObject;
import com.ibm.nzna.projects.common.quest.oa.Question;
import com.ibm.nzna.projects.common.quest.oa.QuestionDraft;
import com.ibm.nzna.projects.common.quest.oa.Symptom;
import com.ibm.nzna.projects.common.quest.oa.SymptomDraft;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.util.LogSystem;
import java.sql.Connection;

public class Node
extends PersistentRec {
    static final long serialVersionUID = 1000000L;
    public static final short NODE_TYPE_ACTION = 0;
    public static final short NODE_TYPE_QUESTION = 1;
    public static final short NODE_TYPE_SYMPTOM = 2;
    public static final short NODE_TYPE_RESOLVED = 3;
    public static final short NODE_TYPE_UNRESOLVED = 4;
    public static final short NODE_TYPE_RETURN = 5;
    public static final short NODE_TYPE_ALIST = 6;
    private int nodeInd_ = 0;
    private int symptomInd_ = 0;
    private short nodeType_ = 0;
    private int activeObjectInd_ = 0;
    private int draftObjectInd_ = 0;
    private int xPos_ = 0;
    private int yPos_ = 0;
    private int width_ = 75;
    private int height_ = 75;
    private int zOrder_ = 0;
    private String dbUser_ = null;
    private String changedTime_ = null;

    public int getInd() {
        return this.nodeInd_;
    }

    void setInd(int n) {
        this.nodeInd_ = n;
    }

    boolean assignDatabaseKey(boolean bl) {
        boolean bl2 = true;
        String string = bl ? "DNODEIND" : "NODEIND";
        if (this.nodeInd_ == 0 && this.valid()) {
            LogSystem.log(1, "Getting database key for Node: " + string);
            this.nodeInd_ = Counter.getCounter(LogSystem.getInstance(), string);
            if (this.nodeInd_ == 0) {
                LogSystem.log(2, "Failed to get database key for Node");
                bl2 = false;
            }
        }
        return bl2;
    }

    void assignDatabaseKey(Connection connection, boolean bl) throws Exception {
        String string = bl ? "DNODEIND" : "NODEIND";
        if (this.nodeInd_ == 0) {
            this.nodeInd_ = Counter.getCounter(connection, string);
            if (this.nodeInd_ == 0) {
                throw new Exception("Failed to get database key for Node");
            }
        }
    }

    void resetNew() {
        this.setInd(0);
        this.setSymptomInd(0);
        this.updateRecStatus(2);
    }

    int getSymptomInd() {
        return this.symptomInd_;
    }

    void setSymptomInd(int n) {
        this.symptomInd_ = n;
    }

    public short getNodeType() {
        return this.nodeType_;
    }

    void setNodeType(short s) {
        this.nodeType_ = s;
    }

    public boolean isOAObjectNode() {
        return this.nodeType_ == 0 || this.nodeType_ == 1 || this.nodeType_ == 2;
    }

    public int getOAObjectInd() {
        return this.activeObjectInd_;
    }

    void setOAObjectInd(int n) {
        this.activeObjectInd_ = n;
    }

    public int getActiveObjectInd() {
        return this.activeObjectInd_;
    }

    void setActiveObjectInd(int n) {
        this.activeObjectInd_ = n;
    }

    public int getDraftObjectInd() {
        return this.draftObjectInd_;
    }

    public void setDraftObjectInd(int n) {
        this.draftObjectInd_ = n;
    }

    public int getXPos() {
        return this.xPos_;
    }

    public int getYPos() {
        return this.yPos_;
    }

    public int getWidth() {
        return this.width_;
    }

    public int getHeight() {
        return this.height_;
    }

    public int getZOrder() {
        return this.zOrder_;
    }

    public void setGuiData(int n, int n2, int n3, int n4, int n5) {
        if (this.xPos_ != n || this.yPos_ != n2 || this.width_ != n3 || this.height_ != n4 || this.zOrder_ != n5) {
            this.updateRecStatus(1);
            this.xPos_ = n;
            this.yPos_ = n2;
            this.width_ = n3;
            this.height_ = n4;
            this.zOrder_ = n5;
        }
    }

    public int hashCode() {
        if (this.getInd() == 0) {
            throw new IllegalStateException("hashCode(): Node is new");
        }
        return this.getInd();
    }

    public boolean equals(Object object) {
        if (this.getInd() == 0) {
            throw new IllegalStateException("equals(): Node is new");
        }
        return object instanceof Node && ((Node)object).getInd() == this.getInd();
    }

    public String getChangedTime() {
        return this.changedTime_;
    }

    void setChangedTime(String string) {
        this.changedTime_ = string;
    }

    public String getDbUser() {
        return this.dbUser_;
    }

    void setDbUser(String string) {
        this.dbUser_ = string;
    }

    public boolean isGuiDataValid() {
        return this.xPos_ != 0 && this.yPos_ != 0 && this.width_ != 0 && this.height_ != 0 && this.zOrder_ != 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Node ").append(this.nodeInd_).append(": ");
        switch (this.nodeType_) {
            case 0: {
                stringBuffer.append("Action ").append(this.activeObjectInd_ + "/" + this.draftObjectInd_);
                break;
            }
            case 1: {
                stringBuffer.append("Question ").append(this.activeObjectInd_ + "/" + this.draftObjectInd_);
                break;
            }
            case 2: {
                stringBuffer.append("Symptom ").append(this.activeObjectInd_ + "/" + this.draftObjectInd_);
                break;
            }
            case 3: {
                stringBuffer.append("RESOLVED");
                break;
            }
            case 4: {
                stringBuffer.append("UNRESOLVED");
                break;
            }
            case 5: {
                stringBuffer.append("RETURN");
                break;
            }
            case 6: {
                stringBuffer.append("ALIST");
                break;
            }
            default: {
                stringBuffer.append("Unknown Type");
                break;
            }
        }
        return stringBuffer.toString();
    }

    public void setXPos(int n) {
        this.xPos_ = n;
    }

    public void setYPos(int n) {
        this.yPos_ = n;
    }

    public void setWidth(int n) {
        this.width_ = n;
    }

    public void setHeight(int n) {
        this.height_ = n;
    }

    public Node(OAObject oAObject) {
        if (oAObject instanceof ActionDraft) {
            ActionDraft actionDraft = (ActionDraft)oAObject;
            this.nodeType_ = 0;
            this.activeObjectInd_ = actionDraft.getActiveActionInd();
            this.draftObjectInd_ = actionDraft.getInd();
        } else if (oAObject instanceof QuestionDraft) {
            QuestionDraft questionDraft = (QuestionDraft)oAObject;
            this.nodeType_ = 1;
            this.activeObjectInd_ = questionDraft.getActiveQuestionInd();
            this.draftObjectInd_ = questionDraft.getInd();
        } else if (oAObject instanceof SymptomDraft) {
            SymptomDraft symptomDraft = (SymptomDraft)oAObject;
            this.nodeType_ = (short)2;
            this.activeObjectInd_ = symptomDraft.getActiveSymptomInd();
            this.draftObjectInd_ = symptomDraft.getInd();
        } else if (oAObject instanceof Action) {
            this.nodeType_ = 0;
            this.activeObjectInd_ = oAObject.getInd();
        } else if (oAObject instanceof Question) {
            this.nodeType_ = 1;
            this.activeObjectInd_ = oAObject.getInd();
        } else if (oAObject instanceof Symptom) {
            this.nodeType_ = (short)2;
            this.activeObjectInd_ = oAObject.getInd();
        }
        if (this.activeObjectInd_ == 0 && this.draftObjectInd_ == 0) {
            throw new IllegalArgumentException("oaObjectInd is 0");
        }
        this.updateRecStatus(2);
    }

    public Node(short s) {
        if (s != 3 && s != 4 && s != 5 && s != 6) {
            throw new IllegalArgumentException("Invalid nodeType " + s);
        }
        this.nodeType_ = s;
        this.updateRecStatus(2);
    }

    public Node(short s, int n) {
        if (s != 0 && s != 1 && s != 2) {
            throw new IllegalArgumentException("Invalid nodeType " + s);
        }
        if (n == 0) {
            throw new IllegalArgumentException("oaObjectInd is 0");
        }
        this.nodeType_ = s;
        this.activeObjectInd_ = n;
        this.draftObjectInd_ = 0;
        this.updateRecStatus(2);
    }

    Node() {
    }
}

