/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.Node;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;

class NodeWriter {
    static String getSQL(Node node) {
        String string;
        switch (node.getRecStatus()) {
            case 2: {
                string = NodeWriter.getInsertSQL(node);
                break;
            }
            case 1: {
                string = NodeWriter.getUpdateSQL(node);
                break;
            }
            case 3: {
                string = NodeWriter.getDeleteSQL(node);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(Node node) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO oa.node (nodeInd, symptomInd, nodeType, actionInd, questionInd, childSymptomInd, xPos, yPos, width, height, zOrder, dbUser, changedTime) VALUES (");
        stringBuffer.append(node.getInd()).append(',');
        stringBuffer.append(node.getSymptomInd()).append(',');
        short s = node.getNodeType();
        stringBuffer.append(s).append(',');
        if (s == 0) {
            stringBuffer.append(node.getOAObjectInd()).append(',');
        } else {
            stringBuffer.append("NULL,");
        }
        if (s == 1) {
            stringBuffer.append(node.getOAObjectInd()).append(',');
        } else {
            stringBuffer.append("NULL,");
        }
        if (s == 2) {
            stringBuffer.append(node.getOAObjectInd()).append(',');
        } else {
            stringBuffer.append("NULL,");
        }
        stringBuffer.append(node.getXPos()).append(',');
        stringBuffer.append(node.getYPos()).append(',');
        stringBuffer.append(node.getWidth()).append(',');
        stringBuffer.append(node.getHeight()).append(',');
        stringBuffer.append(node.getZOrder()).append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(node.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getUpdateSQL(Node node) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("UPDATE oa.node SET");
        stringBuffer.append(" xPos=").append(node.getXPos());
        stringBuffer.append(",yPos=").append(node.getYPos());
        stringBuffer.append(",width=").append(node.getWidth());
        stringBuffer.append(",height=").append(node.getHeight());
        stringBuffer.append(",zOrder=").append(node.getZOrder());
        stringBuffer.append(",dbUser=").append(DatabaseUtil.stringToDB(node.getDbUser()));
        stringBuffer.append(",changedTime=CURRENT TIMESTAMP");
        stringBuffer.append(" WHERE nodeInd=").append(node.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteSQL(Node node) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DELETE from oa.node WHERE nodeInd=").append(node.getInd()).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    static String getDeleteAllForSymptomSQL(int n) {
        return "DELETE FROM oa.node WHERE symptomInd=" + n + SqlRunner.END_DELIM;
    }

    NodeWriter() {
    }
}

