/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.OAInterface;
import com.ibm.nzna.projects.common.quest.type.TypeBrandRec;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeDocClassRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.shared.pom.PersistentRec;
import java.util.Vector;

public abstract class OAObject
extends PersistentRec
implements OAInterface,
Cloneable {
    static final long serialVersionUID = 1000001L;
    private String OAItemNum_ = "";
    private TypeDocClassRec docClass_;
    private Vector countries_;
    private Vector origCountries_;
    private TypeBrandRec brand_;
    private boolean archived_;
    private String creationTime_;
    private String changedTime_;
    private String dbuser_;
    private boolean openDraft_;

    public abstract boolean assignDatabaseKeys();

    public abstract int getInd();

    public String getOAItemNum() {
        return this.OAItemNum_;
    }

    void setOAItemNum(String string) {
        this.OAItemNum_ = string;
    }

    public TypeDocClassRec getDocClass() {
        return this.docClass_;
    }

    public void setDocClass(TypeDocClassRec typeDocClassRec) {
        this.docClass_ = typeDocClassRec;
        this.updateRecStatus(1);
    }

    public Vector getCountryList() {
        if (this.countries_ == null) {
            this.countries_ = new Vector();
        }
        return this.countries_;
    }

    public void setCountryList(Vector vector) {
        this.countries_ = vector;
        this.updateRecStatus(1);
    }

    Vector getOriginalCountryList() {
        return this.origCountries_;
    }

    void setOriginalCountryListFromCurrent() {
        this.origCountries_ = this.countries_ != null ? (Vector)this.countries_.clone() : null;
    }

    public TypeBrandRec getBrand() {
        return this.brand_;
    }

    public void setBrand(TypeBrandRec typeBrandRec) {
        this.brand_ = typeBrandRec;
        this.updateRecStatus(1);
    }

    public boolean isArchived() {
        return this.archived_;
    }

    public void setArchived(boolean bl) {
        this.archived_ = bl;
        this.updateRecStatus(1);
    }

    public String getCreationTime() {
        return this.creationTime_;
    }

    public void setCreationTime(String string) {
        this.creationTime_ = string;
    }

    public String getChangedTime() {
        return this.changedTime_;
    }

    public void setChangedTime(String string) {
        this.changedTime_ = string;
    }

    public String getDbUser() {
        return this.dbuser_;
    }

    public void setDbUser(String string) {
        this.dbuser_ = string.toUpperCase();
    }

    public boolean hasOpenDraft() {
        return this.openDraft_;
    }

    void setOpenDraft(boolean bl) {
        this.openDraft_ = bl;
    }

    public Object clone() {
        try {
            OAObject oAObject = (OAObject)super.clone();
            return oAObject;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public int hashCode() {
        if (this.getInd() == 0) {
            throw new IllegalStateException("hashCode(): OAObject is new");
        }
        return this.OAItemNum_.hashCode();
    }

    public boolean equals(Object object) {
        if (this.getInd() == 0) {
            throw new IllegalStateException("equals(): OAObject is new");
        }
        return object instanceof OAObject && ((OAObject)object).getInd() == this.getInd();
    }

    public String toString() {
        return "OAObject";
    }

    void updateTypeRecData() {
        TypeDocClassRec typeDocClassRec;
        TypeList typeList = TypeList.getInstance();
        TypeBrandRec typeBrandRec = (TypeBrandRec)typeList.objectFromInd(this.brand_.getInd(), 2);
        if (typeBrandRec != null) {
            this.brand_ = typeBrandRec;
        }
        if ((typeDocClassRec = (TypeDocClassRec)typeList.objectFromInd(this.docClass_.getInd(), 5)) != null) {
            this.docClass_ = typeDocClassRec;
        }
        if (this.countries_ != null) {
            Vector<TypeCountryCodeRec> vector = new Vector<TypeCountryCodeRec>();
            int n = 0;
            while (n < this.countries_.size()) {
                TypeCountryCodeRec typeCountryCodeRec = (TypeCountryCodeRec)this.countries_.elementAt(n);
                TypeCountryCodeRec typeCountryCodeRec2 = (TypeCountryCodeRec)typeList.objectFromInd(typeCountryCodeRec.getInd(), 3);
                if (typeCountryCodeRec2 != null) {
                    vector.addElement(typeCountryCodeRec2);
                } else {
                    vector.addElement(typeCountryCodeRec);
                }
                ++n;
            }
            this.countries_ = vector;
        }
    }

    public OAObject() {
        this.docClass_ = null;
        this.countries_ = null;
        this.origCountries_ = null;
        this.brand_ = null;
        this.archived_ = false;
        this.creationTime_ = "";
        this.changedTime_ = "";
        this.dbuser_ = "";
    }

    OAObject(OAObject oAObject) {
        this.docClass_ = oAObject.docClass_;
        this.countries_ = oAObject.countries_;
        this.origCountries_ = null;
        this.brand_ = oAObject.brand_;
        this.archived_ = oAObject.archived_;
        this.dbuser_ = oAObject.dbuser_;
        this.creationTime_ = "";
        this.changedTime_ = "";
    }
}

