/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.oa.AddtlInfo;
import com.ibm.nzna.projects.common.quest.oa.Answer;
import com.ibm.nzna.projects.common.quest.oa.ConditionalObject;
import com.ibm.nzna.projects.common.quest.oa.DocLink;
import com.ibm.nzna.projects.common.quest.oa.OAMode;
import com.ibm.nzna.projects.common.quest.oa.OAObject;
import com.ibm.nzna.projects.common.quest.oa.QuestionDraft;
import com.ibm.nzna.projects.common.quest.oa.QuestionWriter;
import com.ibm.nzna.projects.common.quest.oa.Title;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.quest.type.TypeQuestionRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;

public class Question
extends OAObject {
    static final long serialVersionUID = 1000000L;
    public static final String OA_PREFIX = "Q";
    protected int questionInd_ = 0;
    protected Vector answers_ = null;
    protected Vector titles_ = null;
    protected Vector addtlInfo_ = null;
    protected Vector docLinks_ = null;
    protected Hashtable answersByInd_ = null;
    protected TypeQuestionRec questionType_ = null;
    protected boolean hiddenAnswers_ = false;
    protected boolean autoFill_ = false;

    private void initSubObjects(Question question) {
        ConditionalObject conditionalObject;
        int n;
        this.answers_ = question.answers_;
        this.titles_ = question.titles_;
        this.addtlInfo_ = question.addtlInfo_;
        this.docLinks_ = question.docLinks_;
        this.questionType_ = question.questionType_;
        this.hiddenAnswers_ = question.hiddenAnswers_;
        this.autoFill_ = question.autoFill_;
        boolean bl = false;
        if (this instanceof QuestionDraft) {
            bl = true;
        }
        if (this.answers_ != null) {
            n = 0;
            while (n < this.answers_.size()) {
                conditionalObject = (Answer)this.answers_.elementAt(n);
                ((Answer)conditionalObject).setDraft(bl);
                ((Answer)conditionalObject).resetNew();
                ++n;
            }
        }
        if (this.titles_ != null) {
            n = 0;
            while (n < this.titles_.size()) {
                conditionalObject = (Title)this.titles_.elementAt(n);
                ((Title)conditionalObject).resetNew();
                ++n;
            }
        }
        if (this.addtlInfo_ != null) {
            n = 0;
            while (n < this.addtlInfo_.size()) {
                conditionalObject = (AddtlInfo)this.addtlInfo_.elementAt(n);
                ((AddtlInfo)conditionalObject).resetNew();
                ++n;
            }
        }
        if (this.docLinks_ != null) {
            n = 0;
            while (n < this.docLinks_.size()) {
                conditionalObject = (DocLink)this.docLinks_.elementAt(n);
                ((DocLink)conditionalObject).resetNew();
                ++n;
            }
        }
    }

    public boolean assignDatabaseKeys() {
        ConditionalObject conditionalObject;
        int n;
        boolean bl = false;
        if (this instanceof QuestionDraft) {
            bl = true;
        }
        boolean bl2 = this.assignMyDatabaseKey();
        if (this.answers_ != null) {
            n = 0;
            while (n < this.answers_.size() && bl2) {
                conditionalObject = (Answer)this.answers_.elementAt(n);
                if (bl) {
                    ((Answer)conditionalObject).setDraft(true);
                }
                bl2 = ((Answer)conditionalObject).assignDatabaseKeys();
                ++n;
            }
        }
        if (this.titles_ != null) {
            n = 0;
            while (n < this.titles_.size() && bl2) {
                conditionalObject = (Title)this.titles_.elementAt(n);
                bl2 = bl ? ((Title)conditionalObject).assignDatabaseKeyForQuestionDraft() : ((Title)conditionalObject).assignDatabaseKeyForQuestion();
                ++n;
            }
        }
        if (this.addtlInfo_ != null) {
            n = 0;
            while (n < this.addtlInfo_.size() && bl2) {
                conditionalObject = (AddtlInfo)this.addtlInfo_.elementAt(n);
                bl2 = bl ? ((AddtlInfo)conditionalObject).assignDatabaseKeyForQuestionDraft() : ((AddtlInfo)conditionalObject).assignDatabaseKeyForQuestion();
                ++n;
            }
        }
        if (this.docLinks_ != null) {
            n = 0;
            while (n < this.docLinks_.size() && bl2) {
                conditionalObject = (DocLink)this.docLinks_.elementAt(n);
                bl2 = bl ? ((DocLink)conditionalObject).assignDatabaseKeyForQuestionDraft() : ((DocLink)conditionalObject).assignDatabaseKeyForQuestion();
                ++n;
            }
        }
        return bl2;
    }

    void assignDatabaseKeys(Connection connection) throws Exception {
        ConditionalObject conditionalObject;
        int n;
        boolean bl = false;
        if (this instanceof QuestionDraft) {
            bl = true;
        }
        this.assignMyDatabaseKey(connection);
        if (this.answers_ != null) {
            n = 0;
            while (n < this.answers_.size()) {
                conditionalObject = (Answer)this.answers_.elementAt(n);
                if (bl) {
                    ((Answer)conditionalObject).setDraft(true);
                }
                ((Answer)conditionalObject).assignDatabaseKeys(connection);
                ++n;
            }
        }
        if (this.titles_ != null) {
            n = 0;
            while (n < this.titles_.size()) {
                conditionalObject = (Title)this.titles_.elementAt(n);
                if (bl) {
                    ((Title)conditionalObject).assignDatabaseKeyForQuestionDraft(connection);
                } else {
                    ((Title)conditionalObject).assignDatabaseKeyForQuestion(connection);
                }
                ++n;
            }
        }
        if (this.addtlInfo_ != null) {
            n = 0;
            while (n < this.addtlInfo_.size()) {
                conditionalObject = (AddtlInfo)this.addtlInfo_.elementAt(n);
                if (bl) {
                    ((AddtlInfo)conditionalObject).assignDatabaseKeyForQuestionDraft(connection);
                } else {
                    ((AddtlInfo)conditionalObject).assignDatabaseKeyForQuestion(connection);
                }
                ++n;
            }
        }
        if (this.docLinks_ != null) {
            n = 0;
            while (n < this.docLinks_.size()) {
                conditionalObject = (DocLink)this.docLinks_.elementAt(n);
                if (bl) {
                    ((DocLink)conditionalObject).assignDatabaseKeyForQuestionDraft(connection);
                } else {
                    ((DocLink)conditionalObject).assignDatabaseKeyForQuestion(connection);
                }
                ++n;
            }
        }
    }

    boolean assignMyDatabaseKey() {
        boolean bl = true;
        if (this.questionInd_ == 0 && this.valid()) {
            LogSystem.log(1, "Getting database key for Question");
            this.questionInd_ = Counter.getCounter(LogSystem.getInstance(), "QSTNIND");
            if (this.questionInd_ == 0) {
                LogSystem.log(2, "Failed to get database key for Question");
                bl = false;
            }
        }
        return bl;
    }

    void assignMyDatabaseKey(Connection connection) throws Exception {
        if (this.questionInd_ == 0) {
            this.questionInd_ = Counter.getCounter(connection, "QSTNIND");
            if (this.questionInd_ == 0) {
                throw new Exception("Failed to get database key for Question");
            }
        }
    }

    public boolean objectModified() {
        ConditionalObject conditionalObject;
        int n;
        int n2;
        boolean bl = super.modified();
        if (this.answers_ != null) {
            n2 = 1;
            n = 0;
            while (n < this.answers_.size() && !bl) {
                conditionalObject = (Answer)this.answers_.elementAt(n);
                if (conditionalObject.valid()) {
                    conditionalObject.setSortOrder(n2++);
                }
                bl = bl || ((Answer)conditionalObject).objectModified();
                ++n;
            }
        }
        if (this.titles_ != null) {
            n2 = 1;
            n = 0;
            while (n < this.titles_.size() && !bl) {
                conditionalObject = (Title)this.titles_.elementAt(n);
                if (conditionalObject.valid()) {
                    conditionalObject.setSortOrder(n2++);
                }
                bl = bl || conditionalObject.modified();
                ++n;
            }
        }
        if (this.addtlInfo_ != null) {
            n2 = 1;
            n = 0;
            while (n < this.addtlInfo_.size() && !bl) {
                conditionalObject = (AddtlInfo)this.addtlInfo_.elementAt(n);
                if (conditionalObject.valid()) {
                    conditionalObject.setSortOrder(n2++);
                }
                bl = bl || conditionalObject.modified();
                ++n;
            }
        }
        if (this.docLinks_ != null) {
            n2 = 1;
            n = 0;
            while (n < this.docLinks_.size() && !bl) {
                conditionalObject = (DocLink)this.docLinks_.elementAt(n);
                if (conditionalObject.valid()) {
                    conditionalObject.setSortOrder(n2++);
                }
                bl = bl || conditionalObject.modified();
                ++n;
            }
        }
        return bl;
    }

    public int getInd() {
        return this.questionInd_;
    }

    void setInd(int n) {
        this.questionInd_ = n;
        this.setOAItemNum(this.questionInd_);
    }

    void setOAItemNum(int n) {
        super.setOAItemNum(OA_PREFIX + n);
    }

    public Vector getAnswers() {
        if (this.answers_ == null) {
            this.answers_ = new Vector();
        }
        return this.answers_;
    }

    public void setAnswers(Vector vector) {
        this.answers_ = vector;
    }

    public Answer getAnswerByInd(int n) {
        if (this.answersByInd_ == null) {
            this.buildAnswerTable();
        }
        return (Answer)this.answersByInd_.get(new Integer(n));
    }

    private void buildAnswerTable() {
        this.answersByInd_ = new Hashtable();
        int n = 0;
        while (n < this.answers_.size()) {
            Answer answer = (Answer)this.answers_.elementAt(n);
            this.answersByInd_.put(new Integer(answer.getInd()), answer);
            ++n;
        }
    }

    public Vector getTitles() {
        return this.titles_;
    }

    public void setTitles(Vector vector) {
        this.titles_ = vector;
    }

    public Vector getAdditionalInfo() {
        return this.addtlInfo_;
    }

    public void setAdditionalInfo(Vector vector) {
        this.addtlInfo_ = vector;
    }

    public Vector getDocLinks() {
        return this.docLinks_;
    }

    public void setDocLinks(Vector vector) {
        this.docLinks_ = vector;
    }

    public TypeQuestionRec getQuestionType() {
        return this.questionType_;
    }

    public void setQuestionType(TypeQuestionRec typeQuestionRec) {
        this.questionType_ = typeQuestionRec;
        this.updateRecStatus(1);
    }

    public boolean getHiddenAnswers() {
        return this.hiddenAnswers_;
    }

    public void setHiddenAnswers(boolean bl) {
        this.hiddenAnswers_ = bl;
        this.updateRecStatus(1);
    }

    public boolean getAutoFill() {
        return this.autoFill_;
    }

    public void setAutoFill(boolean bl) {
        this.autoFill_ = bl;
        this.updateRecStatus(1);
    }

    public Object clone() {
        Question question = (Question)super.clone();
        if (this.answers_ != null) {
            question.answers_ = (Vector)this.answers_.clone();
        }
        if (this.answersByInd_ != null) {
            question.answersByInd_ = (Hashtable)this.answersByInd_.clone();
        }
        if (this.addtlInfo_ != null) {
            question.addtlInfo_ = (Vector)this.addtlInfo_.clone();
        }
        if (this.docLinks_ != null) {
            question.docLinks_ = (Vector)this.docLinks_.clone();
        }
        return question;
    }

    public String toString() {
        return "Question " + this.getInd();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int writeToDatabase() {
        int n;
        boolean bl;
        block17: {
            SQLMethod sQLMethod;
            block16: {
                LogSystem.log(2, ">>> Starting Question.writeToDatabase()");
                if (!this.assignDatabaseKeys()) {
                    return -1;
                }
                bl = false;
                sQLMethod = new SQLMethod(1, "Question.writeToDatabase()", 10);
                n = 0;
                StoredProcRec storedProcRec = null;
                try {
                    try {
                        CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.ExtSqlRunner", 3);
                        String string = QuestionWriter.getSQL(this);
                        if (string.length() == 0) {
                            LogSystem.log(1, "No changes to be written");
                            int n2 = 0;
                            Object var6_9 = null;
                            sQLMethod.close();
                            return n2;
                        }
                        String string2 = Text.replaceAllStrInStr(string, SqlRunner.END_DELIM, "\n");
                        LogSystem.log(1, "Starting to send statements to EXTSQLRUNNER");
                        LogSystem.log(1, string2);
                        callableStatement.registerOutParameter(3, -4);
                        callableStatement.setBytes(1, string.getBytes());
                        callableStatement.setInt(2, 0);
                        callableStatement.execute();
                        storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 3);
                        callableStatement.close();
                        if (storedProcRec == null) {
                            LogSystem.log(2, "StoredProcRec is null - error status unknown");
                        }
                        if (storedProcRec != null && storedProcRec.error) {
                            LogSystem.log(2, storedProcRec.errorStr);
                            n = storedProcRec.sqlCode;
                            if (n == 0) {
                                n = -1;
                            }
                            break block16;
                        }
                        if (this.getRecStatus() == 2) {
                            bl = true;
                        }
                        Statement statement = null;
                        int n3 = 0;
                        while (true) {
                            if (this.addtlInfo_ == null || n3 >= this.addtlInfo_.size()) {
                                if (statement != null) {
                                    statement.close();
                                }
                                break;
                            }
                            AddtlInfo addtlInfo = (AddtlInfo)this.addtlInfo_.elementAt(n3);
                            int n4 = addtlInfo.getRecStatus();
                            if (n4 == 2 || n4 == 1) {
                                LogSystem.log(1, "Updating additional information text for " + addtlInfo.getInd());
                                if (statement == null) {
                                    statement = sQLMethod.createPreparedStatement("UPDATE oa.questionAddInfo SET addInfo=? WHERE questionAddInfoInd=?AND languageInd=?");
                                }
                                statement.setString(1, addtlInfo.getAddtlInfo());
                                statement.setInt(2, addtlInfo.getInd());
                                statement.setInt(3, addtlInfo.getLanguage().getInd());
                                statement.executeUpdate();
                            }
                            ++n3;
                        }
                    }
                    catch (Exception exception) {
                        sQLMethod.rollBack();
                        LogSystem.log(3, exception);
                        n = -1;
                        Object var6_11 = null;
                        sQLMethod.close();
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_12 = null;
                    sQLMethod.close();
                    throw throwable;
                }
            }
            Object var6_10 = null;
            sQLMethod.close();
        }
        if (n == 0 || bl) {
            this.setRecNoChange();
        }
        LogSystem.log(2, ">>> Question.writeToDatabase() complete");
        return n;
    }

    void setRecNoChange() {
        ConditionalObject conditionalObject;
        int n;
        this.updateRecStatus(0);
        super.setOriginalCountryListFromCurrent();
        if (this.answers_ != null) {
            n = 0;
            while (n < this.answers_.size()) {
                conditionalObject = (Answer)this.answers_.elementAt(n);
                ((Answer)conditionalObject).setRecNoChange();
                ++n;
            }
        }
        if (this.titles_ != null) {
            n = 0;
            while (n < this.titles_.size()) {
                conditionalObject = (Title)this.titles_.elementAt(n);
                conditionalObject.setRecNoChange();
                ++n;
            }
        }
        if (this.addtlInfo_ != null) {
            n = 0;
            while (n < this.addtlInfo_.size()) {
                conditionalObject = (AddtlInfo)this.addtlInfo_.elementAt(n);
                conditionalObject.setRecNoChange();
                ++n;
            }
        }
        if (this.docLinks_ != null) {
            n = 0;
            while (n < this.docLinks_.size()) {
                conditionalObject = (DocLink)this.docLinks_.elementAt(n);
                conditionalObject.setRecNoChange();
                ++n;
            }
        }
    }

    public static Question readFromDatabase(int n, int n2) {
        LogSystem.log(2, ">>> Starting Question.readFromDatabase()");
        long l = System.currentTimeMillis();
        SQLMethod sQLMethod = new SQLMethod(1, "Question.readFromDatabase()", 5);
        StoredProcRec storedProcRec = null;
        Question question = null;
        try {
            CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.OAReader", 7);
            callableStatement.registerOutParameter(6, -4);
            callableStatement.registerOutParameter(7, -4);
            callableStatement.setInt(1, n);
            callableStatement.setInt(2, 1);
            callableStatement.setInt(3, 0);
            callableStatement.setInt(4, n2);
            callableStatement.setInt(5, OAMode.getMode());
            callableStatement.execute();
            question = (Question)StoredProcUtil.getObjectFromStatement(callableStatement, 6);
            storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 7);
            callableStatement.close();
            if (storedProcRec == null) {
                LogSystem.log(2, "StoredProcRec is null - error status unknown");
            }
            if (storedProcRec != null && storedProcRec.error) {
                LogSystem.log(2, storedProcRec.errorStr);
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(3, exception);
        }
        sQLMethod.close();
        long l2 = System.currentTimeMillis();
        LogSystem.log(1, "Elapsed time: " + (l2 - l) + " msec");
        LogSystem.log(2, ">>> Question.readFromDatabase() completed");
        if (question != null) {
            if (OAMode.currentMode != 1) {
                question.updateTypeRecData();
                question.setRecNoChange();
            }
        } else {
            LogSystem.log(2, "No object found for indicator " + n);
        }
        return question;
    }

    void updateTypeRecData() {
        ConditionalObject conditionalObject;
        int n;
        super.updateTypeRecData();
        TypeList typeList = TypeList.getInstance();
        TypeQuestionRec typeQuestionRec = (TypeQuestionRec)typeList.objectFromInd(this.questionType_.getInd(), 18);
        if (typeQuestionRec != null) {
            this.questionType_ = typeQuestionRec;
        }
        if (this.answers_ != null) {
            n = 0;
            while (n < this.answers_.size()) {
                conditionalObject = (Answer)this.answers_.elementAt(n);
                ((Answer)conditionalObject).updateTypeRecData();
                ++n;
            }
        }
        if (this.titles_ != null) {
            n = 0;
            while (n < this.titles_.size()) {
                conditionalObject = (Title)this.titles_.elementAt(n);
                ((Title)conditionalObject).updateTypeRecData();
                ++n;
            }
        }
        if (this.addtlInfo_ != null) {
            n = 0;
            while (n < this.addtlInfo_.size()) {
                conditionalObject = (AddtlInfo)this.addtlInfo_.elementAt(n);
                ((AddtlInfo)conditionalObject).updateTypeRecData();
                ++n;
            }
        }
        if (this.docLinks_ != null) {
            n = 0;
            while (n < this.docLinks_.size()) {
                conditionalObject = (DocLink)this.docLinks_.elementAt(n);
                conditionalObject.updateTypeRecData();
                ++n;
            }
        }
    }

    public static int findOpenDraft(int n) {
        LogSystem.log(2, ">>> Starting Question.findOpenDraft()");
        SQLMethod sQLMethod = new SQLMethod(1, "Question.findOpenDraft()", 1);
        int n2 = 0;
        try {
            try {
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT questionInd " + "FROM oadraft.question " + "WHERE activeQuestionInd=" + n + " " + "AND stopDate IS NULL " + "FOR FETCH ONLY");
                if (resultSet.next()) {
                    n2 = resultSet.getInt(1);
                } else {
                    LogSystem.log(1, "No open draft found for " + n);
                }
                resultSet.close();
            }
            catch (Exception exception) {
                LogSystem.log(3, exception);
                Object var4_7 = null;
                sQLMethod.close();
            }
            Object var4_6 = null;
            sQLMethod.close();
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            sQLMethod.close();
            throw throwable;
        }
        LogSystem.log(2, ">>> Question.findOpenDraft() completed");
        return n2;
    }

    public Question() {
        this(0);
    }

    public Question(int n) {
        this.setInd(n);
        if (this.questionInd_ == 0) {
            this.updateRecStatus(2);
        }
    }

    Question(Question question) {
        super(question);
        this.setInd(0);
        this.initSubObjects(question);
        this.updateRecStatus(2);
    }

    Question(QuestionDraft questionDraft) {
        super(questionDraft);
        this.setInd(questionDraft.getActiveQuestionInd());
        this.initSubObjects(questionDraft);
        if (this.questionInd_ == 0) {
            this.updateRecStatus(2);
        } else {
            this.updateRecStatus(1);
        }
    }
}

