/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.AddtlInfo;
import com.ibm.nzna.projects.common.quest.oa.Answer;
import com.ibm.nzna.projects.common.quest.oa.AnswerDraftWriter;
import com.ibm.nzna.projects.common.quest.oa.ConditionalObject;
import com.ibm.nzna.projects.common.quest.oa.CountryWriter;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.DocLink;
import com.ibm.nzna.projects.common.quest.oa.Question;
import com.ibm.nzna.projects.common.quest.oa.QuestionDraft;
import com.ibm.nzna.projects.common.quest.oa.QuestionInfoDraftWriter;
import com.ibm.nzna.projects.common.quest.oa.QuestionLinkDraftWriter;
import com.ibm.nzna.projects.common.quest.oa.QuestionTitleDraftWriter;
import com.ibm.nzna.projects.common.quest.oa.Title;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import java.util.Vector;

class QuestionDraftWriter {
    static String getSQL(QuestionDraft questionDraft) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(QuestionDraftWriter.getQuestionDraftSQL(questionDraft));
        if (questionDraft.valid()) {
            stringBuffer.append(QuestionDraftWriter.getObjectSQL(questionDraft));
        }
        if (!questionDraft.modified() && stringBuffer.length() > 0) {
            stringBuffer.append("UPDATE oadraft.question SET changedTime=CURRENT TIMESTAMP WHERE questionInd=").append(questionDraft.getInd()).append(SqlRunner.END_DELIM);
        }
        return stringBuffer.toString();
    }

    static String getObjectSQL(QuestionDraft questionDraft) {
        ConditionalObject conditionalObject;
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = questionDraft.getAnswers();
        if (vector != null) {
            n2 = 1;
            n = 0;
            while (n < vector.size()) {
                conditionalObject = (Answer)vector.elementAt(n);
                if (conditionalObject.valid()) {
                    conditionalObject.setSortOrder(n2++);
                    ((Answer)conditionalObject).setParentInd(questionDraft.getInd());
                    conditionalObject.setDbUser(questionDraft.getDbUser());
                }
                stringBuffer.append(AnswerDraftWriter.getSQL((Answer)conditionalObject));
                ++n;
            }
        }
        if ((vector = questionDraft.getTitles()) != null) {
            n2 = 1;
            n = 0;
            while (n < vector.size()) {
                conditionalObject = (Title)vector.elementAt(n);
                if (conditionalObject.valid()) {
                    conditionalObject.setSortOrder(n2++);
                    ((Title)conditionalObject).setParentInd(questionDraft.getInd());
                    conditionalObject.setDbUser(questionDraft.getDbUser());
                }
                stringBuffer.append(QuestionTitleDraftWriter.getSQL((Title)conditionalObject));
                ++n;
            }
        }
        if ((vector = questionDraft.getAdditionalInfo()) != null) {
            n2 = 1;
            n = 0;
            while (n < vector.size()) {
                conditionalObject = (AddtlInfo)vector.elementAt(n);
                if (conditionalObject.valid()) {
                    conditionalObject.setSortOrder(n2++);
                    ((AddtlInfo)conditionalObject).setParentInd(questionDraft.getInd());
                    conditionalObject.setDbUser(questionDraft.getDbUser());
                }
                stringBuffer.append(QuestionInfoDraftWriter.getSQL((AddtlInfo)conditionalObject));
                ++n;
            }
        }
        if ((vector = questionDraft.getDocLinks()) != null) {
            n2 = 1;
            n = 0;
            while (n < vector.size()) {
                conditionalObject = (DocLink)vector.elementAt(n);
                if (conditionalObject.valid()) {
                    conditionalObject.setSortOrder(n2++);
                    ((DocLink)conditionalObject).setParentInd(questionDraft.getInd());
                    conditionalObject.setDbUser(questionDraft.getDbUser());
                }
                stringBuffer.append(QuestionLinkDraftWriter.getSQL((DocLink)conditionalObject));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    static String getQuestionDraftSQL(QuestionDraft questionDraft) {
        String string;
        switch (questionDraft.getRecStatus()) {
            case 2: {
                string = QuestionDraftWriter.getInsertSQL(questionDraft);
                break;
            }
            case 1: {
                string = QuestionDraftWriter.getUpdateSQL(questionDraft);
                break;
            }
            case 3: {
                string = QuestionDraftWriter.getDeleteSQL(questionDraft);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(QuestionDraft questionDraft) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO oadraft.question (questionInd, activeQuestionInd, questionTypeInd, hiddenFlag, autoFillFlag, brandInd, typeWorkInd, docClassInd, comments, maintLock, startDate, stopDate, recycled, archived, created, dbUser, changedTime) VALUES (");
        stringBuffer.append(questionDraft.getInd()).append(',');
        if (questionDraft.getActiveQuestionInd() == 0) {
            stringBuffer.append("NULL").append(',');
        } else {
            stringBuffer.append(questionDraft.getActiveQuestionInd()).append(',');
        }
        stringBuffer.append(questionDraft.getQuestionType().getInd()).append(',');
        stringBuffer.append(DatabaseUtil.booleanToDB(questionDraft.getHiddenAnswers())).append(',');
        stringBuffer.append(DatabaseUtil.booleanToDB(questionDraft.getAutoFill())).append(',');
        stringBuffer.append(questionDraft.getBrand().getInd()).append(',');
        stringBuffer.append(questionDraft.getTypeWorkRequired().getInd()).append(',');
        stringBuffer.append(questionDraft.getDocClass().getInd()).append(',');
        String string = questionDraft.getComments();
        if (string == null || string.length() == 0) {
            stringBuffer.append("NULL,");
        } else {
            stringBuffer.append(DatabaseUtil.stringToDB(string)).append(',');
        }
        stringBuffer.append(DatabaseUtil.booleanToDB(questionDraft.getMaintLock())).append(',');
        stringBuffer.append("CURRENT DATE").append(',');
        stringBuffer.append("NULL").append(',');
        stringBuffer.append(DatabaseUtil.booleanToDB(questionDraft.isRecycled())).append(',');
        stringBuffer.append(DatabaseUtil.booleanToDB(questionDraft.isArchived())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP").append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(questionDraft.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getInsertSQL("oadraft.questionCountry", questionDraft.getInd(), questionDraft.getCountryList(), questionDraft.getDbUser()));
        return stringBuffer.toString();
    }

    static String getUpdateSQL(QuestionDraft questionDraft) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("UPDATE oadraft.question SET");
        stringBuffer.append(" questionTypeInd=").append(questionDraft.getQuestionType().getInd());
        stringBuffer.append(",hiddenFlag=").append(DatabaseUtil.booleanToDB(questionDraft.getHiddenAnswers()));
        stringBuffer.append(",autoFillFlag=").append(DatabaseUtil.booleanToDB(questionDraft.getAutoFill()));
        stringBuffer.append(",brandInd=").append(questionDraft.getBrand().getInd());
        stringBuffer.append(",typeWorkInd=").append(questionDraft.getTypeWorkRequired().getInd());
        stringBuffer.append(",docClassInd=").append(questionDraft.getDocClass().getInd());
        stringBuffer.append(",comments=");
        String string = questionDraft.getComments();
        if (string == null || string.length() == 0) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append(DatabaseUtil.stringToDB(string));
        }
        stringBuffer.append(",maintLock=").append(DatabaseUtil.booleanToDB(questionDraft.getMaintLock()));
        stringBuffer.append(",recycled=").append(DatabaseUtil.booleanToDB(questionDraft.isRecycled()));
        stringBuffer.append(",archived=").append(DatabaseUtil.booleanToDB(questionDraft.isArchived()));
        stringBuffer.append(",dbUser=").append(DatabaseUtil.stringToDB(questionDraft.getDbUser()));
        stringBuffer.append(",changedTime=CURRENT TIMESTAMP");
        stringBuffer.append(" WHERE questionInd=").append(questionDraft.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getUpdateSQL("oadraft.questionCountry", "questionInd", questionDraft.getInd(), questionDraft.getCountryList(), questionDraft.getOriginalCountryList(), questionDraft.getDbUser()));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(Question question) {
        StringBuffer stringBuffer = new StringBuffer(500);
        int n = question.getInd();
        stringBuffer.append(AnswerDraftWriter.getDeleteAllForQuestionSQL(n));
        stringBuffer.append(QuestionTitleDraftWriter.getDeleteAllForQuestionSQL(n));
        stringBuffer.append(QuestionInfoDraftWriter.getDeleteAllForQuestionSQL(n));
        stringBuffer.append(QuestionLinkDraftWriter.getDeleteAllForQuestionSQL(n));
        stringBuffer.append("DELETE from oadraft.questioncountry where questionind=").append(n).append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oadraft.question where questionind=").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    QuestionDraftWriter() {
    }
}

