/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.CountryReader;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.EdgeGroupDraftReader;
import com.ibm.nzna.projects.common.quest.oa.Node;
import com.ibm.nzna.projects.common.quest.oa.NodeDraftReader;
import com.ibm.nzna.projects.common.quest.oa.PendingDraftException;
import com.ibm.nzna.projects.common.quest.oa.Symptom;
import com.ibm.nzna.projects.common.quest.oa.SymptomDraft;
import com.ibm.nzna.projects.common.quest.oa.SymptomReader;
import com.ibm.nzna.projects.common.quest.oa.TitleReader;
import com.ibm.nzna.projects.common.quest.type.TypeBrandRec;
import com.ibm.nzna.projects.common.quest.type.TypeDocClassRec;
import com.ibm.nzna.projects.common.quest.type.TypeStatusRec;
import com.ibm.nzna.projects.common.quest.type.TypeSymptomRec;
import com.ibm.nzna.projects.common.quest.type.TypeWorkRec;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SymptomDraftReader {
    private static final short TYPE_STATUS_SYMPTOM = 4;

    public static boolean readFromDB(Connection connection, SymptomDraft symptomDraft, int n) throws SQLException {
        boolean bl;
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + "activeSymptomInd, symptomTypeInd, rootNodeInd, " + "brandInd,         typeWorkInd,    docClassInd, statusInd, comments, " + "maintLock,        startDate,      stopDate,    recycled,  archived, " + "created,          dbUser,         changedTime " + "FROM oadraft.symptom " + "WHERE symptomInd=" + symptomDraft.getInd() + " " + "FOR FETCH ONLY");
        if (!resultSet.next()) {
            bl = false;
            statement.close();
        } else {
            bl = true;
            symptomDraft.setActiveSymptomInd(resultSet.getInt(1));
            symptomDraft.setSymptomType(new TypeSymptomRec(resultSet.getShort(2), ""));
            int n2 = resultSet.getInt(3);
            symptomDraft.setBrand(new TypeBrandRec(resultSet.getInt(4), "", 0));
            symptomDraft.setTypeWorkRequired(new TypeWorkRec(resultSet.getInt(5), ""));
            symptomDraft.setDocClass(new TypeDocClassRec(resultSet.getShort(6), ""));
            symptomDraft.setSymptomStatus(new TypeStatusRec(resultSet.getShort(7), 4, ""));
            symptomDraft.setComments(resultSet.getString(8));
            if (resultSet.wasNull()) {
                symptomDraft.setComments("");
            }
            symptomDraft.setMaintLock(DatabaseUtil.booleanFromDB(resultSet.getString(9)));
            symptomDraft.setStartDate(resultSet.getString(10));
            symptomDraft.setStopDate(resultSet.getString(11));
            symptomDraft.setRecycled(DatabaseUtil.booleanFromDB(resultSet.getString(12)));
            symptomDraft.setArchived(DatabaseUtil.booleanFromDB(resultSet.getString(13)));
            symptomDraft.setCreationTime(DatabaseUtil.timestampFromDB(resultSet.getString(14)));
            symptomDraft.setDbUser(resultSet.getString(15).trim());
            symptomDraft.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(16)));
            statement.close();
            symptomDraft.setCountryList(CountryReader.readCountries(connection, "oadraft.symptomCountry", "symptomInd", symptomDraft.getInd()));
            TitleReader.readSymptomDraftTitles(connection, symptomDraft, n);
            NodeDraftReader.readNodesForSymptom(connection, symptomDraft);
            EdgeGroupDraftReader.readEdgeGroupsForSymptom(connection, symptomDraft);
            Node node = symptomDraft.getNodeByInd(n2);
            symptomDraft.setRootNode(node);
            symptomDraft.updateRecStatus(0);
            symptomDraft.edgesByInd_ = null;
            symptomDraft.nodesByInd_ = null;
        }
        return bl;
    }

    public static SymptomDraft getDraft(Connection connection, int n, int n2) throws SQLException, PendingDraftException {
        Statement statement = connection.createStatement();
        SymptomDraft symptomDraft = null;
        ResultSet resultSet = statement.executeQuery("SELECT symptomInd " + "FROM oadraft.symptom " + "WHERE stopDate IS NULL AND activeSymptomInd=" + n + " " + "FOR FETCH ONLY");
        if (resultSet.next()) {
            int n3 = resultSet.getInt(1);
            resultSet.close();
            SymptomDraft symptomDraft2 = new SymptomDraft(n3);
            if (SymptomDraftReader.readFromDB(connection, symptomDraft2, n2)) {
                symptomDraft = symptomDraft2;
            }
        } else {
            resultSet.close();
            Symptom symptom = new Symptom(n);
            if (SymptomReader.readFromDB(connection, symptom, n2, 0)) {
                SymptomDraft symptomDraft3;
                if (symptom.hasOpenDraft()) {
                    throw new PendingDraftException();
                }
                symptomDraft = symptomDraft3 = new SymptomDraft(symptom);
                statement.executeUpdate("UPDATE oa.symptom " + "SET openDraft='Y' " + "WHERE symptomInd=" + n);
            }
        }
        statement.close();
        return symptomDraft;
    }
}

