/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.CountryWriter;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.EdgeGroup;
import com.ibm.nzna.projects.common.quest.oa.EdgeGroupDraftWriter;
import com.ibm.nzna.projects.common.quest.oa.Node;
import com.ibm.nzna.projects.common.quest.oa.NodeDraftWriter;
import com.ibm.nzna.projects.common.quest.oa.SymptomDraft;
import com.ibm.nzna.projects.common.quest.oa.SymptomTitle;
import com.ibm.nzna.projects.common.quest.oa.SymptomTitleDraftWriter;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import java.util.Vector;

class SymptomDraftWriter {
    static String getSQL(SymptomDraft symptomDraft) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SymptomDraftWriter.getSymptomSQL(symptomDraft));
        if (symptomDraft.valid()) {
            stringBuffer.append(SymptomDraftWriter.getObjectSQL(symptomDraft));
        }
        if (symptomDraft.getRecStatus() == 2) {
            stringBuffer.append(SymptomDraftWriter.getUpdateRootNodeSQL(symptomDraft));
        }
        if (!symptomDraft.modified() && stringBuffer.length() > 0) {
            stringBuffer.append("UPDATE oadraft.symptom SET changedTime=CURRENT TIMESTAMP WHERE symptomInd=").append(symptomDraft.getInd()).append(SqlRunner.END_DELIM);
        }
        return stringBuffer.toString();
    }

    static String getObjectSQL(SymptomDraft symptomDraft) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = symptomDraft.getSymptomTitles();
        if (vector != null) {
            n = 1;
            int n2 = 0;
            while (n2 < vector.size()) {
                SymptomTitle symptomTitle = (SymptomTitle)vector.elementAt(n2);
                if (symptomTitle.valid()) {
                    symptomTitle.setSortOrder(n++);
                    symptomTitle.setSymptomInd(symptomDraft.getInd());
                    symptomTitle.setDbUser(symptomDraft.getDbUser());
                }
                stringBuffer.append(SymptomTitleDraftWriter.getSQL(symptomTitle));
                ++n2;
            }
        }
        if ((vector = symptomDraft.getNodes()) != null) {
            n = 0;
            while (n < vector.size()) {
                Node node = (Node)vector.elementAt(n);
                if (node.valid()) {
                    node.setSymptomInd(symptomDraft.getInd());
                    node.setDbUser(symptomDraft.getDbUser());
                }
                stringBuffer.append(NodeDraftWriter.getSQL(node));
                ++n;
            }
        }
        if ((vector = symptomDraft.getEdgeGroups()) != null) {
            n = 0;
            while (n < vector.size()) {
                EdgeGroup edgeGroup = (EdgeGroup)vector.elementAt(n);
                if (edgeGroup.valid()) {
                    edgeGroup.setSymptomInd(symptomDraft.getInd());
                    edgeGroup.setDbUser(symptomDraft.getDbUser());
                }
                stringBuffer.append(EdgeGroupDraftWriter.getSQL(edgeGroup));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    static String getSymptomSQL(SymptomDraft symptomDraft) {
        String string;
        switch (symptomDraft.getRecStatus()) {
            case 2: {
                string = SymptomDraftWriter.getInsertSQL(symptomDraft);
                break;
            }
            case 1: {
                string = SymptomDraftWriter.getUpdateSQL(symptomDraft);
                break;
            }
            case 3: {
                string = SymptomDraftWriter.getDeleteSQL(symptomDraft);
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    static String getInsertSQL(SymptomDraft symptomDraft) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("INSERT INTO oadraft.symptom (symptomInd, activeSymptomInd, symptomTypeInd, rootNodeInd, brandInd, typeWorkInd, docClassInd, statusInd, comments, maintLock, startDate, stopDate, recycled, archived, created, dbUser, changedTime) VALUES (");
        stringBuffer.append(symptomDraft.getInd()).append(',');
        if (symptomDraft.getActiveSymptomInd() == 0) {
            stringBuffer.append("NULL").append(',');
        } else {
            stringBuffer.append(symptomDraft.getActiveSymptomInd()).append(',');
        }
        stringBuffer.append(symptomDraft.getSymptomType().getInd()).append(',');
        stringBuffer.append("NULL,");
        stringBuffer.append(symptomDraft.getBrand().getInd()).append(',');
        stringBuffer.append(symptomDraft.getTypeWorkRequired().getInd()).append(',');
        stringBuffer.append(symptomDraft.getDocClass().getInd()).append(',');
        stringBuffer.append(symptomDraft.getSymptomStatus().getInd()).append(',');
        String string = symptomDraft.getComments();
        if (string == null || string.length() == 0) {
            stringBuffer.append("NULL,");
        } else {
            stringBuffer.append(DatabaseUtil.stringToDB(string)).append(',');
        }
        stringBuffer.append(DatabaseUtil.booleanToDB(symptomDraft.getMaintLock())).append(',');
        stringBuffer.append("CURRENT DATE").append(',');
        stringBuffer.append("NULL").append(',');
        stringBuffer.append(DatabaseUtil.booleanToDB(symptomDraft.isRecycled())).append(',');
        stringBuffer.append(DatabaseUtil.booleanToDB(symptomDraft.isArchived())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP").append(',');
        stringBuffer.append(DatabaseUtil.stringToDB(symptomDraft.getDbUser())).append(',');
        stringBuffer.append("CURRENT TIMESTAMP)").append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getInsertSQL("oadraft.symptomCountry", symptomDraft.getInd(), symptomDraft.getCountryList(), symptomDraft.getDbUser()));
        return stringBuffer.toString();
    }

    static String getUpdateRootNodeSQL(SymptomDraft symptomDraft) {
        if (symptomDraft.getRootNode() == null) {
            throw new IllegalStateException("Root Node has not been set");
        }
        if (symptomDraft.getRootNodeInd() == 0) {
            throw new IllegalStateException("Root Node indicator is 0 -- the Node was probably not put in the Symptom's Vector of Nodes");
        }
        return "UPDATE oadraft.symptom set rootNodeInd=" + symptomDraft.getRootNodeInd() + " WHERE symptomInd=" + symptomDraft.getInd() + SqlRunner.END_DELIM;
    }

    static String getUpdateSQL(SymptomDraft symptomDraft) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("UPDATE oadraft.symptom SET");
        stringBuffer.append(" symptomTypeInd=").append(symptomDraft.getSymptomType().getInd());
        stringBuffer.append(",brandInd=").append(symptomDraft.getBrand().getInd());
        stringBuffer.append(",typeWorkInd=").append(symptomDraft.getTypeWorkRequired().getInd());
        stringBuffer.append(",docClassInd=").append(symptomDraft.getDocClass().getInd());
        stringBuffer.append(",statusInd=").append(symptomDraft.getSymptomStatus().getInd());
        stringBuffer.append(",comments=");
        String string = symptomDraft.getComments();
        if (string == null || string.length() == 0) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append(DatabaseUtil.stringToDB(string));
        }
        stringBuffer.append(",maintLock=").append(DatabaseUtil.booleanToDB(symptomDraft.getMaintLock()));
        stringBuffer.append(",recycled=").append(DatabaseUtil.booleanToDB(symptomDraft.isRecycled()));
        stringBuffer.append(",archived=").append(DatabaseUtil.booleanToDB(symptomDraft.isArchived()));
        stringBuffer.append(",dbUser=").append(DatabaseUtil.stringToDB(symptomDraft.getDbUser()));
        stringBuffer.append(",changedTime=CURRENT TIMESTAMP");
        stringBuffer.append(" WHERE symptomInd=").append(symptomDraft.getInd()).append(SqlRunner.END_DELIM);
        stringBuffer.append(CountryWriter.getUpdateSQL("oadraft.symptomCountry", "symptomInd", symptomDraft.getInd(), symptomDraft.getCountryList(), symptomDraft.getOriginalCountryList(), symptomDraft.getDbUser()));
        return stringBuffer.toString();
    }

    static String getDeleteSQL(SymptomDraft symptomDraft) {
        StringBuffer stringBuffer = new StringBuffer(500);
        int n = symptomDraft.getInd();
        stringBuffer.append("UPDATE oadraft.symptom SET rootNodeInd=NULL WHERE symptomInd=").append(n).append(SqlRunner.END_DELIM);
        stringBuffer.append(EdgeGroupDraftWriter.getDeleteAllForSymptomSQL(n));
        stringBuffer.append(NodeDraftWriter.getDeleteAllForSymptomSQL(n));
        stringBuffer.append(SymptomTitleDraftWriter.getDeleteAllForSymptomSQL(n));
        stringBuffer.append("DELETE from oadraft.symptomcountry where symptomind=").append(n).append(SqlRunner.END_DELIM);
        stringBuffer.append("DELETE from oadraft.symptom where symptomind=").append(n).append(SqlRunner.END_DELIM);
        return stringBuffer.toString();
    }

    SymptomDraftWriter() {
    }
}

