/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.oa;

import com.ibm.nzna.projects.common.quest.oa.Action;
import com.ibm.nzna.projects.common.quest.oa.Answer;
import com.ibm.nzna.projects.common.quest.oa.ConditionReader;
import com.ibm.nzna.projects.common.quest.oa.ConditionalObject;
import com.ibm.nzna.projects.common.quest.oa.CountryReader;
import com.ibm.nzna.projects.common.quest.oa.DatabaseUtil;
import com.ibm.nzna.projects.common.quest.oa.Question;
import com.ibm.nzna.projects.common.quest.oa.Symptom;
import com.ibm.nzna.projects.common.quest.oa.SymptomTitle;
import com.ibm.nzna.projects.common.quest.oa.Title;
import com.ibm.nzna.projects.common.quest.type.TypeDocClassRec;
import com.ibm.nzna.projects.common.quest.type.TypeLanguageRec;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

class TitleReader {
    public static final String ACTIVE_SCHEMA = "oa";
    public static final String DRAFT_SCHEMA = "oadraft";

    static void readActionTitles(Connection connection, Action action) throws SQLException {
        TitleReader.readActionTitles(connection, action, ACTIVE_SCHEMA);
    }

    static void readActionDraftTitles(Connection connection, Action action) throws SQLException {
        TitleReader.readActionTitles(connection, action, DRAFT_SCHEMA);
    }

    private static void readActionTitles(Connection connection, Action action, String string) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + "actionTitleInd, sortOrder, " + "title, docClassInd, created, " + "dbUser, changedTime, " + "languageInd, lastTranslated" + " FROM " + string + ".actionTitle" + " WHERE actionInd=" + action.getInd() + " ORDER BY sortOrder, languageInd" + " FOR FETCH ONLY");
        Vector<Title> vector = new Vector<Title>();
        while (resultSet.next()) {
            Title title = new Title(resultSet.getInt(1));
            title.setParentInd(action.getInd());
            title.setSortOrder(resultSet.getShort(2));
            title.setTitle(resultSet.getString(3));
            title.setDocClass(new TypeDocClassRec(resultSet.getShort(4), ""));
            title.setCreationTime(DatabaseUtil.timestampFromDB(resultSet.getString(5)));
            title.setDbUser(resultSet.getString(6).trim());
            title.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(7)));
            title.setLanguage(new TypeLanguageRec(resultSet.getShort(8), ""));
            title.setLastTranslationDate(DatabaseUtil.timestampFromDB(resultSet.getString(9)));
            title.setTextUpdated(false);
            title.updateRecStatus(0);
            vector.addElement(title);
        }
        resultSet.close();
        statement.close();
        action.setTitles(vector);
        ConditionReader.readAllActionTitleConditions(connection, action, string, true);
        CountryReader.readAllActionTitleCountries(connection, action, string, true);
    }

    static void readActionTitles(Connection connection, Action action, int n) throws SQLException {
        if (n == 0) {
            TitleReader.readActionTitles(connection, action, ACTIVE_SCHEMA);
        } else {
            TitleReader.readActionTitles(connection, action, n, ACTIVE_SCHEMA);
        }
    }

    static void readActionDraftTitles(Connection connection, Action action, int n) throws SQLException {
        if (n == 0) {
            TitleReader.readActionTitles(connection, action, DRAFT_SCHEMA);
        } else {
            TitleReader.readActionTitles(connection, action, n, DRAFT_SCHEMA);
        }
    }

    private static void readActionTitles(Connection connection, Action action, int n, String string) throws SQLException {
        Statement statement = connection.createStatement();
        String string2 = "SELECT " + "actionTitleInd, sortOrder, " + "title, docClassInd, created, " + "dbUser, changedTime, " + "languageInd, lastTranslated " + "FROM " + string + ".actionTitle " + "WHERE actionInd=" + action.getInd() + " " + "AND   languageInd=" + n + " ";
        if (n != 1) {
            string2 = string2 + "UNION " + "SELECT " + "actionTitleInd, sortOrder, " + "title, docClassInd, created, " + "dbUser, changedTime, " + "languageInd, lastTranslated " + "FROM " + string + ".actionTitle " + "WHERE actionInd=" + action.getInd() + " " + "AND   languageInd=1 " + "AND   actionTitleInd NOT IN (" + "SELECT actionTitleInd " + "FROM " + string + ".actionTitle " + "WHERE actionInd=" + action.getInd() + " " + "AND   languageInd=" + n + ") ";
        }
        string2 = string2 + "ORDER BY sortOrder " + "FOR FETCH ONLY";
        ResultSet resultSet = statement.executeQuery(string2);
        Vector<Title> vector = new Vector<Title>();
        while (resultSet.next()) {
            Title title = new Title(resultSet.getInt(1));
            title.setParentInd(action.getInd());
            title.setSortOrder(resultSet.getShort(2));
            title.setTitle(resultSet.getString(3));
            title.setDocClass(new TypeDocClassRec(resultSet.getShort(4), ""));
            title.setCreationTime(DatabaseUtil.timestampFromDB(resultSet.getString(5)));
            title.setDbUser(resultSet.getString(6).trim());
            title.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(7)));
            title.setLanguage(new TypeLanguageRec(resultSet.getShort(8), ""));
            title.setLastTranslationDate(DatabaseUtil.timestampFromDB(resultSet.getString(9)));
            title.setTextUpdated(false);
            title.updateRecStatus(0);
            vector.addElement(title);
        }
        resultSet.close();
        statement.close();
        action.setTitles(vector);
        ConditionReader.readAllActionTitleConditions(connection, action, string, false);
        CountryReader.readAllActionTitleCountries(connection, action, string, false);
    }

    static void readQuestionTitles(Connection connection, Question question) throws SQLException {
        TitleReader.readQuestionTitles(connection, question, ACTIVE_SCHEMA);
    }

    static void readQuestionDraftTitles(Connection connection, Question question) throws SQLException {
        TitleReader.readQuestionTitles(connection, question, DRAFT_SCHEMA);
    }

    private static void readQuestionTitles(Connection connection, Question question, String string) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + "questionTitleInd, sortOrder, " + "title, docClassInd, created, " + "dbUser, changedTime, " + "languageInd, lastTranslated" + " FROM " + string + ".questionTitle" + " WHERE questionInd=" + question.getInd() + " ORDER BY sortOrder, languageInd" + " FOR FETCH ONLY");
        Vector<Title> vector = new Vector<Title>();
        while (resultSet.next()) {
            Title title = new Title(resultSet.getInt(1));
            title.setParentInd(question.getInd());
            title.setSortOrder(resultSet.getShort(2));
            title.setTitle(resultSet.getString(3));
            title.setDocClass(new TypeDocClassRec(resultSet.getShort(4), ""));
            title.setCreationTime(DatabaseUtil.timestampFromDB(resultSet.getString(5)));
            title.setDbUser(resultSet.getString(6).trim());
            title.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(7)));
            title.setLanguage(new TypeLanguageRec(resultSet.getShort(8), ""));
            title.setLastTranslationDate(DatabaseUtil.timestampFromDB(resultSet.getString(9)));
            title.setTextUpdated(false);
            title.updateRecStatus(0);
            vector.addElement(title);
        }
        resultSet.close();
        statement.close();
        question.setTitles(vector);
        ConditionReader.readAllQuestionTitleConditions(connection, question, string, true);
        CountryReader.readAllQuestionTitleCountries(connection, question, string, true);
    }

    static void readQuestionTitles(Connection connection, Question question, int n) throws SQLException {
        if (n == 0) {
            TitleReader.readQuestionTitles(connection, question, ACTIVE_SCHEMA);
        } else {
            TitleReader.readQuestionTitles(connection, question, n, ACTIVE_SCHEMA);
        }
    }

    static void readQuestionDraftTitles(Connection connection, Question question, int n) throws SQLException {
        if (n == 0) {
            TitleReader.readQuestionTitles(connection, question, DRAFT_SCHEMA);
        } else {
            TitleReader.readQuestionTitles(connection, question, n, DRAFT_SCHEMA);
        }
    }

    private static void readQuestionTitles(Connection connection, Question question, int n, String string) throws SQLException {
        Statement statement = connection.createStatement();
        String string2 = "SELECT " + "questionTitleInd, sortOrder, " + "title, docClassInd, created, " + "dbUser, changedTime, " + "languageInd, lastTranslated " + "FROM " + string + ".questionTitle " + "WHERE questionInd=" + question.getInd() + " " + "AND   languageInd=" + n + " ";
        if (n != 1) {
            string2 = string2 + "UNION " + "SELECT " + "questionTitleInd, sortOrder, " + "title, docClassInd, created, " + "dbUser, changedTime, " + "languageInd, lastTranslated " + "FROM " + string + ".questionTitle " + "WHERE questionInd=" + question.getInd() + " " + "AND   languageInd=1 " + "AND   questionTitleInd NOT IN (" + "SELECT questionTitleInd " + "FROM " + string + ".questionTitle " + "WHERE questionInd=" + question.getInd() + " " + "AND languageInd=" + n + ") ";
        }
        string2 = string2 + "ORDER BY sortOrder " + "FOR FETCH ONLY";
        ResultSet resultSet = statement.executeQuery(string2);
        Vector<Title> vector = new Vector<Title>();
        while (resultSet.next()) {
            Title title = new Title(resultSet.getInt(1));
            title.setParentInd(question.getInd());
            title.setSortOrder(resultSet.getShort(2));
            title.setTitle(resultSet.getString(3));
            title.setDocClass(new TypeDocClassRec(resultSet.getShort(4), ""));
            title.setCreationTime(DatabaseUtil.timestampFromDB(resultSet.getString(5)));
            title.setDbUser(resultSet.getString(6).trim());
            title.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(7)));
            title.setLanguage(new TypeLanguageRec(resultSet.getShort(8), ""));
            title.setLastTranslationDate(DatabaseUtil.timestampFromDB(resultSet.getString(9)));
            title.setTextUpdated(false);
            title.updateRecStatus(0);
            vector.addElement(title);
        }
        resultSet.close();
        statement.close();
        question.setTitles(vector);
        ConditionReader.readAllQuestionTitleConditions(connection, question, string, false);
        CountryReader.readAllQuestionTitleCountries(connection, question, string, false);
    }

    static void readAllAnswerTitles(Connection connection, Question question) throws SQLException {
        TitleReader.readAllAnswerTitles(connection, question, ACTIVE_SCHEMA);
    }

    static void readAllAnswerDraftTitles(Connection connection, Question question) throws SQLException {
        TitleReader.readAllAnswerTitles(connection, question, DRAFT_SCHEMA);
    }

    private static void readAllAnswerTitles(Connection connection, Question question, String string) throws SQLException {
        ConditionalObject conditionalObject;
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + "at.answerTitleInd, at.sortOrder, " + "at.title, at.docClassInd, at.created, " + "at.dbUser, at.changedTime, " + "at.languageInd, at.lastTranslated, " + "at.answerInd" + " FROM " + string + ".answerTitle at, " + string + ".answer a" + " WHERE at.answerInd=a.answerInd" + " AND a.questionInd=" + question.getInd() + " ORDER BY at.answerInd, " + "at.sortOrder, at.languageInd" + " FOR FETCH ONLY");
        int n = 0;
        int n2 = -99;
        Vector<ConditionalObject> vector = null;
        while (resultSet.next()) {
            n = resultSet.getInt(10);
            if (n != n2) {
                if (vector != null) {
                    conditionalObject = question.getAnswerByInd(n2);
                    ((Answer)conditionalObject).setTitles(vector);
                }
                vector = new Vector<ConditionalObject>(1, 5);
                n2 = n;
            }
            conditionalObject = new Title(resultSet.getInt(1));
            ((Title)conditionalObject).setParentInd(n);
            conditionalObject.setSortOrder(resultSet.getShort(2));
            ((Title)conditionalObject).setTitle(resultSet.getString(3));
            conditionalObject.setDocClass(new TypeDocClassRec(resultSet.getShort(4), ""));
            conditionalObject.setCreationTime(DatabaseUtil.timestampFromDB(resultSet.getString(5)));
            conditionalObject.setDbUser(resultSet.getString(6).trim());
            conditionalObject.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(7)));
            ((Title)conditionalObject).setLanguage(new TypeLanguageRec(resultSet.getShort(8), ""));
            ((Title)conditionalObject).setLastTranslationDate(DatabaseUtil.timestampFromDB(resultSet.getString(9)));
            ((Title)conditionalObject).setTextUpdated(false);
            conditionalObject.updateRecStatus(0);
            vector.addElement(conditionalObject);
        }
        resultSet.close();
        statement.close();
        if (vector != null) {
            conditionalObject = question.getAnswerByInd(n);
            ((Answer)conditionalObject).setTitles(vector);
        }
        ConditionReader.readAllAnswerTitleConditions(connection, question, string, true);
        CountryReader.readAllAnswerTitleCountries(connection, question, string, true);
    }

    static void readAllAnswerTitles(Connection connection, Question question, int n) throws SQLException {
        if (n == 0) {
            TitleReader.readAllAnswerTitles(connection, question, ACTIVE_SCHEMA);
        } else {
            TitleReader.readAllAnswerTitles(connection, question, n, ACTIVE_SCHEMA);
        }
    }

    static void readAllAnswerDraftTitles(Connection connection, Question question, int n) throws SQLException {
        if (n == 0) {
            TitleReader.readAllAnswerTitles(connection, question, DRAFT_SCHEMA);
        } else {
            TitleReader.readAllAnswerTitles(connection, question, n, DRAFT_SCHEMA);
        }
    }

    private static void readAllAnswerTitles(Connection connection, Question question, int n, String string) throws SQLException {
        ConditionalObject conditionalObject;
        Statement statement = connection.createStatement();
        String string2 = "SELECT " + "at.answerTitleInd, at.sortOrder, " + "at.title, at.docClassInd, at.created, " + "at.dbUser, at.changedTime, " + "at.languageInd, at.lastTranslated, " + "at.answerInd" + " FROM " + string + ".answerTitle at, " + string + ".answer a" + " WHERE at.languageInd=" + n + " AND at.answerInd=a.answerInd" + " AND a.questionInd=" + question.getInd() + " ";
        if (n != 1) {
            string2 = string2 + "UNION " + "SELECT " + "at.answerTitleInd, at.sortOrder, " + "at.title, at.docClassInd, at.created, " + "at.dbUser, at.changedTime, " + "at.languageInd, at.lastTranslated, " + "at.answerInd" + " FROM " + string + ".answerTitle at, " + string + ".answer a" + " WHERE at.languageInd=1" + " AND at.answerInd=a.answerInd" + " AND a.questionInd=" + question.getInd() + " AND at.answerTitleInd NOT IN (" + "SELECT at.answerTitleInd " + "FROM " + string + ".answerTitle at, " + string + ".answer a " + "WHERE at.languageInd=" + n + " " + "AND at.answerInd=a.answerInd " + "AND a.questionInd=" + question.getInd() + ") ";
        }
        string2 = string2 + "ORDER BY answerInd, sortOrder " + "FOR FETCH ONLY";
        ResultSet resultSet = statement.executeQuery(string2);
        int n2 = 0;
        int n3 = -99;
        Vector<ConditionalObject> vector = null;
        while (resultSet.next()) {
            n2 = resultSet.getInt(10);
            if (n2 != n3) {
                if (vector != null) {
                    conditionalObject = question.getAnswerByInd(n3);
                    ((Answer)conditionalObject).setTitles(vector);
                }
                vector = new Vector<ConditionalObject>(1, 5);
                n3 = n2;
            }
            conditionalObject = new Title(resultSet.getInt(1));
            ((Title)conditionalObject).setParentInd(n2);
            conditionalObject.setSortOrder(resultSet.getShort(2));
            ((Title)conditionalObject).setTitle(resultSet.getString(3));
            conditionalObject.setDocClass(new TypeDocClassRec(resultSet.getShort(4), ""));
            conditionalObject.setCreationTime(DatabaseUtil.timestampFromDB(resultSet.getString(5)));
            conditionalObject.setDbUser(resultSet.getString(6).trim());
            conditionalObject.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(7)));
            ((Title)conditionalObject).setLanguage(new TypeLanguageRec(resultSet.getShort(8), ""));
            ((Title)conditionalObject).setLastTranslationDate(DatabaseUtil.timestampFromDB(resultSet.getString(9)));
            ((Title)conditionalObject).setTextUpdated(false);
            conditionalObject.updateRecStatus(0);
            vector.addElement(conditionalObject);
        }
        resultSet.close();
        statement.close();
        if (vector != null) {
            conditionalObject = question.getAnswerByInd(n2);
            ((Answer)conditionalObject).setTitles(vector);
        }
        ConditionReader.readAllAnswerTitleConditions(connection, question, string, false);
        CountryReader.readAllAnswerTitleCountries(connection, question, string, false);
    }

    static void readSymptomTitles(Connection connection, Symptom symptom) throws SQLException {
        TitleReader.readSymptomTitles(connection, symptom, ACTIVE_SCHEMA);
    }

    static void readSymptomDraftTitles(Connection connection, Symptom symptom) throws SQLException {
        TitleReader.readSymptomTitles(connection, symptom, DRAFT_SCHEMA);
    }

    private static void readSymptomTitles(Connection connection, Symptom symptom, String string) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + "symptomTitleInd, sortOrder, title, " + "keywords, languageInd, lastTranslated, " + "docClassInd, indexable, " + "dbUser, changedTime" + " FROM " + string + ".symptomTitle " + " WHERE symptomInd= " + symptom.getInd() + " ORDER BY sortOrder, languageInd" + " FOR FETCH ONLY");
        Vector<SymptomTitle> vector = new Vector<SymptomTitle>();
        while (resultSet.next()) {
            SymptomTitle symptomTitle = new SymptomTitle(resultSet.getInt(1));
            symptomTitle.setSymptomInd(symptom.getInd());
            symptomTitle.setSortOrder(resultSet.getShort(2));
            symptomTitle.setTitle(resultSet.getString(3));
            symptomTitle.setKeywords(resultSet.getString(4));
            symptomTitle.setLanguage(new TypeLanguageRec(resultSet.getShort(5), ""));
            symptomTitle.setLastTranslationDate(DatabaseUtil.timestampFromDB(resultSet.getString(6)));
            symptomTitle.setDocClass(new TypeDocClassRec(resultSet.getShort(7), ""));
            symptomTitle.setIndexable(DatabaseUtil.booleanFromDB(resultSet.getString(8)));
            symptomTitle.setDbUser(resultSet.getString(9).trim());
            symptomTitle.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(10)));
            symptomTitle.setTextUpdated(false);
            symptomTitle.updateRecStatus(0);
            vector.addElement(symptomTitle);
        }
        resultSet.close();
        statement.close();
        symptom.setSymptomTitles(vector);
        CountryReader.readAllSymptomTitleCountries(connection, symptom, string, true);
    }

    static void readSymptomTitles(Connection connection, Symptom symptom, int n) throws SQLException {
        if (n == 0) {
            TitleReader.readSymptomTitles(connection, symptom, ACTIVE_SCHEMA);
        } else {
            TitleReader.readSymptomTitles(connection, symptom, n, ACTIVE_SCHEMA);
        }
    }

    static void readSymptomDraftTitles(Connection connection, Symptom symptom, int n) throws SQLException {
        if (n == 0) {
            TitleReader.readSymptomTitles(connection, symptom, DRAFT_SCHEMA);
        } else {
            TitleReader.readSymptomTitles(connection, symptom, n, DRAFT_SCHEMA);
        }
    }

    private static void readSymptomTitles(Connection connection, Symptom symptom, int n, String string) throws SQLException {
        Statement statement = connection.createStatement();
        String string2 = "SELECT " + "symptomTitleInd, sortOrder, title, " + "keywords, languageInd, lastTranslated, " + "docClassInd, indexable, " + "dbUser, changedTime " + "FROM " + string + ".symptomTitle " + "WHERE symptomInd=" + symptom.getInd() + " " + "AND   languageInd=" + n + " ";
        if (n != 1) {
            string2 = string2 + "UNION " + "SELECT " + "symptomTitleInd, sortOrder, title, " + "keywords, languageInd, lastTranslated, " + "docClassInd, indexable, " + "dbUser, changedTime " + "FROM " + string + ".symptomTitle " + "WHERE symptomInd=" + symptom.getInd() + " " + "AND   languageInd=1 " + "AND   symptomTitleInd NOT IN (" + "SELECT symptomTitleInd " + "FROM " + string + ".symptomTitle " + "WHERE symptomInd=" + symptom.getInd() + " " + "AND   languageInd=" + n + ") ";
        }
        string2 = string2 + "ORDER BY sortOrder " + "FOR FETCH ONLY";
        ResultSet resultSet = statement.executeQuery(string2);
        Vector<SymptomTitle> vector = new Vector<SymptomTitle>();
        while (resultSet.next()) {
            SymptomTitle symptomTitle = new SymptomTitle(resultSet.getInt(1));
            symptomTitle.setSymptomInd(symptom.getInd());
            symptomTitle.setSortOrder(resultSet.getShort(2));
            symptomTitle.setTitle(resultSet.getString(3));
            symptomTitle.setKeywords(resultSet.getString(4));
            symptomTitle.setLanguage(new TypeLanguageRec(resultSet.getShort(5), ""));
            symptomTitle.setLastTranslationDate(DatabaseUtil.timestampFromDB(resultSet.getString(6)));
            symptomTitle.setDocClass(new TypeDocClassRec(resultSet.getShort(7), ""));
            symptomTitle.setIndexable(DatabaseUtil.booleanFromDB(resultSet.getString(8)));
            symptomTitle.setDbUser(resultSet.getString(9).trim());
            symptomTitle.setChangedTime(DatabaseUtil.timestampFromDB(resultSet.getString(10)));
            symptomTitle.setTextUpdated(false);
            symptomTitle.updateRecStatus(0);
            vector.addElement(symptomTitle);
        }
        resultSet.close();
        statement.close();
        symptom.setSymptomTitles(vector);
        CountryReader.readAllSymptomTitleCountries(connection, symptom, string, false);
    }

    TitleReader() {
    }
}

