/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.product;

import com.ibm.nzna.projects.common.quest.product.CreateProductDraft;
import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.util.LogSystem;

public class DeleteTest {
    private String databaseName = null;
    private String server = null;
    private String userId = null;
    private String password = null;
    private String portNumber = null;
    private int productInd = 1;

    public static void main(String[] stringArray) {
        new LogSystem(1, "DeleteTest.out");
        new DeleteTest(stringArray);
    }

    private final void deleteProduct() {
        System.out.println("Creating ProductDraft");
        CreateProductDraft createProductDraft = ProductDraft.createProductDraft(this.productInd);
        ProductDraft productDraft = createProductDraft.getProductDraft();
        int n = 0;
        if (createProductDraft.getSqlCode() == 0) {
            System.out.print("Saving Product            ");
            long l = System.currentTimeMillis();
            productDraft.setWorkRequired(3);
            n = productDraft.writeToDatabase();
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    System.out.println("Failed. RC:" + n);
                }
            }
            System.out.print("Time:" + (System.currentTimeMillis() - l) + "(ms)\n\nReading Draft back in     ");
            l = System.currentTimeMillis();
            n = productDraft.readFromDatabase();
            System.out.println("Time:" + (System.currentTimeMillis() - l) + "(ms)\n\n");
            if (n == 0) {
                l = System.currentTimeMillis();
                System.out.print("Publishing Product         ");
                productDraft.publish();
                System.out.println("Time:" + (System.currentTimeMillis() - l) + "(ms)\n\n");
            } else {
                System.out.println("Could not re-read product draft. rc:" + n);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeleteTest(String[] stringArray) {
        try {
            this.databaseName = stringArray[0];
            this.server = stringArray[1];
            this.portNumber = stringArray[2];
            this.userId = stringArray[3];
            this.password = stringArray[4];
            this.productInd = new Integer(stringArray[5]);
        }
        catch (Exception exception) {
            System.out.println("Usage:\njava com.ibm.nzna.projects.common.quest.product.DeleteTest <databaseName> <serverName> <portNumber> <userId> <password> <product ind to edit>");
            System.exit(0);
        }
        try {
            DatabaseSystem databaseSystem = new DatabaseSystem(false, null, false);
            System.out.println("This test will create a Product Draft for Delete, save the draft, read the draft and publish the draft");
            System.out.print("Connecting to Quest...");
            if (DatabaseSystem.createConnection(1, this.databaseName, this.server, this.portNumber, this.userId, this.password)) {
                System.out.println("Connected");
                new TypeList();
                TypeList.getInstance().initialize(false);
                this.deleteProduct();
            } else {
                System.out.println("Could not connect to " + this.databaseName + " on " + this.server + " on port " + this.portNumber);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Could not connect to " + this.databaseName + " on " + this.server + " on port " + this.portNumber);
        }
        System.exit(0);
    }
}

