/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.product;

import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.util.LogSystem;

public class DraftReadTest {
    private String databaseName = null;
    private String server = null;
    private String userId = null;
    private String password = null;
    private String portNumber = null;
    private int docInd = 0;

    public static void main(String[] stringArray) {
        new LogSystem(1, "DraftReadTest.out");
        new DraftReadTest(stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DraftReadTest(String[] stringArray) {
        try {
            this.databaseName = stringArray[0];
            this.server = stringArray[1];
            this.portNumber = stringArray[2];
            this.userId = stringArray[3];
            this.password = stringArray[4];
            this.docInd = new Integer(stringArray[5]);
        }
        catch (Exception exception) {
            System.out.println("Usage:\njava com.ibm.nzna.projects.common.quest.doc.DocReader <databaseName> <serverName> <portNumber> <userId> <password> <doc indicator>");
            System.exit(0);
        }
        try {
            DatabaseSystem databaseSystem = new DatabaseSystem(false, null, false);
            if (!DatabaseSystem.createConnection(1, this.databaseName, this.server, this.portNumber, this.userId, this.password)) {
                System.out.println("Could not connect to " + this.databaseName + " on " + this.server + " on port " + this.portNumber);
                return;
            }
            System.out.print("Initializing TypeList...  ");
            new TypeList();
            TypeList.getInstance().initialize(false);
            System.out.println("Done");
            int n = this.docInd;
            while (true) {
                if (n >= this.docInd + 5) {
                    return;
                }
                ProductDraft productDraft = new ProductDraft(n);
                long l = 0L;
                int n2 = productDraft.readFromDatabase();
                productDraft = (ProductDraft)ProductDraft.findFromCategory("IBM Aptiva", "PS/1", "2165", "55C");
                if (productDraft != null) {
                    System.out.println("Found Product " + productDraft.getProductInd() + " Through Product.find");
                }
                productDraft = new ProductDraft(n);
                l = System.currentTimeMillis();
                n2 = productDraft.readFromDatabase();
                System.out.println("--------------------------------------------------\nTotal Time Taken:" + (System.currentTimeMillis() - l) + "(ms)\n-----------------------------------------------");
                if (n2 == 0) {
                    System.out.println(productDraft.toOut());
                } else if (n2 == 100) {
                    System.out.println("Could not find Product");
                } else {
                    System.out.println("Error:" + n2);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Could not connect to " + this.databaseName + " on " + this.server + " on port " + this.portNumber);
        }
    }
}

