/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.product;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.LocaleRec;
import com.ibm.nzna.projects.common.quest.product.CreateProductDraft;
import com.ibm.nzna.projects.common.quest.product.ProductComment;
import com.ibm.nzna.projects.common.quest.product.ProductDate;
import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.product.ProductPropertyListener;
import com.ibm.nzna.projects.common.quest.product.ProductSQL;
import com.ibm.nzna.projects.common.quest.product.XRef;
import com.ibm.nzna.projects.common.quest.type.TypeCategory;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeGeoRec;
import com.ibm.nzna.projects.common.quest.type.TypeRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.pom.POMUtil;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class Product
extends PersistentRec {
    static final long serialVersionUID = 1000000L;
    public static final int BASEMODEL = 1;
    public static final int BRAND = 2;
    public static final int MACHINE = 3;
    public static final int MODEL = 4;
    public static final int FAMILY = 5;
    public static final int CHECKEDOUTBY = 6;
    public static final int CREATEDBY = 7;
    public static final int CREATEDON = 8;
    public static final int CUSTOMER = 9;
    public static final int DATES = 10;
    public static final int DESCRIPTION = 11;
    public static final int INPUT = 12;
    public static final int LOCALE = 13;
    public static final int OFFERING = 14;
    public static final int OPICMIMPORT = 16;
    public static final int PRODUCTIND = 17;
    public static final int PRODUCTTYPE = 18;
    public static final int SOURCE = 19;
    public static final int WARRANTY = 20;
    public static final int XREF = 21;
    public static final int PARTNUMBER = 22;
    public static final int SUBCATEGORY = 23;
    public static final int PROJECT = 24;
    private static String SOURCE_AUTHOR = "Author";
    private static String SOURCE_OPICM = "OPIC/M";
    private Vector commentHistory = null;
    private int productInd = 0;
    private boolean fireEventEnabled = true;
    private boolean publish = true;
    private int customer = 0;
    private Vector listeners = null;
    private int warranty = 0;
    private int offering = 0;
    private int type = 0;
    private String prodNum = null;
    private boolean opicmImport = false;
    private TypeCategoryRec partNum = null;
    private String description = null;
    private String baseModel = null;
    private String input = null;
    private String source = SOURCE_AUTHOR;
    private String checkedOutBy = null;
    private String createdOn = null;
    private String createdBy = null;
    private String lastTouchedOn = null;
    private String lastTouchedBy = null;
    private Vector xRef = null;
    private LocaleRec locale = null;
    protected Vector dates = null;
    protected boolean brandUpdated = false;
    protected boolean projectUpdated = false;
    protected boolean partNumUpdated = false;
    protected boolean familyUpdated = false;
    protected boolean machineUpdated = false;
    protected boolean modelUpdated = false;
    private TypeCategoryRec brand = null;
    private TypeCategoryRec family = null;
    private TypeCategoryRec model = null;
    private TypeCategoryRec machine = null;
    protected TypeCategoryRec project = null;
    private TypeCategoryRec subCategory = null;

    public int getProductInd() {
        this.generateKeys();
        return this.productInd;
    }

    public int getProductIndNow() {
        return this.productInd;
    }

    protected void setProductInd(int n) {
        this.productInd = n;
        this.firePropertyChanged(17);
    }

    public Object cloneAll() {
        Product product = (Product)this.clone();
        product.productInd = this.productInd;
        return product;
    }

    public int getCustomer() {
        return this.customer;
    }

    public void setCustomer(int n) {
        this.customer = n;
        this.updateRecStatus(1);
        this.firePropertyChanged(9);
    }

    public int getWarranty() {
        return this.warranty;
    }

    public void setWarranty(int n) {
        this.warranty = n;
        this.updateRecStatus(1);
        this.firePropertyChanged(20);
    }

    public int getOffering() {
        return this.offering;
    }

    public void setOffering(int n) {
        this.offering = n;
        this.updateRecStatus(1);
        this.firePropertyChanged(14);
    }

    public int getProductType() {
        return this.type;
    }

    public String getProdNum() {
        return this.prodNum;
    }

    public TypeCategoryRec getPartNumber() {
        return this.partNum;
    }

    public void setPartNumber(TypeCategoryRec typeCategoryRec) {
        if (this.partNum == null) {
            this.partNum = typeCategoryRec;
        } else if (typeCategoryRec != null) {
            this.partNum.setDescript(typeCategoryRec.toString());
            this.partNum.setIsDraft(typeCategoryRec.getIsDraft());
            this.partNum.setParentCatInd(typeCategoryRec.getParentCatInd());
        } else {
            this.partNum = null;
        }
        this.partNumUpdated = true;
        this.firePropertyChanged(22);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) throws IllegalArgumentException {
        if (string == null || string.length() > 254) {
            throw new IllegalArgumentException("Product Descriptions cannot " + "be null and must be less than " + "254 characters");
        }
        this.description = string;
        this.updateRecStatus(1);
        this.firePropertyChanged(11);
    }

    public String getBaseModel() {
        return this.baseModel;
    }

    public void setBaseModel(String string) {
        this.baseModel = string;
        this.updateRecStatus(1);
        this.firePropertyChanged(1);
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String string) throws IllegalArgumentException {
        if (string == null || string.length() > 25) {
            throw new IllegalArgumentException("The Input property of a" + "Product cannot be NULL or " + "exceed 25 characters");
        }
        this.input = string;
        this.updateRecStatus(1);
        this.firePropertyChanged(12);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) throws IllegalArgumentException {
        if (string == null || string.length() > 254) {
            throw new IllegalArgumentException("The Product Source cannot be " + "NULL and it cannot exceed " + "254 characters");
        }
        this.source = string;
        this.updateRecStatus(1);
        this.firePropertyChanged(19);
    }

    public String getCheckedOutBy() {
        return this.checkedOutBy;
    }

    public void setCheckedOutBy(String string) throws IllegalArgumentException {
        if (string != null) {
            if (string.length() > 12) {
                throw new IllegalArgumentException("The Product CheckedOutBy cannot " + "exceed 12 characters in length");
            }
            this.checkedOutBy = string;
            this.updateRecStatus(1);
        }
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getLastTouchedOn() {
        return this.lastTouchedOn;
    }

    public String getLastTouchedBy() {
        return this.lastTouchedBy;
    }

    public Vector getXRef() {
        return this.xRef;
    }

    public void setXRef(Vector vector) {
        this.xRef = vector;
        this.firePropertyChanged(21);
    }

    public LocaleRec getLocale() {
        if (this.locale != null) {
            return (LocaleRec)this.locale.clone();
        }
        return new LocaleRec();
    }

    public void setLocale(LocaleRec localeRec) {
        this.locale = localeRec;
        this.firePropertyChanged(13);
    }

    public TypeCategoryRec getBrand() {
        return this.brand;
    }

    public TypeCategoryRec getFamily() {
        return this.family;
    }

    public TypeCategoryRec getProject() {
        if (this.project == null && this.family != null) {
            TypeCategoryRec typeCategoryRec = TypeCategory.getCategoryFromDescription("Default", "project", this.family.getInd());
            if (typeCategoryRec == null) {
                typeCategoryRec = TypeCategory.createTypeCategory(this.family.getInd(), "Default", "project", 0, "N", "QUEST");
                TypeCategory.writeToDatabase();
            }
            this.projectUpdated = true;
            this.project = typeCategoryRec;
        }
        return this.project;
    }

    public TypeCategoryRec getMachine() {
        return this.machine;
    }

    public TypeCategoryRec getModel() {
        return this.model;
    }

    public TypeCategoryRec getSubCategory() {
        return this.subCategory;
    }

    public int writeToDatabase() {
        String string = this.toSQL();
        int n = 0;
        if (string != null && string.length() > 0 && (n = SqlRunner.sqlRunnerCode(1, string)) == 0) {
            this.setLastTouchedOn(ProductSQL.getDBTimestampFromDatabase());
            this.updateRecStatus(0);
            this.resetUpdateVariables();
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readFromDatabase() {
        int n;
        SQLMethod sQLMethod;
        block6: {
            String string = "Product.readFromDatabase";
            sQLMethod = new SQLMethod(1, string, 5);
            n = 0;
            if (sQLMethod != null) {
                try {
                    CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.ProductReader", 3);
                    callableStatement.setInt(1, this.getProductInd());
                    callableStatement.registerOutParameter(2, -4);
                    callableStatement.registerOutParameter(3, -4);
                    LogSystem.log(1, "Reading Product:" + this.getProductInd());
                    callableStatement.execute();
                    StoredProcRec storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 3);
                    if (storedProcRec != null && storedProcRec.error) {
                        LogSystem.beginLogSection("ProductReader Returned Error");
                        LogSystem.log(1, "sqlCode:   " + storedProcRec.sqlCode);
                        LogSystem.log(1, "userError: " + storedProcRec.userError);
                        LogSystem.log(1, "errorStr:  " + storedProcRec.errorStr);
                        LogSystem.log(1, "error:     " + storedProcRec.error);
                        try {
                            n = new Integer(storedProcRec.sqlCode);
                        }
                        catch (Exception exception) {
                            LogSystem.log(1, "Could not translate retRec.sqlCode to integer");
                            n = -1;
                        }
                        LogSystem.endLogSection();
                        break block6;
                    }
                    this.initializeProperties((Product)StoredProcUtil.getObjectFromStatement(callableStatement, 2));
                    this.forceRecStatus(0);
                    n = 0;
                }
                catch (Exception exception) {
                    sQLMethod.rollBack();
                    LogSystem.log(1, exception, false);
                    n = -1;
                }
            }
        }
        sQLMethod.close();
        return n;
    }

    public void removeDate(ProductDate productDate) throws IllegalArgumentException {
        if (this.dates == null || this.dates.indexOf(productDate) <= 0) {
            throw new IllegalArgumentException("Cannot remove date from product because " + "product does not contain date");
        }
        productDate.updateRecStatus(3);
    }

    public void addDate(ProductDate productDate) {
        if (this.dates == null) {
            this.dates = new Vector(10, 1);
        }
        this.dates.addElement(productDate);
    }

    public Vector getDates() {
        if (this.dates != null) {
            return (Vector)this.dates.clone();
        }
        return new Vector(1);
    }

    public void setDates(Vector vector) {
        this.dates = vector;
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                ((ProductDate)vector.elementAt(n)).setProductInd(this.getProductInd());
                ++n;
            }
            this.firePropertyChanged(10);
        }
    }

    public void removeXRef(XRef xRef) throws IllegalArgumentException {
        if (this.xRef == null || this.xRef.indexOf(xRef) <= 0) {
            throw new IllegalArgumentException("Cannot remove XRef from product because " + "product does not contain XRef");
        }
        xRef.updateRecStatus(3);
    }

    public void addXRef(XRef xRef) {
        if (this.xRef == null) {
            this.xRef = new Vector(10, 1);
        }
        this.xRef.addElement(xRef);
    }

    public CreateProductDraft createProductDraft() {
        return ProductDraft.createProductDraft(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkOut(String string) throws Exception {
        if (this.productInd == 0) throw new IllegalArgumentException("Cannot lock a product without a Product Indicator");
        SQLMethod sQLMethod = new SQLMethod(1, "checkOut ( " + string + " )", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            this.setCheckedOutBy(string);
            if (string != null) {
                statement.executeUpdate("UPDATE PRODUCT.PRODUCT SET CHECKEDOUTBY = '" + string + "' where productInd = " + this.productInd);
            } else {
                statement.executeUpdate("UPDATE PRODUCT.PRODUCT SET CHECKEDOUTBY = NULL where productInd = " + this.productInd);
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            throw exception;
        }
        sQLMethod.close();
    }

    public Object clone() {
        Product product = new Product();
        product.customer = this.customer;
        product.warranty = this.warranty;
        product.offering = this.offering;
        product.type = this.type;
        product.prodNum = this.prodNum;
        product.partNum = this.partNum;
        product.description = this.description;
        product.baseModel = this.baseModel;
        product.input = this.input;
        product.source = this.source;
        product.checkedOutBy = this.checkedOutBy;
        product.createdOn = this.createdOn;
        product.createdBy = this.createdBy;
        product.lastTouchedOn = this.lastTouchedOn;
        product.lastTouchedBy = this.lastTouchedBy;
        product.xRef = this.xRef;
        product.locale = this.locale;
        product.dates = this.dates;
        product.brand = this.brand;
        product.family = this.family;
        product.model = this.model;
        product.machine = this.machine;
        product.project = this.project;
        product.subCategory = this.subCategory;
        return product;
    }

    public void initializeProperties(Product product) {
        this.customer = product.customer;
        this.warranty = product.warranty;
        this.offering = product.offering;
        this.type = product.type;
        this.prodNum = product.prodNum;
        this.partNum = product.partNum;
        this.description = product.description;
        this.baseModel = product.baseModel;
        this.input = product.input;
        this.source = product.source;
        this.checkedOutBy = product.checkedOutBy;
        this.createdOn = product.createdOn;
        this.createdBy = product.createdBy;
        this.lastTouchedOn = product.lastTouchedOn;
        this.lastTouchedBy = product.lastTouchedBy;
        this.xRef = product.xRef;
        this.locale = product.getLocale();
        this.dates = product.getDates();
        this.opicmImport = product.opicmImport;
        if (product.commentHistory != null) {
            this.commentHistory = (Vector)product.commentHistory.clone();
        }
        if (product.brand != null) {
            this.setBrand(product.brand);
        }
        if (product.family != null) {
            this.setFamily(product.family);
        }
        if (product.model != null) {
            this.setModel(product.model);
        }
        if (product.machine != null) {
            this.setMachine(product.machine);
        }
        if (product.project != null) {
            this.setProject(product.project);
        }
        if (product.subCategory != null) {
            this.setSubCategory(product.subCategory);
        }
        if (product.partNum != null) {
            this.setPartNumber(product.partNum);
        }
        if (this.dates != null) {
            int n = 0;
            int n2 = this.dates.size();
            while (n < n2) {
                ((ProductDate)this.dates.elementAt(n)).setProductInd(this.getProductInd());
                ++n;
            }
        }
        this.locale.updateRecStatus(2);
    }

    public String getPublish() {
        return this.publish ? "Y" : "N";
    }

    public void setPublish(String string) {
        this.publish = !string.equals("N");
    }

    protected void setLastTouchedOn(String string) {
        this.lastTouchedOn = string;
        this.updateRecStatus(1);
    }

    public void setLastTouchedBy(String string) {
        this.lastTouchedBy = string;
        this.updateRecStatus(1);
    }

    public void setBrand(TypeCategoryRec typeCategoryRec) throws IllegalArgumentException {
        if (this.brand == null) {
            this.brand = typeCategoryRec;
            this.brandUpdated = true;
        } else if (typeCategoryRec != null) {
            if (this.brand.getInd() != typeCategoryRec.getInd()) {
                this.brand = typeCategoryRec;
                this.brandUpdated = true;
                this.firePropertyChanged(2);
            }
        } else {
            this.brand = null;
        }
    }

    public void setFamily(TypeCategoryRec typeCategoryRec) throws IllegalArgumentException {
        if (typeCategoryRec != null) {
            if (this.family == null) {
                this.family = typeCategoryRec;
                this.familyUpdated = true;
                this.firePropertyChanged(5);
            } else if (this.family.getInd() != typeCategoryRec.getInd()) {
                this.family = typeCategoryRec;
                this.familyUpdated = true;
                this.firePropertyChanged(5);
            }
        } else {
            this.family = null;
        }
    }

    public void setMachine(TypeCategoryRec typeCategoryRec) throws IllegalArgumentException {
        if (typeCategoryRec != null) {
            if (this.machine == null) {
                this.machineUpdated = true;
                this.machine = typeCategoryRec;
                this.firePropertyChanged(3);
            } else if (this.machine.getInd() != typeCategoryRec.getInd()) {
                this.machine = typeCategoryRec;
                this.machineUpdated = true;
                this.firePropertyChanged(3);
            }
            this.prodNum = this.model != null ? typeCategoryRec.toString() + "-" + this.model.toString() : typeCategoryRec.toString();
        } else {
            this.machine = null;
        }
    }

    public void setModel(TypeCategoryRec typeCategoryRec) throws IllegalArgumentException {
        if (typeCategoryRec != null) {
            if (this.model == null) {
                this.model = typeCategoryRec;
            } else {
                this.model.setDescript(typeCategoryRec.toString());
                this.model.setIsDraft(typeCategoryRec.getIsDraft());
                this.model.setParentCatInd(typeCategoryRec.getParentCatInd());
                typeCategoryRec = this.model;
            }
            this.modelUpdated = true;
            this.firePropertyChanged(4);
            this.prodNum = this.machine != null ? this.machine.toString() + "-" + typeCategoryRec.toString() : typeCategoryRec.toString();
        } else {
            this.model = null;
        }
    }

    protected void hardSetModel(TypeCategoryRec typeCategoryRec) {
        this.model = typeCategoryRec;
        this.modelUpdated = true;
    }

    protected void hardSetPartNumber(TypeCategoryRec typeCategoryRec) {
        this.partNum = typeCategoryRec;
        this.partNumUpdated = true;
    }

    public void setProject(TypeCategoryRec typeCategoryRec) throws IllegalArgumentException {
        this.project = typeCategoryRec;
        this.updateRecStatus(1);
        this.projectUpdated = true;
        this.firePropertyChanged(24);
    }

    public void setSubCategory(TypeCategoryRec typeCategoryRec) throws IllegalArgumentException {
        if (typeCategoryRec != null && this.subCategory != null) {
            if (this.subCategory.getInd() != typeCategoryRec.getInd()) {
                this.subCategory = typeCategoryRec;
                this.machineUpdated = true;
                this.updateRecStatus(1);
                this.firePropertyChanged(23);
            }
        } else {
            this.subCategory = typeCategoryRec;
            this.machineUpdated = true;
            this.updateRecStatus(1);
            this.firePropertyChanged(23);
        }
    }

    public void setCreatedBy(String string) throws IllegalArgumentException {
        if (string == null || string.length() > 12) {
            throw new IllegalArgumentException("Cannot set Created By to NULL or set to > 12 characters. Tried to set created by to :" + string + ":");
        }
        this.createdBy = string;
        this.updateRecStatus(1);
        this.firePropertyChanged(7);
    }

    public void setCreatedOn(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Cannot set Created By to NULL. Tried to set created by to :" + string + ":");
        }
        this.createdOn = string;
        this.updateRecStatus(1);
        this.firePropertyChanged(8);
    }

    public boolean getOPICMImport() {
        return this.opicmImport;
    }

    public void setOPICMImport(boolean bl) {
        this.opicmImport = bl;
        this.updateRecStatus(1);
        this.firePropertyChanged(16);
    }

    public void setProductType(int n) {
        this.type = n;
        this.updateRecStatus(1);
        this.firePropertyChanged(18);
    }

    public String toSQL() {
        String string = "";
        if (this.generateKeys()) {
            switch (this.getRecStatus()) {
                case 3: {
                    int n = 0;
                    if (this.partNum != null) {
                        n = this.partNum.getInd();
                    } else if (this.model != null) {
                        n = this.model.getInd();
                    }
                    string = "UPDATE PRODUCT.PRODUCT " + "SET PUBLISH = 'N'," + "    LASTTOUCHEDBY = '" + this.lastTouchedBy + "', " + "    LASTTOUCHEDON = CURRENT TIMESTAMP " + "WHERE PRODUCTIND = " + this.productInd + "" + SqlRunner.END_DELIM + "" + "DELETE FROM TIGRIS.CATEGORY WHERE TYPECATIND = " + n + "" + SqlRunner.END_DELIM + "" + "DELETE FROM QUEST.CATEGORY WHERE TYPECATIND = " + n;
                    break;
                }
                case 2: {
                    string = "INSERT INTO PRODUCT.PRODUCT " + "( PRODUCTIND,     PRODNUM,         DESCRIPTION,      BASEMODEL, TYPECUSTOMERIND, " + "  TYPEPRODUCTIND, TYPEOFFERINGIND, TYPEWARRANTYIND,  INPUT,     SOURCE, " + "  PUBLISH,        CHECKEDOUTBY,    IMPORTOPICM,      CREATEDON, CREATEDBY, " + "  LASTTOUCHEDON,  LASTTOUCHEDBY ) values ( " + " " + this.productInd + ", " + " '" + Text.cleanDBString(this.prodNum) + "', " + " '" + Text.cleanDBString(this.description) + "', " + " " + Text.cleanNullableDBString(this.baseModel) + ", " + " " + this.customer + ", " + " " + this.type + ", " + " " + this.offering + ", " + " " + this.warranty + ", " + " '" + Text.cleanDBString(this.input) + "', " + " '" + Text.cleanDBString(this.source) + "', " + " 'Y', " + " NULL, " + " 'Y', " + " CURRENT TIMESTAMP, " + " '" + this.lastTouchedBy + "', " + " CURRENT TIMESTAMP, " + " '" + this.lastTouchedBy + "' )";
                    break;
                }
                case 1: {
                    string = "UPDATE PRODUCT.PRODUCT " + "SET PRODNUM     = '" + Text.cleanDBString(this.prodNum) + "', " + "    DESCRIPTION     = '" + Text.cleanDBString(this.description) + "', " + "    BASEMODEL       = '" + Text.cleanDBString(this.baseModel) + "', " + "    TYPECUSTOMERIND = " + this.customer + ", " + "    TYPEPRODUCTIND  = " + this.type + ", " + "    TYPEOFFERINGIND = " + this.offering + ", " + "    TYPEWARRANTYIND = " + this.warranty + ", " + "    INPUT           = '" + Text.cleanDBString(this.input) + "', " + "    SOURCE          = '" + Text.cleanDBString(this.source) + "', " + "    PUBLISH         = '" + (this.publish ? "Y" : "N") + "', " + "    CHECKEDOUTBY    = " + Text.cleanNullableDBString(this.checkedOutBy) + ", " + "    IMPORTOPICM     = '" + (this.opicmImport ? "Y" : "N") + "', " + "    LASTTOUCHEDON   = CURRENT TIMESTAMP, " + "    LASTTOUCHEDBY   = '" + Text.cleanDBString(this.lastTouchedBy) + "' " + "WHERE PRODUCTIND = " + this.productInd;
                    break;
                }
            }
            if (string.length() > 0) {
                string = string + SqlRunner.END_DELIM;
            }
            string = string + this.datesToSQL();
            string = string + this.xRefToSQL();
            string = string + this.localeToSQL();
            string = string + this.categoryToSQL();
        } else {
            String string2 = "Could not generate a Product Indicator. No INSERT can occur. Please check logs for more info";
            LogSystem.log(1, string2);
        }
        return string;
    }

    protected String datesToSQL() {
        String string = "";
        Vector vector = this.getDates();
        int n = 0;
        int n2 = vector.size();
        ProductDate productDate = null;
        string = "DELETE FROM PRODUCT.DATES WHERE PRODUCTIND = " + this.getProductInd() + SqlRunner.END_DELIM;
        while (n < n2) {
            productDate = (ProductDate)vector.elementAt(n);
            productDate.setProductInd(this.getProductInd());
            string = string + productDate.toSQL();
            ++n;
        }
        return string;
    }

    protected String xRefToSQL() {
        String string = "";
        if (POMUtil.vectorContainsChanges(this.xRef)) {
            int n = 0;
            int n2 = this.xRef.size();
            XRef xRef = null;
            while (n < n2) {
                xRef = (XRef)this.xRef.elementAt(n);
                if (xRef.modified()) {
                    string = string + xRef.toSQL();
                }
                ++n;
            }
        }
        return string;
    }

    protected String localeToSQL() {
        String string = "";
        if (this.locale != null && this.locale.modified()) {
            Vector vector = this.locale.getCountryList();
            Vector vector2 = this.locale.getGeoListContainingAll();
            string = "DELETE FROM PRODUCT.GEO WHERE PRODUCTIND = " + this.productInd + SqlRunner.END_DELIM;
            string = string + "DELETE FROM PRODUCT.COUNTRY WHERE PRODUCTIND = " + this.productInd + SqlRunner.END_DELIM;
            if (this.locale.isWorldWide()) {
                string = string + "INSERT INTO PRODUCT.GEO ( PRODUCTIND, GEOIND ) " + "values ( " + this.productInd + ", " + 6 + " )" + SqlRunner.END_DELIM;
            } else {
                TypeRec typeRec;
                int n;
                int n2;
                if (vector != null && vector.size() > 0) {
                    n2 = 0;
                    n = vector.size();
                    typeRec = null;
                    while (n2 < n) {
                        typeRec = (TypeCountryCodeRec)vector.elementAt(n2);
                        string = string + "INSERT INTO PRODUCT.COUNTRY ( PRODUCTIND, COUNTRYCODEIND ) " + "values ( " + this.productInd + ", " + typeRec.getInd() + " )" + SqlRunner.END_DELIM;
                        ++n2;
                    }
                }
                if (vector2 != null && vector2.size() > 0) {
                    n2 = 0;
                    n = vector2.size();
                    typeRec = null;
                    while (n2 < n) {
                        typeRec = (TypeGeoRec)vector2.elementAt(n2);
                        string = string + "INSERT INTO PRODUCT.GEO ( PRODUCTIND, GEOIND ) " + "values ( " + this.productInd + ", " + typeRec.getInd() + " )" + SqlRunner.END_DELIM;
                        ++n2;
                    }
                }
            }
        }
        return string;
    }

    protected String categoryToSQL() {
        TypeCategoryRec typeCategoryRec;
        String string = "";
        if (this.brandUpdated) {
            if (this.getRecStatus() != 2) {
                string = string + "DELETE FROM PRODUCT.CATEGORY " + "WHERE PRODUCTIND = " + this.productInd + " AND " + "      TYPECATIND = (select b.typecatind " + "                    from product.category a, " + "                         product.typecategory b " + "                    where productInd      = " + this.productInd + " and " + "                          a.typecatind    = b.typecatind and " + "                          b.categorylevel = 'brand')" + SqlRunner.END_DELIM;
            }
            string = string + "INSERT INTO PRODUCT.CATEGORY " + "(PRODUCTIND, TYPECATIND) values (" + "" + this.productInd + ", " + "" + this.brand.getInd() + " )" + SqlRunner.END_DELIM;
        }
        if (this.familyUpdated) {
            if (this.getRecStatus() != 2) {
                string = string + "DELETE FROM PRODUCT.CATEGORY " + "WHERE PRODUCTIND = " + this.productInd + " AND " + "      TYPECATIND = (select b.typecatind " + "                    from product.category a, " + "                         product.typecategory b " + "                    where productInd      = " + this.productInd + " and " + "                          a.typecatind    = b.typecatind and " + "                          b.categorylevel = 'family')" + SqlRunner.END_DELIM;
            }
            string = string + "INSERT INTO PRODUCT.CATEGORY " + "(PRODUCTIND, TYPECATIND) values (" + "" + this.productInd + ", " + "" + this.family.getInd() + " )" + SqlRunner.END_DELIM;
        }
        if ((this.project == null || this.projectUpdated) && (typeCategoryRec = this.getProject()) != null) {
            string = string + typeCategoryRec.toSQL();
            if (this.getRecStatus() != 2) {
                string = string + "DELETE FROM PRODUCT.CATEGORY " + "WHERE PRODUCTIND = " + this.productInd + " AND " + "      TYPECATIND = (select b.typecatind " + "                    from product.category a, " + "                         product.typecategory b " + "                    where productInd      = " + this.productInd + " and " + "                          a.typecatind    = b.typecatind and " + "                          b.categorylevel = '" + "project" + "')" + SqlRunner.END_DELIM;
            }
            string = string + "INSERT INTO PRODUCT.CATEGORY " + "(PRODUCTIND, TYPECATIND) values (" + "" + this.productInd + ", " + "" + typeCategoryRec.getInd() + " )" + SqlRunner.END_DELIM;
        }
        if (this.machineUpdated) {
            boolean bl = this.getProductType() == 2;
            string = bl ? string + this.getSubCategory().toDraftSQL() : string + this.getMachine().toDraftSQL();
            if (this.getRecStatus() != 2) {
                string = string + "DELETE FROM PRODUCT.CATEGORY " + "WHERE PRODUCTIND = " + this.getProductInd() + " AND " + "      TYPECATIND = (select b.typecatind " + "                    from prodraft.category a, " + "                         prodraft.typecategory b " + "                    where a.productInd      = " + this.getProductInd() + " and " + "                          a.typecatind    = b.typecatind and " + "                          b.categorylevel = IN ('" + "machine" + "', '" + "subcategory" + "')" + SqlRunner.END_DELIM;
            }
            string = bl ? string + "INSERT INTO PRODUCT.CATEGORY " + "(PRODUCTIND, TYPECATIND) values (" + "" + this.getProductInd() + ", " + "" + this.getSubCategory().getInd() + " )" + SqlRunner.END_DELIM : string + "INSERT INTO PRODUCT.CATEGORY " + "(PRODUCTIND, TYPECATIND) values (" + "" + this.getProductInd() + ", " + "" + this.getMachine().getInd() + " )" + SqlRunner.END_DELIM;
        }
        if (this.partNumUpdated) {
            if (this.partNum != null) {
                string = string + this.partNum.toSQL();
                if (this.getRecStatus() == 2) {
                    string = string + "INSERT INTO PRODUCT.CATEGORY " + "(PRODUCTIND, TYPECATIND) values (" + "" + this.productInd + ", " + "" + this.partNum.getInd() + " )" + SqlRunner.END_DELIM;
                }
            } else {
                string = string + "DELETE FROM PRODUCT.CATEGORY WHERE PRODUCTIND = " + this.getProductInd() + " AND " + "TYPECATIND IN (SELECT TYPECATIND FROM PRODUCT.TYPECATEGORY WHERE CATEGORYLEVEL = '" + "partnum" + "')" + SqlRunner.END_DELIM;
            }
        }
        if (this.modelUpdated) {
            if (this.model != null) {
                string = string + this.model.toSQL();
                if (this.getRecStatus() == 2) {
                    string = string + "INSERT INTO PRODUCT.CATEGORY " + "(PRODUCTIND, TYPECATIND) values (" + "" + this.productInd + ", " + "" + this.model.getInd() + " )" + SqlRunner.END_DELIM;
                }
            } else {
                string = string + "DELETE FROM PRODUCT.CATEGORY WHERE PRODUCTIND = " + this.productInd + " AND " + "TYPECATIND IN (SELECT TYPECATIND FROM PRODUCT.TYPECATEGORY WHERE CATEGORYLEVEL = '" + "model" + "')" + SqlRunner.END_DELIM;
            }
        }
        return string;
    }

    protected boolean generateKeys() {
        if (this.productInd == 0) {
            this.setProductInd(Counter.getCounter(LogSystem.getInstance(), "PRODUCT"));
        }
        return this.productInd != 0;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toOut() {
        block6: {
            block5: {
                var1_1 = "";
                var1_1 = var1_1 + "Product Ind:            " + this.getProductIndNow() + "\n";
                var1_1 = var1_1 + "Description:            " + this.getDescription() + "\n";
                var1_1 = this.getBrand() != null ? var1_1 + "Brand:                  " + this.getBrand().toString() + "\n" : var1_1 + "Brand:                  NONE\n";
                var1_1 = this.getFamily() != null ? var1_1 + "Family:                 " + this.getFamily().toString() + "\n" : var1_1 + "Family:                  NONE\n";
                var1_1 = this.getProject() != null ? (this.project.toString().equals("Default") ? var1_1 + "Project:                BLANK PROJECT\n" : var1_1 + "Project:                " + this.getProject().toString() + "\n") : var1_1 + "Project:                NULL!\n";
                try {
                    var1_1 = var1_1 + "Machine:                " + this.getMachine().toString() + "\n";
                    var1_1 = var1_1 + "Model:                  " + this.getModel().toString() + "\n";
                }
                catch (Exception var2_2) {
                    var1_1 = var1_1 + "Machine:                NONE\n";
                    var1_1 = var1_1 + "Model:                  NONE\n";
                }
                try {
                    var1_1 = var1_1 + "Part Number:            " + this.getPartNumber().toString() + "\n";
                }
                catch (Exception var2_3) {
                    var1_1 = var1_1 + "Part Number:            NONE\n";
                }
                var1_1 = var1_1 + "publish:                " + this.getPublish() + "\n";
                var1_1 = var1_1 + "Checked Out By:         " + this.getCheckedOutBy() + "\n";
                var1_1 = var1_1 + "Source:                 " + this.getSource() + "\n";
                var1_1 = var1_1 + "Offering:               " + this.getOffering() + "\n";
                var1_1 = var1_1 + "Customer:               " + this.getCustomer() + "\n";
                var1_1 = var1_1 + "Warranty:               " + this.getWarranty() + "\n";
                if (this.xRef == null || this.xRef.size() <= 0) break block5;
                var2_5 = 0;
                var3_6 = this.xRef.size();
                if (true) ** GOTO lbl37
            }
            var1_1 = var1_1 + "\nNo XRef Objects\n";
            break block6;
            do {
                var1_1 = var1_1 + ((XRef)this.xRef.elementAt(var2_5)).toOut() + "\n\n";
                ++var2_5;
lbl37:
                // 2 sources

            } while (var2_5 < var3_6);
        }
        if (this.locale == null) return var1_1 + "No locale information\n\n";
        return var1_1 + this.locale.toOut() + "\n\n";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Product find(int n) {
        ProductDraft productDraft = null;
        SQLMethod sQLMethod = new SQLMethod(1, "ProductDraft.find ( " + n + " )", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT PRODUCTIND FROM PRODUCT.PRODUCT WHERE PRODUCTIND = " + n + " FOR FETCH ONLY");
            if (resultSet.next()) {
                productDraft = new ProductDraft(n);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        return productDraft;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Product findFromCategory(int n, int n2, int n3, int n4) {
        ProductDraft productDraft = null;
        SQLMethod sQLMethod = new SQLMethod(1, "ProductDraft.find ( " + n2 + ", " + n3 + ", " + n4 + " )", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT PRODUCTIND " + "FROM   PRODUCT.PRODUCT " + "WHERE " + "PRODUCTIND IN ( " + "    SELECT PRODUCTIND " + "    FROM   PRODUCT.CATEGORY " + "    WHERE  TYPECATIND = " + n2 + ") AND " + "PRODUCTIND IN ( " + "    SELECT PRODUCTIND " + "    FROM   PRODUCT.CATEGORY " + "    WHERE  TYPECATIND = " + n + ") AND " + "PRODUCTIND IN ( " + "    SELECT PRODUCTIND " + "    FROM   PRODUCT.CATEGORY " + "    WHERE  TYPECATIND = " + n3 + ") AND " + "PRODUCTIND IN ( " + "    SELECT PRODUCTIND " + "    FROM   PRODUCT.CATEGORY " + "    WHERE  TYPECATIND = " + n4 + ") FOR FETCH ONLY ");
            if (resultSet.next()) {
                productDraft = new ProductDraft(resultSet.getInt(1));
            }
            resultSet.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        return productDraft;
    }

    public static Product findFromCategory(String string, String string2, String string3, String string4) {
        TypeCategoryRec typeCategoryRec = TypeCategory.getCategory(string, "brand");
        TypeCategoryRec typeCategoryRec2 = TypeCategory.getCategory(string2, "family");
        TypeCategoryRec typeCategoryRec3 = TypeCategory.getCategory(string3, "machine");
        TypeCategoryRec typeCategoryRec4 = TypeCategory.getCategory(string4, "model");
        if (typeCategoryRec2 != null && typeCategoryRec3 != null && typeCategoryRec4 != null) {
            return Product.findFromCategory(typeCategoryRec.getInd(), typeCategoryRec2.getInd(), typeCategoryRec3.getInd(), typeCategoryRec4.getInd());
        }
        return null;
    }

    public void forceRecStatus(int n) {
        this.updateRecStatus(0);
        this.updateRecStatus(n);
        if (n == 0) {
            this.resetUpdateVariables();
        }
    }

    protected void createCategoryFromDraft(ProductDraft productDraft) {
        TypeCategoryRec typeCategoryRec = null;
        TypeCategoryRec typeCategoryRec2 = null;
        TypeCategoryRec typeCategoryRec3 = null;
        TypeCategoryRec typeCategoryRec4 = null;
        TypeCategoryRec typeCategoryRec5 = null;
        TypeCategoryRec typeCategoryRec6 = productDraft.getMachine();
        TypeCategoryRec typeCategoryRec7 = productDraft.getModel();
        TypeCategoryRec typeCategoryRec8 = productDraft.getProject();
        TypeCategoryRec typeCategoryRec9 = productDraft.getPartNumber();
        TypeCategoryRec typeCategoryRec10 = productDraft.getSubCategory();
        if (typeCategoryRec8 != null) {
            typeCategoryRec3 = TypeCategory.getCategory(typeCategoryRec8.getInd());
            if (typeCategoryRec3 == null) {
                typeCategoryRec3 = TypeCategory.createTypeCategory(typeCategoryRec8.getInd(), this.getFamily().getInd(), typeCategoryRec8.toString(), "project", typeCategoryRec8.getOrderNum(), typeCategoryRec8.getChildSort(), typeCategoryRec8.getOwner());
                typeCategoryRec3.writeToDatabase();
                this.setProject(typeCategoryRec3);
            } else {
                this.projectUpdated = this.getRecStatus() == 2;
                this.project = typeCategoryRec3;
            }
        }
        if (typeCategoryRec6 != null) {
            typeCategoryRec = TypeCategory.getCategory(typeCategoryRec6.getInd());
            if (typeCategoryRec == null) {
                typeCategoryRec = TypeCategory.createTypeCategory(typeCategoryRec6.getInd(), typeCategoryRec3.getInd(), typeCategoryRec6.toString(), "machine", typeCategoryRec6.getOrderNum(), typeCategoryRec6.getChildSort(), typeCategoryRec6.getOwner());
                typeCategoryRec.writeToDatabase();
                this.setMachine(typeCategoryRec);
            } else {
                this.machineUpdated = this.getRecStatus() == 2;
                this.machine = typeCategoryRec;
            }
        }
        if (typeCategoryRec7 != null) {
            typeCategoryRec2 = TypeCategory.getCategory(typeCategoryRec7.getInd());
            if (typeCategoryRec2 == null) {
                typeCategoryRec2 = TypeCategory.createTypeCategory(typeCategoryRec7.getInd(), typeCategoryRec6.getInd(), typeCategoryRec7.toString(), "model", typeCategoryRec7.getOrderNum(), typeCategoryRec7.getChildSort(), typeCategoryRec7.getOwner());
                this.model = null;
                this.setModel(typeCategoryRec2);
            } else {
                this.modelUpdated = false;
                this.model = typeCategoryRec2;
            }
        }
        if (typeCategoryRec != null && this.model != null) {
            this.model.setParentCatInd(typeCategoryRec.getInd());
            typeCategoryRec2.writeToDatabase();
        }
        if (typeCategoryRec10 != null) {
            typeCategoryRec4 = TypeCategory.getCategory(typeCategoryRec10.getInd());
            if (typeCategoryRec4 == null) {
                typeCategoryRec4 = TypeCategory.createTypeCategory(typeCategoryRec10.getInd(), typeCategoryRec3.getInd(), typeCategoryRec10.toString(), "subcategory", typeCategoryRec10.getOrderNum(), typeCategoryRec10.getChildSort(), typeCategoryRec10.getOwner());
                typeCategoryRec4.writeToDatabase();
                this.setSubCategory(typeCategoryRec4);
            } else {
                this.machineUpdated = this.getRecStatus() == 2;
                this.subCategory = typeCategoryRec4;
            }
        }
        if (typeCategoryRec9 != null) {
            typeCategoryRec5 = TypeCategory.getCategory(typeCategoryRec9.getInd());
            if (typeCategoryRec5 == null) {
                typeCategoryRec5 = TypeCategory.createTypeCategory(typeCategoryRec9.getInd(), typeCategoryRec10.getInd(), typeCategoryRec9.toString(), "partnum", typeCategoryRec9.getOrderNum(), typeCategoryRec9.getChildSort(), typeCategoryRec9.getOwner());
                typeCategoryRec5.writeToDatabase();
                typeCategoryRec5.updateRecStatus(0);
                this.partNum = null;
                this.setPartNumber(typeCategoryRec5);
            } else {
                this.partNumUpdated = false;
                this.partNum = typeCategoryRec5;
            }
        }
    }

    protected void resetUpdateVariables() {
        this.machineUpdated = false;
        this.modelUpdated = false;
        this.partNumUpdated = false;
        this.brandUpdated = false;
        this.familyUpdated = false;
        this.projectUpdated = false;
        if (this.dates != null) {
            int n = 0;
            int n2 = this.dates.size();
            while (n < n2) {
                if (((ProductDate)this.dates.elementAt(n)).valid()) {
                    ((ProductDate)this.dates.elementAt(n)).updateRecStatus(0);
                }
                ++n;
            }
        }
        if (this.locale != null && this.locale.valid()) {
            this.locale.updateRecStatus(0);
        }
        if (this.brand != null) {
            this.brand.updateRecStatus(0);
        }
        if (this.family != null) {
            this.family.updateRecStatus(0);
        }
        if (this.project != null) {
            this.project.updateRecStatus(0);
        }
        if (this.machine != null) {
            this.machine.updateRecStatus(0);
        }
        if (this.subCategory != null) {
            this.subCategory.updateRecStatus(0);
        }
        if (this.model != null) {
            this.model.updateRecStatus(0);
        }
        if (this.partNum != null) {
            this.partNum.updateRecStatus(0);
        }
    }

    public void addProductPropertyListener(ProductPropertyListener productPropertyListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(1);
        }
        this.listeners.addElement(productPropertyListener);
    }

    public void removeProductPropertyListener(ProductPropertyListener productPropertyListener) {
        if (this.listeners != null) {
            this.listeners.removeElement(productPropertyListener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    protected void firePropertyChanged(int n) {
        if (this.listeners != null && this.fireEventEnabled) {
            Product product = this;
            if (product == null) {
                throw null;
            }
            product.new FireThread(this, n, this.listeners);
        }
    }

    public void setPropertyChangeEnabled(boolean bl) {
        this.fireEventEnabled = bl;
    }

    public Vector getCommentHistory() {
        return this.commentHistory;
    }

    protected void addCommentToHistory(ProductComment productComment) {
        if (this.commentHistory == null) {
            this.commentHistory = new Vector(1);
        }
        this.commentHistory.addElement(productComment);
    }

    public String getCommentHistoryAsText() {
        String string = "";
        if (this.commentHistory != null && this.commentHistory.size() > 0) {
            int n = 0;
            int n2 = this.commentHistory.size();
            while (n < n2) {
                string = string + ((ProductComment)this.commentHistory.elementAt(n)).toString();
                if (n < n2 - 1) {
                    string = string + "\n\n";
                }
                ++n;
            }
        }
        return string;
    }

    public Product() {
        this.updateRecStatus(2);
    }

    public Product(int n) {
        this.setProductInd(n);
    }

    public class FireThread
    implements Runnable {
        int property = 0;
        Vector listeners = null;
        Product product = null;

        public void run() {
            int n = 0;
            int n2 = this.listeners.size();
            while (n < n2) {
                ((ProductPropertyListener)this.listeners.elementAt(n)).productChanged(this.product, this.property);
                ++n;
            }
        }

        public FireThread(Product product2, int n, Vector vector) {
            this.product = product2;
            this.property = n;
            this.listeners = vector;
            new Thread(this).start();
        }
    }
}

