/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.product;

import com.ibm.nzna.projects.common.quest.product.Product;
import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.util.LogSystem;

public class ProductReadTest {
    private String databaseName = null;
    private String server = null;
    private String userId = null;
    private String password = null;
    private String portNumber = null;
    private int docInd = 0;

    public static void main(String[] stringArray) {
        new LogSystem(1, "ProductReadTest.out");
        new ProductReadTest(stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProductReadTest(String[] stringArray) {
        try {
            this.databaseName = stringArray[0];
            this.server = stringArray[1];
            this.portNumber = stringArray[2];
            this.userId = stringArray[3];
            this.password = stringArray[4];
            this.docInd = new Integer(stringArray[5]);
        }
        catch (Exception exception) {
            System.out.println("Usage:\njava com.ibm.nzna.projects.common.quest.doc.DocReader <databaseName> <serverName> <portNumber> <userId> <password> <doc indicator>");
            System.exit(0);
        }
        try {
            DatabaseSystem databaseSystem = new DatabaseSystem(false, null, false);
            System.out.print("Connecting to Quest...");
            if (!DatabaseSystem.createConnection(1, this.databaseName, this.server, this.portNumber, this.userId, this.password)) {
                System.out.println("Could not connect to " + this.databaseName + " on " + this.server + " on port " + this.portNumber);
                return;
            }
            System.out.println("Done");
            int n = this.docInd;
            while (true) {
                if (n >= this.docInd + 5) {
                    return;
                }
                System.out.print("Reading Product :" + n + "  ");
                Product product = new Product(n);
                long l = System.currentTimeMillis();
                int n2 = 0;
                product = Product.findFromCategory("IBM Aptiva", "PS/1", "2165", "55C");
                if (product != null) {
                    System.out.println("Found Product " + product.getProductInd() + " Through Product.find");
                }
                if ((n2 = (product = new Product(n)).readFromDatabase()) == 0) {
                    System.out.println("Done");
                    System.out.println(product.toOut());
                } else if (n2 == 100) {
                    System.out.println("Could not find product");
                } else {
                    System.out.println("Error. RC:" + n2);
                }
                System.out.println("Total Time Taken:" + (System.currentTimeMillis() - l) + "(ms)");
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Could not connect to " + this.databaseName + " on " + this.server + " on port " + this.portNumber);
        }
    }
}

