/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.product;

import com.ibm.nzna.projects.common.quest.product.Product;
import com.ibm.nzna.projects.common.quest.product.ProductDraft;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.shared.gui.ExtendedMultiListRow;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.gui.MultiListSort;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.Text;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;

public class ProductRow
implements Serializable,
ExtendedMultiListRow,
MultiListRow,
MultiListSort {
    public static final int COL_LOCKED = 1;
    public static final int COL_PRODNUM = 2;
    public static final int COL_DESCRIPTION = 3;
    public static final int COL_ANNOUNCEDATE = 4;
    public static final int COL_CREATEDATE = 5;
    public static final int COL_LASTTOUCHEDBY = 6;
    public static final int COL_LASTTOUCHEDON = 7;
    public static final int MAX_COLUMNS = 8;
    private String description = null;
    private String[] descriptionArray = null;
    private int existingProductInd = 0;
    private int productInd = 0;
    private String prodNum = null;
    private Image image = null;
    private String originalLastTouchedBy = null;
    private String lastTouchedOn = null;
    private String createdOn = null;
    private String createdBy = null;
    private String actualDate = null;
    private String targetDate = null;
    private String lastTouchedBy = null;
    private TypeCategoryRec model = null;
    private int[] columnOrder = null;
    private boolean draft = false;
    private Product product = null;

    public Object getColumnData(int n) {
        return this.getData(this.columnOrder[n]);
    }

    private Object getData(int n) {
        switch (n) {
            case 1: {
                return this.image;
            }
            case 2: {
                return this.prodNum;
            }
            case 3: {
                return this.descriptionArray;
            }
            case 4: {
                return this.actualDate != null ? this.actualDate : this.targetDate;
            }
            case 5: {
                return this.createdOn;
            }
            case 6: {
                return this.lastTouchedBy;
            }
            case 7: {
                return this.lastTouchedOn;
            }
        }
        return "";
    }

    public String getLastTouchedBy() {
        return this.lastTouchedBy;
    }

    public void setLastTouchedBy(String string) {
        if (this.originalLastTouchedBy == null) {
            this.originalLastTouchedBy = this.lastTouchedBy;
        }
        this.lastTouchedBy = string;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public void adjustColumnGraphics(int n, Graphics graphics) {
    }

    public int getExistingProductInd() {
        return new Integer(this.existingProductInd);
    }

    public int getProductInd() {
        return new Integer(this.productInd);
    }

    public String getDescription() {
        return this.description;
    }

    public int readProduct(boolean bl) {
        int n = 0;
        if (bl) {
            this.product = null;
        }
        if (this.product == null) {
            this.product = this.isDraft() ? new ProductDraft(this.productInd) : new Product(this.productInd);
            n = this.product.readFromDatabase();
        }
        return n;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProdNum(String string) {
        this.prodNum = this.prodNum;
    }

    public String toString() {
        return "(" + this.prodNum + ") " + this.description;
    }

    public void columnSized(int n, int n2) {
        if (this.columnOrder[n] == 3) {
            this.descriptionArray = Text.formatStringLines(this.description, n2 / 6);
        }
    }

    public TypeCategoryRec getModel() {
        return this.model;
    }

    public void setModel(TypeCategoryRec typeCategoryRec) {
        this.model = typeCategoryRec;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public int compareTo(MultiListSort multiListSort, int n) {
        if (multiListSort instanceof ProductRow) {
            ProductRow productRow = (ProductRow)multiListSort;
            switch (this.columnOrder[n]) {
                case 1: {
                    if (this.image != null && productRow.image == null) {
                        return 1;
                    }
                    if (this.image == null && productRow.image != null) {
                        return -1;
                    }
                    return 0;
                }
                case 2: {
                    return this.prodNum.compareTo(productRow.prodNum);
                }
                case 3: {
                    return this.description.compareTo(productRow.description);
                }
                case 4: {
                    if (this.actualDate != null && productRow.actualDate != null) {
                        return CDate.compareDate(this.actualDate, productRow.actualDate, 14);
                    }
                    return 0;
                }
                case 5: {
                    return CDate.compareDate(this.createdOn, productRow.createdOn, 14);
                }
                case 6: {
                    return this.lastTouchedBy.compareTo(productRow.lastTouchedBy);
                }
                case 7: {
                    return CDate.compareDate(this.lastTouchedOn, productRow.lastTouchedOn, 14);
                }
            }
        }
        return 0;
    }

    public void setActualDate(String string) {
        this.actualDate = string;
    }

    public String getActualDate() {
        return this.actualDate;
    }

    public ProductRow(ProductDraft productDraft) {
        this(productDraft.getProductInd(), productDraft.getExistingProductInd(), productDraft.getProdNum() != null ? productDraft.getProdNum() : productDraft.getPartNumber().toString(), productDraft.getDescription(), productDraft.getCreatedOn(), productDraft.getCreatedBy(), "", "", productDraft.getLastTouchedBy(), productDraft.getLastTouchedOn(), true);
        this.product = productDraft;
    }

    public ProductRow(int n, int n2, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        this.productInd = n;
        this.existingProductInd = n2;
        this.prodNum = string;
        this.description = string2;
        this.createdOn = string3;
        this.createdBy = string4;
        this.actualDate = string5;
        this.targetDate = string6;
        this.lastTouchedBy = string7;
        this.lastTouchedOn = string8;
        this.draft = bl;
        this.columnOrder = new int[8];
        this.columnOrder[0] = 1;
        this.columnOrder[1] = 2;
        this.columnOrder[2] = 3;
        this.columnOrder[3] = 4;
        this.columnOrder[4] = 5;
        this.columnOrder[5] = 6;
        this.columnOrder[6] = 7;
        this.columnSized(1, 500);
    }
}

