/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.product;

import com.ibm.nzna.projects.common.quest.product.ProductRow;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.shared.db.SQLMethod;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class ProductSQL {
    public static Vector getProductsFromFamily(int n) throws SQLException {
        SQLMethod sQLMethod = new SQLMethod(1, "getProductsFromFamily ( " + n + " )", 5);
        Vector<ProductRow> vector = new Vector<ProductRow>(1);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT A.PRODUCTIND, A.PRODNUM,       A.DESCRIPTION,  A.CREATEDON, " + "       A.CREATEDBY,  A.LASTTOUCHEDBY, A.LASTTOUCHEDON " + "FROM PRODUCT.PRODUCT A, " + "     PRODUCT.CATEGORY B " + "WHERE A.PRODUCTIND = B.PRODUCTIND AND " + "      A.PUBLISH    = 'Y' AND " + "      B.TYPECATIND = " + n + " FOR FETCH ONLY");
            while (resultSet.next()) {
                vector.addElement(new ProductRow(resultSet.getInt(1), 0, resultSet.getString(2).trim(), resultSet.getString(3).trim(), resultSet.getString(4).trim(), resultSet.getString(5).trim(), "", "", resultSet.getString(6).trim(), resultSet.getString(7), false));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            sQLMethod.rollBack();
            sQLMethod.close();
            throw sQLException;
        }
        sQLMethod.close();
        if (vector.size() > 0) {
            ProductSQL.populateActiveOptionPartNumbers(vector);
        }
        return vector;
    }

    public static Vector getDeletedProductsFromFamily(int n) throws SQLException {
        SQLMethod sQLMethod = new SQLMethod(1, "getProductsFromFamily ( " + n + " )", 5);
        Vector<ProductRow> vector = new Vector<ProductRow>(1);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT A.PRODUCTIND, A.PRODNUM,       A.DESCRIPTION,  A.CREATEDON, " + "       A.CREATEDBY,  A.LASTTOUCHEDBY, A.LASTTOUCHEDON " + "FROM PRODUCT.PRODUCT A, " + "     PRODUCT.CATEGORY B " + "WHERE A.PRODUCTIND = B.PRODUCTIND AND " + "      A.PUBLISH    = 'N' AND " + "      B.TYPECATIND = " + n + " FOR FETCH ONLY");
            while (resultSet.next()) {
                vector.addElement(new ProductRow(resultSet.getInt(1), 0, resultSet.getString(2).trim(), resultSet.getString(3).trim(), resultSet.getString(4).trim(), resultSet.getString(5).trim(), "", "", resultSet.getString(6).trim(), resultSet.getString(7), false));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            sQLMethod.rollBack();
            sQLMethod.close();
            throw sQLException;
        }
        sQLMethod.close();
        if (vector.size() > 0) {
            ProductSQL.populateActiveOptionPartNumbers(vector);
        }
        return vector;
    }

    public static void populateDraftOptionPartNumbers(Vector vector) throws SQLException {
        SQLMethod sQLMethod = new SQLMethod(1, "populateOptionPartNumbers()", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT B.PRODUCTIND, A.DESCRIPTION FROM " + "PRODRAFT.TYPECATEGORY A, " + "PRODRAFT.CATEGORY B " + "WHERE A.TYPECATIND = B.TYPECATIND AND " + "A.CATEGORYLEVEL = '" + "partnum" + "' AND " + "B.PRODUCTIND IN " + ProductSQL.createInClauseFromProductRows(vector) + " " + "FOR FETCH ONLY");
            while (resultSet.next()) {
                ProductRow productRow = ProductSQL.getProductRowFromInd(resultSet.getInt(1), vector);
                productRow.setProdNum(resultSet.getString(2));
            }
        }
        catch (SQLException sQLException) {
            sQLMethod.rollBack();
            sQLMethod.close();
            throw sQLException;
        }
        sQLMethod.close();
    }

    public static void populateActiveOptionPartNumbers(Vector vector) throws SQLException {
        SQLMethod sQLMethod = new SQLMethod(1, "populateOptionPartNumbers()", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT B.PRODUCTIND, A.DESCRIPTION FROM " + "PRODUCT.TYPECATEGORY A, " + "PRODUCT.CATEGORY B " + "WHERE A.TYPECATIND = B.TYPECATIND AND " + "A.CATEGORYLEVEL = '" + "partnum" + "' AND " + "B.PRODUCTIND IN " + ProductSQL.createInClauseFromProductRows(vector) + " " + "FOR FETCH ONLY");
            while (resultSet.next()) {
                ProductRow productRow = ProductSQL.getProductRowFromInd(resultSet.getInt(1), vector);
                productRow.setProdNum(resultSet.getString(2));
            }
        }
        catch (SQLException sQLException) {
            sQLMethod.rollBack();
            sQLMethod.close();
            throw sQLException;
        }
        sQLMethod.close();
    }

    public static String createInClauseFromProductRows(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        String string = "(";
        while (n < n2) {
            string = string + ((ProductRow)vector.elementAt(n)).getProductInd();
            if (n < n2 - 1) {
                string = string + ",";
            }
            ++n;
        }
        return string + ")";
    }

    public static ProductRow getProductRowFromInd(int n, Vector vector) {
        int n2 = 0;
        ProductRow productRow = null;
        int n3 = vector.size();
        while (productRow == null && n2 < n3) {
            if (((ProductRow)vector.elementAt(n2)).getProductInd() == n) {
                productRow = (ProductRow)vector.elementAt(n2);
            }
            ++n2;
        }
        return productRow;
    }

    public static Vector getProductTemplatesFromFamily(int n) throws SQLException {
        SQLMethod sQLMethod = new SQLMethod(1, "getProductsFromFamily ( " + n + " )", 5);
        Vector<ProductRow> vector = new Vector<ProductRow>(1);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT A.PRODUCTIND, A.EXISTINGPRODUCTIND, A.PRODNUM,       A.DESCRIPTION, " + "       A.CREATEDON,  A.CREATEDBY,          A.LASTTOUCHEDBY, A.LASTTOUCHEDON " + "FROM PRODRAFT.PRODUCT A, " + "     PRODRAFT.CATEGORY B " + "WHERE A.PRODUCTIND = B.PRODUCTIND AND " + "      A.TEMPLATE   = 'Y' AND " + "      B.TYPECATIND = " + n + " FOR FETCH ONLY");
            while (resultSet.next()) {
                vector.addElement(new ProductRow(resultSet.getInt(1), 0, resultSet.getString(2).trim(), resultSet.getString(3).trim(), resultSet.getString(4).trim(), resultSet.getString(5).trim(), "", "", resultSet.getString(6).trim(), resultSet.getString(7), false));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            sQLMethod.rollBack();
            sQLMethod.close();
            throw sQLException;
        }
        sQLMethod.close();
        if (vector.size() > 0) {
            ProductSQL.populateDraftOptionPartNumbers(vector);
        }
        return vector;
    }

    public static Vector getProductHistoryFromFamily(int n) throws SQLException {
        SQLMethod sQLMethod = new SQLMethod(1, "getProductsFromFamily ( " + n + " )", 5);
        Vector<ProductRow> vector = new Vector<ProductRow>(1);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT A.PRODUCTIND, A.EXISTINGPRODUCTIND, A.PRODNUM,       A.DESCRIPTION, " + "       A.CREATEDON,  A.CREATEDBY,          A.LASTTOUCHEDBY, A.LASTTOUCHEDON " + "FROM PRODRAFT.PRODUCT A, " + "     PRODRAFT.CATEGORY B " + "WHERE A.PRODUCTIND = B.PRODUCTIND AND " + "      A.TEMPLATE   = 'N' AND " + "      B.TYPECATIND = " + n + " FOR FETCH ONLY");
            while (resultSet.next()) {
                vector.addElement(new ProductRow(resultSet.getInt(1), 0, resultSet.getString(2).trim(), resultSet.getString(3).trim(), resultSet.getString(4).trim(), resultSet.getString(5).trim(), "", "", resultSet.getString(6).trim(), resultSet.getString(7), false));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            sQLMethod.rollBack();
            sQLMethod.close();
            throw sQLException;
        }
        sQLMethod.close();
        if (vector.size() > 0) {
            ProductSQL.populateDraftOptionPartNumbers(vector);
        }
        return vector;
    }

    public static int getProductIndFromModel(TypeCategoryRec typeCategoryRec) throws SQLException {
        int n = 0;
        SQLMethod sQLMethod = new SQLMethod(1, "ProductSQL.getProductIndFromModel ( " + typeCategoryRec.toString() + " )", 5);
        Statement statement = sQLMethod.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT PRODUCTIND FROM PRODUCT.CATEGORY WHERE TYPECATIND = " + typeCategoryRec.getInd() + " FOR FETCH ONLY");
        if (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        resultSet.close();
        statement.close();
        return n;
    }

    public static int getDraftProductIndFromModel(TypeCategoryRec typeCategoryRec) throws SQLException {
        int n = 0;
        SQLMethod sQLMethod = new SQLMethod(1, "ProductSQL.getDraftProductIndFromModel ( " + typeCategoryRec.toString() + " )", 5);
        Statement statement = sQLMethod.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT PRODUCTIND FROM PRODRAFT.CATEGORY WHERE TYPECATIND = " + typeCategoryRec.getInd() + " FOR FETCH ONLY");
        if (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        resultSet.close();
        statement.close();
        return n;
    }

    public static int getExistingProductInd(int n) throws SQLException {
        int n2 = 0;
        SQLMethod sQLMethod = new SQLMethod(1, "ProductSQL.getExistingProductInd ( " + n + " )", 5);
        Statement statement = sQLMethod.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT EXISTINGPRODUCTIND FROM PRODRAFT.PRODUCT WHERE PRODUCTIND=" + n + " FOR FETCH ONLY");
        if (resultSet.next()) {
            n2 = resultSet.getInt(1);
        }
        resultSet.close();
        statement.close();
        return n2;
    }

    public static String getDBTimestampFromDatabase() {
        String string = null;
        SQLMethod sQLMethod = null;
        try {
            Statement statement = null;
            ResultSet resultSet = null;
            sQLMethod = new SQLMethod(1, "getDBTimestamp", 5);
            if (sQLMethod != null) {
                statement = sQLMethod.createStatement();
                resultSet = statement.executeQuery("SELECT CURRENT TIMESTAMP FROM TIGRIS.USERID FETCH FIRST 1 ROWS ONLY");
                if (resultSet.next()) {
                    string = resultSet.getString(1).trim();
                }
                resultSet.close();
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
        }
        if (sQLMethod != null) {
            sQLMethod.close();
        }
        return string;
    }
}

