/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.type;

import com.ibm.nzna.projects.common.quest.type.TypeCategoryListener;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.projects.common.storedProc.extSqlRunner.ExtSqlRunner;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class TypeCategory {
    public static final String LEVEL_BRAND = "brand";
    public static final String LEVEL_FAMILY = "family";
    public static final String LEVEL_MACHINE = "machine";
    public static final String LEVEL_MODEL = "model";
    public static final String LEVEL_PARTNUMBER = "partnum";
    public static final String LEVEL_OPICM_BRAND = "opicmbrand";
    public static final String LEVEL_OPICM_FAMILY = "opicmfamily";
    public static final String LEVEL_OPICM_SERIES = "opicmseries";
    public static final String LEVEL_OPICM_COUNTRY = "opicmcountry";
    public static final String LEVEL_OPICM_GEOGRAPHY = "opicmgeo";
    public static final String LEVEL_DOC_CATEGORY = "doccategory";
    public static final String LEVEL_PROJECT = "project";
    public static final String LEVEL_SUBCATEGORY = "subcategory";
    private static Vector listeners = new Vector(1);
    private static Vector categories = null;
    private static boolean cache = false;
    private static String cacheDirectory = null;
    private static Vector draftCategories = null;

    public static Vector getCategories(String string) {
        Vector vector = TypeCategory.readCategoriesFromMemory(string);
        if (vector == null) {
            TypeCategory.readCategoriesFromDatabase(-1, string);
            vector = TypeCategory.readCategoriesFromMemory(string);
        }
        if (vector == null) {
            vector = new Vector();
        }
        return vector;
    }

    public static Vector getChildCategories(int n) {
        Vector vector = TypeCategory.readCategoriesFromMemory(n);
        if (vector == null) {
            TypeCategory.readCategoriesFromDatabase(n, "");
            vector = TypeCategory.readCategoriesFromMemory(n);
        }
        return vector;
    }

    public static Vector getChildCategories(int n, String string) {
        Vector vector = TypeCategory.readCategoriesFromMemory(n, string);
        if (vector == null) {
            vector = TypeCategory.readCategoriesFromDatabase(n, string);
        }
        if (vector == null) {
            vector = new Vector();
        }
        return vector;
    }

    public static Vector getChildDraftCategories(int n, String string) {
        Vector vector = TypeCategory.readDraftCategoriesFromMemory(n, string);
        if (vector == null || vector.size() == 0) {
            vector = TypeCategory.readDraftCategoriesFromDatabase(n, string);
        }
        if (vector == null) {
            vector = new Vector();
        }
        return vector;
    }

    public static TypeCategoryRec lazyCreateTypeCategory(int n, String string, String string2, int n2, String string3, String string4) throws IllegalArgumentException {
        TypeCategoryRec typeCategoryRec = new TypeCategoryRec();
        typeCategoryRec.setParentCatInd(n);
        typeCategoryRec.setDescript(string);
        typeCategoryRec.setCategoryLevel(string2);
        typeCategoryRec.setOrderNum(n2);
        typeCategoryRec.setChildSort(string3);
        typeCategoryRec.setOwner(string4);
        typeCategoryRec.updateRecStatus(0);
        typeCategoryRec.updateRecStatus(2);
        return typeCategoryRec;
    }

    public static TypeCategoryRec lazyCreateDraftTypeCategory(int n, String string, String string2, int n2, String string3, String string4) throws IllegalArgumentException {
        TypeCategoryRec typeCategoryRec = new TypeCategoryRec();
        typeCategoryRec.setIsDraft(true);
        typeCategoryRec.setParentCatInd(n);
        typeCategoryRec.setDescript(string);
        typeCategoryRec.setCategoryLevel(string2);
        typeCategoryRec.setOrderNum(n2);
        typeCategoryRec.setChildSort(string3);
        typeCategoryRec.setOwner(string4);
        typeCategoryRec.updateRecStatus(0);
        typeCategoryRec.updateRecStatus(2);
        return typeCategoryRec;
    }

    public static TypeCategoryRec createTypeCategory(int n, String string, String string2, int n2, String string3, String string4) throws IllegalArgumentException {
        TypeCategoryRec typeCategoryRec = TypeCategory.lazyCreateTypeCategory(n, string, string2, n2, string3, string4);
        typeCategoryRec.generateKeys();
        TypeCategory.addCategory(typeCategoryRec);
        return typeCategoryRec;
    }

    public static TypeCategoryRec createDraftTypeCategory(int n, String string, String string2, int n2, String string3, String string4) throws IllegalArgumentException {
        TypeCategoryRec typeCategoryRec = TypeCategory.lazyCreateDraftTypeCategory(n, string, string2, n2, string3, string4);
        if (typeCategoryRec != null) {
            typeCategoryRec.generateKeys();
        }
        TypeCategory.addCategory(typeCategoryRec);
        return typeCategoryRec;
    }

    public static TypeCategoryRec createDraftTypeCategory(int n, int n2, String string, String string2, int n3, String string3, String string4) throws IllegalArgumentException {
        TypeCategoryRec typeCategoryRec = new TypeCategoryRec(n);
        typeCategoryRec.setParentCatInd(n2);
        typeCategoryRec.setDescript(string);
        typeCategoryRec.setCategoryLevel(string2);
        typeCategoryRec.setOrderNum(n3);
        typeCategoryRec.setChildSort(string3);
        typeCategoryRec.setOwner(string4);
        typeCategoryRec.setIsDraft(true);
        typeCategoryRec.updateRecStatus(0);
        typeCategoryRec.updateRecStatus(2);
        TypeCategory.addCategory(typeCategoryRec);
        return typeCategoryRec;
    }

    public static TypeCategoryRec createTypeCategory(int n, int n2, String string, String string2, int n3, String string3, String string4) throws IllegalArgumentException {
        TypeCategoryRec typeCategoryRec = new TypeCategoryRec(n);
        typeCategoryRec.setParentCatInd(n2);
        typeCategoryRec.setDescript(string);
        typeCategoryRec.setCategoryLevel(string2);
        typeCategoryRec.setOrderNum(n3);
        typeCategoryRec.setChildSort(string3);
        typeCategoryRec.setOwner(string4);
        typeCategoryRec.updateRecStatus(0);
        typeCategoryRec.updateRecStatus(2);
        TypeCategory.addCategory(typeCategoryRec);
        return typeCategoryRec;
    }

    public static int writeToDatabase() {
        int n;
        int n2;
        int n3 = -1;
        StringBuffer stringBuffer = new StringBuffer("");
        if (categories != null && categories.size() > 0) {
            n2 = 0;
            n = categories.size();
            TypeCategory.fireWriteStart();
            while (n2 < n) {
                stringBuffer.append(((TypeCategoryRec)categories.elementAt(n2)).toSQL());
                ++n2;
            }
        }
        if (draftCategories != null && draftCategories.size() > 0) {
            n2 = 0;
            n = draftCategories.size();
            TypeCategory.fireWriteStart();
            while (n2 < n) {
                System.out.println("Saving Draft Category. Rec Status:" + ((TypeCategoryRec)draftCategories.elementAt(n2)).getRecStatus() + ": " + ((TypeCategoryRec)draftCategories.elementAt(n2)).toString());
                stringBuffer.append(((TypeCategoryRec)draftCategories.elementAt(n2)).toSQL());
                ++n2;
            }
        }
        if (stringBuffer.length() > 0) {
            n3 = ExtSqlRunner.sqlRunnerCode(1, stringBuffer.toString());
            if (n3 == 0) {
                if (categories != null && categories.size() > 0) {
                    n2 = 0;
                    n = categories.size();
                    n = categories.size();
                    while (n2 < n) {
                        if (!((TypeCategoryRec)categories.elementAt(n2)).valid()) {
                            categories.removeElementAt(n2);
                            n = categories.size();
                            continue;
                        }
                        ((TypeCategoryRec)categories.elementAt(n2)).updateRecStatus(0);
                        ++n2;
                    }
                }
                if (draftCategories != null && draftCategories.size() > 0) {
                    n2 = 0;
                    n = draftCategories.size();
                    n = draftCategories.size();
                    while (n2 < n) {
                        if (!((TypeCategoryRec)draftCategories.elementAt(n2)).valid()) {
                            draftCategories.removeElementAt(n2);
                            n = draftCategories.size();
                            continue;
                        }
                        ((TypeCategoryRec)draftCategories.elementAt(n2)).updateRecStatus(0);
                        ++n2;
                    }
                }
            }
            TypeCategory.fireWriteStop();
        } else {
            n3 = 0;
        }
        return n3;
    }

    private static Vector readCategoriesFromDatabase(int n) {
        return TypeCategory.readCategoriesFromDatabase(n, "");
    }

    private static Vector readCategoriesFromDatabase(int n, String string) {
        Vector vector = null;
        String string2 = "readCategoriesFromDatabase";
        SQLMethod sQLMethod = new SQLMethod(1, string2, 5);
        TypeCategory.fireReadStart(TypeCategory.getDescriptFromCategoryLevel(string));
        if (sQLMethod != null) {
            try {
                CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.TypeCatReader", 4);
                callableStatement.setString(1, string);
                callableStatement.setInt(2, n);
                callableStatement.registerOutParameter(3, -4);
                callableStatement.registerOutParameter(4, -4);
                if (LogSystem.getInstance() != null) {
                    LogSystem.log(1, "Reading Categories. ParentCatInd:" + n + "   Category Level:" + string);
                }
                callableStatement.execute();
                StoredProcRec storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 4);
                if (storedProcRec != null && storedProcRec.error) {
                    if (LogSystem.getInstance() != null) {
                        LogSystem.beginLogSection("TypeCatReader Returned Error");
                        LogSystem.log(1, "sqlCode:   " + storedProcRec.sqlCode);
                        LogSystem.log(1, "userError: " + storedProcRec.userError);
                        LogSystem.log(1, "errorStr:  " + storedProcRec.errorStr);
                        LogSystem.log(1, "error:     " + storedProcRec.error);
                        LogSystem.endLogSection();
                    }
                } else {
                    vector = (Vector)StoredProcUtil.getObjectFromStatement(callableStatement, 3);
                    if (vector != null && vector.size() > 0) {
                        int n2 = 0;
                        int n3 = vector.size();
                        while (n2 < n3) {
                            TypeCategory.addCategory((TypeCategoryRec)vector.elementAt(n2));
                            ++n2;
                        }
                    }
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception, false);
                vector = null;
            }
        }
        sQLMethod.close();
        TypeCategory.fireReadStop();
        return vector;
    }

    private static Vector readCategoriesFromMemory(String string) {
        Vector vector = new Vector(10);
        if (categories != null && categories.size() > 0) {
            int n = 0;
            int n2 = categories.size();
            while (n < n2) {
                if (((TypeCategoryRec)categories.elementAt(n)).getCategoryLevel().equals(string) && ((TypeCategoryRec)categories.elementAt(n)).valid()) {
                    vector.addElement(categories.elementAt(n));
                }
                ++n;
            }
        }
        vector.trimToSize();
        if (vector.size() == 0) {
            vector = null;
        }
        return vector;
    }

    private static Vector readDraftCategoriesFromMemory(int n, String string) {
        Vector vector = new Vector(10);
        if (draftCategories != null && draftCategories.size() > 0) {
            TypeCategoryRec typeCategoryRec = TypeCategory.getDraftCategory(n);
            int n2 = 0;
            int n3 = draftCategories.size();
            while (n2 < n3) {
                if (((TypeCategoryRec)draftCategories.elementAt(n2)).getCategoryLevel().equals(string) && ((TypeCategoryRec)draftCategories.elementAt(n2)).getIsDraft() && ((TypeCategoryRec)draftCategories.elementAt(n2)).valid() && ((TypeCategoryRec)draftCategories.elementAt(n2)).getParentCatInd() == n) {
                    vector.addElement(draftCategories.elementAt(n2));
                }
                ++n2;
            }
        }
        vector.trimToSize();
        if (vector.size() == 0) {
            vector = null;
        }
        return vector;
    }

    private static Vector readCategoriesFromMemory(int n, String string) {
        Vector vector = new Vector(10);
        if (categories != null && categories.size() > 0) {
            TypeCategoryRec typeCategoryRec = TypeCategory.getCategory(n);
            int n2 = 0;
            int n3 = categories.size();
            while (n2 < n3) {
                if (((TypeCategoryRec)categories.elementAt(n2)).getCategoryLevel().equals(string) && ((TypeCategoryRec)categories.elementAt(n2)).getIsDraft() == typeCategoryRec.getIsDraft() && ((TypeCategoryRec)categories.elementAt(n2)).valid() && ((TypeCategoryRec)categories.elementAt(n2)).getParentCatInd() == n) {
                    vector.addElement(categories.elementAt(n2));
                }
                ++n2;
            }
        }
        vector.trimToSize();
        if (vector.size() == 0) {
            vector = null;
        }
        return vector;
    }

    private static Vector readCategoriesFromMemory(int n) {
        Vector vector = new Vector(10);
        TypeCategoryRec typeCategoryRec = TypeCategory.getCategory(n);
        if (categories != null && categories.size() > 0) {
            int n2 = 0;
            int n3 = categories.size();
            while (n2 < n3) {
                if (((TypeCategoryRec)categories.elementAt(n2)).getParentCatInd() == n && ((TypeCategoryRec)categories.elementAt(n2)).valid() && ((TypeCategoryRec)categories.elementAt(n2)).getIsDraft() == typeCategoryRec.getIsDraft()) {
                    vector.addElement(categories.elementAt(n2));
                }
                ++n2;
            }
        }
        vector.trimToSize();
        if (vector.size() == 0) {
            vector = null;
        }
        return vector;
    }

    public static void setCache(boolean bl) {
        cache = bl;
    }

    public static void setCacheDirectory(String string) {
        cacheDirectory = string;
    }

    public static String getCacheDirectory() {
        return cacheDirectory;
    }

    public static TypeCategoryRec getCategoryFromDescription(String string) {
        TypeCategoryRec typeCategoryRec = null;
        if (categories != null && categories.size() > 0) {
            int n = 0;
            int n2 = categories.size();
            while (n < n2 && typeCategoryRec == null) {
                if (((TypeCategoryRec)categories.elementAt(n)).toString().equals(string) && ((TypeCategoryRec)categories.elementAt(n)).valid() && !((TypeCategoryRec)categories.elementAt(n)).getIsDraft()) {
                    typeCategoryRec = (TypeCategoryRec)categories.elementAt(n);
                }
                ++n;
            }
        }
        if (typeCategoryRec == null) {
            SQLMethod sQLMethod = new SQLMethod(1, "TypeCategory.getCategoryFromDescription ( " + string + " )", 5);
            TypeCategory.fireReadStart("");
            try {
                TypeCategoryRec typeCategoryRec2 = null;
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = statement.executeQuery("select TypeCatInd,    Description, ParentCatInd, " + "       CategoryLevel, OrderNum,    ChildSort,    " + "       Owner " + "from product.TypeCategory " + "where description = '" + Text.cleanDBString(string) + "' and " + "      valid = 'Y' for Fetch only");
                while (resultSet.next()) {
                    typeCategoryRec = typeCategoryRec2 = new TypeCategoryRec(resultSet.getInt(1));
                    typeCategoryRec2.setDescript(resultSet.getString(2).trim());
                    typeCategoryRec2.setParentCatInd(resultSet.getInt(3));
                    typeCategoryRec2.setCategoryLevel(resultSet.getString(4).trim());
                    typeCategoryRec2.setOrderNum(resultSet.getInt(5));
                    typeCategoryRec2.setChildSort(resultSet.getString(6).trim());
                    typeCategoryRec2.setOwner(resultSet.getString(7));
                    typeCategoryRec2.updateRecStatus(0);
                    TypeCategory.addCategory(typeCategoryRec2);
                }
                resultSet.close();
            }
            catch (Exception exception) {
                if (LogSystem.getInstance() != null) {
                    LogSystem.log(1, exception, false);
                } else {
                    exception.printStackTrace();
                }
                sQLMethod.rollBack();
            }
            sQLMethod.close();
            TypeCategory.fireReadStop();
        }
        return typeCategoryRec;
    }

    public static TypeCategoryRec getCategoryFromDescription(String string, String string2) {
        TypeCategoryRec typeCategoryRec = null;
        if (categories != null && categories.size() > 0) {
            int n = 0;
            int n2 = categories.size();
            while (n < n2 && typeCategoryRec == null) {
                if (((TypeCategoryRec)categories.elementAt(n)).toString().equals(string) && !((TypeCategoryRec)categories.elementAt(n)).getIsDraft() && ((TypeCategoryRec)categories.elementAt(n)).valid() && ((TypeCategoryRec)categories.elementAt(n)).getCategoryLevel().equals(string2)) {
                    typeCategoryRec = (TypeCategoryRec)categories.elementAt(n);
                }
                ++n;
            }
        }
        if (typeCategoryRec == null) {
            SQLMethod sQLMethod = new SQLMethod(1, "TypeCategory.getCategoryFromDescription ( " + string + " )", 5);
            TypeCategory.fireReadStart("");
            try {
                TypeCategoryRec typeCategoryRec2 = null;
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = statement.executeQuery("select TypeCatInd,    Description, ParentCatInd, " + "       CategoryLevel, OrderNum,    ChildSort,    " + "       Owner " + "from product.TypeCategory " + "where description   = '" + string + "' and " + "      categoryLevel = '" + string2 + "' AND " + "      valid         = 'Y' for Fetch only");
                while (resultSet.next()) {
                    typeCategoryRec = typeCategoryRec2 = new TypeCategoryRec(resultSet.getInt(1));
                    typeCategoryRec2.setDescript(resultSet.getString(2).trim());
                    typeCategoryRec2.setParentCatInd(resultSet.getInt(3));
                    typeCategoryRec2.setCategoryLevel(resultSet.getString(4).trim());
                    typeCategoryRec2.setOrderNum(resultSet.getInt(5));
                    typeCategoryRec2.setChildSort(resultSet.getString(6).trim());
                    typeCategoryRec2.setOwner(resultSet.getString(7));
                    typeCategoryRec2.updateRecStatus(0);
                    TypeCategory.addCategory(typeCategoryRec2);
                }
                resultSet.close();
            }
            catch (Exception exception) {
                if (LogSystem.getInstance() != null) {
                    LogSystem.log(1, exception, false);
                } else {
                    exception.printStackTrace();
                }
                sQLMethod.rollBack();
            }
            sQLMethod.close();
            TypeCategory.fireReadStop();
        }
        return typeCategoryRec;
    }

    public static TypeCategoryRec getCategoryFromDescription(String string, int n) {
        TypeCategoryRec typeCategoryRec = null;
        if (categories != null && categories.size() > 0) {
            int n2 = 0;
            int n3 = categories.size();
            while (n2 < n3 && typeCategoryRec == null) {
                if (((TypeCategoryRec)categories.elementAt(n2)).toString().equals(string) && !((TypeCategoryRec)categories.elementAt(n2)).getIsDraft() && ((TypeCategoryRec)categories.elementAt(n2)).valid() && ((TypeCategoryRec)categories.elementAt(n2)).getParentCatInd() == n) {
                    typeCategoryRec = (TypeCategoryRec)categories.elementAt(n2);
                }
                ++n2;
            }
        }
        if (typeCategoryRec == null) {
            SQLMethod sQLMethod = new SQLMethod(1, "TypeCategory.getCategoryFromDescription ( " + string + " )", 5);
            TypeCategory.fireReadStart("");
            try {
                TypeCategoryRec typeCategoryRec2 = null;
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = statement.executeQuery("select a.TypeCatInd,    a.Description, a.ParentCatInd, " + "       a.CategoryLevel, a.OrderNum,    a.ChildSort,    " + "       a.Owner " + "from product.TypeCategory a, " + "     product.typeCatChild b " + "where a.description  = '" + string + "' and " + "      a.typeCatInd   = b.typeCatInd and " + "      b.parentCatInd = " + n + " AND " + "      a.valid        = 'Y' for Fetch only");
                while (resultSet.next()) {
                    typeCategoryRec = typeCategoryRec2 = new TypeCategoryRec(resultSet.getInt(1));
                    typeCategoryRec2.setDescript(resultSet.getString(2).trim());
                    typeCategoryRec2.setParentCatInd(resultSet.getInt(3));
                    typeCategoryRec2.setCategoryLevel(resultSet.getString(4).trim());
                    typeCategoryRec2.setOrderNum(resultSet.getInt(5));
                    typeCategoryRec2.setChildSort(resultSet.getString(6).trim());
                    typeCategoryRec2.setOwner(resultSet.getString(7));
                    typeCategoryRec2.updateRecStatus(0);
                    TypeCategory.addCategory(typeCategoryRec2);
                }
                resultSet.close();
            }
            catch (Exception exception) {
                if (LogSystem.getInstance() != null) {
                    LogSystem.log(1, exception, false);
                } else {
                    exception.printStackTrace();
                }
                sQLMethod.rollBack();
            }
            sQLMethod.close();
            TypeCategory.fireReadStop();
        }
        return typeCategoryRec;
    }

    public static TypeCategoryRec getCategoryFromDescription(String string, String string2, int n) {
        TypeCategoryRec typeCategoryRec = null;
        if (categories != null && categories.size() > 0) {
            int n2 = 0;
            int n3 = categories.size();
            while (n2 < n3 && typeCategoryRec == null) {
                if (((TypeCategoryRec)categories.elementAt(n2)).toString().equals(string) && ((TypeCategoryRec)categories.elementAt(n2)).getCategoryLevel().equals(string2) && !((TypeCategoryRec)categories.elementAt(n2)).getIsDraft() && ((TypeCategoryRec)categories.elementAt(n2)).valid() && ((TypeCategoryRec)categories.elementAt(n2)).getParentCatInd() == n) {
                    typeCategoryRec = (TypeCategoryRec)categories.elementAt(n2);
                }
                ++n2;
            }
        }
        if (typeCategoryRec == null) {
            SQLMethod sQLMethod = new SQLMethod(1, "TypeCategory.getCategoryFromDescription ( " + string + " )", 5);
            TypeCategory.fireReadStart("");
            try {
                TypeCategoryRec typeCategoryRec2 = null;
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = statement.executeQuery("select TypeCatInd,    Description, ParentCatInd, " + "       CategoryLevel, OrderNum,    ChildSort,    " + "       Owner " + "from product.TypeCategory " + "where description   = '" + string + "' and " + "      categoryLevel = '" + string2 + "' and " + "      parentCatInd  = " + n + " and " + "      valid         = 'Y' for Fetch only");
                while (resultSet.next()) {
                    typeCategoryRec = typeCategoryRec2 = new TypeCategoryRec(resultSet.getInt(1));
                    typeCategoryRec2.setDescript(resultSet.getString(2).trim());
                    typeCategoryRec2.setParentCatInd(resultSet.getInt(3));
                    typeCategoryRec2.setCategoryLevel(resultSet.getString(4).trim());
                    typeCategoryRec2.setOrderNum(resultSet.getInt(5));
                    typeCategoryRec2.setChildSort(resultSet.getString(6).trim());
                    typeCategoryRec2.setOwner(resultSet.getString(7));
                    typeCategoryRec2.updateRecStatus(0);
                    TypeCategory.addCategory(typeCategoryRec2);
                }
                resultSet.close();
            }
            catch (Exception exception) {
                if (LogSystem.getInstance() != null) {
                    LogSystem.log(1, exception, false);
                } else {
                    exception.printStackTrace();
                }
                sQLMethod.rollBack();
            }
            sQLMethod.close();
            TypeCategory.fireReadStop();
        }
        return typeCategoryRec;
    }

    public static TypeCategoryRec getDraftCategoryFromDescription(String string, String string2, int n) {
        TypeCategoryRec typeCategoryRec = null;
        if (draftCategories != null && draftCategories.size() > 0) {
            int n2 = 0;
            int n3 = draftCategories.size();
            while (n2 < n3 && typeCategoryRec == null) {
                if (((TypeCategoryRec)draftCategories.elementAt(n2)).toString().equals(string) && ((TypeCategoryRec)draftCategories.elementAt(n2)).getCategoryLevel().equals(string2) && ((TypeCategoryRec)draftCategories.elementAt(n2)).getIsDraft() && ((TypeCategoryRec)draftCategories.elementAt(n2)).valid() && ((TypeCategoryRec)draftCategories.elementAt(n2)).getParentCatInd() == n) {
                    typeCategoryRec = (TypeCategoryRec)draftCategories.elementAt(n2);
                }
                ++n2;
            }
        }
        if (typeCategoryRec == null) {
            SQLMethod sQLMethod = new SQLMethod(1, "TypeCategory.getDraftCategoryFromDescription ( " + string + " )", 5);
            TypeCategory.fireReadStart("");
            try {
                TypeCategoryRec typeCategoryRec2 = null;
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = statement.executeQuery("select TypeCatInd,    Description, ParentCatInd, " + "       CategoryLevel, OrderNum,    ChildSort,    " + "       Owner " + "from prodraft.TypeCategory " + "where description   = '" + string + "' and " + "      categoryLevel = '" + string2 + "' and " + "      parentCatInd  = " + n + " and " + "      valid         = 'Y' for Fetch only");
                while (resultSet.next()) {
                    typeCategoryRec = typeCategoryRec2 = new TypeCategoryRec(resultSet.getInt(1));
                    typeCategoryRec2.setDescript(resultSet.getString(2).trim());
                    typeCategoryRec2.setParentCatInd(resultSet.getInt(3));
                    typeCategoryRec2.setCategoryLevel(resultSet.getString(4).trim());
                    typeCategoryRec2.setOrderNum(resultSet.getInt(5));
                    typeCategoryRec2.setChildSort(resultSet.getString(6).trim());
                    typeCategoryRec2.setOwner(resultSet.getString(7));
                    typeCategoryRec2.setIsDraft(true);
                    typeCategoryRec2.updateRecStatus(0);
                    TypeCategory.addCategory(typeCategoryRec2);
                }
                resultSet.close();
            }
            catch (Exception exception) {
                if (LogSystem.getInstance() != null) {
                    LogSystem.log(1, exception, false);
                } else {
                    exception.printStackTrace();
                }
                sQLMethod.rollBack();
            }
            sQLMethod.close();
            TypeCategory.fireReadStop();
        }
        return typeCategoryRec;
    }

    private static TypeCategoryRec readCategoryFromDatabase(int n, String string) {
        SQLMethod sQLMethod = new SQLMethod(1, "TypeCategory.readCategoryFromDatabase ( " + n + ", " + string + " )", 5);
        TypeCategoryRec typeCategoryRec = null;
        TypeCategory.fireReadStart(TypeCategory.getDescriptFromCategoryLevel(string));
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("select TypeCatInd,    Description, ParentCatInd, " + "       CategoryLevel, OrderNum,    ChildSort,    " + "       Owner " + "from product.TypeCategory " + "where typeCatInd = " + n + " and " + "      categoryLevel = '" + string + "' and " + "      valid = 'Y' for Fetch only");
            if (resultSet.next()) {
                typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
                typeCategoryRec.setDescript(resultSet.getString(2).trim());
                typeCategoryRec.setParentCatInd(resultSet.getInt(3));
                typeCategoryRec.setCategoryLevel(resultSet.getString(4).trim());
                typeCategoryRec.setOrderNum(resultSet.getInt(5));
                typeCategoryRec.setChildSort(resultSet.getString(6).trim());
                typeCategoryRec.setOwner(resultSet.getString(7));
                typeCategoryRec.updateRecStatus(0);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            typeCategoryRec = null;
            sQLMethod.rollBack();
            if (LogSystem.getInstance() != null) {
                LogSystem.log(1, exception, false);
            }
            exception.printStackTrace();
        }
        sQLMethod.close();
        TypeCategory.fireReadStop();
        return typeCategoryRec;
    }

    private static TypeCategoryRec readCategoryFromDatabase(int n) {
        SQLMethod sQLMethod = new SQLMethod(1, "TypeCategory.readCategoryFromDatabase ( " + n + " )", 5);
        TypeCategoryRec typeCategoryRec = null;
        TypeCategory.fireReadStart("" + n);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("select TypeCatInd,    Description, ParentCatInd, " + "       CategoryLevel, OrderNum,    ChildSort,    " + "       Owner " + "from product.TypeCategory " + "where typeCatInd = " + n + " and " + "      valid = 'Y' for Fetch only");
            if (resultSet.next()) {
                typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
                typeCategoryRec.setDescript(resultSet.getString(2).trim());
                typeCategoryRec.setParentCatInd(resultSet.getInt(3));
                typeCategoryRec.setCategoryLevel(resultSet.getString(4).trim());
                typeCategoryRec.setOrderNum(resultSet.getInt(5));
                typeCategoryRec.setChildSort(resultSet.getString(6).trim());
                typeCategoryRec.setOwner(resultSet.getString(7));
                typeCategoryRec.updateRecStatus(0);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            typeCategoryRec = null;
            sQLMethod.rollBack();
            if (LogSystem.getInstance() != null) {
                LogSystem.log(1, exception, false);
            }
            exception.printStackTrace();
        }
        sQLMethod.close();
        TypeCategory.fireReadStop();
        return typeCategoryRec;
    }

    private static TypeCategoryRec readCategoryFromDatabase(String string, String string2) {
        SQLMethod sQLMethod = new SQLMethod(1, "TypeCategory.readCategoryFromDatabase ( " + string + ", " + string2 + " )", 5);
        TypeCategoryRec typeCategoryRec = null;
        TypeCategory.fireReadStart(TypeCategory.getDescriptFromCategoryLevel(string2));
        try {
            Statement statement = sQLMethod.createStatement();
            if (statement != null) {
                ResultSet resultSet = statement.executeQuery("select TypeCatInd,    Description, ParentCatInd, " + "       CategoryLevel, OrderNum,    ChildSort,    " + "       Owner " + "from product.TypeCategory " + "where Description   = '" + string + "' and " + "      categoryLevel = '" + string2 + "' and " + "      valid         = 'Y' for Fetch only");
                if (resultSet.next()) {
                    typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
                    typeCategoryRec.setDescript(resultSet.getString(2).trim());
                    typeCategoryRec.setParentCatInd(resultSet.getInt(3));
                    typeCategoryRec.setCategoryLevel(resultSet.getString(4).trim());
                    typeCategoryRec.setOrderNum(resultSet.getInt(5));
                    typeCategoryRec.setChildSort(resultSet.getString(6).trim());
                    typeCategoryRec.setOwner(resultSet.getString(7));
                    typeCategoryRec.updateRecStatus(0);
                }
                resultSet.close();
            } else if (LogSystem.getInstance() != null) {
                LogSystem.log(1, "TypeCategoryRec.readCategoryFromDatabase could not establish a Statement object");
            }
        }
        catch (Exception exception) {
            typeCategoryRec = null;
            sQLMethod.rollBack();
            if (LogSystem.getInstance() != null) {
                LogSystem.log(1, exception, false);
            }
            exception.printStackTrace();
        }
        sQLMethod.close();
        TypeCategory.fireReadStop();
        return typeCategoryRec;
    }

    public static TypeCategoryRec getCategory(int n) {
        TypeCategoryRec typeCategoryRec = null;
        if (categories != null && categories.size() > 0) {
            int n2 = 0;
            int n3 = categories.size();
            while (typeCategoryRec == null && n2 < n3) {
                if (((TypeCategoryRec)categories.elementAt(n2)).getInd() == n && ((TypeCategoryRec)categories.elementAt(n2)).valid()) {
                    typeCategoryRec = (TypeCategoryRec)categories.elementAt(n2);
                }
                ++n2;
            }
        }
        if (typeCategoryRec == null) {
            typeCategoryRec = TypeCategory.readCategoryFromDatabase(n);
            TypeCategory.addCategory(typeCategoryRec);
        }
        return typeCategoryRec;
    }

    public static TypeCategoryRec getCategory(int n, String string) {
        TypeCategoryRec typeCategoryRec = null;
        if (categories != null && categories.size() > 0) {
            int n2 = 0;
            int n3 = categories.size();
            while (typeCategoryRec == null && n2 < n3) {
                if (((TypeCategoryRec)categories.elementAt(n2)).getInd() == n && ((TypeCategoryRec)categories.elementAt(n2)).valid() && ((TypeCategoryRec)categories.elementAt(n2)).getCategoryLevel().equals(string)) {
                    typeCategoryRec = (TypeCategoryRec)categories.elementAt(n2);
                }
                ++n2;
            }
        }
        if (typeCategoryRec == null) {
            typeCategoryRec = TypeCategory.readCategoryFromDatabase(n, string);
            TypeCategory.addCategory(typeCategoryRec);
        }
        return typeCategoryRec;
    }

    public static TypeCategoryRec getCategory(String string, String string2) {
        TypeCategoryRec typeCategoryRec = null;
        if (categories != null && categories.size() > 0) {
            int n = 0;
            int n2 = categories.size();
            while (typeCategoryRec == null && n < n2) {
                if (((TypeCategoryRec)categories.elementAt(n)).getDescript().equals(string) && ((TypeCategoryRec)categories.elementAt(n)).valid() && ((TypeCategoryRec)categories.elementAt(n)).getCategoryLevel().equals(string2)) {
                    typeCategoryRec = (TypeCategoryRec)categories.elementAt(n);
                }
                ++n;
            }
        }
        if (typeCategoryRec == null) {
            typeCategoryRec = TypeCategory.readCategoryFromDatabase(string, string2);
            TypeCategory.addCategory(typeCategoryRec);
        }
        return typeCategoryRec;
    }

    public static Vector getCategoryParents(TypeCategoryRec typeCategoryRec) {
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1);
        if (typeCategoryRec != null) {
            boolean bl = true;
            TypeCategoryRec typeCategoryRec2 = typeCategoryRec;
            while (bl) {
                if (typeCategoryRec2 != null) {
                    if (typeCategoryRec2.getParentCatInd() == 0) {
                        bl = false;
                        continue;
                    }
                    typeCategoryRec2 = TypeCategory.getCategory(typeCategoryRec2.getParentCatInd());
                    vector.addElement(typeCategoryRec2);
                    continue;
                }
                bl = false;
            }
        }
        return vector;
    }

    public static TypeCategoryRec getParentCategory(TypeCategoryRec typeCategoryRec, String string) {
        Vector vector = TypeCategory.getCategoryParents(typeCategoryRec);
        TypeCategoryRec typeCategoryRec2 = null;
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2 && typeCategoryRec2 == null) {
                if (((TypeCategoryRec)vector.elementAt(n)).getCategoryLevel().equals(string)) {
                    typeCategoryRec2 = (TypeCategoryRec)vector.elementAt(n);
                }
                ++n;
            }
        }
        return typeCategoryRec2;
    }

    public static Vector getCategoryParents(int n) {
        return TypeCategory.getCategoryParents(TypeCategory.getCategory(n));
    }

    private static TypeCategoryRec readDraftCategoryFromDatabase(String string, String string2) {
        SQLMethod sQLMethod = new SQLMethod(1, "TypeCategory.readDraftCategoryFromDatabase ( " + string + ", " + string2 + " )", 5);
        TypeCategoryRec typeCategoryRec = null;
        TypeCategory.fireReadStart(TypeCategory.getDescriptFromCategoryLevel(string2));
        try {
            Statement statement = sQLMethod.createStatement();
            if (statement != null) {
                ResultSet resultSet = statement.executeQuery("select TypeCatInd,    Description, ParentCatInd, " + "       CategoryLevel, OrderNum,    ChildSort,    " + "       Owner " + "from proDraft.TypeCategory " + "where Description   = '" + string + "' and " + "      categoryLevel = '" + string2 + "' and " + "      valid         = 'Y' for Fetch only");
                if (resultSet.next()) {
                    typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
                    typeCategoryRec.setDescript(resultSet.getString(2).trim());
                    typeCategoryRec.setParentCatInd(resultSet.getInt(3));
                    typeCategoryRec.setCategoryLevel(resultSet.getString(4).trim());
                    typeCategoryRec.setOrderNum(resultSet.getInt(5));
                    typeCategoryRec.setChildSort(resultSet.getString(6).trim());
                    typeCategoryRec.setOwner(resultSet.getString(7));
                    typeCategoryRec.setIsDraft(true);
                    typeCategoryRec.updateRecStatus(0);
                    TypeCategory.addCategory(typeCategoryRec);
                }
                resultSet.close();
            } else if (LogSystem.getInstance() != null) {
                LogSystem.log(1, "TypeCategoryRec.readCategoryFromDatabase could not establish a Statement object");
            }
        }
        catch (Exception exception) {
            typeCategoryRec = null;
            sQLMethod.rollBack();
            if (LogSystem.getInstance() != null) {
                LogSystem.log(1, exception, false);
            }
            exception.printStackTrace();
        }
        sQLMethod.close();
        TypeCategory.fireReadStop();
        return typeCategoryRec;
    }

    public static TypeCategoryRec getDraftCategory(int n) {
        TypeCategoryRec typeCategoryRec = null;
        if (draftCategories != null && draftCategories.size() > 0) {
            int n2 = 0;
            int n3 = draftCategories.size();
            while (typeCategoryRec == null && n2 < n3) {
                if (((TypeCategoryRec)draftCategories.elementAt(n2)).getInd() == n && ((TypeCategoryRec)draftCategories.elementAt(n2)).valid() && ((TypeCategoryRec)draftCategories.elementAt(n2)).getIsDraft()) {
                    typeCategoryRec = (TypeCategoryRec)draftCategories.elementAt(n2);
                }
                ++n2;
            }
        }
        if (typeCategoryRec == null) {
            typeCategoryRec = TypeCategory.readDraftCategoryFromDatabase(n);
            TypeCategory.addCategory(typeCategoryRec);
        }
        return typeCategoryRec;
    }

    public static TypeCategoryRec getDraftCategory(int n, String string) {
        TypeCategoryRec typeCategoryRec = null;
        if (draftCategories != null && draftCategories.size() > 0) {
            int n2 = 0;
            int n3 = draftCategories.size();
            while (typeCategoryRec == null && n2 < n3) {
                if (((TypeCategoryRec)draftCategories.elementAt(n2)).getInd() == n && ((TypeCategoryRec)draftCategories.elementAt(n2)).getIsDraft() && ((TypeCategoryRec)draftCategories.elementAt(n2)).valid() && ((TypeCategoryRec)draftCategories.elementAt(n2)).getCategoryLevel().equals(string)) {
                    typeCategoryRec = (TypeCategoryRec)draftCategories.elementAt(n2);
                }
                ++n2;
            }
        }
        if (typeCategoryRec == null) {
            typeCategoryRec = TypeCategory.readDraftCategoryFromDatabase(n, string);
            TypeCategory.addCategory(typeCategoryRec);
        }
        return typeCategoryRec;
    }

    public static TypeCategoryRec getDraftCategory(String string, String string2) {
        TypeCategoryRec typeCategoryRec = null;
        if (draftCategories != null && draftCategories.size() > 0) {
            int n = 0;
            int n2 = draftCategories.size();
            while (typeCategoryRec == null && n < n2) {
                if (((TypeCategoryRec)draftCategories.elementAt(n)).getDescript().equals(string) && ((TypeCategoryRec)draftCategories.elementAt(n)).getIsDraft() && ((TypeCategoryRec)draftCategories.elementAt(n)).valid() && ((TypeCategoryRec)draftCategories.elementAt(n)).getCategoryLevel().equals(string2)) {
                    typeCategoryRec = (TypeCategoryRec)draftCategories.elementAt(n);
                }
                ++n;
            }
        }
        if (typeCategoryRec == null) {
            typeCategoryRec = TypeCategory.readDraftCategoryFromDatabase(string, string2);
            TypeCategory.addCategory(typeCategoryRec);
        }
        return typeCategoryRec;
    }

    private static TypeCategoryRec readDraftCategoryFromDatabase(int n) {
        SQLMethod sQLMethod = new SQLMethod(1, "TypeCategory.readDraftCategoryFromDatabase ( " + n + " )", 5);
        TypeCategoryRec typeCategoryRec = null;
        TypeCategory.fireReadStart("" + n);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("select TypeCatInd,    Description, ParentCatInd, " + "       CategoryLevel, OrderNum,    ChildSort,    " + "       Owner " + "from proDraft.TypeCategory " + "where typeCatInd = " + n + " and " + "      valid = 'Y' for Fetch only");
            if (resultSet.next()) {
                typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
                typeCategoryRec.setDescript(resultSet.getString(2).trim());
                typeCategoryRec.setParentCatInd(resultSet.getInt(3));
                typeCategoryRec.setCategoryLevel(resultSet.getString(4).trim());
                typeCategoryRec.setOrderNum(resultSet.getInt(5));
                typeCategoryRec.setChildSort(resultSet.getString(6).trim());
                typeCategoryRec.setOwner(resultSet.getString(7));
                typeCategoryRec.setIsDraft(true);
                typeCategoryRec.updateRecStatus(0);
                TypeCategory.addCategory(typeCategoryRec);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            typeCategoryRec = null;
            sQLMethod.rollBack();
            if (LogSystem.getInstance() != null) {
                LogSystem.log(1, exception, false);
            }
            exception.printStackTrace();
        }
        sQLMethod.close();
        TypeCategory.fireReadStop();
        return typeCategoryRec;
    }

    private static Vector readDraftCategoriesFromDatabase(int n, String string) {
        SQLMethod sQLMethod = new SQLMethod(1, "TypeCategory.readDraftCategoriesFromDatabase ( " + n + ", " + string + " )", 5);
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1);
        TypeCategory.fireReadStart(TypeCategory.getDescriptFromCategoryLevel(string));
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("select TypeCatInd,    Description, ParentCatInd, " + "       CategoryLevel, OrderNum,    ChildSort,    " + "       Owner " + "from proDraft.TypeCategory " + "where parentCatInd  = " + n + " and " + "      categoryLevel = '" + string + "' and " + "      valid = 'Y' for Fetch only");
            while (resultSet.next()) {
                TypeCategoryRec typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
                typeCategoryRec.setDescript(resultSet.getString(2).trim());
                typeCategoryRec.setParentCatInd(resultSet.getInt(3));
                typeCategoryRec.setCategoryLevel(resultSet.getString(4).trim());
                typeCategoryRec.setOrderNum(resultSet.getInt(5));
                typeCategoryRec.setChildSort(resultSet.getString(6).trim());
                typeCategoryRec.setOwner(resultSet.getString(7));
                typeCategoryRec.updateRecStatus(0);
                vector.addElement(typeCategoryRec);
                typeCategoryRec.setIsDraft(true);
                TypeCategory.addCategory(typeCategoryRec);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            vector = null;
            sQLMethod.rollBack();
            if (LogSystem.getInstance() != null) {
                LogSystem.log(1, exception, false);
            }
            exception.printStackTrace();
        }
        sQLMethod.close();
        TypeCategory.fireReadStop();
        return vector;
    }

    private static TypeCategoryRec readDraftCategoryFromDatabase(int n, String string) {
        SQLMethod sQLMethod = new SQLMethod(1, "TypeCategory.readDraftCategoryFromDatabase ( " + n + ", " + string + " )", 5);
        TypeCategoryRec typeCategoryRec = null;
        TypeCategory.fireReadStart(TypeCategory.getDescriptFromCategoryLevel(string));
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("select TypeCatInd,    Description, ParentCatInd, " + "       CategoryLevel, OrderNum,    ChildSort,    " + "       Owner " + "from proDraft.TypeCategory " + "where typeCatInd = " + n + " and " + "      categoryLevel = '" + string + "' and " + "      valid = 'Y' for Fetch only");
            if (resultSet.next()) {
                typeCategoryRec = new TypeCategoryRec(resultSet.getInt(1));
                typeCategoryRec.setDescript(resultSet.getString(2).trim());
                typeCategoryRec.setParentCatInd(resultSet.getInt(3));
                typeCategoryRec.setCategoryLevel(resultSet.getString(4).trim());
                typeCategoryRec.setOrderNum(resultSet.getInt(5));
                typeCategoryRec.setChildSort(resultSet.getString(6).trim());
                typeCategoryRec.setOwner(resultSet.getString(7));
                typeCategoryRec.setIsDraft(true);
                typeCategoryRec.updateRecStatus(0);
                TypeCategory.addCategory(typeCategoryRec);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            typeCategoryRec = null;
            sQLMethod.rollBack();
            if (LogSystem.getInstance() != null) {
                LogSystem.log(1, exception, false);
            }
            exception.printStackTrace();
        }
        sQLMethod.close();
        TypeCategory.fireReadStop();
        return typeCategoryRec;
    }

    public static void addTypeCategoryListener(TypeCategoryListener typeCategoryListener) {
        listeners.addElement(typeCategoryListener);
    }

    public static void removeTypeCategoryListener(TypeCategoryListener typeCategoryListener) {
        listeners.removeElement(typeCategoryListener);
    }

    private static void fireReadStart(String string) {
        int n = 0;
        int n2 = listeners.size();
        while (n < n2) {
            ((TypeCategoryListener)listeners.elementAt(n)).typeCategoryReadStart(string);
            ++n;
        }
    }

    private static void fireReadStop() {
        int n = 0;
        int n2 = listeners.size();
        while (n < n2) {
            ((TypeCategoryListener)listeners.elementAt(n)).typeCategoryReadStop();
            ++n;
        }
    }

    private static void fireWriteStart() {
        int n = 0;
        int n2 = listeners.size();
        while (n < n2) {
            ((TypeCategoryListener)listeners.elementAt(n)).typeCategoryWriteStart();
            ++n;
        }
    }

    private static void fireWriteStop() {
        int n = 0;
        int n2 = listeners.size();
        while (n < n2) {
            ((TypeCategoryListener)listeners.elementAt(n)).typeCategoryWriteStop();
            ++n;
        }
    }

    public static String getDescriptFromCategoryLevel(String string) {
        if (string.equals(LEVEL_BRAND)) {
            return "Brand";
        }
        if (string.equals(LEVEL_FAMILY)) {
            return "Family";
        }
        if (string.equals(LEVEL_MACHINE)) {
            return "Machine";
        }
        if (string.equals(LEVEL_MODEL)) {
            return "Model";
        }
        if (string.equals(LEVEL_PARTNUMBER)) {
            return "Part Number";
        }
        if (string.equals(LEVEL_OPICM_BRAND)) {
            return "OPIC/M Brand";
        }
        if (string.equals(LEVEL_OPICM_FAMILY)) {
            return "OPIC/M Family";
        }
        if (string.equals(LEVEL_OPICM_SERIES)) {
            return "OPIC/M Series";
        }
        if (string.equals(LEVEL_OPICM_COUNTRY)) {
            return "OPIC/M Country";
        }
        if (string.equals(LEVEL_OPICM_GEOGRAPHY)) {
            return "OPIC/M Geography";
        }
        if (string.equals(LEVEL_DOC_CATEGORY)) {
            return "Document Category";
        }
        if (string.equals(LEVEL_PROJECT)) {
            return "Project";
        }
        if (string.equals(LEVEL_SUBCATEGORY)) {
            return "Sub Category";
        }
        return "Unknown";
    }

    private static void addCategory(TypeCategoryRec typeCategoryRec) {
        try {
            if (typeCategoryRec != null) {
                boolean bl = true;
                if (categories == null) {
                    categories = new Vector(1);
                }
                if (draftCategories == null) {
                    draftCategories = new Vector(1);
                }
                if (!(bl = typeCategoryRec.getIsDraft() ? draftCategories.contains(typeCategoryRec) : categories.contains(typeCategoryRec)) && (typeCategoryRec.getCategoryLevel().equals(LEVEL_FAMILY) || typeCategoryRec.getCategoryLevel().equals(LEVEL_BRAND) || typeCategoryRec.getCategoryLevel().equals(LEVEL_OPICM_BRAND) || typeCategoryRec.getCategoryLevel().equals(LEVEL_OPICM_FAMILY) || typeCategoryRec.getCategoryLevel().equals(LEVEL_OPICM_COUNTRY) || typeCategoryRec.getCategoryLevel().equals(LEVEL_OPICM_GEOGRAPHY) || typeCategoryRec.getCategoryLevel().equals(LEVEL_OPICM_SERIES) || typeCategoryRec.getCategoryLevel().equals(LEVEL_PROJECT) || typeCategoryRec.getCategoryLevel().equals(LEVEL_SUBCATEGORY) || typeCategoryRec.getCategoryLevel().equals(LEVEL_DOC_CATEGORY))) {
                    if (typeCategoryRec.getIsDraft()) {
                        draftCategories.addElement(typeCategoryRec);
                    } else {
                        categories.addElement(typeCategoryRec);
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    public static TypeCategoryRec getDraftCategoryFromCategory(TypeCategoryRec typeCategoryRec) {
        TypeCategoryRec typeCategoryRec2 = TypeCategory.getDraftCategoryFromDescription(typeCategoryRec.toString(), typeCategoryRec.getCategoryLevel(), typeCategoryRec.getParentCatInd());
        if (typeCategoryRec2 == null) {
            typeCategoryRec2 = TypeCategory.createDraftTypeCategory(typeCategoryRec.getParentCatInd(), typeCategoryRec.toString(), typeCategoryRec.getCategoryLevel(), typeCategoryRec.getOrderNum(), typeCategoryRec.getChildSort(), typeCategoryRec.getOwner());
            TypeCategory.addCategory(typeCategoryRec2);
            TypeCategory.writeToDatabase();
        }
        return typeCategoryRec2;
    }

    public static Vector getDraftCategoryParents(TypeCategoryRec typeCategoryRec) {
        Vector<TypeCategoryRec> vector = new Vector<TypeCategoryRec>(1);
        if (typeCategoryRec != null) {
            boolean bl = true;
            TypeCategoryRec typeCategoryRec2 = typeCategoryRec;
            while (bl) {
                if (typeCategoryRec2 != null) {
                    if (typeCategoryRec2.getParentCatInd() == 0) {
                        bl = false;
                        continue;
                    }
                    typeCategoryRec2 = TypeCategory.getDraftCategory(typeCategoryRec2.getParentCatInd());
                    vector.addElement(typeCategoryRec2);
                    continue;
                }
                bl = false;
            }
        }
        return vector;
    }

    public static Vector getDraftCategoryParents(int n) {
        return TypeCategory.getDraftCategoryParents(TypeCategory.getCategory(n));
    }

    public TypeCategory() {
    }

    public TypeCategory(String string) {
        TypeCategory.setCache(true);
        TypeCategory.setCacheDirectory(string);
    }
}

