/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.type;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.type.TypeCategory;
import com.ibm.nzna.projects.common.quest.type.TypeRec;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.shared.sort.IQuickSort;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.util.Vector;

public class TypeCategoryRec
extends TypeRec
implements IQuickSort {
    static final long serialVersionUID = 1000000L;
    private String categoryLevel = null;
    private int parentCatInd = 0;
    private int orderNum = 0;
    private String childSort = "N";
    private String owner = null;
    private boolean valid = true;
    private boolean isDraft = false;
    private boolean parentUpdated = false;

    public String getCategoryLevel() {
        return this.categoryLevel;
    }

    public int getParentCatInd() {
        return this.parentCatInd;
    }

    public String getOwner() {
        return this.owner;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOwner(String string) throws IllegalArgumentException {
        if (string != null) {
            if ((string = string.trim()).length() > 12) throw new IllegalArgumentException("Owner cannot be " + string.length() + " characters " + "long. Max is 12");
            this.updateRecStatus(1);
            this.owner = string.trim();
            return;
        } else {
            this.updateRecStatus(1);
            this.owner = null;
        }
    }

    public void setParentCatInd(int n) {
        if (this.parentCatInd != n) {
            this.parentCatInd = n;
            this.updateRecStatus(1);
            this.parentUpdated = true;
        }
    }

    public void setCategoryLevel(String string) throws IllegalArgumentException {
        if (string == null || string.length() >= 15) {
            throw new IllegalArgumentException("Category Level cannot " + "be NULL and Max length is 12");
        }
        this.categoryLevel = string;
        this.updateRecStatus(1);
    }

    public int getOrderNum() {
        return this.orderNum;
    }

    public void setOrderNum(int n) {
        if (this.orderNum != n) {
            this.orderNum = n;
            this.updateRecStatus(1);
        }
    }

    public String getChildSort() {
        return this.childSort;
    }

    public void setChildSort(String string) throws IllegalArgumentException {
        if (string != null) {
            string = string.trim();
        }
        if (string == null || !string.equals("Y") && !string.equals("N")) {
            throw new IllegalArgumentException("The childSort property MUST be" + "either 'Y' or 'N'");
        }
        this.childSort = string;
        this.updateRecStatus(1);
    }

    public String toSQL() {
        String string = "";
        if (this.getIsDraft()) {
            return this.toDraftSQL();
        }
        Vector vector = TypeCategory.getCategoryParents(this);
        switch (this.getRecStatus()) {
            case 2: {
                this.generateKeys();
                string = "insert into product.TypeCategory " + "( typeCatInd,    description, parentCatInd, " + "  categoryLevel, orderNum,    childSort, " + "  owner, valid ) " + "values ( " + " " + this.getInd() + ", " + " '" + Text.cleanDBString(this.toString()) + "', " + " " + this.parentCatInd + ", " + " '" + this.categoryLevel + "', " + "  " + this.orderNum + ", " + " '" + this.childSort + "', " + "  " + Text.cleanNullableDBString(this.owner) + ", " + " '" + Text.getYN(this.valid) + "' )" + SqlRunner.END_DELIM;
                if (vector == null || vector.size() <= 0) break;
                int n = 0;
                int n2 = vector.size();
                TypeCategoryRec typeCategoryRec = null;
                while (n < n2) {
                    typeCategoryRec = (TypeCategoryRec)vector.elementAt(n);
                    if (typeCategoryRec != null) {
                        string = string + "insert into product.typeCatChild values ( " + typeCategoryRec.getInd() + ", " + this.getInd() + " )" + SqlRunner.END_DELIM;
                    }
                    ++n;
                }
                break;
            }
            case 1: {
                string = "update product.TypeCategory " + "set categoryLevel = '" + this.categoryLevel + "', " + "    description   = '" + Text.cleanDBString(this.toString()) + "', " + "    parentCatInd  = " + this.parentCatInd + ", " + "    orderNum      = " + this.orderNum + ", " + "    childSort     = '" + this.childSort + "', " + "    owner         = " + Text.cleanNullableDBString(this.owner) + ", " + "    valid         = '" + Text.getYN(this.valid) + "' " + "where typeCatInd = " + this.getInd() + SqlRunner.END_DELIM;
                if (!this.parentUpdated) break;
                string = string + "delete from product.typeCatChild where typeCatInd = " + this.getInd() + SqlRunner.END_DELIM;
                if (vector == null || vector.size() <= 0) break;
                int n = 0;
                int n3 = vector.size();
                TypeCategoryRec typeCategoryRec = null;
                while (n < n3) {
                    typeCategoryRec = (TypeCategoryRec)vector.elementAt(n);
                    if (typeCategoryRec != null) {
                        string = string + "insert into product.typeCatChild values ( " + typeCategoryRec.getInd() + ", " + this.getInd() + " )" + SqlRunner.END_DELIM;
                    }
                    ++n;
                }
                break;
            }
            case 3: {
                string = "delete from product.category where typeCatInd = " + this.getInd() + SqlRunner.END_DELIM + "delete from prodraft.category where typeCatInd = " + this.getInd() + SqlRunner.END_DELIM + "delete from tigris.category where typeCatInd = " + this.getInd() + SqlRunner.END_DELIM + "delete from quest.category where typeCatInd = " + this.getInd() + SqlRunner.END_DELIM + "delete from product.TypeCatChild where parentCatInd = " + this.getInd() + SqlRunner.END_DELIM + "delete from product.TypeCatChild where typeCatInd = " + this.getInd() + SqlRunner.END_DELIM + "delete from product.TypeCategory where TypeCatInd = " + this.getInd() + SqlRunner.END_DELIM;
                break;
            }
        }
        this.parentUpdated = false;
        return string;
    }

    public String toDraftSQL() {
        String string = "";
        Vector vector = TypeCategory.getDraftCategoryParents(this);
        switch (this.getRecStatus()) {
            case 2: {
                this.generateKeys();
                string = "insert into proDraft.TypeCategory " + "( typeCatInd,    description, parentCatInd, " + "  categoryLevel, orderNum,    childSort, " + "  owner, valid ) " + "values ( " + " " + this.getInd() + ", " + " '" + Text.cleanDBString(this.toString()) + "', " + " " + this.parentCatInd + ", " + " '" + this.categoryLevel + "', " + "  " + this.orderNum + ", " + " '" + this.childSort + "', " + "  " + Text.cleanNullableDBString(this.owner) + ", " + " '" + Text.getYN(this.valid) + "' )" + SqlRunner.END_DELIM;
                if (vector == null || vector.size() <= 0) break;
                int n = 0;
                int n2 = vector.size();
                TypeCategoryRec typeCategoryRec = null;
                while (n < n2) {
                    typeCategoryRec = (TypeCategoryRec)vector.elementAt(n);
                    if (typeCategoryRec != null) {
                        string = string + "insert into proDraft.typeCatChild values ( " + typeCategoryRec.getInd() + ", " + this.getInd() + " )" + SqlRunner.END_DELIM;
                    }
                    ++n;
                }
                break;
            }
            case 1: {
                string = "update proDraft.TypeCategory " + "set categoryLevel = '" + this.categoryLevel + "', " + "    description   = '" + Text.cleanDBString(this.toString()) + "', " + "    parentCatInd  = " + this.parentCatInd + ", " + "    orderNum      = " + this.orderNum + ", " + "    childSort     = '" + this.childSort + "', " + "    owner         = " + Text.cleanNullableDBString(this.owner) + ", " + "    valid         = '" + Text.getYN(this.valid) + "' " + "where typeCatInd = " + this.getInd() + SqlRunner.END_DELIM;
                if (!this.parentUpdated) break;
                string = string + "delete from proDraft.typeCatChild where typeCatInd = " + this.getInd() + SqlRunner.END_DELIM;
                if (vector == null || vector.size() <= 0) break;
                int n = 0;
                int n3 = vector.size();
                TypeCategoryRec typeCategoryRec = null;
                while (n < n3) {
                    typeCategoryRec = (TypeCategoryRec)vector.elementAt(n);
                    if (typeCategoryRec != null) {
                        string = string + "insert into prodraft.typeCatChild values ( " + typeCategoryRec.getInd() + ", " + this.getInd() + " )" + SqlRunner.END_DELIM;
                    }
                    ++n;
                }
                break;
            }
            case 3: {
                string = "delete from proDraft.TypeCatChild where parentInd = " + this.getInd() + SqlRunner.END_DELIM + "delete from proDraft.TypeCategory where TypeCatInd = " + this.getInd() + SqlRunner.END_DELIM;
                break;
            }
        }
        this.updateRecStatus(0);
        return string;
    }

    protected boolean generateKeys() {
        if (super.getInd() == 0) {
            this.setInd(Counter.getCounter(LogSystem.getInstance(), "TYPECATIND"));
        }
        return super.getInd() != 0;
    }

    public void setValid(boolean bl) {
        this.valid = bl;
    }

    public boolean getValid() {
        return this.valid;
    }

    public int getInd() {
        if (super.getInd() == 0) {
            this.generateKeys();
        }
        return super.getInd();
    }

    public boolean getIsDraft() {
        return this.isDraft;
    }

    public void setIsDraft(boolean bl) {
        this.isDraft = bl;
    }

    public int compareTo(IQuickSort iQuickSort) {
        int n = 0;
        if (iQuickSort instanceof TypeCategoryRec) {
            TypeCategoryRec typeCategoryRec = (TypeCategoryRec)iQuickSort;
            n = this.orderNum == 0 ? ((n = this.toString().compareTo(typeCategoryRec.toString())) < 0 ? -1 : (n > 0 ? 1 : 0)) : (this.orderNum > typeCategoryRec.orderNum ? 1 : (this.orderNum < typeCategoryRec.orderNum ? -1 : 0));
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = object == this;
        if (object instanceof TypeCategoryRec) {
            bl = ((TypeCategoryRec)object).getInd() == this.getInd();
        }
        return bl;
    }

    public Object clone() {
        TypeCategoryRec typeCategoryRec = new TypeCategoryRec(this.getInd());
        typeCategoryRec.setDescript(this.getDescript());
        typeCategoryRec.setCategoryLevel(this.getCategoryLevel());
        typeCategoryRec.setParentCatInd(this.getParentCatInd());
        typeCategoryRec.setOrderNum(this.getOrderNum());
        typeCategoryRec.setChildSort(this.getChildSort());
        typeCategoryRec.setOwner(this.getOwner());
        typeCategoryRec.setValid(this.getValid());
        return typeCategoryRec;
    }

    public int writeToDatabase() {
        int n = 0;
        n = this.getIsDraft() ? SqlRunner.sqlRunnerCode(1, this.toDraftSQL()) : SqlRunner.sqlRunnerCode(1, this.toSQL());
        if (n == 0) {
            this.updateRecStatus(0);
        }
        return n;
    }

    public TypeCategoryRec(int n) {
        super(n);
    }

    public TypeCategoryRec(String string, String string2) {
        this.updateRecStatus(2);
        this.setDescript(string);
        this.setCategoryLevel(string2);
    }

    public TypeCategoryRec() {
        this.updateRecStatus(2);
    }
}

