/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.type;

import com.ibm.nzna.projects.common.quest.type.TypeListListener;
import com.ibm.nzna.projects.common.quest.type.TypeListRec;
import com.ibm.nzna.projects.common.quest.type.TypeListRefresher;
import com.ibm.nzna.projects.common.quest.type.TypeListStatusListener;
import com.ibm.nzna.projects.common.quest.type.TypeRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.projects.common.storedProc.typeListReader.TypeListReaderRec;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Choice;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JList;

public class TypeList
implements Serializable {
    public static final int TYPE_AUTH = 1;
    public static final int TYPE_COUNTRYCODE = 3;
    public static final int TYPE_DOC = 4;
    public static final int TYPE_DOCCLASS = 5;
    public static final int TYPE_GEOGRAPHY = 6;
    public static final int TYPE_LANGUAGE = 8;
    public static final int TYPE_TEAM = 9;
    public static final int TYPE_DOCCAT = 10;
    public static final int TYPE_METRIC = 11;
    public static final int TYPE_PROPERTIES = 12;
    public static final int TYPE_PUB = 13;
    public static final int TYPE_WORKREQUIRED = 14;
    public static final int TYPE_STATUS = 15;
    public static final int TYPE_RESOLUTION = 16;
    public static final int TYPE_ACTION = 17;
    public static final int TYPE_QUESTION = 18;
    public static final int TYPE_SYMPTOM = 19;
    public static final int TYPE_OABRAND = 20;
    public static final int TYPE_LINK = 21;
    public static final int TYPE_CUSTOMVIEW = 22;
    public static final int TYPE_PRODUCT = 23;
    public static final int TYPE_OFFERING = 24;
    public static final int TYPE_CUSTOMER = 25;
    public static final int TYPE_WARRANTY = 26;
    public static final int TYPE_DATE = 27;
    public static final int TYPE_CANCEL = 28;
    public static final int MAX_TYPE_LIST = 29;
    public static final int WORKREQ_NOTAPPLICABLE = 0;
    public static final int WORKREQ_CREATE = 1;
    public static final int WORKREQ_EDIT = 2;
    public static final int WORKREQ_DELETE = 3;
    public static final int DOCCLASS_IBM_CONFIDENTIAL = 1;
    public static final int DOCCLASS_DEALER_CONFIDENTIAL = 2;
    public static final int DOCCLASS_UNCLASSIFIED = 3;
    public static final int LANGUAGE_ENGLISH = 1;
    public static final int LANGUAGE_GERMAN = 2;
    public static final int LANGUAGE_SPANISH = 3;
    public static final int LANGUAGE_FRENCH = 4;
    public static final int LANGUAGE_PORTUGESE = 5;
    public static final int LANGUAGE_ITALIAN = 6;
    public static final int GEO_WORLD_WIDE = 6;
    public static final int COUNTRY_WORLD_WIDE = 124;
    public static final int DOCTYPE_PARTS_INFO = 2;
    public static final int DOCTYPE_PRODUCT_INFO = 3;
    public static final int DOCTYPE_SERVICE_HINTS_TIPS = 4;
    public static final int DOCTYPE_SSD = 9;
    public static final int DOCTYPE_SERVICE_PUB = 8;
    public static final int DOCTYPE_PRELOAD = 10;
    public static final int PUBLICATIONTYPE_NOTAPPLICABLE = 0;
    public static final int PUBLICATIONTYPE_FUNCTIONALSPECS = 1;
    public static final int PUBLICATIONTYPE_HARDWAREMANUAL = 2;
    public static final int PUBLICATIONTYPE_USERMANUAL = 3;
    public static final int DATE_WITHDRAWN = 1;
    public static final int DATE_ANNOUNCED = 2;
    public static final int DATE_DELETED_FROM_XREF = 3;
    public static final int DATE_PRE_ANNOUNCED = 4;
    public static final int DATE_GA_AVAILABLE = 5;
    public static final int DATE_END_OF_SERVICE = 6;
    public static final int DATE_END_OF_MANUFACT = 7;
    public static final int DATE_END_OF_MARKET = 8;
    public static final int DATE_END_OF_PRODUCTION = 9;
    public static final int DATE_SHIP_SUPPORTED = 10;
    public static final int DATE_FIRST_ORDER = 11;
    public static final int OFFERING_DEFAULT = 0;
    public static final int OFFERING_CTO = 1;
    public static final int PRODUCTTYPE_SYSTEM = 1;
    public static final int PRODUCTTYPE_OPTION = 2;
    public static final int PRODUCTTYPE_MONITOR = 3;
    public static boolean cacheEnabled = false;
    public static TypeList instance = null;
    public static int languageInd = 1;
    public static Vector statusListenerVec = null;
    private Vector typeLists = null;
    public String cacheDir = "";

    public void initialize(boolean bl) {
        cacheEnabled = bl;
        this.initializeTypeList();
    }

    public void setInstance(TypeList typeList) {
        instance = typeList;
    }

    private final void initializeTypeList() {
        this.typeLists = new Vector(29, 1);
        this.initializeTypeList(1);
        this.initializeTypeList(3);
        this.initializeTypeList(4);
        this.initializeTypeList(5);
        this.initializeTypeList(6);
        this.initializeTypeList(8);
        this.initializeTypeList(9);
        this.initializeTypeList(10);
        this.initializeTypeList(11);
        this.initializeTypeList(12);
        this.initializeTypeList(13);
        this.initializeTypeList(14);
        this.initializeTypeList(15);
        this.initializeTypeList(16);
        this.initializeTypeList(17);
        this.initializeTypeList(18);
        this.initializeTypeList(19);
        this.initializeTypeList(20);
        this.initializeTypeList(21);
        this.initializeTypeList(22);
        this.initializeTypeList(27);
        this.initializeTypeList(23);
        this.initializeTypeList(24);
        this.initializeTypeList(25);
        this.initializeTypeList(26);
        this.initializeTypeList(28);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void initializeTypeList(int n) {
        TypeListRec typeListRec;
        block5: {
            typeListRec = null;
            String string = null;
            try {
                if (!cacheEnabled) break block5;
                typeListRec = (TypeListRec)FileUtil.readObjectFromDisk(this.getCacheDir() + "TypeList_" + n + ".cache");
                string = (String)FileUtil.readObjectFromDisk(this.getCacheDir() + "TypeList_" + n + "_CacheTime.cache");
                if (typeListRec != null && TypeList.hasTypeListChanged(n, string)) {
                    typeListRec = null;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (typeListRec == null) {
            typeListRec = new TypeListRec(n);
        }
        this.typeLists.addElement(typeListRec);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean hasTypeListChanged(int n, String string) {
        String string2 = TypeList.getTableName(n);
        SQLMethod sQLMethod = new SQLMethod(1, "hasTypeListChanged", 5);
        boolean bl = false;
        if (string2 != null && string2.length() > 0) {
            try {
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT changedtime FROM " + string2 + " where changedtime > '" + string + "' FETCH FIRST 1 ROWS ONLY");
                bl = resultSet.next();
                resultSet.close();
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                exception.printStackTrace();
                bl = false;
            }
        } else {
            bl = true;
        }
        sQLMethod.close();
        return bl;
    }

    private static final String getTableName(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "TIGRIS.TYPEAUTH";
                break;
            }
            case 3: {
                string = "TIGRIS.TYPECOUNTRYCODE";
                break;
            }
            case 4: {
                string = "TIGRIS.TYPEDOCUMENT";
                break;
            }
            case 5: {
                string = "TIGRIS.TYPEDOCCLASS";
                break;
            }
            case 6: {
                string = "TIGRIS.TYPEGEOGRAPHY";
                break;
            }
            case 8: {
                string = "TIGRIS.TYPELANGUAGE";
                break;
            }
            case 9: {
                string = "TIGRIS.USERGROUP";
                break;
            }
            case 10: {
                string = "TIGRIS.TYPEDOCCAT";
                break;
            }
            case 11: {
                string = "TIGRIS.TYPEMETRIC";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                string = "TIGRIS.TYPEPUBLICATION";
                break;
            }
            case 14: {
                string = "TIGRIS.TYPEWORKREQUIRED";
                break;
            }
            case 15: {
                string = "TIGRIS.TYPESTATUS";
                break;
            }
            case 16: {
                string = "QUEST.TYPERESOLUTION";
                break;
            }
            case 17: {
                string = "OA.TYPEACTION";
                break;
            }
            case 18: {
                string = "OA.TYPEQUESTION";
                break;
            }
            case 19: {
                string = "OA.TYPESYMPTOM";
                break;
            }
            case 20: {
                string = "OA.TYPEBRAND";
                break;
            }
            case 21: {
                string = "OA.TYPELINK";
                break;
            }
            case 22: {
                string = "QIT.TYPECUSTOMVIEW";
                break;
            }
        }
        return string;
    }

    protected final TypeListRec typeListRecFromInd(int n) {
        TypeListRec typeListRec = null;
        if (this.typeLists != null) {
            int n2 = 0;
            int n3 = this.typeLists.size();
            TypeListRec typeListRec2 = null;
            while (typeListRec == null && n2 < n3) {
                typeListRec2 = (TypeListRec)this.typeLists.elementAt(n2);
                if (typeListRec2.getTypeListInd() == n) {
                    typeListRec = typeListRec2;
                }
                ++n2;
            }
        }
        return typeListRec;
    }

    public Vector getTypeListVec() {
        return this.typeLists;
    }

    public static TypeList getInstance() {
        if (instance == null) {
            instance = new TypeList();
        }
        return instance;
    }

    public Vector getTypeList(int n) {
        TypeListRec typeListRec = this.typeListRecFromInd(n);
        if (this.validateTypeList(typeListRec)) {
            return typeListRec.getTypeListVec();
        }
        return null;
    }

    public String stringFromInd(int n, int n2) {
        Vector vector = this.getTypeList(n2);
        String string = "";
        TypeRec typeRec = null;
        if (vector != null) {
            int n3 = vector.size();
            int n4 = 0;
            boolean bl = false;
            while (n4 < n3 && !bl) {
                typeRec = (TypeRec)vector.elementAt(n4);
                if (typeRec != null) {
                    bl = typeRec.isInd(n);
                }
                ++n4;
            }
            if (bl) {
                string = typeRec.toString();
            }
        }
        return string;
    }

    public int indFromString(String string, int n) {
        Vector vector = this.getTypeList(n);
        int n2 = 0;
        TypeRec typeRec = null;
        boolean bl = false;
        if (vector != null) {
            int n3 = vector.size();
            int n4 = 0;
            boolean bl2 = false;
            while (n4 < n3 && !bl2) {
                typeRec = (TypeRec)vector.elementAt(n4);
                if (typeRec != null) {
                    bl2 = typeRec.toString().equals(string);
                }
                ++n4;
            }
            if (bl2) {
                n2 = typeRec.getInd();
            }
        }
        return n2;
    }

    public Object objectFromInd(int n, int n2) {
        Vector vector = this.getTypeList(n2);
        TypeRec typeRec = null;
        TypeRec typeRec2 = null;
        if (vector != null) {
            int n3 = vector.size();
            int n4 = 0;
            boolean bl = false;
            while (n4 < n3 && !bl) {
                if (vector.elementAt(n4) instanceof TypeRec) {
                    typeRec2 = (TypeRec)vector.elementAt(n4);
                    if (typeRec2 != null) {
                        bl = typeRec2.isInd(n);
                    }
                } else if (vector.elementAt(n4) instanceof String) {
                    System.err.println("Error. TypeList of: " + n2 + " has a Vector of Strings! These records were expected to be TypeRecs.");
                } else {
                    System.err.println("Error. TypeList of: " + n2 + " has a Vector of non-TypeRecs.");
                }
                ++n4;
            }
            if (bl) {
                typeRec = typeRec2;
            }
        }
        return typeRec;
    }

    public Object objectFromString(String string, int n) {
        Vector vector = this.getTypeList(n);
        TypeRec typeRec = null;
        TypeRec typeRec2 = null;
        if (vector != null) {
            int n2 = vector.size();
            int n3 = 0;
            boolean bl = false;
            while (n3 < n2 && !bl) {
                typeRec2 = (TypeRec)vector.elementAt(n3);
                if (typeRec2 != null) {
                    bl = typeRec2.toString().equals(string);
                }
                ++n3;
            }
            if (bl) {
                typeRec = typeRec2;
            }
        }
        return typeRec;
    }

    public static void addToList(TypeRec typeRec, int n) {
        TypeList.getInstance().typeListRecFromInd(n).addToList(typeRec);
        TypeList.getInstance().setTypeList(n, TypeList.getInstance().getTypeList(n));
    }

    public static void removeFromList(TypeRec typeRec, int n) {
        TypeList.getInstance().typeListRecFromInd(n).removeFromList(typeRec);
        TypeList.getInstance().setTypeList(n, TypeList.getInstance().getTypeList(n));
    }

    public static void replaceList(Vector vector, int n) {
        TypeList.getInstance().typeListRecFromInd(n).setTypeList(vector);
    }

    public static void removeAll() {
        int n = 0;
        int n2 = TypeList.getInstance().typeLists.size();
        while (n < n2) {
            ((TypeListRec)TypeList.getInstance().typeLists.elementAt(n++)).removeAll();
        }
        ++n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean readStartupLists(int n) {
        boolean bl = false;
        if (cacheEnabled) {
            if (!TypeList.getInstance().typeListRecFromInd(6).isValid()) {
                TypeList.getInstance().getTypeList(6);
            }
            if (!TypeList.getInstance().typeListRecFromInd(3).isValid()) {
                TypeList.getInstance().getTypeList(3);
            }
            if (!TypeList.getInstance().typeListRecFromInd(4).isValid()) {
                TypeList.getInstance().getTypeList(4);
            }
            if (!TypeList.getInstance().typeListRecFromInd(5).isValid()) {
                TypeList.getInstance().getTypeList(5);
            }
            if (!TypeList.getInstance().typeListRecFromInd(22).isValid()) {
                TypeList.getInstance().getTypeList(22);
            }
            if (!TypeList.getInstance().typeListRecFromInd(1).isValid()) {
                TypeList.getInstance().getTypeList(1);
            }
            if (!TypeList.getInstance().typeListRecFromInd(14).isValid()) {
                TypeList.getInstance().getTypeList(14);
            }
            if (!TypeList.getInstance().typeListRecFromInd(11).isValid()) {
                TypeList.getInstance().getTypeList(11);
            }
            if (TypeList.getInstance().typeListRecFromInd(8).isValid()) return true;
            TypeList.getInstance().getTypeList(8);
            return true;
        }
        SQLMethod sQLMethod = new SQLMethod(1, "TypeList.readStartupLists", 5);
        CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.TypeListReader", 4);
        TypeListReaderRec typeListReaderRec = null;
        try {
            callableStatement.setInt(1, n);
            callableStatement.setInt(2, -1);
            callableStatement.registerOutParameter(3, -4);
            callableStatement.registerOutParameter(4, -4);
            callableStatement.execute();
            StoredProcRec storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 4);
            if (storedProcRec != null && storedProcRec.error) {
                LogSystem.log(1, storedProcRec.errorStr);
            } else {
                typeListReaderRec = (TypeListReaderRec)StoredProcUtil.getObjectFromStatement(callableStatement, 3);
                TypeList.getInstance().setTypeList(6, typeListReaderRec.geographyVec);
                TypeList.getInstance().setTypeList(3, typeListReaderRec.countryCodeVec);
                TypeList.getInstance().setTypeList(4, typeListReaderRec.docTypeVec);
                TypeList.getInstance().setTypeList(5, typeListReaderRec.docClassVec);
                TypeList.getInstance().setTypeList(22, typeListReaderRec.customViewVec);
                TypeList.getInstance().setTypeList(1, typeListReaderRec.authVec);
                TypeList.getInstance().setTypeList(14, typeListReaderRec.workVec);
                TypeList.getInstance().setTypeList(11, typeListReaderRec.metricVec);
                TypeList.getInstance().setTypeList(8, typeListReaderRec.languageVec);
                bl = true;
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        return bl;
    }

    public static void addStatusListener(TypeListStatusListener typeListStatusListener) {
        if (statusListenerVec == null) {
            statusListenerVec = new Vector(1, 1);
        }
        statusListenerVec.addElement(typeListStatusListener);
    }

    private static final void fireStatusBeginEvent(String string) {
        if (statusListenerVec != null) {
            int n = 0;
            int n2 = statusListenerVec.size();
            while (n < n2) {
                ((TypeListStatusListener)statusListenerVec.elementAt(n)).typeListStatusChangeBegin(string);
                ++n;
            }
        }
    }

    private static final void fireStatusEndEvent() {
        if (statusListenerVec != null) {
            int n = 0;
            int n2 = statusListenerVec.size();
            while (n < n2) {
                ((TypeListStatusListener)statusListenerVec.elementAt(n)).typeListStatusChangeEnd();
                ++n;
            }
        }
    }

    public static void removeStatusListener(TypeListStatusListener typeListStatusListener) {
        if (statusListenerVec != null) {
            statusListenerVec.removeElement(typeListStatusListener);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateTypeList(TypeListRec typeListRec) {
        boolean bl = false;
        if (typeListRec == null) {
            System.out.println("Cannot validate NULL TypeListRec");
            return bl;
        }
        try {
            if (typeListRec.isValid()) return typeListRec.isValid();
            TypeList.readTypeList(typeListRec);
            return typeListRec.isValid();
        }
        catch (Exception exception) {
            LogSystem.log(1, "Exception Validating Type List");
            LogSystem.log(1, exception, false);
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void readTypeList(TypeListRec typeListRec) {
        boolean bl = false;
        SQLMethod sQLMethod = new SQLMethod(1, "TypeList.readTypeList ( " + typeListRec + ") ", 5);
        CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.TypeListReader", 4);
        TypeListReaderRec typeListReaderRec = null;
        TypeList.fireStatusBeginEvent("Reading Type List " + typeListRec.toString());
        try {
            callableStatement.setInt(1, languageInd);
            callableStatement.setInt(2, typeListRec.getTypeListInd());
            callableStatement.registerOutParameter(3, -4);
            callableStatement.registerOutParameter(4, -4);
            callableStatement.execute();
            StoredProcRec storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 4);
            if (storedProcRec != null && storedProcRec.error) {
                LogSystem.log(1, storedProcRec.errorStr);
            } else {
                typeListReaderRec = (TypeListReaderRec)StoredProcUtil.getObjectFromStatement(callableStatement, 3);
                TypeList.getInstance().setTypeList(typeListRec.getTypeListInd(), typeListReaderRec.retVec);
                bl = true;
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        TypeList.fireStatusEndEvent();
    }

    public void setCacheDir(String string) {
        this.cacheDir = string == null ? "" : string;
    }

    public static void setLanguage(int n) {
        languageInd = n;
    }

    public static void refreshList(Choice choice, int n, TypeListListener typeListListener) {
        new TypeListRefresher(choice, n, typeListListener);
    }

    public static void refreshList(MultiList multiList, int n, TypeListListener typeListListener) {
        new TypeListRefresher(multiList, n, typeListListener);
    }

    public static void refreshList(JList jList, int n, TypeListListener typeListListener) {
        new TypeListRefresher(jList, n, typeListListener);
    }

    public static void refreshList(JComboBox jComboBox, int n, TypeListListener typeListListener) {
        new TypeListRefresher(jComboBox, n, typeListListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void setTypeList(int n, Vector vector) {
        TypeListRec typeListRec = TypeList.getInstance().typeListRecFromInd(n);
        typeListRec.setTypeList(vector);
        if (!cacheEnabled) return;
        try {
            FileUtil.writeObjectToDisk(this.getCacheDir() + "TypeList_" + n + ".cache", typeListRec);
            FileUtil.writeObjectToDisk(this.getCacheDir() + "TypeList_" + n + "_CacheTime.cache", new CDate(1).today());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getCacheDir() {
        if (this.cacheDir == null || this.cacheDir.length() == 0) {
            return "";
        }
        return this.cacheDir + File.separator;
    }

    public TypeList() {
        if (instance == null) {
            instance = this;
        }
    }
}

