/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.quest.type;

import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.quest.type.TypeListListener;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Choice;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JList;

class TypeListRefresher
implements Runnable {
    private Component c = null;
    private int listType = 0;
    private TypeListListener listener = null;

    public void run() {
        if (this.c instanceof JComboBox) {
            TypeListRefresher.refreshList((JComboBox)this.c, this.listType);
        } else if (this.c instanceof Choice) {
            TypeListRefresher.refreshList((Choice)this.c, this.listType);
        } else if (this.c instanceof JList) {
            TypeListRefresher.refreshList((JList)this.c, this.listType);
        } else if (this.c instanceof MultiList) {
            TypeListRefresher.refreshList((MultiList)this.c, this.listType);
        }
        if (this.listener != null) {
            this.listener.listRefreshed(this.listType);
        }
    }

    public static void refreshList(JComboBox jComboBox, int n) {
        Vector vector = TypeList.getInstance().getTypeList(n);
        if (vector != null) {
            int n2 = 0;
            int n3 = vector.size();
            while (n2 < n3) {
                jComboBox.addItem(vector.elementAt(n2++));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void refreshList(Choice choice, int n) {
        try {
            Vector vector = TypeList.getInstance().getTypeList(n);
            int n2 = 0;
            if (vector == null) return;
            int n3 = vector.size();
            while (true) {
                if (n2 >= n3) {
                    return;
                }
                choice.addItem(vector.elementAt(n2).toString());
                ++n2;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void refreshList(MultiList multiList, int n) {
        try {
            Vector vector = TypeList.getInstance().getTypeList(n);
            multiList.removeAll();
            if (vector == null) return;
            multiList.add(vector);
            return;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void refreshList(JList jList, int n) {
        try {
            Vector vector = TypeList.getInstance().getTypeList(n);
            jList.setListData(vector);
            return;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    public TypeListRefresher(Component component, int n, TypeListListener typeListListener) {
        this.c = component;
        this.listener = typeListListener;
        this.listType = n;
        new Thread(this).start();
    }
}

