/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.storedProc;

import com.ibm.nzna.shared.util.LogSystem;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class TestStoredProcs {
    Connection con = null;

    public static void main(String[] stringArray) {
        new LogSystem(1, "TestStoredProcs.out");
        if (stringArray == null || stringArray.length != 4) {
            System.out.println("Usage: java TestStoredProcs <database> <server> <user id> <password>");
        } else {
            new TestStoredProcs(stringArray[2], stringArray[3], stringArray[0], stringArray[1]);
        }
    }

    public TestStoredProcs(String string, String string2, String string3, String string4) {
        boolean bl = false;
        try {
            String string5 = "jdbc:db2//" + string4 + ":5703:" + string3;
            System.out.println("Registering DB/2 Net Driver");
            Class.forName("COM.ibm.db2.jdbc.net.DB2Driver").newInstance();
            System.out.println("Connecting to " + string3 + " on " + string4);
            this.con = DriverManager.getConnection(string5, string, string2);
            this.testStoredProc();
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == -1403) {
                System.out.println("The user id and password is not valid");
            } else if (sQLException.getErrorCode() == -1013) {
                System.out.println("The database name: " + string3 + " could not be connected to.");
            } else {
                sQLException.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void testStoredProc() {
        try {
            CallableStatement callableStatement = this.createStoredProc("QUEST.TestStoredProc", 1);
            if (callableStatement != null) {
                boolean bl = false;
                boolean bl2 = false;
                String string = null;
                System.out.println("Setting up Call");
                callableStatement.registerOutParameter(1, 12);
                LogSystem.log(1, "Executing Doc List Query:" + string);
                System.out.println("Calling DocListReader Stored Procedure");
                callableStatement.execute();
                System.out.println("Returned:" + callableStatement.getString(1));
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            exception.printStackTrace();
        }
    }

    public CallableStatement createStoredProc(String string, int n) {
        CallableStatement callableStatement = null;
        String string2 = this.constructDB2StoredProcCall(string, n);
        try {
            System.out.print("Preparing Call for " + string + " ...");
            callableStatement = this.con.prepareCall(string2);
            System.out.println("Ok");
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
            System.out.println("Bad. Check Logs");
        }
        return callableStatement;
    }

    private String constructDB2StoredProcCall(String string, int n) {
        String string2 = "CALL " + string + " ( ";
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            string2 = string2 + "?";
            if (n2 != n - 1) {
                string2 = string2 + ", ";
            }
            ++n2;
        }
        LogSystem.log(1, "SQLMethod Creating Stored Procedure Call:" + string2 + ")");
        return string2 + ")";
    }
}

