/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.common.storedProc.oaReader;

import COM.ibm.db2.app.Blob;
import COM.ibm.db2.app.Lob;
import COM.ibm.db2.app.StoredProc;
import com.ibm.nzna.projects.common.quest.oa.Action;
import com.ibm.nzna.projects.common.quest.oa.ActionDraft;
import com.ibm.nzna.projects.common.quest.oa.ActionDraftReader;
import com.ibm.nzna.projects.common.quest.oa.ActionReader;
import com.ibm.nzna.projects.common.quest.oa.DraftObject;
import com.ibm.nzna.projects.common.quest.oa.Link;
import com.ibm.nzna.projects.common.quest.oa.LinkDraft;
import com.ibm.nzna.projects.common.quest.oa.LinkDraftReader;
import com.ibm.nzna.projects.common.quest.oa.LinkGroup;
import com.ibm.nzna.projects.common.quest.oa.LinkGroupDraft;
import com.ibm.nzna.projects.common.quest.oa.LinkGroupDraftReader;
import com.ibm.nzna.projects.common.quest.oa.LinkGroupReader;
import com.ibm.nzna.projects.common.quest.oa.LinkReader;
import com.ibm.nzna.projects.common.quest.oa.OAInterface;
import com.ibm.nzna.projects.common.quest.oa.OAObject;
import com.ibm.nzna.projects.common.quest.oa.PendingDraftException;
import com.ibm.nzna.projects.common.quest.oa.Question;
import com.ibm.nzna.projects.common.quest.oa.QuestionDraft;
import com.ibm.nzna.projects.common.quest.oa.QuestionDraftReader;
import com.ibm.nzna.projects.common.quest.oa.QuestionReader;
import com.ibm.nzna.projects.common.quest.oa.Symptom;
import com.ibm.nzna.projects.common.quest.oa.SymptomDraft;
import com.ibm.nzna.projects.common.quest.oa.SymptomDraftReader;
import com.ibm.nzna.projects.common.quest.oa.SymptomReader;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.shared.pom.PersistentRec;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class OAReader
extends StoredProc {
    public static final int ACTION = 0;
    public static final int QUESTION = 1;
    public static final int SYMPTOM = 2;
    public static final int LINK = 3;
    public static final int LINKGROUP = 4;
    public static final int READ_ACTIVE = 0;
    public static final int READ_DRAFT = 1;
    public static final int GET_DRAFT = 2;
    public static final int PENDING_DRAFT_RC = 100;

    public void readOAObject(int n, int n2, int n3, int n4, int n5, Blob blob, Blob blob2) throws Exception {
        OAInterface oAInterface = null;
        StoredProcRec storedProcRec = new StoredProcRec();
        Connection connection = null;
        boolean bl = false;
        try {
            connection = this.getConnection();
            connection.setAutoCommit(true);
            switch (n2) {
                case 0: {
                    if (n3 == 0) {
                        Action action = new Action(n);
                        if (!ActionReader.readFromDB(connection, action, n4, n5)) break;
                        oAInterface = action;
                        break;
                    }
                    if (n3 == 1) {
                        ActionDraft actionDraft = new ActionDraft(n);
                        if (!ActionDraftReader.readFromDB(connection, actionDraft, n4)) break;
                        oAInterface = actionDraft;
                        break;
                    }
                    if (n3 == 2) {
                        ActionDraft actionDraft = ActionDraftReader.getDraft(connection, n, n4);
                        oAInterface = actionDraft;
                        break;
                    }
                    storedProcRec.error = true;
                    storedProcRec.errorStr = "Invalid readType " + n3 + " for ACTION";
                    break;
                }
                case 1: {
                    if (n3 == 0) {
                        Question question = new Question(n);
                        if (!QuestionReader.readFromDB(connection, question, n4, n5)) break;
                        oAInterface = question;
                        break;
                    }
                    if (n3 == 1) {
                        QuestionDraft questionDraft = new QuestionDraft(n);
                        if (!QuestionDraftReader.readFromDB(connection, questionDraft, n4)) break;
                        oAInterface = questionDraft;
                        break;
                    }
                    if (n3 == 2) {
                        QuestionDraft questionDraft = QuestionDraftReader.getDraft(connection, n, n4);
                        oAInterface = questionDraft;
                        break;
                    }
                    storedProcRec.error = true;
                    storedProcRec.errorStr = "Invalid readType " + n3 + " for QUESTION";
                    break;
                }
                case 2: {
                    if (n3 == 0) {
                        Symptom symptom = new Symptom(n);
                        if (!SymptomReader.readFromDB(connection, symptom, n4, n5)) break;
                        oAInterface = symptom;
                        break;
                    }
                    if (n3 == 1) {
                        SymptomDraft symptomDraft = new SymptomDraft(n);
                        if (!SymptomDraftReader.readFromDB(connection, symptomDraft, n4)) break;
                        oAInterface = symptomDraft;
                        break;
                    }
                    if (n3 == 2) {
                        SymptomDraft symptomDraft = SymptomDraftReader.getDraft(connection, n, n4);
                        oAInterface = symptomDraft;
                        break;
                    }
                    storedProcRec.error = true;
                    storedProcRec.errorStr = "Invalid readType " + n3 + " for SYMPTOM";
                    break;
                }
                case 3: {
                    if (n3 == 0) {
                        oAInterface = LinkReader.readFromDB(connection, n, n4);
                        break;
                    }
                    if (n3 == 1) {
                        oAInterface = LinkDraftReader.readFromDB(connection, n, n4);
                        break;
                    }
                    if (n3 == 2) {
                        LinkDraft linkDraft = LinkDraftReader.getDraft(connection, n, n4);
                        oAInterface = linkDraft;
                        break;
                    }
                    storedProcRec.error = true;
                    storedProcRec.errorStr = "Invalid readType " + n3 + " for LINK";
                    break;
                }
                case 4: {
                    if (n3 == 0) {
                        LinkGroup linkGroup = new LinkGroup(n);
                        if (!LinkGroupReader.readFromDB(connection, linkGroup, n4)) break;
                        oAInterface = linkGroup;
                        break;
                    }
                    if (n3 == 1) {
                        LinkGroupDraft linkGroupDraft = new LinkGroupDraft(n);
                        if (!LinkGroupDraftReader.readFromDB(connection, linkGroupDraft, n4)) break;
                        oAInterface = linkGroupDraft;
                        break;
                    }
                    if (n3 == 2) {
                        LinkGroupDraft linkGroupDraft = LinkGroupDraftReader.getDraft(connection, n, n4);
                        oAInterface = linkGroupDraft;
                        break;
                    }
                    storedProcRec.error = true;
                    storedProcRec.errorStr = "Invalid readType " + n3 + " for LINKGROUP";
                    break;
                }
                default: {
                    storedProcRec.error = true;
                    storedProcRec.errorStr = "Invalid objectType " + n2;
                }
            }
            if (n3 == 2) {
                this.setDateAndTimeForNewDraft(connection, oAInterface);
            }
        }
        catch (SQLException sQLException) {
            StoredProcUtil.writeException(sQLException, storedProcRec);
            storedProcRec.sqlCode = sQLException.getErrorCode();
            storedProcRec.error = true;
            connection.rollback();
        }
        catch (PendingDraftException pendingDraftException) {
            storedProcRec.error = true;
            storedProcRec.errorStr = "Draft is pending for indicator " + n;
            storedProcRec.sqlCode = 100;
        }
        catch (Exception exception) {
            StoredProcUtil.writeException(exception, storedProcRec);
            storedProcRec.error = true;
            connection.rollback();
        }
        catch (Error error) {
            StoredProcUtil.writeException(error, storedProcRec);
            storedProcRec.error = true;
            connection.rollback();
        }
        connection.commit();
        connection.close();
        blob = Lob.newBlob();
        StoredProcUtil.setObjectInBlob(blob, oAInterface);
        blob2 = Lob.newBlob();
        StoredProcUtil.setObjectInBlob(blob2, storedProcRec);
        this.set(6, blob);
        this.set(7, blob2);
    }

    private void setDateAndTimeForNewDraft(Connection connection, Object object) {
        if (object != null && ((PersistentRec)object).getRecStatus() == 2) {
            try {
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT DISTINCT CURRENT TIMESTAMP, CURRENT DATE FROM oa.typeAction");
                resultSet.next();
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                DraftObject draftObject = (DraftObject)object;
                draftObject.setStartDate(string2);
                string = string.substring(0, string.lastIndexOf(46));
                if (object instanceof OAObject) {
                    OAObject oAObject = (OAObject)object;
                    oAObject.setCreationTime(string);
                    oAObject.setChangedTime(string);
                } else if (object instanceof Link) {
                    Link link = (Link)object;
                    link.setCreationTime(string);
                    link.setChangedTime(string);
                } else if (object instanceof LinkGroup) {
                    LinkGroup linkGroup = (LinkGroup)object;
                    linkGroup.setCreationTime(string);
                    linkGroup.setChangedTime(string);
                }
                resultSet.close();
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

