/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.ftpsync;

import com.ibm.nzna.projects.ftpsync.FTPSync;
import com.ibm.nzna.projects.ftpsync.HDRFilter;
import com.ibm.nzna.shared.batch.BatchLogSystem;
import com.ibm.nzna.shared.ftp.FTP.Ftp;
import com.ibm.nzna.shared.ftp.FtpError;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Vector;

public class FTPMan {
    static File basePath = null;
    static File incomingDir = null;
    static String[] fileList = null;
    static String hdrFileStr = null;
    static String logFilename = null;
    static String filename = null;
    static String fileArea = null;
    static String actionType = null;
    static String inFilename = null;
    static String headerFileName = null;
    static String localAreaFile = null;
    static Ftp ftp = null;
    static FTPSync ftpSync = null;
    static Vector deleteFileVec = null;
    final String scriptFilename;
    final String FILE_NAME;
    final String FILE_AREA;
    final String ACTION_TYPE;
    final String INSERT;
    final String DELETE;
    final String UPDATE;
    final String REMOTEHOST = FTPSync.properties.getProperty("remoteHost");
    final String REMOTE_DIRNAME = FTPSync.properties.getProperty("remoteDir");
    final String BASE_PATH = FTPSync.properties.getProperty("basePath");
    final String INCOMING_DIRNAME = FTPSync.properties.getProperty("incomingDir");
    final String SENT_DIRNAME = FTPSync.properties.getProperty("sentDir");
    final String LINEFEED = System.getProperty("line.separator");
    final String SLASH = System.getProperty("file.separator");
    final String USERID = FTPSync.properties.getProperty("userid");
    final String PASSWORD = FTPSync.properties.getProperty("password");
    final char ASCII = (char)65;
    final char BINARY = (char)73;

    private boolean connect() {
        boolean bl = false;
        BatchLogSystem.beginLogSection("Connecting to FTP server :" + this.REMOTEHOST);
        ftp = new Ftp();
        try {
            ftp.connect(this.REMOTEHOST);
            ftpSync.logProgress("Connected to " + this.REMOTEHOST + ". Complete", 0, 0);
            ftpSync.logProgress("   FTP Reply:" + ftp.getReply(), 0, 0);
            bl = true;
        }
        catch (UnknownHostException unknownHostException) {
            ftpSync.logError("Could not create connection to " + this.REMOTEHOST + ". (Unknown Host) Failed");
            ftpSync.logError("   FTP Reply:" + ftp.getReply());
            ftpSync.logSevereError(unknownHostException);
        }
        catch (IOException iOException) {
            ftpSync.logError("Could not create connection to " + this.REMOTEHOST + ". (IOException) Failed");
            ftpSync.logError("   FTP Reply:" + ftp.getReply());
            ftpSync.logSevereError(iOException);
        }
        BatchLogSystem.endLogSection();
        return bl;
    }

    public boolean login(String string, String string2) {
        boolean bl = false;
        BatchLogSystem.beginLogSection("Logging into server");
        try {
            ftp.login(string, string2);
            ftpSync.logProgress("Logged into " + ftp.getHost() + ".", 0, 0);
            ftpSync.logProgress("   FTP Reply:" + ftp.getReply(), 0, 0);
            bl = true;
        }
        catch (FtpError ftpError) {
            ftpSync.logError("Could not login to host " + ftp.getHost() + " with User Id:" + string + ", Password:" + string2);
            ftpSync.logError("   FTP Reply:" + ftp.getReply());
            ftpSync.logSevereError(ftpError);
        }
        catch (IOException iOException) {
            ftpSync.logError("Could not login to host " + ftp.getHost() + " with User Id:" + string + ", Password:" + string2 + ". (IOException)");
            ftpSync.logError("   FTP Reply:" + ftp.getReply());
            ftpSync.logSevereError(iOException);
        }
        BatchLogSystem.endLogSection();
        return bl;
    }

    public void logout() {
        BatchLogSystem.beginLogSection("Logging off of " + ftp.getHost());
        try {
            ftp.logout();
            ftpSync.logProgress("Logged out successfully", 0, 0);
        }
        catch (FtpError ftpError) {
            ftpSync.logError("Could not logout from " + ftp.getHost());
            ftpSync.logError("   FTP Reply:" + ftp.getReply());
            ftpSync.logSevereError(ftpError);
        }
        catch (IOException iOException) {
            ftpSync.logError("Could not logout from " + ftp.getHost() + " (IOException)");
            ftpSync.logError("   FTP Reply:" + ftp.getReply());
            ftpSync.logSevereError(iOException);
        }
        BatchLogSystem.endLogSection();
    }

    public void disconnect() {
        BatchLogSystem.beginLogSection("Disconnecting from " + ftp.getHost());
        try {
            ftp.disconnect();
            ftpSync.logProgress("Disconnected from " + ftp.getHost(), 0, 0);
        }
        catch (IOException iOException) {
            ftpSync.logError("Could not disconnect from " + ftp.getHost() + " (IOException)");
            ftpSync.logError("   FTP Reply:" + ftp.getReply());
            ftpSync.logSevereError(iOException);
        }
        BatchLogSystem.endLogSection();
    }

    public void startFtp() {
        BatchLogSystem.beginLogSection("Starting FTP Process");
        if (basePath.exists() && incomingDir.exists()) {
            if (this.readIncomingDir() && this.connect()) {
                if (this.login(this.USERID, this.PASSWORD)) {
                    int n = 0;
                    while (n < fileList.length) {
                        if (this.readHdrFile(n)) {
                            BatchLogSystem.beginLogSection("Processing File " + filename);
                            if (this.copyToLocalArea() && this.transferFile() && this.deleteIncomingFile()) {
                                this.moveHdrToSent();
                                ftpSync.logProgress("All actions for file:" + filename + " complete.", 0, 0);
                            }
                            BatchLogSystem.endLogSection();
                        }
                        ++n;
                    }
                }
                this.disconnect();
                try {
                    FileUtil.writeObjectToDisk("deleteFiles.ser", deleteFileVec);
                }
                catch (Exception exception) {
                    FTPSync.logSystem.logError("Could not write deleteFiles.ser");
                }
            }
        } else {
            ftpSync.logError("Could not find directory for files. Please check base path and incoming path properties");
        }
        BatchLogSystem.endLogSection();
    }

    private boolean readIncomingDir() {
        boolean bl = false;
        fileList = incomingDir.list(new HDRFilter());
        if (fileList.length <= 0) {
            ftpSync.logProgress("No files in incoming directory to process", 0, 0);
        } else {
            ftpSync.logProgress("Going to process " + fileList.length + " files from incoming directory", 0, 0);
            bl = true;
        }
        return bl;
    }

    private boolean readHdrFile(int n) {
        boolean bl = false;
        try {
            hdrFileStr = FileUtil.readFile(incomingDir + this.SLASH + fileList[n]);
            headerFileName = fileList[n];
            ftpSync.logProgress("Read Header File:" + headerFileName, 0, 0);
            filename = this.getHdrFileVars(hdrFileStr, "Filename: ");
            fileArea = this.getHdrFileVars(hdrFileStr, "filearea: ");
            fileArea = fileArea.substring(1);
            actionType = this.getHdrFileVars(hdrFileStr, "actiontype: ");
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            ftpSync.logError("Could not read header file for :" + headerFileName + ". File Not Found");
            ftpSync.logSevereError(fileNotFoundException);
        }
        catch (IOException iOException) {
            ftpSync.logError("Could not read header file for :" + headerFileName + ". (IOException)");
            ftpSync.logSevereError(iOException);
        }
        return bl;
    }

    public String getHdrFileVars(String string, String string2) {
        String string3;
        block5: {
            string3 = null;
            int n = 0;
            if (string.length() > 0) {
                try {
                    n = string.indexOf(string2);
                    if (n != -1) {
                        string3 = string.substring(n += string2.length(), string.indexOf(this.LINEFEED, n));
                        string3 = string3.trim();
                        break block5;
                    }
                    ftpSync.logError("Could not find variable " + string2 + " in header file :" + headerFileName);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    ftpSync.logSevereError(stringIndexOutOfBoundsException);
                }
            } else {
                ftpSync.logError("Header file is empty. Filename:" + headerFileName);
            }
        }
        return string3;
    }

    private boolean transferFile() {
        boolean bl;
        block11: {
            File file = new File(this.REMOTE_DIRNAME + this.SLASH + fileArea);
            String string = this.REMOTE_DIRNAME + this.SLASH + fileArea + this.SLASH + filename;
            bl = false;
            if (actionType.equalsIgnoreCase("insert") || actionType.equalsIgnoreCase("update")) {
                try {
                    ftp.setType('I');
                    ftp.put(inFilename, string, false);
                    ftpSync.logProgress("Transferred File " + filename + " success.", 0, 0);
                    ftpSync.logProgress("   FTP Reply:" + ftp.getReply(), 0, 0);
                    bl = true;
                }
                catch (FtpError ftpError) {
                    ftpSync.logError("Cannot FTP " + inFilename + " to " + string);
                    ftpSync.logError("   FTP Reply:" + ftp.getReply());
                    ftpSync.logSevereError(ftpError);
                }
                catch (IOException iOException) {
                    ftpSync.logError("Cannot FTP " + inFilename + " to " + string + ". (IOException)");
                    ftpSync.logError("   FTP Reply:" + ftp.getReply());
                    ftpSync.logSevereError(iOException);
                }
            } else if (FTPSync.deleteFiles && actionType.equalsIgnoreCase("delete")) {
                try {
                    ftp.delete(string);
                    ftpSync.logProgress("Deleted File " + string + " from host " + ftp.getHost() + " success.", 0, 0);
                    ftpSync.logProgress("   FTP Reply:" + ftp.getReply(), 0, 0);
                    bl = true;
                }
                catch (FtpError ftpError) {
                    String string2 = ftp.getReply().toString();
                    if (string2.indexOf("550") == -1) {
                        ftpSync.logError("Could not delete host file " + string);
                        ftpSync.logError("   FTP Reply:" + ftp.getReply());
                        ftpSync.logSevereError(ftpError);
                        break block11;
                    }
                    ftpSync.logProgress("Could not delete host file " + string + " because it was not there", 0, 0);
                    bl = true;
                }
                catch (IOException iOException) {
                    ftpSync.logError("Could not delete host file " + string + ". (IOException)");
                    ftpSync.logError("   FTP Reply:" + ftp.getReply());
                    ftpSync.logSevereError(iOException);
                }
            } else {
                ftpSync.logProgress("No Action for file:" + filename + ".", 0, 0);
                bl = false;
            }
        }
        return bl;
    }

    private boolean copyToLocalArea() {
        boolean bl;
        block13: {
            bl = false;
            if (actionType.equalsIgnoreCase("insert") || actionType.equalsIgnoreCase("update")) {
                localAreaFile = this.BASE_PATH + this.SLASH + fileArea + this.SLASH + filename;
                inFilename = incomingDir + this.SLASH + filename;
                try {
                    if (FileUtil.exists(inFilename)) {
                        if (FileUtil.copyFile(inFilename, localAreaFile)) {
                            this.appendFileToChmodScript(localAreaFile);
                            ftpSync.logProgress("Copied file " + filename + " to correct local area.", 0, 0);
                            bl = true;
                        } else {
                            ftpSync.logError("Could not copy file " + inFilename + " to " + localAreaFile);
                        }
                        break block13;
                    }
                    ftpSync.logError("Could not copy file " + inFilename + " to " + localAreaFile + " (File Not Found)");
                }
                catch (Exception exception) {
                    ftpSync.logError("Cannot copy file to local file area.");
                    ftpSync.logError("   incoming file:" + inFilename);
                    ftpSync.logError("   to file:" + localAreaFile);
                    ftpSync.logSevereError(exception);
                }
            } else if (actionType.equalsIgnoreCase("delete")) {
                localAreaFile = this.BASE_PATH + this.SLASH + fileArea + this.SLASH + filename;
                inFilename = incomingDir + this.SLASH + filename;
                try {
                    if (FileUtil.exists(localAreaFile)) {
                        FileUtil.deleteFile(localAreaFile);
                        ftpSync.logProgress("Delete local file:" + localAreaFile + " success.", 0, 0);
                        bl = true;
                    } else {
                        ftpSync.logProgress("Cannot delete local file " + localAreaFile + " because it is not there to delete.", 0, 0);
                        bl = true;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    FTPSync.logSystem.logError("Cannot find local file for delete. Filename:" + localAreaFile);
                    bl = true;
                }
                catch (Exception exception) {
                    FTPSync.logSystem.logError("Cannot delete file from local area:" + localAreaFile);
                    FTPSync.logSystem.logSevereError(exception);
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean deleteIncomingFile() {
        boolean bl = false;
        deleteFileVec.addElement(inFilename);
        bl = true;
        return bl;
    }

    private boolean moveHdrToSent() {
        boolean bl = true;
        String string = incomingDir + this.SLASH + headerFileName;
        String string2 = this.SENT_DIRNAME + this.SLASH + headerFileName;
        try {
            if (FileUtil.copyFile(string, string2)) {
                FileUtil.deleteFile(string);
                ftpSync.logProgress("Moved header file of " + string2, 0, 0);
                bl = true;
            } else {
                ftpSync.logError("Could not move header file " + headerFileName + " to " + this.SENT_DIRNAME);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            FTPSync.logSystem.logError("Cannot find header file for move. Header filename:" + headerFileName);
            FTPSync.logSystem.logSevereError(fileNotFoundException);
        }
        catch (Exception exception) {
            FTPSync.logSystem.logError("Cannot move header file. Header filename:" + headerFileName);
            FTPSync.logSystem.logSevereError(exception);
        }
        return bl;
    }

    private void appendFileToChmodScript(String string) {
        try {
            String string2 = FileUtil.readFile("chmod_script");
            string2 = string2 + "\nchmod 664 " + string;
            FileUtil.saveFile("chmod_script", string2);
        }
        catch (Exception exception) {
            ftpSync.logSevereError(exception);
        }
    }

    public FTPMan(FTPSync fTPSync) {
        this.scriptFilename = "chmod_script";
        this.FILE_NAME = "Filename: ";
        this.FILE_AREA = "filearea: ";
        this.ACTION_TYPE = "actiontype: ";
        this.INSERT = "insert";
        this.DELETE = "delete";
        this.UPDATE = "update";
        ftpSync = fTPSync;
        FileUtil.saveFile("chmod_script", "");
        CDate cDate = new CDate(1);
        logFilename = "ftpsync_" + cDate.today() + ".out";
        fTPSync.logProgress("FTP Manager Starting", 0, 0);
        basePath = new File(this.BASE_PATH);
        incomingDir = new File(this.INCOMING_DIRNAME);
        deleteFileVec = new Vector(10, 10);
    }
}

