/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.oa.engine;

import com.ibm.nzna.projects.oa.engine.MyException;
import com.ibm.nzna.projects.oa.engine.OAEngine;
import com.ibm.nzna.projects.oa.engine.OAReturnVars;
import com.ibm.nzna.projects.oa.engine.OASessionState;
import com.ibm.nzna.projects.oa.engine.OASubmitVars;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogModule;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.StandardPropertyLoader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Properties;

public class LogicAPI {
    private String sessionPath = "/tmp/oa/";
    private String sessionIndex = "LogicAPI.index";
    private Hashtable index = new Hashtable(50);
    private Integer curSessionInd = new Integer(1000);
    private String curSessionFile = "./0.0.0";
    private String curSessionBase = "./0.0";
    private String curSessionKey = "0000";
    private FileUtil myFutil = new FileUtil();
    private String logFile = "OAhistory.log";
    private LogModule log = null;
    private boolean myDebug = false;
    private Properties countryMapping = null;
    private Properties languageMapping = null;
    private Properties preanswerLists = null;
    private boolean preanswerProc = false;
    private String questDbname = "";
    private String questServer = "";
    private String questPort = "";
    private String questUser = "";
    private String questPasswd = "";
    private boolean dbUseAppDriver = false;
    private String clioDbname = "";
    private String clioServer = "";
    private String clioPort = "";
    private String clioUser = "";
    private String clioPasswd = "";

    public OAReturnVars dispatch(OASubmitVars oASubmitVars, int n) {
        Object object;
        Object object2;
        OASessionState oASessionState = null;
        OAReturnVars oAReturnVars = null;
        try {
            if (oASubmitVars.command.equals("SetHistory")) {
                oASessionState = this.processHistory(oASubmitVars);
            } else {
                object2 = new FileInputStream(this.curSessionFile);
                object = new ObjectInputStream((InputStream)object2);
                oASessionState = (OASessionState)((ObjectInputStream)object).readObject();
                ((ObjectInputStream)object).close();
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, "LogicAPI: I/O error reading saved session state object: " + this.curSessionFile + " - " + exception.toString());
            try {
                FileUtil.appendToFile(this.logFile, "Error Encountered - reading saved object - " + this.curSessionFile + " - " + exception.toString() + " - Starting Over\n");
                LogSystem.log(1, "Error Encountered - reading saved object - " + this.curSessionFile + " - " + exception.toString() + " - Starting Over");
                oASessionState = new OASessionState(this.curSessionInd);
            }
            catch (Exception exception2) {
                LogSystem.log(1, "LogicAPI/readState: Log File appendToFile / new session Exception.");
                LogSystem.log(1, exception2);
            }
        }
        try {
            if (oASubmitVars.qitMemory != null) {
                oASessionState.setSourceFlag(true);
            }
            object2 = new OAEngine(this.questDbname, this.questServer, this.questPort, this.questUser, this.questPasswd, oASubmitVars.qitMemory, this.sessionPath, this.dbUseAppDriver);
            if (oASessionState.getCurrentSymptom() == 0 && n != 0) {
                oASessionState.setCurrentSymptom(n);
            }
            if (oASessionState.getCurrentNode() == 0 && oASubmitVars.nodeInd != 0) {
                oASessionState.setCurrentNode(oASubmitVars.nodeInd);
            }
            if (oASubmitVars.sessionSeqNo != 0) {
                oASessionState.setCurrentSeqNo(oASubmitVars.sessionSeqNo);
            }
            if (this.myDebug) {
                LogSystem.log(1, "LogicAPI: QIT_FLAG = " + oASessionState.getSourceFlag());
            }
            if (oASubmitVars.response != 0) {
                oASessionState.setCurrentResponse(oASubmitVars.response);
            }
            if (oASubmitVars.brand == null || oASubmitVars.brand.equals("")) {
                throw new MyException("Empty brand.  ");
            }
            oASubmitVars.brand = oASubmitVars.brand.replace('+', ' ');
            oASessionState.setBrand(oASubmitVars.brand);
            if (oASubmitVars.docClass != 0) {
                oASessionState.setDocClassInd(oASubmitVars.docClass);
            }
            object = "";
            if (oASubmitVars.custNum != null && !oASubmitVars.custNum.equals("")) {
                oASessionState.setCustNum(Integer.parseInt(oASubmitVars.custNum));
                object = ((OAEngine)object2).getThreeCharCountryCode(oASessionState, this.clioDbname, this.clioServer, this.clioPort, this.clioUser, this.clioPasswd);
            } else {
                object = "";
            }
            if (object != null && !((String)object).equals("")) {
                object = this.countryMapping != null ? this.countryMapping.getProperty((String)object) : "";
                if (object == null) {
                    object = "";
                }
            } else {
                object = "";
            }
            if (this.myDebug) {
                LogSystem.log(1, "LogicAPI: cocode1 = " + (String)object);
            }
            if (!((String)object).equals("")) {
                oASessionState.setCountry(Integer.parseInt((String)object));
            } else {
                oASessionState.setCountry(110);
            }
            object = oASubmitVars.lang != null ? oASubmitVars.lang : "";
            if (!((String)object).equals("")) {
                ((OAEngine)object2).getLanguageIndandSet((String)object, oASessionState);
            } else {
                ((OAEngine)object2).getLanguageIndandSet("English", oASessionState);
            }
            if (this.myDebug) {
                LogSystem.log(1, "LogicAPI: cocode2 = " + (String)object);
            }
            if (!oASubmitVars.typeModel.equals("")) {
                if (oASubmitVars.typeModel.indexOf("-") > 0 && oASubmitVars.typeModel.length() >= 8 + oASubmitVars.typeModel.indexOf("-")) {
                    oASubmitVars.typeModel = oASubmitVars.typeModel.substring(oASubmitVars.typeModel.indexOf("-") + 1);
                }
                if (oASubmitVars.typeModel.indexOf("-") < 0 && oASubmitVars.typeModel.length() > 4) {
                    oASubmitVars.typeModel = oASubmitVars.typeModel.substring(0, 4) + "-" + oASubmitVars.typeModel.substring(4);
                }
                oASessionState.setModel(oASubmitVars.typeModel);
            }
            if (this.preanswerLists != null && !this.preanswerProc) {
                String string;
                String string2;
                this.preanswerProc = true;
                String string3 = this.preanswerLists.getProperty("brand." + oASubmitVars.brand.replace(' ', '.') + ".question");
                String string4 = this.preanswerLists.getProperty("brand." + oASubmitVars.brand.replace(' ', '.') + ".answer");
                if (string3 != null && string4 != null) {
                    oASessionState.addPreanswerItem(Integer.parseInt(string3), Integer.parseInt(string4));
                }
                if (oASubmitVars.country.equals("United States") || oASubmitVars.country.equals("Canada")) {
                    string2 = this.preanswerLists.getProperty("geography.North.America.question");
                    string = this.preanswerLists.getProperty("geography.North.America.answer");
                    if (string2 != null && string != null) {
                        oASessionState.addPreanswerItem(Integer.parseInt(string2), Integer.parseInt(string));
                    }
                }
                string2 = this.preanswerLists.getProperty("supported." + oASubmitVars.brand.replace(' ', '.') + ".question");
                string = this.preanswerLists.getProperty("supported." + oASubmitVars.brand.replace(' ', '.') + ".answer");
                if (string2 != null && string != null) {
                    oASessionState.addPreanswerItem(Integer.parseInt(string2), Integer.parseInt(string));
                }
            }
            if (this.myDebug) {
                LogSystem.log(1, "<p>OA Session State:<br>\n" + "  Session.Seqno = " + oASessionState.getSessionId() + "." + oASessionState.getCurrentSeqNo() + "<br>\n" + "  Brand = " + oASessionState.getBrand() + "<br>\n" + "  Type/Model = " + oASessionState.getModel() + "<br>\n" + "  Geo = " + oASessionState.getGeo() + "<br>\n" + "  Country Ind = " + oASessionState.getCountry() + "<br>\n" + "  Language Ind = " + oASessionState.getLanguage() + "<br>\n" + "  Doc Class = " + oASessionState.getDocClassInd() + "<br>\n" + "  Response = " + oASessionState.getCurrentResponse() + "<br>\n" + "  History size = " + oASessionState.getQuestionHistory().size() + "<br>\n" + "  Symptom = " + oASessionState.getCurrentSymptom() + "<br>\n" + "  Node = " + oASessionState.getCurrentNode() + "<br>\n" + "  Source Flag = " + oASessionState.getSourceFlag() + "<br>");
            }
            FileUtil.appendToFile(this.logFile, "Command = " + oASubmitVars.command + " - " + oASessionState.getSessionId() + "." + oASessionState.getCurrentSeqNo() + " - " + oASessionState.getBrand() + ":" + oASessionState.getModel() + " " + oASessionState.getCurrentSymptom() + "/" + oASessionState.getCurrentNode() + "/" + oASessionState.getCurrentResponse() + "\n");
            LogSystem.log(1, "Command = " + oASubmitVars.command + " - " + oASessionState.getSessionId() + "." + oASessionState.getCurrentSeqNo() + " - " + oASessionState.getBrand() + ":" + oASessionState.getModel() + " " + oASessionState.getCurrentSymptom() + "/" + oASessionState.getCurrentNode() + "/" + oASessionState.getCurrentResponse() + "\n");
            oAReturnVars = new OAReturnVars(oASessionState.getSessionId());
            if (oASubmitVars.command.equals("GetNextNode")) {
                oAReturnVars = this.getNextNode((OAEngine)object2, oASessionState);
            } else {
                if (oASubmitVars.command.equals("EndSession")) {
                    oAReturnVars = this.endSession((OAEngine)object2, oASessionState);
                    return oAReturnVars;
                }
                if (oASubmitVars.command.equals("GetHistory")) {
                    oAReturnVars = this.getHistory((OAEngine)object2, oASessionState);
                } else if (oASubmitVars.command.equals("LogHistory")) {
                    oAReturnVars = this.logHistory(oASubmitVars.message, (OAEngine)object2, oASessionState);
                } else if (oASubmitVars.command.equals("SetHistory")) {
                    oAReturnVars = this.setHistory((OAEngine)object2, oASessionState);
                } else {
                    if (oASubmitVars.command.equals("SaveResolved")) {
                        oAReturnVars = this.saveResolved((OAEngine)object2, oASessionState);
                        return oAReturnVars;
                    }
                    if (oASubmitVars.command.equals("SaveUnresolved")) {
                        oAReturnVars = this.saveUnresolved((OAEngine)object2, oASessionState);
                        return oAReturnVars;
                    }
                    oAReturnVars = new OAReturnVars(0);
                    oAReturnVars.addInfo = "LogicAPI: ERROR in command parameter.\n";
                }
            }
        }
        catch (Throwable throwable) {
            object = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)object);
            if (oAReturnVars == null) {
                try {
                    oAReturnVars = new OAReturnVars(oASessionState.getSessionId());
                }
                catch (Exception exception) {
                    oAReturnVars = new OAReturnVars(0);
                }
            }
            oAReturnVars.title = "THE ONLINE ASSISTANT ENCOUNTERED AN ERROR";
            oAReturnVars.addInfo = "LogicAPI dispatch function received an exception from OA Engine, " + "or had erroneous parameters.  " + "<!-- " + "OA LogicAPI dispatch exception: " + throwable.toString() + "\nOA LogicAPI dispatch exception detail:" + throwable.toString() + "\n";
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            oAReturnVars.addInfo = oAReturnVars.addInfo + ((StringWriter)object).getBuffer().toString() + " -->";
            try {
                oAReturnVars.sessionSeqNo = oASessionState.getCurrentSeqNo();
                oAReturnVars.nodeInd = oASessionState.getCurrentNode();
                oAReturnVars.node_flag = oASessionState.getNodeFlag();
                FileUtil.appendToFile(this.logFile, "Error Encountered - " + oAReturnVars.sessionInd + "." + oAReturnVars.sessionSeqNo + " - " + throwable.toString() + "\n");
                LogSystem.log(1, "Error Encountered - " + oAReturnVars.sessionInd + "." + oAReturnVars.sessionSeqNo + " - " + throwable.toString() + "\n");
            }
            catch (Exception exception) {
                LogSystem.log(1, "LogicAPI/Error: Log File appendToFile took Exception.");
                LogSystem.log(1, exception);
            }
            return oAReturnVars;
        }
        try {
            this.curSessionFile = this.curSessionBase + "." + (oASubmitVars.sessionSeqNo + 1);
            oASessionState.setCurrentSeqNo(oASubmitVars.sessionSeqNo + 1);
            object2 = new FileOutputStream(this.curSessionFile);
            object = new ObjectOutputStream((OutputStream)object2);
            ((ObjectOutputStream)object).writeObject(oASessionState);
            ((ObjectOutputStream)object).flush();
            ((ObjectOutputStream)object).close();
            oAReturnVars.sessionSeqNo = oASessionState.getCurrentSeqNo();
            if (this.myDebug) {
                LogSystem.log(1, "LogicAPI: increased SeqNo to " + oASessionState.getCurrentSeqNo());
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, "LogicAPI: I/O Error saving session state object: " + this.curSessionFile + " - " + exception.toString());
            try {
                FileUtil.appendToFile(this.logFile, "Error saving state - " + this.curSessionFile + " - " + exception.toString() + "\n");
                LogSystem.log(1, "Error saving state - " + this.curSessionFile + " - " + exception.toString() + "\n");
            }
            catch (Exception exception3) {
                LogSystem.log(1, "LogicAPI/saveState: Log File appendToFile took Exception.");
                LogSystem.log(1, exception3);
            }
        }
        return oAReturnVars;
    }

    public String getCalDateTime() {
        Calendar calendar = Calendar.getInstance();
        String string = calendar.get(1) + (calendar.get(2) < 9 ? "-0" : "-") + (calendar.get(2) + 1) + (calendar.get(5) < 10 ? "-0" : "-") + calendar.get(5) + " " + calendar.get(11) + (calendar.get(12) < 10 ? ":0" : ":") + calendar.get(12) + (calendar.get(13) < 10 ? ":0" : ":") + calendar.get(13);
        return string;
    }

    public OAReturnVars endSession(OAEngine oAEngine, OASessionState oASessionState) throws Exception {
        OAReturnVars oAReturnVars = oAEngine.displayHistory(oASessionState);
        try {
            FileUtil.appendToFile(this.logFile, "EndSession - " + oASessionState.getSessionId() + "." + oASessionState.getCurrentSeqNo() + " - " + oASessionState.getBrand() + ":" + oASessionState.getModel() + " " + oASessionState.getCurrentSymptom() + "/" + oASessionState.getCurrentNode() + "/" + oASessionState.getCurrentResponse() + " - " + this.getCalDateTime() + "\n");
            LogSystem.log(1, "EndSession - " + oASessionState.getSessionId() + "." + oASessionState.getCurrentSeqNo() + " - " + oASessionState.getBrand() + ":" + oASessionState.getModel() + " " + oASessionState.getCurrentSymptom() + "/" + oASessionState.getCurrentNode() + "/" + oASessionState.getCurrentResponse() + " - " + this.getCalDateTime() + "\n");
        }
        catch (Exception exception) {
            LogSystem.log(1, "LogicAPI/endSession: Log File appendToFile took Exception.");
            LogSystem.log(1, exception);
        }
        try {
            int n = 0;
            File file = new File(this.curSessionBase + ".0");
            while (file.exists()) {
                file.delete();
                file = new File(this.curSessionBase + "." + ++n);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, "LogicAPI/endSession: Cleanup Objects took Exception.");
            LogSystem.log(1, exception);
        }
        return oAReturnVars;
    }

    public OAReturnVars getHistory(OAEngine oAEngine, OASessionState oASessionState) throws Exception {
        OAReturnVars oAReturnVars = oAEngine.displayHistory(oASessionState);
        return oAReturnVars;
    }

    public OAReturnVars logHistory(String string, OAEngine oAEngine, OASessionState oASessionState) throws Exception {
        OAReturnVars oAReturnVars = new OAReturnVars(oASessionState.getSessionId());
        try {
            FileUtil.appendToFile(this.logFile, "LogHistory - " + oASessionState.getSessionId() + "." + oASessionState.getCurrentSeqNo() + " - " + oASessionState.getBrand() + ":" + oASessionState.getModel() + " " + string + " - " + this.getCalDateTime() + "\n");
            LogSystem.log(1, "LogHistory - " + oASessionState.getSessionId() + "." + oASessionState.getCurrentSeqNo() + " - " + oASessionState.getBrand() + ":" + oASessionState.getModel() + " " + string + " - " + this.getCalDateTime() + "\n");
        }
        catch (Exception exception) {
            LogSystem.log(1, "LogicAPI/logHistory: Log File appendToFile took Exception.");
            LogSystem.log(1, exception);
        }
        return oAReturnVars;
    }

    public OAReturnVars getNextNode(OAEngine oAEngine, OASessionState oASessionState) throws Exception {
        OAReturnVars oAReturnVars = null;
        oAReturnVars = oAEngine.processNode(oASessionState);
        return oAReturnVars;
    }

    public OAReturnVars saveResolved(OAEngine oAEngine, OASessionState oASessionState) throws Exception {
        OAReturnVars oAReturnVars = this.endSession(oAEngine, oASessionState);
        oAReturnVars.title = oAEngine.getSymptomTitleAsString(oASessionState);
        return oAReturnVars;
    }

    public OAReturnVars saveUnresolved(OAEngine oAEngine, OASessionState oASessionState) throws Exception {
        OAReturnVars oAReturnVars = this.endSession(oAEngine, oASessionState);
        oAReturnVars.title = oAEngine.getSymptomTitleAsString(oASessionState);
        return oAReturnVars;
    }

    public OAReturnVars setHistory(OAEngine oAEngine, OASessionState oASessionState) throws Exception {
        OAReturnVars oAReturnVars = this.getNextNode(oAEngine, oASessionState);
        return oAReturnVars;
    }

    public OASessionState processHistory(OASubmitVars oASubmitVars) throws Exception {
        OASessionState oASessionState = null;
        String string = "";
        try {
            string = this.sessionPath + oASubmitVars.sessionInd + "." + ((Long)this.index.get(new Integer(oASubmitVars.sessionInd))).toString() + "." + oASubmitVars.sessionSeqNo;
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            oASessionState = (OASessionState)objectInputStream.readObject();
            --oASubmitVars.sessionSeqNo;
            oASessionState.setCurrentSeqNo(oASubmitVars.sessionSeqNo);
            if (oASubmitVars.sessionSeqNo == 0) {
                oASessionState.setCurrentNode(0);
            } else {
                oASubmitVars.response = oASessionState.getPreviousResponse();
                oASubmitVars.nodeInd = oASessionState.getPreviousNode();
                oASessionState.setCurrentNode(oASessionState.getPreviousNode());
                if (this.myDebug) {
                    LogSystem.log(1, "LogicAPI: found previous response: " + oASubmitVars.response + " and node: " + oASubmitVars.nodeInd);
                }
            }
            objectInputStream.close();
        }
        catch (Exception exception) {
            LogSystem.log(1, "LogicAPI: I/O Error reading " + "session state object from history: " + string + " - " + exception.toString() + " - Starting Over");
            FileUtil.appendToFile(this.logFile, "Error Encountered - reading from history - " + string + " - " + exception.toString() + " - Starting Over\n");
            oASessionState = new OASessionState(oASubmitVars.sessionInd);
        }
        return oASessionState;
    }

    public void setQuestNames(String string, String string2, String string3, String string4, String string5) {
        this.questDbname = string;
        this.questServer = string2;
        this.questPort = string3;
        this.questUser = string4;
        this.questPasswd = string5;
        this.dbUseAppDriver = false;
    }

    public void setQuestNames(String string, String string2, String string3, String string4, String string5, boolean bl) {
        this.questDbname = string;
        this.questServer = string2;
        this.questPort = string3;
        this.questUser = string4;
        this.questPasswd = string5;
        this.dbUseAppDriver = bl;
    }

    public void setClioNames(String string, String string2, String string3, String string4, String string5) {
        this.clioDbname = string;
        this.clioServer = string2;
        this.clioPort = string3;
        this.clioUser = string4;
        this.clioPasswd = string5;
        this.dbUseAppDriver = false;
    }

    public void setClioNames(String string, String string2, String string3, String string4, String string5, boolean bl) {
        this.clioDbname = string;
        this.clioServer = string2;
        this.clioPort = string3;
        this.clioUser = string4;
        this.clioPasswd = string5;
        this.dbUseAppDriver = bl;
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < stringArray.length) {
                if (stringArray[n4].length() >= 3 && (stringArray[n4].substring(0, 3).equals("ses") || stringArray[n4].substring(0, 3).equals("seq")) && stringArray[n4].indexOf("=") >= 0) {
                    if (stringArray[n4].substring(0, 3).equals("ses")) {
                        n = Integer.parseInt(stringArray[n4].substring(1 + stringArray[n4].indexOf("=")));
                    } else {
                        n3 = Integer.parseInt(stringArray[n4].substring(1 + stringArray[n4].indexOf("=")));
                    }
                }
                ++n4;
            }
            LogicAPI logicAPI = new LogicAPI(n, n3, "/tmp/oa/", null, null);
            logicAPI.setClioNames("CLIO", "CHAOS", "5703", "esupport", "ESUPP0RT");
            logicAPI.setQuestNames("QUESTOA2", "CHAOS", "5703", "quest", "j0hnny");
            OASubmitVars oASubmitVars = new OASubmitVars(n);
            oASubmitVars.command = "GetNextNode";
            oASubmitVars.node_flag = "DQ";
            oASubmitVars.sessionSeqNo = n3;
            if (stringArray.length == 0) {
                System.out.println("Usage: LogicAPI parameter=value . . .\nwhere parameters are:\n  command = GetNextNode,GetHistory,SetHistory,SaveResolved,or SaveUnresolved\n  brand = PC brand, eg, IBM ThinkPad\n  typeModel = 4 + 3 character string, hyphen optional, or Options model (longer)\n  country = 2 + '_' + 2 language_country string\n  docClass = 1, 2, or 3 depending on site (enduser, partner, internal)\n  node = node indicator (integer)\n  nflag = node-flag (AA, AQ, AS, DA, DQ, DS)\n  response = answer indicator (integer)\n  message = additional values / parameters (string)\n  sessionind = session indicator (integer)\n  seqno = sequence within session (integer)\n  (qflag can only be false)\n  symptom = symptom indicator (integer)\nParameter names can be abbreviated with the first 3 letters.\nEg, LogicAPI com=GetNextNode nfl=DQ res=130567 nodeInd=150210");
                return;
            }
            String string = "";
            String string2 = "";
            int n5 = 0;
            while (n5 < stringArray.length) {
                if (stringArray[n5].length() >= 3 && (string = stringArray[n5].substring(0, stringArray[n5].indexOf("="))).length() >= 3) {
                    string = string.substring(0, 3);
                    if (stringArray[n5].indexOf("=") >= 0 && (string2 = stringArray[n5].substring(1 + stringArray[n5].indexOf("="))).length() >= 1 && !string.equals("ses") && !string.equals("seq")) {
                        if (string.equals("com")) {
                            oASubmitVars.command = string2;
                        } else if (string.equals("bra")) {
                            oASubmitVars.brand = string2;
                        } else if (string.equals("typ")) {
                            oASubmitVars.typeModel = string2;
                        } else if (string.equals("cou")) {
                            oASubmitVars.country = string2;
                        } else if (string.equals("cus")) {
                            oASubmitVars.custNum = string2;
                        } else if (string.equals("doc")) {
                            oASubmitVars.docClass = Integer.parseInt(string2);
                        } else if (string.equals("nod")) {
                            oASubmitVars.nodeInd = Integer.parseInt(string2);
                        } else if (string.equals("nfl")) {
                            oASubmitVars.node_flag = string2;
                        } else if (string.equals("res")) {
                            oASubmitVars.response = Integer.parseInt(string2);
                        } else if (string.equals("mes")) {
                            oASubmitVars.message = string2;
                        } else if (string.equals("sym")) {
                            n2 = Integer.parseInt(string2);
                        }
                    }
                }
                ++n5;
            }
            LogSystem.log(1, oASubmitVars.toString());
            OAReturnVars oAReturnVars = logicAPI.dispatch(oASubmitVars, n2);
            LogSystem.log(1, oAReturnVars.toString());
        }
        catch (Throwable throwable) {
            LogSystem.log(1, "OA LogicAPI main exception: " + throwable.toString() + "\nOA LogicAPI main exception detail:" + throwable.getMessage());
            return;
        }
        long l2 = System.currentTimeMillis();
        LogSystem.log(1, "Run time: " + (l2 - l) + " msec");
    }

    public LogicAPI(int n, int n2, String string, Properties properties, Properties properties2) {
        Object object;
        Closeable closeable;
        Object object2;
        Object object3;
        boolean bl = false;
        if (string != null && string.length() > 0) {
            this.sessionPath = string;
        }
        this.logFile = this.sessionPath + this.logFile;
        String string2 = this.getCalDateTime();
        try {
            LogSystem.beginLogSection("LogicAPI starting/continuing... " + n + "." + n2 + " " + string2);
            if (FileUtil.exists(this.logFile)) {
                FileUtil.appendToFile(this.logFile, "LogicAPI continuing " + n + "." + n2 + " " + string2 + "\n");
            } else {
                FileUtil.saveFile(this.logFile, "LogicAPI starting " + n + "." + n2 + " " + string2 + "\n");
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, "LogicAPI/timeStr: Log File appendTo/saveFile took Exception.");
            LogSystem.log(1, exception);
        }
        try {
            if (this.preanswerLists == null) {
                this.preanswerLists = StandardPropertyLoader.load("com/ibm/nzna/properties/servlet/oa/LogicAPI");
            }
            if (this.myDebug) {
                if (this.preanswerLists != null) {
                    LogSystem.log(10, "LogicAPI init -- " + this.preanswerLists.size() + " properties loaded.");
                } else {
                    LogSystem.log(10, "LogicAPI init -- NO properties loaded.");
                }
            }
        }
        catch (Exception exception) {
            try {
                FileUtil.appendToFile(this.logFile, "LogicAPI/properties: Std. Prop. loader took Exception.");
                LogSystem.log(1, "LogicAPI/properties: Std. Prop. loader took Exception.");
            }
            catch (Exception exception2) {
                LogSystem.log(1, "LogicAPI/properties: Std. Prop. loader took Exception.");
                LogSystem.log(1, exception);
            }
        }
        this.countryMapping = properties;
        this.languageMapping = properties2;
        try {
            object3 = new FileInputStream(this.sessionPath + this.sessionIndex);
            object2 = new ObjectInputStream((InputStream)object3);
            this.index = (Hashtable)((ObjectInputStream)object2).readObject();
            ((ObjectInputStream)object2).close();
            this.curSessionInd = (Integer)this.index.get(this.curSessionKey);
        }
        catch (Exception exception) {
            if (n != 0) {
                this.curSessionInd = new Integer(n);
                this.index.put(this.curSessionInd, new Long(System.currentTimeMillis()));
                this.index.put(this.curSessionKey, this.curSessionInd);
                LogSystem.log(1, "LogicAPI: Couldn't find the expected index of sessions.  Attempting to start over on this session.");
                LogSystem.log(1, exception);
                try {
                    FileUtil.appendToFile(this.logFile, "Error Encountered - no index of sessions - " + n + "." + n2 + "\n");
                    LogSystem.log(1, "Error Encountered - no index of sessions - " + n + "." + n2 + "\n");
                }
                catch (Exception exception3) {
                    LogSystem.log(1, "LogicAPI/index: Log File appendToFile took Exception.");
                    LogSystem.log(1, exception3);
                }
                object2 = this.index;
                synchronized (object2) {
                    try {
                        closeable = new FileOutputStream(this.sessionPath + this.sessionIndex);
                        object = new ObjectOutputStream((OutputStream)closeable);
                        ((ObjectOutputStream)object).writeObject(this.index);
                        ((ObjectOutputStream)object).flush();
                        ((ObjectOutputStream)object).close();
                    }
                    catch (Exception exception4) {
                        LogSystem.log(1, "LogicAPI: I/O Error creating new " + "index hashtable object (errorIndex): " + this.sessionIndex + " - " + this.curSessionFile + " - " + exception4.toString());
                    }
                }
            }
            bl = true;
        }
        if (n == 0) {
            Closeable closeable2;
            if (bl) {
                object3 = this.index;
                synchronized (object3) {
                    try {
                        this.index.put(this.curSessionInd, new Long(System.currentTimeMillis()));
                        this.index.put(this.curSessionKey, this.curSessionInd);
                        closeable2 = new FileOutputStream(this.sessionPath + this.sessionIndex);
                        closeable = new ObjectOutputStream((OutputStream)closeable2);
                        ((ObjectOutputStream)closeable).writeObject(this.index);
                        ((ObjectOutputStream)closeable).flush();
                        ((ObjectOutputStream)closeable).close();
                    }
                    catch (Exception exception) {
                        LogSystem.log(1, "LogicAPI: I/O Error creating new " + "index hashtable object (newIndex): " + this.sessionIndex + " - " + this.curSessionFile + " - " + exception.toString());
                        LogSystem.log(1, exception);
                        try {
                            FileUtil.appendToFile(this.logFile, "Error Encountered - new index - " + n + "." + n2 + " - " + this.curSessionFile + " - " + exception.toString() + "\n");
                            LogSystem.log(1, "Error Encountered - new index - " + n + "." + n2 + " - " + this.curSessionFile + " - " + exception.toString() + "\n");
                            LogSystem.log(1, exception);
                        }
                        catch (Exception exception5) {
                            LogSystem.log(1, "LogicAPI/newIndex: Log File appendToFile took Exception.");
                            LogSystem.log(1, exception5);
                        }
                    }
                }
            }
            object3 = this.index;
            synchronized (object3) {
                try {
                    closeable2 = new FileInputStream(this.sessionPath + this.sessionIndex);
                    closeable = new ObjectInputStream((InputStream)closeable2);
                    this.index = (Hashtable)((ObjectInputStream)closeable).readObject();
                    ((ObjectInputStream)closeable).close();
                    this.curSessionInd = new Integer((Integer)this.index.get(this.curSessionKey) + 1);
                    if (this.index.get(this.curSessionInd) != null) {
                        object = this.curSessionInd.toString() + "." + ((Long)this.index.get(this.curSessionInd)).toString();
                        int n3 = 0;
                        try {
                            n3 = 0;
                            while (n3 < 9999) {
                                File file = new File(this.sessionPath, (String)object + "." + n3);
                                file.delete();
                                ++n3;
                            }
                        }
                        catch (Exception exception) {
                            LogSystem.log(1, "LogicAPI: Cleanup ended deleting old session=" + n3);
                            try {
                                FileUtil.appendToFile(this.logFile, "Cleanup - " + this.curSessionInd.toString() + "." + n3 + "\n");
                                LogSystem.log(1, "Cleanup - " + this.curSessionInd.toString() + "." + n3 + "\n");
                            }
                            catch (Exception exception6) {
                                LogSystem.log(1, "LogicAPI/cleanup: Log File appendToFile took Exception.");
                                LogSystem.log(1, exception6);
                            }
                        }
                    }
                    this.index.put(this.curSessionInd, new Long(System.currentTimeMillis()));
                    this.index.put(this.curSessionKey, this.curSessionInd);
                    object = new FileOutputStream(this.sessionPath + this.sessionIndex);
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
                    objectOutputStream.writeObject(this.index);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                }
                catch (Exception exception) {
                    LogSystem.log(1, "LogicAPI: I/O Error creating new " + "index hashtable object (update): " + this.sessionPath + this.sessionIndex + " - " + exception.toString());
                    try {
                        FileUtil.appendToFile(this.logFile, "Error Encountered - new hashtable - " + this.sessionPath + this.sessionIndex + " - " + exception.toString() + "\n");
                        LogSystem.log(1, "Error Encountered - new hashtable - " + this.sessionPath + this.sessionIndex + " - " + exception.toString() + "\n");
                    }
                    catch (Exception exception7) {
                        LogSystem.log(1, "LogicAPI/updateIndex: Log File appendToFile took Exception.");
                        LogSystem.log(1, exception7);
                    }
                }
            }
            try {
                object3 = new OASessionState(this.curSessionInd);
                this.curSessionBase = this.sessionPath + this.curSessionInd.toString() + "." + ((Long)this.index.get(this.curSessionInd)).toString();
                this.curSessionFile = this.curSessionBase + ".0";
                object2 = new FileOutputStream(this.curSessionFile);
                closeable2 = new ObjectOutputStream((OutputStream)object2);
                ((ObjectOutputStream)closeable2).writeObject(object3);
                ((ObjectOutputStream)closeable2).flush();
                ((ObjectOutputStream)closeable2).close();
            }
            catch (Exception exception) {
                LogSystem.log(1, "LogicAPI: I/O Error creating new " + "saved session state object: " + this.curSessionFile + " - " + exception.toString());
                try {
                    FileUtil.appendToFile(this.logFile, "Error Encountered - " + this.curSessionFile + " - " + exception.toString() + "\n");
                    LogSystem.log(1, "Error Encountered - " + this.curSessionFile + " - " + exception.toString() + "\n");
                }
                catch (Exception exception8) {
                    LogSystem.log(1, "LogicAPI/saveNewState: Log File appendToFile took Exception.");
                    LogSystem.log(1, exception8);
                }
            }
        } else {
            this.curSessionBase = this.sessionPath + this.curSessionInd.toString() + "." + ((Long)this.index.get(this.curSessionInd)).toString();
            this.curSessionFile = this.curSessionBase + "." + n2;
        }
    }
}

