/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.oa.engine;

import com.ibm.nzna.projects.common.quest.oa.Action;
import com.ibm.nzna.projects.common.quest.oa.Answer;
import com.ibm.nzna.projects.common.quest.oa.AnswerConcl;
import com.ibm.nzna.projects.common.quest.oa.Conditions;
import com.ibm.nzna.projects.common.quest.oa.Edge;
import com.ibm.nzna.projects.common.quest.oa.EdgeAlist;
import com.ibm.nzna.projects.common.quest.oa.EdgeObject;
import com.ibm.nzna.projects.common.quest.oa.EdgePreanswer;
import com.ibm.nzna.projects.common.quest.oa.EdgeReturn;
import com.ibm.nzna.projects.common.quest.oa.EdgeUnanswer;
import com.ibm.nzna.projects.common.quest.oa.Node;
import com.ibm.nzna.projects.common.quest.oa.Question;
import com.ibm.nzna.projects.common.quest.oa.Symptom;
import com.ibm.nzna.projects.oa.engine.DBAPI;
import com.ibm.nzna.projects.oa.engine.OAMemoryInterface;
import com.ibm.nzna.projects.oa.engine.OAReturnVars;
import com.ibm.nzna.projects.oa.engine.OASessionState;
import com.ibm.nzna.shared.util.LogSystem;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class OAEngine {
    DBAPI dba = null;
    int sym_loop = 0;
    boolean Debug = true;
    int debugLevel = 10;
    String warnings = "";

    public OAReturnVars processNode(OASessionState oASessionState) throws Exception {
        Object object;
        Hashtable hashtable;
        Node node;
        Edge edge;
        OAReturnVars oAReturnVars;
        int n;
        int n2;
        block55: {
            Node node2;
            block54: {
                n2 = oASessionState.getCurrentNode();
                n = oASessionState.getCurrentResponse();
                oAReturnVars = null;
                edge = null;
                node2 = null;
                if (this.Debug) {
                    LogSystem.log(this.debugLevel, "Engine: source flag = " + oASessionState.getSourceFlag());
                }
                Symptom symptom = this.dba.getSymptomObject(n2, oASessionState);
                try {
                    node2 = this.dba.getNodeByInd(n2, symptom);
                }
                catch (Exception exception) {
                    if (exception == null) break block54;
                    oAReturnVars = this.displayError(2, oASessionState);
                    return oAReturnVars;
                }
            }
            if (this.Debug) {
                LogSystem.log(this.debugLevel, "Engine: process current node = " + n2 + " and response = " + n);
            }
            node = null;
            if (n2 != 0 && n != 0) {
                oASessionState.addHistoryItem(n2, this.dba.getOAObjectIndForNode(node2, oASessionState), n);
            }
            if (n2 != 0) {
                try {
                    this.updateConclusions(node2, oASessionState);
                }
                catch (Exception exception) {
                    if (exception == null) break block55;
                    oAReturnVars = this.displayError(2, oASessionState);
                    return oAReturnVars;
                }
            }
        }
        oASessionState.setPreviousNode(n2);
        oASessionState.setPreviousResponse(n);
        Symptom symptom = this.dba.getSymptomObject(n2, oASessionState);
        if (n2 == 0) {
            block56: {
                try {
                    node = this.dba.getRootNode(symptom, oASessionState);
                }
                catch (Exception exception) {
                    if (exception == null) break block56;
                    this.warnings = this.warnings + " -- No root node for " + symptom;
                    oAReturnVars = this.displayError(1, oASessionState);
                    return oAReturnVars;
                }
            }
            if (this.Debug) {
                LogSystem.log(this.debugLevel, "Engine: RootNode received " + (node != null ? " (non-null)" : " NULL!"));
            }
            if (node == null) {
                this.warnings = this.warnings + " -- No root node for " + symptom;
            }
            hashtable = this.dba.getProductConclusionsForNewSym(oASessionState);
            if (this.Debug) {
                LogSystem.log(this.debugLevel, "Engine: Preanswers for this product are " + hashtable);
            }
            this.processPreanswers(hashtable, oASessionState);
        } else {
            Cloneable cloneable;
            if (this.Debug) {
                LogSystem.log(1, "Engine: Current Response = " + n);
            }
            hashtable = this.dba.getEdgesForNodeAndAnswer(oASessionState);
            object = hashtable.keys();
            int n3 = oASessionState.getDocClassInd();
            boolean bl = false;
            while (object.hasMoreElements() && !bl) {
                edge = (Edge)object.nextElement();
                if (!this.dba.isDocClassIndMatch(this.dba.getEdgeDocClassInd(edge), oASessionState)) continue;
                if (this.Debug) {
                    LogSystem.log(1, "Engine: Passed docClass " + this.dba.getEdgeDocClassInd(edge));
                }
                if (!this.dba.checkCountryForEdge(edge, oASessionState)) continue;
                cloneable = edge.getConditions();
                if (this.Debug) {
                    LogSystem.log(1, "Engine: Passed CountryCode");
                }
                if (!this.dba.areConditionsValid((Conditions)cloneable, oASessionState)) continue;
                this.processOtherEdges(oASessionState, edge);
                node = (Node)hashtable.get(edge);
                bl = true;
                if (this.Debug) {
                    LogSystem.log(1, "Engine: Next node to traverse is " + node.getInd() + " / Edge " + edge + " / node " + node + " / value of find " + bl);
                }
                if (node != null) continue;
                this.warnings = this.warnings + " -- No node for edge " + edge;
                if (!this.Debug) continue;
                LogSystem.log(1, "Engine: WARNING: There is no Node for this edge");
            }
            if (!bl) {
                if (this.Debug) {
                    LogSystem.log(1, "Engine: checking Other nodes");
                }
                cloneable = this.dba.getOtherEdgesForNode(oASessionState);
                if (this.Debug) {
                    LogSystem.log(1, "Engine: Other edges hashtable " + cloneable);
                }
                object = ((Hashtable)cloneable).keys();
                while (object.hasMoreElements() && !bl) {
                    edge = (Edge)object.nextElement();
                    if (!this.dba.isDocClassIndMatch(this.dba.getEdgeDocClassInd(edge), oASessionState)) continue;
                    if (this.Debug) {
                        LogSystem.log(1, "Engine: Passed docClass" + this.dba.getEdgeDocClassInd(edge));
                    }
                    if (!this.dba.checkCountryForEdge(edge, oASessionState)) continue;
                    Conditions conditions = edge.getConditions();
                    if (this.Debug) {
                        LogSystem.log(1, "Engine: Passed CountryCode");
                    }
                    if (!this.dba.areConditionsValid(conditions, oASessionState)) continue;
                    this.processOtherEdges(oASessionState, edge);
                    node = (Node)((Hashtable)cloneable).get(edge);
                    bl = true;
                    if (!this.Debug) continue;
                    LogSystem.log(1, "Engine: The Node is ---- " + node);
                    if (node != null) continue;
                    LogSystem.log(1, "Engine: WARNING: There is no Node for this edge");
                }
                if (node == null) {
                    this.warnings = this.warnings + " -- No nodes for edges " + cloneable;
                }
                if (this.Debug) {
                    LogSystem.log(1, "Engine: Other Node is **** " + node);
                    if (node == null) {
                        LogSystem.log(1, "Engine: ERROR: There are no Other nodes for this edge ");
                    }
                }
            }
        }
        if (node == null) {
            return this.displayError(1, oASessionState);
        }
        if (this.Debug) {
            LogSystem.log(1, "Engine: Check for symptom node");
        }
        if (node.getNodeType() == 2) {
            if (this.Debug) {
                LogSystem.log(1, "Engine: This is a symptom Node -- Jumping.");
            }
            symptom = this.symptomJump(oASessionState, node);
            oASessionState.setCurrentNode(0);
            oAReturnVars = this.processNode(oASessionState);
            oASessionState.setCurrentNode(oAReturnVars.nodeInd);
            if (this.Debug) {
                LogSystem.log(1, "Engine: After Jumping, node is " + oAReturnVars.nodeInd);
            }
            return oAReturnVars;
        }
        if (this.Debug) {
            LogSystem.log(1, "Engine: Check for question node");
        }
        if (node.getNodeType() == 1) {
            int n4 = this.dba.getOAObjectIndForNode(node, oASessionState);
            if (oASessionState.isAnswered(n4)) {
                oASessionState.setCurrentResponse(oASessionState.getAnswer(n4));
                if (this.Debug) {
                    LogSystem.log(1, "Engine: Question Node is preanswered, processing...");
                }
                oASessionState.setCurrentNode(node.getInd());
                oAReturnVars = this.processNode(oASessionState);
                oASessionState.setCurrentNode(oAReturnVars.nodeInd);
                if (this.Debug) {
                    LogSystem.log(1, "Engine: After pre-answer, node is " + oAReturnVars.nodeInd);
                }
                return oAReturnVars;
            }
            object = this.dba.getQuestionByInd(n4, node.getInd(), oASessionState);
            if (this.Debug) {
                LogSystem.log(1, "Engine: This is a Question Node.");
            }
            oAReturnVars = this.processOAReturnVarsForQuestion((Question)object, node, oASessionState);
            oASessionState.setCurrentNode(oAReturnVars.nodeInd);
        }
        if (this.Debug) {
            LogSystem.log(1, "Engine: Check for Action");
        }
        if (node.getNodeType() == 0) {
            int n5 = this.dba.getOAObjectIndForNode(node, oASessionState);
            object = this.dba.getActionByInd(n5, node.getInd(), oASessionState);
            oAReturnVars = this.processOAReturnVarsForAction((Action)object, node, oASessionState);
            if (this.Debug) {
                LogSystem.log(1, "Engine: This is an Action Node.");
            }
        }
        if (node.getNodeType() == 5) {
            if (this.Debug) {
                LogSystem.log(1, "Engine: Inside node_type_return loop");
            }
            if (this.sym_loop < 100) {
                this.symptomReturn(oASessionState);
                EdgeReturn edgeReturn = edge.getReturnNode();
                if (edgeReturn != null) {
                    int n6 = edgeReturn.getNodeInd();
                    oASessionState.setCurrentNode(n6);
                }
                oAReturnVars = this.processNode(oASessionState);
            } else {
                if (this.Debug) {
                    LogSystem.log(1, "Engine: error in return node loop");
                }
                oAReturnVars = this.displayError(3, oASessionState);
            }
        }
        if (this.Debug) {
            LogSystem.log(1, "Engine: Check Resolved/Unresolved/Alist.");
        }
        if (node.getNodeType() == 3) {
            String string = "<OARESOLVED>";
            oAReturnVars = this.processOAReturnVarsForSpNode(node, string, oASessionState);
        }
        if (node.getNodeType() == 4) {
            String string = "<OAUNRESOLVED>";
            oAReturnVars = this.processOAReturnVarsForSpNode(node, string, oASessionState);
        }
        if (node.getNodeType() == 6) {
            oAReturnVars = this.processOAReturnVarsForAlistNode(node, oASessionState);
        }
        if (this.Debug) {
            LogSystem.log(1, "Engine: Nextnode returned back to LogicAPI = " + oAReturnVars);
        }
        return oAReturnVars;
    }

    public void processOtherEdges(OASessionState oASessionState, Edge edge) throws Exception {
        int n;
        EdgeObject edgeObject;
        Vector vector = this.dba.getPreanswers(edge);
        int n2 = 0;
        while (n2 < vector.size()) {
            edgeObject = (EdgePreanswer)vector.elementAt(n2);
            n = this.dba.getQuestionForEdgePreanswer((EdgePreanswer)edgeObject, oASessionState);
            int n3 = this.dba.getAnswerForEdgePreanswer((EdgePreanswer)edgeObject, oASessionState);
            oASessionState.addPreanswerItem(n, n3);
            ++n2;
        }
        Vector vector2 = this.dba.getUnanswers(edge);
        n2 = 0;
        while (n2 < vector2.size()) {
            edgeObject = (EdgeUnanswer)vector2.elementAt(n2);
            n = this.dba.getQuestionForEdgeUnanswer((EdgeUnanswer)edgeObject, oASessionState);
            oASessionState.removePreanswerItem(n);
            ++n2;
        }
        Vector vector3 = this.dba.getActionListsForEdge(edge);
        n2 = 0;
        while (n2 < vector3.size()) {
            edgeObject = (EdgeAlist)vector3.elementAt(n2);
            n = this.dba.getActionForEdgeAlist((EdgeAlist)edgeObject, oASessionState);
            oASessionState.addActionListItem(n);
            ++n2;
        }
        if (this.Debug) {
            LogSystem.log(1, "Engine/processOtherEdges: After processing, preanswers: " + oASessionState.getPreanswerString() + ", actionlist: " + oASessionState.getActionListString());
        }
    }

    public Symptom symptomJump(OASessionState oASessionState, Node node) throws Exception {
        int n = oASessionState.getCurrentNode();
        int n2 = oASessionState.getCurrentResponse();
        int n3 = this.dba.getOAObjectIndForNode(node, oASessionState);
        oASessionState.setCurrentSymptom(n3);
        Symptom symptom = this.dba.getSymptomObject(n, oASessionState);
        return symptom;
    }

    public void symptomReturn(OASessionState oASessionState) throws Exception {
        int n = 0;
        n = oASessionState.popSymptom();
        oASessionState.setCurrentSymptom(n);
        oASessionState.setCurrentNode(0);
        oASessionState.setCurrentResponse(0);
    }

    public void updateConclusions(Node node, OASessionState oASessionState) throws Exception {
        AnswerConcl answerConcl = null;
        int n = this.dba.getOAObjectIndForNode(node, oASessionState);
        int n2 = oASessionState.getCurrentResponse();
        Question question = this.dba.getQuestionByInd(n, node.getInd(), oASessionState);
        Answer answer = this.dba.getAnswerByInd(n, node.getInd(), n2, oASessionState);
        if (this.Debug) {
            LogSystem.log(1, "Engine/Update: Updating Conclusions -- questionInd = " + n);
        }
        if (this.Debug) {
            LogSystem.log(1, "Engine/Update: answerInd = " + n2);
        }
        if (answer != null) {
            Vector vector = answer.getConclusions();
            int n3 = 0;
            while (n3 < vector.size()) {
                Conditions conditions;
                answerConcl = (AnswerConcl)vector.elementAt(n3);
                if (this.dba.isDocClassIndMatch(this.dba.getAnswerConclDocClassInd(answerConcl), oASessionState) && this.dba.checkCountryForAnswerConcl(answerConcl, oASessionState) && this.dba.areConditionsValid(conditions = answerConcl.getConditions(), oASessionState)) {
                    int n4 = this.dba.getQuestionForConclusion(answerConcl);
                    int n5 = this.dba.getAnswerForConclusion(answerConcl);
                    oASessionState.addPreanswerItem(n4, n5);
                }
                ++n3;
            }
        }
        if (this.Debug) {
            LogSystem.log(1, "Engine/Update: After updateConclusions, preanswers: " + oASessionState.getPreanswerString() + ", actionlist: " + oASessionState.getActionListString());
        }
    }

    public OAReturnVars processOAReturnVarsForAction(Action action, Node node, OASessionState oASessionState) throws Exception {
        OAReturnVars oAReturnVars = new OAReturnVars(oASessionState.getSessionId());
        oAReturnVars.addInfo = this.dba.getAddInfoStringForAction(action, oASessionState);
        oAReturnVars.linkTitles = this.dba.getLinkTitlesForAction(action, oASessionState);
        oAReturnVars.linkURLs = this.dba.getLinkURLsForAction(action, oASessionState);
        oAReturnVars.title = this.dba.getTitleStringForAction(action, oASessionState);
        oAReturnVars.objectInd = oASessionState.getCurrentSymptom();
        oAReturnVars.nodeInd = node.getInd();
        oAReturnVars.node_flag = oASessionState.getNodeFlag();
        oAReturnVars.sessionSeqNo = oASessionState.getCurrentSeqNo();
        return oAReturnVars;
    }

    public OAReturnVars processOAReturnVarsForQuestion(Question question, Node node, OASessionState oASessionState) throws Exception {
        OAReturnVars oAReturnVars = new OAReturnVars(oASessionState.getSessionId());
        oAReturnVars.addInfo = this.dba.getAddInfoStringForQuestion(question, oASessionState);
        oAReturnVars.linkTitles = this.dba.getLinkTitlesForQuestion(question, oASessionState);
        oAReturnVars.title = this.dba.getTitleStringForQuestion(question, oASessionState);
        oAReturnVars.linkURLs = this.dba.getLinkURLsForQuestion(question, oASessionState);
        oAReturnVars.answerTitles = this.getAnswerTitlesForQuestion(question, node.getInd(), oASessionState);
        oAReturnVars.answerInds = this.getAnswerIndsForQuestion(question, node.getInd(), oASessionState);
        oAReturnVars.objectInd = oASessionState.getCurrentSymptom();
        oAReturnVars.nodeInd = node.getInd();
        oAReturnVars.node_flag = oASessionState.getNodeFlag();
        oAReturnVars.sessionSeqNo = oASessionState.getCurrentSeqNo();
        return oAReturnVars;
    }

    public Vector getAnswerTitlesForQuestion(Question question, int n, OASessionState oASessionState) throws Exception {
        int n2 = this.dba.getQuestionInd(question, oASessionState);
        Hashtable hashtable = this.dba.getTitlesForValidAnswers(n2, n, oASessionState);
        Vector vector = new Vector();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public Vector getAnswerIndsForQuestion(Question question, int n, OASessionState oASessionState) throws Exception {
        int n2 = this.dba.getQuestionInd(question, oASessionState);
        Hashtable hashtable = this.dba.getTitlesForValidAnswers(n2, n, oASessionState);
        Vector vector = new Vector();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public OAReturnVars processOAReturnVarsForSpNode(Node node, String string, OASessionState oASessionState) throws Exception {
        OAReturnVars oAReturnVars = new OAReturnVars(oASessionState.getSessionId());
        oAReturnVars.addInfo = string;
        oAReturnVars.nodeInd = node.getInd();
        oAReturnVars.node_flag = oASessionState.getNodeFlag();
        oAReturnVars.sessionSeqNo = oASessionState.getCurrentSeqNo();
        return oAReturnVars;
    }

    public OAReturnVars processOAReturnVarsForAlistNode(Node node, OASessionState oASessionState) throws Exception {
        OAReturnVars oAReturnVars = new OAReturnVars(oASessionState.getSessionId());
        int n = node.getInd();
        oAReturnVars.actionInds = this.getActionIndsForAlistNode(oASessionState);
        oAReturnVars.actionTitles = this.getActionTitlesForAlistNode(n, oASessionState);
        oAReturnVars.linkTitles = this.getLinkTitlesForAlistNode(n, oASessionState);
        oAReturnVars.linkURLs = this.getLinkURLsForAlistNode(n, oASessionState);
        oAReturnVars.nodeInd = node.getInd();
        oAReturnVars.node_flag = oASessionState.getNodeFlag();
        oAReturnVars.sessionSeqNo = oASessionState.getCurrentSeqNo();
        return oAReturnVars;
    }

    public OAReturnVars displayHistory(OASessionState oASessionState) throws Exception {
        OAReturnVars oAReturnVars = new OAReturnVars(oASessionState.getSessionId());
        oAReturnVars.title = "Please select the question to which you would like to return:";
        oAReturnVars.addInfo = this.getHistoryAsString(oASessionState);
        oAReturnVars.nodeInd = oASessionState.getCurrentNode();
        oAReturnVars.node_flag = oASessionState.getNodeFlag();
        oAReturnVars.sessionSeqNo = oASessionState.getCurrentSeqNo();
        return oAReturnVars;
    }

    public OAReturnVars displayError(int n, OASessionState oASessionState) throws Exception {
        String string;
        OAReturnVars oAReturnVars = new OAReturnVars(oASessionState.getSessionId());
        oAReturnVars.title = string = "THE ONLINE ASSISTANT ENCOUNTERED AN ERROR";
        switch (n) {
            case 1: {
                oAReturnVars.addInfo = "<!-- Node could not be found for this Symptom Indicator" + " -- possibly wrong SymInd or data error or no" + " rootnode for this symptom " + this.warnings + oASessionState.toString() + " -->";
                break;
            }
            case 2: {
                oAReturnVars.addInfo = "<!-- Node indicator is not valid or it doesn't have" + " a corresponding object in database " + this.warnings + oASessionState.toString() + " -->";
                break;
            }
            case 3: {
                oAReturnVars.addInfo = "<!-- Infinite loop looking for return node " + oASessionState.toString() + " -->";
                break;
            }
            default: {
                oAReturnVars.addInfo = "<!-- OAEngine failed -- unknown error type" + this.warnings + oASessionState.toString() + " -->";
            }
        }
        oAReturnVars.node_flag = oASessionState.getNodeFlag();
        oAReturnVars.sessionSeqNo = oASessionState.getCurrentSeqNo();
        return oAReturnVars;
    }

    public String getHistoryAsString(OASessionState oASessionState) throws Exception {
        Vector vector = oASessionState.getQuestionHistory();
        Vector vector2 = oASessionState.getAnswerHistory();
        Vector vector3 = oASessionState.getNodeHistory();
        Vector vector4 = oASessionState.getSequenceHistory();
        String string = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        Question question = null;
        Answer answer = null;
        if (this.Debug && (vector.size() != vector2.size() || vector.size() != vector4.size())) {
            LogSystem.log(1, "Engine/getHist: vector size mismatch");
        }
        int n6 = 0;
        while (n6 < vector.size()) {
            if (n6 >= vector2.size() || n6 >= vector4.size()) break;
            n = (Integer)vector.elementAt(n6);
            n2 = (Integer)vector2.elementAt(n6);
            n3 = (Integer)vector3.elementAt(n6);
            n4 = (Integer)vector4.elementAt(n6);
            if (n4 != n5) {
                n5 = n4;
                question = this.dba.getQuestionByInd(n, n3, oASessionState);
                answer = this.dba.getAnswerByInd(n, n3, n2, oASessionState);
                string = string + "<Question " + n + ">";
                string = string + this.dba.getTitleStringForQuestion(question, oASessionState);
                string = string + "<Answer " + n2 + ">";
                string = string + this.dba.getTitleStringForAnswer(answer, oASessionState);
            }
            ++n6;
        }
        if (this.Debug) {
            LogSystem.log(1, "Engine/getHist: The history for this session is " + string);
        }
        return string;
    }

    public Vector getActionTitlesForAlistNode(int n, OASessionState oASessionState) throws Exception {
        String string = "";
        Enumeration enumeration = oASessionState.getActionList();
        Vector vector = null;
        while (enumeration.hasMoreElements()) {
            int n2 = (Integer)enumeration.nextElement();
            Action action = this.dba.getActionByInd(n2, n, oASessionState);
            vector.addElement(this.dba.getTitleStringForAction(action, oASessionState));
        }
        return vector;
    }

    public Vector getActionIndsForAlistNode(OASessionState oASessionState) throws Exception {
        String string = "";
        Enumeration enumeration = oASessionState.getActionList();
        Vector vector = null;
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public Vector getLinkTitlesForAlistNode(int n, OASessionState oASessionState) throws Exception {
        String string = "";
        Enumeration enumeration = oASessionState.getActionList();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            int n2 = (Integer)enumeration.nextElement();
            Action action = this.dba.getActionByInd(n2, n, oASessionState);
            this.dba.concatenateTwoVectors(vector, this.dba.getLinkTitlesForAction(action, oASessionState));
        }
        return vector;
    }

    public Vector getLinkURLsForAlistNode(int n, OASessionState oASessionState) throws Exception {
        String string = "";
        Enumeration enumeration = oASessionState.getActionList();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            int n2 = (Integer)enumeration.nextElement();
            Action action = this.dba.getActionByInd(n2, n, oASessionState);
            this.dba.concatenateTwoVectors(vector, this.dba.getLinkURLsForAction(action, oASessionState));
        }
        return vector;
    }

    public String getSymptomTitleAsString(OASessionState oASessionState) throws Exception {
        Vector vector = oASessionState.getNodeHistory();
        Vector vector2 = oASessionState.getSymptomHistory();
        int n = oASessionState.getCurrentSymptom();
        int n2 = 0;
        int n3 = 0;
        while (n3 < vector2.size()) {
            if (n3 >= vector.size()) break;
            if ((Integer)vector2.elementAt(n3) == n) {
                n2 = (Integer)vector.elementAt(n3);
                break;
            }
            ++n3;
        }
        if (n2 == 0) {
            return "";
        }
        return this.dba.getTitleForCurrentSymptom(n2, oASessionState);
    }

    public void processPreanswers(Hashtable hashtable, OASessionState oASessionState) throws Exception {
        Enumeration enumeration = hashtable.keys();
        Enumeration enumeration2 = hashtable.elements();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < hashtable.size()) {
            n = (Integer)enumeration.nextElement();
            n2 = (Integer)enumeration2.nextElement();
            oASessionState.addPreanswerItem(n, n2);
            ++n3;
        }
        if (this.Debug) {
            LogSystem.log(1, "Engine/processPreanswers: After processing, preanswers: " + oASessionState.getPreanswerString() + ", actionlist: " + oASessionState.getActionListString());
        }
    }

    public String getThreeCharCountryCode(OASessionState oASessionState, String string, String string2, String string3, String string4, String string5) throws Exception {
        String string6 = this.dba.getCLIOCountryCodeForCustNum(oASessionState.getCustNum(), string, string2, string3, string4, string5);
        return string6;
    }

    public void getLanguageIndandSet(String string, OASessionState oASessionState) throws Exception {
        int n = this.dba.getLangIndFromDatabase(string);
        oASessionState.setLanguage(n);
    }

    public OAEngine(String string, String string2, String string3, String string4, String string5, OAMemoryInterface oAMemoryInterface, String string6, boolean bl) throws Exception {
        if (this.Debug) {
            LogSystem.log(this.debugLevel, "Engine: OAEngine constructor.");
        }
        this.dba = new DBAPI(string, string2, string3, string4, string5, oAMemoryInterface, string6, bl);
    }
}

