/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qQuestStats;

import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.LogSystem;
import java.sql.ResultSet;
import java.sql.Statement;

public class QQuestStats {
    private String databaseName = "quest";
    private String databasePort = null;
    private String databaseServer = "localhost";

    public static void main(String[] stringArray) {
        new QQuestStats(stringArray);
    }

    private final boolean processParams(String[] stringArray) {
        boolean bl = false;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    if (stringArray[n].toUpperCase().startsWith("/S:")) {
                        this.databaseServer = stringArray[n].substring(3);
                    } else if (stringArray[n].toUpperCase().startsWith("/D:")) {
                        this.databaseName = stringArray[n].substring(3);
                    } else if (stringArray[n].toUpperCase().startsWith("/P:")) {
                        this.databasePort = stringArray[n].substring(3);
                    }
                }
                ++n;
            }
        }
        LogSystem.log(1, "Command Line Paremeters Read. Program Variables:");
        LogSystem.log(1, "Database Name  :" + this.databaseName);
        LogSystem.log(1, "Database Server:" + this.databaseServer);
        LogSystem.log(1, "Database Port  :" + this.databasePort);
        LogSystem.log(1, "\n\n");
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean connectToDatabase() {
        boolean bl = false;
        try {
            new DatabaseSystem(true, LogSystem.getInstance(), this.databasePort == null);
            bl = DatabaseSystem.createConnection(1, this.databaseName, this.databaseServer, this.databasePort, "quest", "j0hnny");
            if (!bl) return bl;
            LogSystem.log(2, "Connection Established");
            return bl;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void updateStat(String string, String string2) {
        SQLMethod sQLMethod = new SQLMethod(1, "updateStat", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            statement.executeUpdate("DELETE FROM TIGRIS.CONSTANTS WHERE CONSTANT = '" + string + "'");
            statement.executeUpdate("INSERT INTO TIGRIS.CONSTANTS VALUES " + "( '" + string + "', " + "  0, " + "  '" + string2 + "', " + "  'QQuestStats', " + "  'QUEST', " + "  CURRENT TIMESTAMP)");
            statement.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void setStatDate() {
        SQLMethod sQLMethod = new SQLMethod(1, "setStatDate", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            statement.executeUpdate("DELETE FROM TIGRIS.CONSTANTS WHERE CONSTANT = 'QQ_STAT_DATE'");
            statement.executeUpdate("INSERT INTO TIGRIS.CONSTANTS VALUES " + "( 'QQ_STAT_DATE', " + "  0, " + "  CURRENT DATE, " + "  'QQuestStats', " + "  'QUEST', " + "  CURRENT TIMESTAMP)");
            statement.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void setDocumentStats() {
        SQLMethod sQLMethod = new SQLMethod(1, "setDocumentStats", 5);
        try {
            CDate cDate = new CDate();
            Statement statement = sQLMethod.createStatement();
            int n = cDate.getYear();
            int n2 = cDate.getMonth();
            int n3 = cDate.getDayOfMonth();
            int n4 = n3 - CDate.getDayOfWeek(cDate.today(), 2);
            ResultSet resultSet = null;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            if (n4 == 0) {
                n4 = 1;
            }
            LogSystem.beginLogSection("Document Statistics");
            resultSet = statement.executeQuery("SELECT COUNT(*) FROM TIGRIS.DOCUMENTS " + "WHERE CHANGEDTIME > '" + n + "-01-01-01.00.00.000000' AND " + "      RECYCLED = 'N' AND " + "      PUBLISH  = 'Y'");
            if (resultSet.next()) {
                n5 = resultSet.getInt(1);
            }
            LogSystem.log(1, "docsPublishedThisYear:" + n5);
            resultSet.close();
            resultSet = statement.executeQuery("SELECT COUNT(*) FROM TIGRIS.DOCUMENTS " + "WHERE CHANGEDTIME > '" + n + "-" + CDate.format2Digit(n2) + "-01-01.00.00.000000' AND " + "      RECYCLED = 'N' AND " + "      PUBLISH  = 'Y'");
            if (resultSet.next()) {
                n6 = resultSet.getInt(1);
            }
            LogSystem.log(1, "docsPublishedThisMonth:" + n6);
            resultSet = statement.executeQuery("SELECT COUNT(*) FROM TIGRIS.DOCUMENTS " + "WHERE CHANGEDTIME > '" + n + "-" + CDate.format2Digit(n2) + "-" + n4 + "-01.00.00.000000' AND " + "      RECYCLED = 'N' AND " + "      PUBLISH  = 'Y'");
            if (resultSet.next()) {
                n7 = resultSet.getInt(1);
            }
            LogSystem.log(1, "docsPublishedThisWeek:" + n7);
            resultSet = statement.executeQuery("SELECT COUNT(*) FROM TIGRIS.DOCUMENTS " + "WHERE CHANGEDTIME > '" + n + "-" + CDate.format2Digit(n2) + "-" + n3 + "-01.00.00.000000' AND " + "      RECYCLED = 'N' AND " + "      PUBLISH  = 'Y'");
            if (resultSet.next()) {
                n8 = resultSet.getInt(1);
            }
            LogSystem.log(1, "docsPublishedThisDay:" + n8);
            resultSet = statement.executeQuery("SELECT COUNT(*) FROM TIGRIS.DOCUMENTS " + "WHERE RECYCLED = 'N' AND " + "      PUBLISH  = 'Y'");
            if (resultSet.next()) {
                n9 = resultSet.getInt(1);
            }
            LogSystem.log(1, "Total Documents:" + n9);
            resultSet = statement.executeQuery("SELECT COUNT(*) FROM TIGRIS.DOCUMENTS A, TIGRIS.DOCMEDIA B " + "WHERE A.DOCIND = B.DOCIND AND " + "      RECYCLED = 'N' AND " + "      PUBLISH  = 'Y'");
            if (resultSet.next()) {
                n10 = resultSet.getInt(1);
            }
            LogSystem.log(1, "Total Files:" + n10);
            this.updateStat("QQ_DOC_PUB_THIS_YEAR", "" + n5);
            this.updateStat("QQ_DOC_PUB_THIS_MONTH", "" + n6);
            this.updateStat("QQ_DOC_PUB_THIS_DAY", "" + n8);
            this.updateStat("QQ_DOC_PUB_THIS_WEEK", "" + n7);
            this.updateStat("QQ_TOTAL_FILES", "" + n10);
            this.updateStat("QQ_TOTAL_DOCS", "" + n9);
            LogSystem.endLogSection();
            statement.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void setProductStats() {
        SQLMethod sQLMethod = new SQLMethod(1, "setProductStats", 5);
        try {
            CDate cDate = new CDate();
            Statement statement = sQLMethod.createStatement();
            int n = cDate.getYear();
            int n2 = cDate.getMonth();
            int n3 = cDate.getDayOfMonth();
            int n4 = n3 - CDate.getDayOfWeek(cDate.today(), 2);
            ResultSet resultSet = null;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            if (n4 == 0) {
                n4 = 1;
            }
            LogSystem.beginLogSection("Document Statistics");
            resultSet = statement.executeQuery("SELECT COUNT(*) FROM PRODUCT.PRODUCT " + "WHERE LASTTOUCHEDON > '" + n + "-01-01-01.00.00.000000' AND " + "      PUBLISH  = 'Y'");
            if (resultSet.next()) {
                n5 = resultSet.getInt(1);
            }
            LogSystem.log(1, "prodsPublishedThisYear:" + n5);
            resultSet.close();
            resultSet = statement.executeQuery("SELECT COUNT(*) FROM PRODUCT.PRODUCT " + "WHERE LASTTOUCHEDON > '" + n + "-" + CDate.format2Digit(n2) + "-01-01.00.00.000000' AND " + "      PUBLISH  = 'Y'");
            if (resultSet.next()) {
                n6 = resultSet.getInt(1);
            }
            LogSystem.log(1, "prodsPublishedThisMonth:" + n6);
            resultSet = statement.executeQuery("SELECT COUNT(*) FROM PRODUCT.PRODUCT " + "WHERE LASTTOUCHEDON > '" + n + "-" + CDate.format2Digit(n2) + "-" + CDate.format2Digit(n4) + "-01.00.00.000000' AND " + "      PUBLISH  = 'Y'");
            if (resultSet.next()) {
                n7 = resultSet.getInt(1);
            }
            LogSystem.log(1, "prodsPublishedThisWeek:" + n7);
            resultSet = statement.executeQuery("SELECT COUNT(*) FROM PRODUCT.PRODUCT " + "WHERE LASTTOUCHEDON > '" + n + "-" + CDate.format2Digit(n2) + "-" + n3 + "-01.00.00.000000' AND " + "      PUBLISH  = 'Y'");
            if (resultSet.next()) {
                n8 = resultSet.getInt(1);
            }
            LogSystem.log(1, "prodsPublishedThisDay:" + n8);
            resultSet = statement.executeQuery("SELECT COUNT(*) FROM PRODUCT.PRODUCT " + "WHERE PUBLISH  = 'Y'");
            if (resultSet.next()) {
                n9 = resultSet.getInt(1);
            }
            LogSystem.log(1, "Total Products:" + n9);
            resultSet = statement.executeQuery("SELECT COUNT(*) FROM PRODUCT.TYPECATEGORY WHERE CATEGORYLEVEL = 'family'");
            if (resultSet.next()) {
                n10 = resultSet.getInt(1);
            }
            LogSystem.log(1, "Total Families:" + n10);
            this.updateStat("QQ_PROD_PUB_THIS_YEAR", "" + n5);
            this.updateStat("QQ_PROD_PUB_THIS_MONTH", "" + n6);
            this.updateStat("QQ_PROD_PUB_THIS_DAY", "" + n8);
            this.updateStat("QQ_PROD_PUB_THIS_WEEK", "" + n7);
            this.updateStat("QQ_TOTAL_FAMILIES", "" + n10);
            this.updateStat("QQ_TOTAL_PRODUCTS", "" + n9);
            LogSystem.endLogSection();
            statement.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
    }

    public QQuestStats(String[] stringArray) {
        new LogSystem(1, "QQuestStats.out");
        this.processParams(stringArray);
        if (this.connectToDatabase()) {
            this.setStatDate();
            this.setDocumentStats();
            this.setProductStats();
        }
        System.exit(0);
    }
}

