/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.AppletSystem;
import com.ibm.nzna.projects.qit.app.CacheSystem;
import com.ibm.nzna.projects.qit.app.ClipSystem;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.InitializeThread;
import com.ibm.nzna.projects.qit.app.ProcessManagerSystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.ThemeSystem;
import com.ibm.nzna.projects.qit.app.UserStatSystem;
import com.ibm.nzna.projects.qit.app.WindowSystem;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.projects.qit.bookmark.BookmarkSystem;
import com.ibm.nzna.projects.qit.customview.CustomViewSystem;
import com.ibm.nzna.projects.qit.gui.InitAppWindow;
import com.ibm.nzna.projects.qit.help.HelpSystem;
import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.spell.SpellChecker;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import java.io.File;
import java.util.Properties;

public class Qit
implements AppConst,
Runnable {
    private static boolean appEnabled = true;
    private static int disabled = 0;
    private InitAppWindow initWindow = null;
    private Str str = null;
    private String[] args = null;
    private BookmarkSystem bookmarkSystem = null;
    private UserStatSystem userStatSystem = null;
    private DateSystem dateSystem = null;

    public static void main(String[] stringArray) {
        System.out.print("Quest Initializing\n------------------\n\n");
        Properties properties = System.getProperties();
        String string = properties.getProperty("os.name");
        System.out.println("Platform:" + string);
        new Qit(stringArray);
    }

    public void finalize() {
        try {
            try {
                super.finalize();
                System.out.println("QIT FINALIZED!");
            }
            catch (Throwable throwable) {
                System.out.println("Exception while finalized");
                Object var2_2 = null;
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            throw throwable;
        }
    }

    public void readParams(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            int n2 = 0;
            LogSystem.beginLogSection("Reading Command Line Parameters");
            PropertySystem.putBool(60, false);
            while (n2 < n) {
                this.processParam(stringArray[n2].toUpperCase(), stringArray[n2]);
                ++n2;
            }
            LogSystem.endLogSection();
        }
    }

    public void processParam(String string, String string2) {
        try {
            if (string.startsWith("/G:")) {
                try {
                    Integer n = new Integer(string.substring(3, string.length()));
                    PropertySystem.putInt(16, n);
                }
                catch (Exception exception) {
                    System.out.println("Could not parse Debug Level of " + string);
                }
            } else if (string.startsWith("/D:")) {
                PropertySystem.putString(11, string.substring(3, string.length()));
            } else if (string.startsWith("/P:")) {
                PropertySystem.putString(12, string.substring(3, string.length()));
            } else if (string.startsWith("/S:")) {
                PropertySystem.putString(13, string.substring(3, string.length()));
            } else if (string.startsWith("/U:")) {
                PropertySystem.putString(10, string.substring(3, string.length()));
            } else if (string.startsWith("/PW:")) {
                PropertySystem.putString(18, string.substring(4, string.length()));
            } else if (string.startsWith("/TEST")) {
                PropertySystem.putBool(15, true);
            } else if (string.startsWith("/L:")) {
                PropertySystem.putString(1, string2.substring(3, string2.length()));
            } else if (string.startsWith("/NOLOGO")) {
                PropertySystem.putBool(72, false);
            } else if (string.startsWith("/?")) {
                Qit.printParams();
                System.exit(0);
            } else if (string.charAt(0) == '?') {
                Qit.printParams();
                System.exit(0);
            } else if (string.startsWith("/APPDRIVER")) {
                PropertySystem.putBool(17, true);
            } else if (string.startsWith("/IMPORTFILE:")) {
                PropertySystem.putString(20, string.substring("/IMPORTFILE:".length(), string.length()));
            } else if (string.startsWith("/RUNBATCH:")) {
                PropertySystem.putString(19, string.substring("/RUNBATCH:".length(), string.length()));
                PropertySystem.putBool(14, true);
            } else if (string.startsWith("/DBWINDOW")) {
                PropertySystem.putBool(60, true);
            } else {
                System.out.println("Unknown parameter:" + string);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    private static void printParams() {
        System.out.println("");
        System.out.println("Usage: java Quest <params>");
        System.out.println("Param       Description                                         Usage");
        System.out.println("----------- -------------------------------------               ----------------");
        System.out.println("/D:         Specify a database name                             /D:QUEST ");
        System.out.println("/P:         Specify a database port                             /P:5703 ");
        System.out.println("/S:         Specify the database Server                         /S:SERVER ");
        System.out.println("/U:         Specify the user to log on with                     /U:USER ");
        System.out.println("/PW:        Specify the password to log on with                 /P:PASSWORD ");
        System.out.println("/G:         Start in debug mode                                 /G:DEBUGLEVEL# ");
        System.out.println("/L:         Display in a certain language                       /L:English or /L:Spanish");
        System.out.println("/TEST       Use the test User Id and Password                   /TEST");
        System.out.println("/APPDRIVER  Uses the DB/2 App Driver, instead of the Net Driver /APPDRIVER");
        System.out.println("/RUNBATCH   No GUI, just run a predefined batch import          /RUNBATCH:<batchname>");
        System.out.println("/IMPORTFILE Used when in batch mode to identify import file     /IMPORTFILE:<import filename>");
        System.out.println("/?          Get this help                                       /? ");
    }

    public static void setEnabled(boolean bl) {
        if (bl) {
            if (--disabled == 0) {
                appEnabled = true;
            }
        } else {
            ++disabled;
            appEnabled = false;
        }
    }

    public static boolean getEnabled() {
        return appEnabled;
    }

    private static boolean getFirstApplicationRun() {
        boolean bl = PropertySystem.getBool(55);
        PropertySystem.putBool(55, false);
        return bl;
    }

    public static String writeSomething() {
        System.out.println("Something");
        return "AS";
    }

    public void run() {
        try {
            File file = new File("quest.pid");
            System.out.println("Creating Property System");
            new PropertySystem();
            System.out.println("Cleaning Old Log Files");
            QuestUtil.cleanOldLogFiles();
            System.out.println("Reading Params");
            this.readParams(this.args);
            LogSystem.log(3, "Creating ImageSystem");
            System.out.println("Creating ImageSystem");
            new ImageSystem();
            System.out.println("Creating GUISystem");
            LogSystem.log(3, "Creating GUISystem");
            new GUISystem();
            System.out.println("Creating CacheSystem");
            LogSystem.log(3, "Creating CacheSystem");
            new CacheSystem();
            System.out.println("Creating DateSystem");
            LogSystem.log(3, "Creating DateSystem");
            this.dateSystem = new DateSystem();
            System.out.println("Creating ThemeSystem");
            LogSystem.log(3, "Creating ThemeSystem");
            new ThemeSystem();
            System.out.println("Creating FontSystem");
            LogSystem.log(3, "Creating FontSystem");
            new FontSystem();
            System.out.println("Creating HelpSystem");
            LogSystem.log(3, "Creating HelpSystem");
            new HelpSystem();
            System.out.println("Creating UserStatSystem");
            LogSystem.log(3, "Creating UserStatSystem");
            this.userStatSystem = new UserStatSystem();
            System.out.println("Creating CustomViewSystem");
            LogSystem.log(3, "Creating CustomViewSystem");
            new CustomViewSystem();
            System.out.println("Creating BookmarkSystem");
            LogSystem.log(3, "Creating Bookmarks");
            this.bookmarkSystem = new BookmarkSystem();
            System.out.println("Creating ProcessManagerSystem");
            LogSystem.log(3, "Creating ProcessManagerSystem");
            new ProcessManagerSystem();
            System.out.println("Creating Spell Checker");
            LogSystem.log(3, "Creating Spell Checker");
            new SpellChecker();
            System.out.println("Creating Initialize, Clipboard, Database System");
            LogSystem.log(3, "Creating initialize");
            new AppletSystem().initialize();
            new ClipSystem();
            new DatabaseSystem(PropertySystem.getInt(16) > 0, LogSystem.getInstance(), PropertySystem.getBool(17));
            PropertySystem.putBool(27, !file.exists());
            LogSystem.setDebugLevel(PropertySystem.getInt(16));
            if (!file.exists()) {
                file = null;
                FileUtil.saveFile("quest.pid", "Running");
            }
            System.out.println("Creating WindowSystem");
            new WindowSystem();
            if (Qit.getFirstApplicationRun()) {
                // empty if block
            }
            System.out.println("Creating Writing Properties");
            PropertySystem.getInstance().writeToDisk();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox("Severe Error", "Cannot Initialize Quest SubSystems. Application will now exit");
            System.exit(-1);
        }
    }

    public Qit(String[] stringArray) {
        try {
            this.args = stringArray;
            this.initWindow = this.initWindow;
            new LogSystem(0, "quest.debug");
            LogSystem.addAlias("quest.debug." + new CDate(1).today());
            LogSystem.log(0, "Internal Version Number:43");
            this.str = new Str("english");
            LogSystem.log(0, "Application String Version:" + Str.getApplicationName());
            this.run();
            new InitializeThread(this, true);
            if (this.initWindow != null) {
                this.initWindow.dispose();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

