/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.admin.brandmgmt;

import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.doc.DocumentSQL;
import com.ibm.nzna.projects.common.quest.product.ProductSQL;
import com.ibm.nzna.projects.common.quest.type.TypeCategory;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.quest.type.TypeDocCatRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.projects.qit.admin.AdminConst;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.Authority;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserRec;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.dbgui.ProductDocumentDlg;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.doc.gui.DocumentDlg;
import com.ibm.nzna.projects.qit.gui.ActionButton;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.projects.qit.gui.SingleEntryDlg;
import com.ibm.nzna.projects.qit.gui.StatusWin;
import com.ibm.nzna.projects.qit.gui.UserEntryPanel;
import com.ibm.nzna.projects.qit.gui.UserEntryPanelListener;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.gui.DCheckBox;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.gui.JListDlg;
import com.ibm.nzna.shared.gui.JTreeDlg;
import com.ibm.nzna.shared.gui.ValueLabel;
import com.ibm.nzna.shared.sort.QuickSort;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BrandMgmtPanel
extends JPanel
implements Authority,
UserEntryPanelListener,
DocConst,
ListSelectionListener,
QuestPanel,
AppConst,
AdminConst,
ActionListener,
ProductConst {
    private AppDefaultWin parentDefWin = null;
    private HotLinkLabel addCategory = this.createActionHotLink(Str.getStr(95));
    private HotLinkLabel removeCategory = this.createActionHotLink(Str.getStr(96));
    private HotLinkLabel upCategory = this.createActionHotLink(Str.getStr(1044));
    private HotLinkLabel downCategory = this.createActionHotLink(Str.getStr(1045));
    private ButtonPanel familyAction = null;
    private ButtonPanel machineAction = null;
    private ButtonPanel categoryAction = null;
    private HotLinkLabel addFamily = this.createActionHotLink(Str.getStr(95));
    private HotLinkLabel editFamily = this.createActionHotLink(Str.getStr(50));
    private HotLinkLabel removeFamily = this.createActionHotLink(Str.getStr(172));
    private HotLinkLabel upFamily = this.createActionHotLink(Str.getStr(1044));
    private HotLinkLabel downFamily = this.createActionHotLink(Str.getStr(1045));
    private HotLinkLabel upMachine = this.createActionHotLink(Str.getStr(1044));
    private HotLinkLabel downMachine = this.createActionHotLink(Str.getStr(1045));
    private HotLinkLabel editMachine = this.createActionHotLink(Str.getStr(50));
    private DefaultListModel familyListModel = new DefaultListModel();
    private DefaultListModel categoryListModel = new DefaultListModel();
    private DefaultListModel machineListModel = new DefaultListModel();
    private JLabel st_TITLE = null;
    private ValueLabel vl_BPM = null;
    private UserEntryPanel ef_BPM = null;
    private DCheckBox ck_AUTO_SORT_FAMILY = null;
    private DCheckBox ck_AUTO_SORT_MACHINE = null;
    private DCheckBox ck_AUTO_SORT_CATEGORY = null;
    private JLabel st_FAMILY = null;
    private JLabel st_MACHINE = null;
    private ActionButton pb_CLOSE = null;
    private JList lb_FAMILY = null;
    private JList lb_MACHINE = null;
    private JList lb_CATEGORY = null;
    private JScrollPane scr_FAMILY = null;
    private JScrollPane scr_MACHINE = null;
    private JScrollPane scr_CATEGORY = null;
    private JLabel st_CATEGORY = null;
    private TypeCategoryRec brandRec = null;
    private JScrollPane scrollPane = null;
    private JPanel allComponentPanel = new JPanel();

    public boolean initialize() {
        boolean bl = Brands.isBrandOption(this.brandRec);
        this.pb_CLOSE = new ActionButton(Str.getStr(28), ImageSystem.getImageIcon((Object)this, 8), Str.getStr(28));
        this.st_TITLE = new JLabel(this.brandRec.toString());
        this.ef_BPM = new UserEntryPanel();
        this.vl_BPM = new ValueLabel(Str.getStr(660), this.ef_BPM);
        this.st_FAMILY = new JLabel(Str.getStr(149));
        this.st_MACHINE = new JLabel(bl ? Str.getStr(1665) : Str.getStr(340));
        this.st_CATEGORY = new JLabel(Str.getStr(495));
        this.ck_AUTO_SORT_FAMILY = new DCheckBox(Str.getStr(15004));
        this.ck_AUTO_SORT_MACHINE = new DCheckBox(Str.getStr(15004));
        this.ck_AUTO_SORT_CATEGORY = new DCheckBox(Str.getStr(15004));
        this.lb_FAMILY = new JList();
        this.lb_MACHINE = new JList();
        this.lb_CATEGORY = new JList();
        this.scr_FAMILY = new JScrollPane(this.lb_FAMILY);
        this.scr_MACHINE = new JScrollPane(this.lb_MACHINE);
        this.scr_CATEGORY = new JScrollPane(this.lb_CATEGORY);
        this.familyAction = new ButtonPanel();
        this.machineAction = new ButtonPanel();
        this.categoryAction = new ButtonPanel();
        this.vl_BPM.setBackground(Color.white);
        this.vl_BPM.setDescriptionWidth(100);
        this.setBackground(Color.white);
        this.st_TITLE.setFont(FontSystem.largeTitleFont);
        this.ck_AUTO_SORT_FAMILY.setBackground(Color.white);
        this.ck_AUTO_SORT_MACHINE.setBackground(Color.white);
        this.ck_AUTO_SORT_CATEGORY.setBackground(Color.white);
        this.familyAction.setBackground(Color.white);
        this.categoryAction.setBackground(Color.white);
        this.machineAction.setBackground(Color.white);
        this.lb_FAMILY.setModel(this.familyListModel);
        this.lb_MACHINE.setModel(this.machineListModel);
        this.lb_CATEGORY.setModel(this.categoryListModel);
        this.allComponentPanel.setBackground(Color.white);
        this.ef_BPM.addUserEntryPanelListener(this);
        this.pb_CLOSE.addActionListener(this);
        this.ck_AUTO_SORT_FAMILY.addActionListener(this);
        this.ck_AUTO_SORT_MACHINE.addActionListener(this);
        this.ck_AUTO_SORT_CATEGORY.addActionListener(this);
        this.lb_FAMILY.addListSelectionListener(this);
        this.lb_MACHINE.addListSelectionListener(this);
        this.lb_CATEGORY.addListSelectionListener(this);
        this.upMachine.addActionListener(this);
        this.downMachine.addActionListener(this);
        this.editMachine.addActionListener(this);
        this.upFamily.addActionListener(this);
        this.downFamily.addActionListener(this);
        this.addFamily.addActionListener(this);
        this.removeFamily.addActionListener(this);
        this.editFamily.addActionListener(this);
        this.upCategory.addActionListener(this);
        this.downCategory.addActionListener(this);
        this.addCategory.addActionListener(this);
        this.removeCategory.addActionListener(this);
        if (UserSystem.hasAuthority(52)) {
            this.familyAction.add(this.addFamily);
            this.familyAction.add(this.editFamily);
            this.familyAction.add(this.removeFamily);
            this.familyAction.add(this.upFamily);
            this.familyAction.add(this.downFamily);
        }
        this.categoryAction.add(this.addCategory);
        this.categoryAction.add(this.removeCategory);
        this.categoryAction.add(this.upCategory);
        this.categoryAction.add(this.downCategory);
        if (UserSystem.hasAuthority(54)) {
            this.machineAction.add(this.editMachine);
            this.machineAction.add(this.upMachine);
            this.machineAction.add(this.downMachine);
        }
        this.allComponentPanel.setLayout(null);
        this.allComponentPanel.add(this.st_TITLE);
        this.allComponentPanel.add(this.vl_BPM);
        this.allComponentPanel.add(this.st_FAMILY);
        this.allComponentPanel.add(this.st_CATEGORY);
        this.allComponentPanel.add(this.st_MACHINE);
        if (UserSystem.hasAuthority(52)) {
            this.allComponentPanel.add(this.ck_AUTO_SORT_FAMILY);
        }
        this.allComponentPanel.add(this.scr_FAMILY);
        this.allComponentPanel.add(this.familyAction);
        this.allComponentPanel.add(this.ck_AUTO_SORT_CATEGORY);
        this.allComponentPanel.add(this.scr_CATEGORY);
        this.allComponentPanel.add(this.categoryAction);
        if (UserSystem.hasAuthority(54)) {
            this.allComponentPanel.add(this.ck_AUTO_SORT_MACHINE);
        }
        this.allComponentPanel.add(this.scr_MACHINE);
        this.allComponentPanel.add(this.machineAction);
        this.allComponentPanel.setMinimumSize(new Dimension(400, 550));
        this.allComponentPanel.setPreferredSize(new Dimension(400, 550));
        this.scrollPane = new JScrollPane(this.allComponentPanel);
        this.setLayout(new BorderLayout());
        this.add(this.scrollPane);
        return true;
    }

    public void start() {
        this.parentDefWin = GUISystem.getParentDefWin(this);
        this.parentDefWin.addActionComponent(this, this.pb_CLOSE);
        this.refresh();
    }

    public void refresh() {
        this.parentDefWin.setStatus(Str.getStr(1511));
        this.st_TITLE.setText(this.brandRec.toString());
        this.ef_BPM.setText(this.brandRec.getOwner());
        this.refreshFamilies();
        this.refreshCategories();
        this.refreshMachines();
        this.enableInput(true);
        this.parentDefWin.setStatus(null);
    }

    private final void refreshFamilies() {
        TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.lb_FAMILY.getSelectedValue();
        Vector vector = Brands.getFamilies(this.brandRec);
        new QuickSort(vector);
        WinUtil.setListData(vector, this.familyListModel);
        this.lb_FAMILY.setModel(this.familyListModel);
        this.ck_AUTO_SORT_FAMILY.setSelected(this.brandRec.getChildSort().equals("Y"));
    }

    private final void refreshMachines() {
        TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.lb_FAMILY.getSelectedValue();
        if (typeCategoryRec != null) {
            Vector vector = Brands.getMachinesSubCategoriesFromFamily(typeCategoryRec.getInd());
            new QuickSort(vector);
            this.ck_AUTO_SORT_MACHINE.setEnabled(true);
            this.ck_AUTO_SORT_MACHINE.setSelected(typeCategoryRec.getChildSort().equals("Y"));
            WinUtil.setListData(vector, this.machineListModel);
            this.lb_MACHINE.setModel(this.machineListModel);
        }
    }

    private final void refreshCategories() {
        Vector vector = TypeCategory.getChildCategories(this.brandRec.getInd(), "doccategory");
        new QuickSort(vector);
        this.lb_CATEGORY.setModel(this.categoryListModel);
        WinUtil.setListData(vector, this.categoryListModel);
        this.ck_AUTO_SORT_CATEGORY.setSelected(this.brandRec.getChildSort().equals("Y"));
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 15;
        int n2 = 0;
        int n3 = GUISystem.getRowHeight();
        int n4 = dimension.width / 2 - 15;
        super.doLayout();
        this.st_TITLE.setBounds(n, n2, dimension.width - n * 2, n3 * 2);
        n2 += n3 * 2;
        this.vl_BPM.setBounds(n, n2 += 5, 250, n3);
        this.st_FAMILY.setBounds(n, n2 += n3, n4 - 20, n3);
        this.st_CATEGORY.setBounds(n4 + n + 20, n2, n4 - n - 25, n3);
        this.ck_AUTO_SORT_FAMILY.setBounds(n, n2 += n3, n4 - 20, n3);
        this.ck_AUTO_SORT_CATEGORY.setBounds(n4 + n + 20, n2, n4 - n - 25, n3);
        this.scr_FAMILY.setBounds(n, n2 += n3, n4 - 20, n3 * 10);
        this.scr_CATEGORY.setBounds(n4 + n + 20, n2, n4 - n - 25, n3 * 10);
        this.familyAction.setBounds(n, n2 += n3 * 10, n4 - 20, n3);
        this.categoryAction.setBounds(n4 + n + 20, n2, n4 - n - 25, n3);
        this.st_MACHINE.setBounds(n, n2 += n3 * 2, n4 - 20, n3);
        this.ck_AUTO_SORT_MACHINE.setBounds(n, n2 += n3, n4 - 20, n3);
        this.scr_MACHINE.setBounds(n, n2 += n3, n4 - 20, n3 * 10);
        this.machineAction.setBounds(n, n2 += n3 * 10, n4 - 20, n3);
        n2 += n3;
    }

    public ImageIcon getIcon() {
        return ImageSystem.getImageIcon((Object)this, 237);
    }

    public String getName() {
        return Str.getStr(15001);
    }

    public JComponent getJComponent() {
        return this;
    }

    public boolean shutdown() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_CLOSE) {
            GUISystem.getParentDefWin(this).closePanel(this, null);
        } else if (actionEvent.getSource() == this.ck_AUTO_SORT_FAMILY) {
            TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.lb_FAMILY.getSelectedValue();
            if (this.ck_AUTO_SORT_FAMILY.isSelected()) {
                this.brandRec.setChildSort("Y");
                this.zeroCategoryList(this.familyListModel);
                this.refreshFamilies();
            } else {
                this.brandRec.setChildSort("N");
                this.resetCategoryList(this.familyListModel);
            }
            this.refresh();
            if (typeCategoryRec != null) {
                this.lb_FAMILY.removeListSelectionListener(this);
                this.lb_FAMILY.setSelectedValue(typeCategoryRec, true);
                this.lb_FAMILY.addListSelectionListener(this);
            }
            this.enableInput(true);
        } else if (actionEvent.getSource() == this.removeFamily) {
            this.removeFamily();
        } else if (actionEvent.getSource() == this.ck_AUTO_SORT_MACHINE) {
            TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.lb_FAMILY.getSelectedValue();
            if (this.ck_AUTO_SORT_MACHINE.isSelected()) {
                typeCategoryRec.setChildSort("Y");
                this.zeroCategoryList(this.machineListModel);
            } else {
                typeCategoryRec.setChildSort("N");
                this.resetCategoryList(this.machineListModel);
            }
            this.refreshMachines();
            this.enableInput(true);
        } else if (actionEvent.getSource() == this.ck_AUTO_SORT_CATEGORY) {
            if (this.ck_AUTO_SORT_CATEGORY.isSelected()) {
                this.brandRec.setChildSort("Y");
                this.zeroCategoryList(this.categoryListModel);
                this.refresh();
            } else {
                this.brandRec.setChildSort("N");
                this.resetCategoryList(this.categoryListModel);
                this.refresh();
            }
            this.enableInput(true);
        } else if (actionEvent.getSource() == this.upFamily) {
            this.lb_FAMILY.removeListSelectionListener(this);
            this.moveCategoryUp(this.lb_FAMILY);
            this.lb_FAMILY.addListSelectionListener(this);
        } else if (actionEvent.getSource() == this.downFamily) {
            this.lb_FAMILY.removeListSelectionListener(this);
            this.moveCategoryDown(this.lb_FAMILY);
            this.lb_FAMILY.addListSelectionListener(this);
        } else if (actionEvent.getSource() == this.upMachine) {
            this.lb_MACHINE.removeListSelectionListener(this);
            this.moveCategoryUp(this.lb_MACHINE);
            this.lb_MACHINE.addListSelectionListener(this);
        } else if (actionEvent.getSource() == this.downMachine) {
            this.lb_MACHINE.removeListSelectionListener(this);
            this.moveCategoryDown(this.lb_MACHINE);
            this.lb_MACHINE.addListSelectionListener(this);
        } else if (actionEvent.getSource() == this.addFamily) {
            this.addFamily();
        } else if (actionEvent.getSource() == this.editFamily) {
            this.editFamily();
        } else if (actionEvent.getSource() == this.editMachine) {
            boolean bl = Brands.isBrandOption(this.brandRec);
            if (bl) {
                this.editSubCategory();
            } else {
                this.editMachine();
            }
        } else if (actionEvent.getSource() == this.upCategory) {
            this.lb_CATEGORY.removeListSelectionListener(this);
            this.moveCategoryUp(this.lb_CATEGORY);
            this.lb_CATEGORY.addListSelectionListener(this);
        } else if (actionEvent.getSource() == this.downCategory) {
            this.lb_CATEGORY.removeListSelectionListener(this);
            this.moveCategoryDown(this.lb_CATEGORY);
            this.lb_CATEGORY.addListSelectionListener(this);
        } else if (actionEvent.getSource() == this.addCategory) {
            this.addCategory();
        } else if (actionEvent.getSource() == this.removeCategory) {
            this.removeCategory();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting() && listSelectionEvent.getSource() == this.lb_FAMILY) {
            this.refreshMachines();
        }
        this.enableInput(true);
    }

    private final void moveCategoryUp(JList jList) {
        WinUtil.moveItemUp(jList);
        this.resetCategoryList((DefaultListModel)jList.getModel());
    }

    private final void moveCategoryDown(JList jList) {
        WinUtil.moveItemDown(jList);
        this.resetCategoryList((DefaultListModel)jList.getModel());
    }

    public boolean stop() {
        return true;
    }

    private final HotLinkLabel createActionHotLink(String string) {
        HotLinkLabel hotLinkLabel = new HotLinkLabel(string);
        hotLinkLabel.showSelection(false);
        return hotLinkLabel;
    }

    private final synchronized void resetCategoryList(DefaultListModel defaultListModel) {
        int n = 1;
        int n2 = 0;
        int n3 = defaultListModel.getSize();
        StringBuffer stringBuffer = new StringBuffer();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.upFamily.setEnabled(false);
        this.downFamily.setEnabled(false);
        this.upMachine.setEnabled(false);
        this.downMachine.setEnabled(false);
        this.upCategory.setEnabled(false);
        this.downCategory.setEnabled(false);
        this.upFamily.setCursor(Cursor.getPredefinedCursor(3));
        this.downFamily.setCursor(Cursor.getPredefinedCursor(3));
        this.upMachine.setCursor(Cursor.getPredefinedCursor(3));
        this.downMachine.setCursor(Cursor.getPredefinedCursor(3));
        this.upCategory.setCursor(Cursor.getPredefinedCursor(3));
        this.downCategory.setCursor(Cursor.getPredefinedCursor(3));
        while (n2 < n3) {
            ((TypeCategoryRec)defaultListModel.elementAt(n2)).setOrderNum(n);
            stringBuffer.append(((TypeCategoryRec)defaultListModel.elementAt(n2)).toSQL());
            ++n;
            ++n2;
        }
        if (SqlRunner.sqlRunnerCode(1, stringBuffer.toString()) != 0) {
            GUISystem.printBox(7, 202);
        }
        this.enableInput(true);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.upFamily.setCursor(Cursor.getPredefinedCursor(0));
        this.downFamily.setCursor(Cursor.getPredefinedCursor(0));
        this.upMachine.setCursor(Cursor.getPredefinedCursor(0));
        this.downMachine.setCursor(Cursor.getPredefinedCursor(0));
        this.upCategory.setCursor(Cursor.getPredefinedCursor(0));
        this.downCategory.setCursor(Cursor.getPredefinedCursor(0));
    }

    private final synchronized void zeroCategoryList(DefaultListModel defaultListModel) {
        int n = 1;
        int n2 = 0;
        int n3 = defaultListModel.getSize();
        while (n2 < n3) {
            ((TypeCategoryRec)defaultListModel.elementAt(n2)).setOrderNum(0);
            ++n;
            ++n2;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        TypeCategory.writeToDatabase();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private final void enableInput(boolean bl) {
        if (bl) {
            boolean bl2 = this.lb_FAMILY.getSelectedValue() != null;
            boolean bl3 = this.lb_CATEGORY.getSelectedValue() != null;
            boolean bl4 = this.lb_MACHINE.getSelectedValue() != null;
            this.ck_AUTO_SORT_MACHINE.setEnabled(bl2);
            this.scr_MACHINE.setEnabled(bl2);
            this.editFamily.setEnabled(bl2);
            this.removeFamily.setEnabled(bl2);
            this.editMachine.setEnabled(bl4);
            this.removeCategory.setEnabled(bl3);
            this.upFamily.setEnabled(bl2 && !this.ck_AUTO_SORT_FAMILY.isSelected());
            this.downFamily.setEnabled(bl2 && !this.ck_AUTO_SORT_FAMILY.isSelected());
            this.upMachine.setEnabled(bl4 && !this.ck_AUTO_SORT_MACHINE.isSelected());
            this.downMachine.setEnabled(bl4 && !this.ck_AUTO_SORT_MACHINE.isSelected());
            this.upCategory.setEnabled(bl3 && !this.ck_AUTO_SORT_CATEGORY.isSelected());
            this.downCategory.setEnabled(bl3 && !this.ck_AUTO_SORT_CATEGORY.isSelected());
        }
    }

    private final void addFamily() {
        TypeCategoryRec typeCategoryRec;
        String string = this.getFamilyName(null);
        if (string != null && (typeCategoryRec = TypeCategory.createTypeCategory(this.brandRec.getInd(), string, "family", 1, "N", UserSystem.getUserId())) != null) {
            TypeCategoryRec typeCategoryRec2 = TypeCategory.createDraftTypeCategory(typeCategoryRec.getInd(), this.brandRec.getInd(), string, "family", 1, "N", UserSystem.getUserId());
            int n = typeCategoryRec.writeToDatabase();
            if (n == 0) {
                n = typeCategoryRec2.writeToDatabase();
            }
            switch (n) {
                case 0: {
                    this.refreshFamilies();
                    this.lb_FAMILY.setSelectedValue(typeCategoryRec, true);
                    break;
                }
                default: {
                    LogSystem.log(1, "Cannot save to TypeCategory. Return Code:" + n);
                    GUISystem.printBox(6, 202);
                    break;
                }
            }
        }
    }

    private final void editFamily() {
        TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.lb_FAMILY.getSelectedValue();
        String string = this.getFamilyName(typeCategoryRec.toString());
        if (string != null) {
            int n = 0;
            TypeCategoryRec typeCategoryRec2 = TypeCategory.getDraftCategory(typeCategoryRec.getInd());
            if (typeCategoryRec2 == null) {
                typeCategoryRec2 = TypeCategory.createDraftTypeCategory(typeCategoryRec.getInd(), this.brandRec.getInd(), string, "family", 1, "N", UserSystem.getUserId());
            }
            typeCategoryRec2.setDescript(string);
            typeCategoryRec.setDescript(string);
            n = TypeCategory.writeToDatabase();
            switch (n) {
                case 0: {
                    this.refreshFamilies();
                    this.lb_FAMILY.setSelectedValue(typeCategoryRec, true);
                    break;
                }
                default: {
                    LogSystem.log(1, "Cannot save to TypeCategory. Return Code:" + n);
                    GUISystem.printBox(6, 202);
                    break;
                }
            }
        }
    }

    private final void editMachine() {
        TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.lb_MACHINE.getSelectedValue();
        TypeCategoryRec typeCategoryRec2 = (TypeCategoryRec)this.lb_FAMILY.getSelectedValue();
        String string = this.getMachineName(typeCategoryRec.toString(), typeCategoryRec2);
        if (string != null) {
            int n = 0;
            typeCategoryRec.setDescript(string);
            n = TypeCategory.writeToDatabase();
            switch (n) {
                case 0: {
                    this.refreshMachines();
                    this.lb_MACHINE.setSelectedValue(typeCategoryRec, true);
                    break;
                }
                default: {
                    LogSystem.log(1, "Cannot save to TypeCategory. Return Code:" + n);
                    GUISystem.printBox(6, 202);
                    break;
                }
            }
        }
    }

    private final void editSubCategory() {
        TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.lb_MACHINE.getSelectedValue();
        TypeCategoryRec typeCategoryRec2 = (TypeCategoryRec)this.lb_FAMILY.getSelectedValue();
        String string = this.getSubCategoryName(typeCategoryRec.toString(), typeCategoryRec2);
        if (string != null) {
            int n = 0;
            typeCategoryRec.setDescript(string);
            n = TypeCategory.writeToDatabase();
            switch (n) {
                case 0: {
                    this.refreshMachines();
                    this.lb_MACHINE.setSelectedValue(typeCategoryRec, true);
                    break;
                }
                default: {
                    LogSystem.log(1, "Cannot save to TypeCategory. Return Code:" + n);
                    GUISystem.printBox(6, 202);
                    break;
                }
            }
        }
    }

    private final String getFamilyName(String string) {
        boolean bl = true;
        while (bl) {
            string = new SingleEntryDlg((Frame)this.parentDefWin, Str.getStr(149), Str.getStr(15005), string == null ? "" : string).getResult();
            if (string != null) {
                if (TypeCategory.getCategoryFromDescription(string, "family", this.brandRec.getInd()) != null) {
                    GUISystem.printBox(7, 15006);
                    continue;
                }
                if (TypeCategory.getCategoryFromDescription(string, "family") != null) {
                    TypeCategoryRec typeCategoryRec = TypeCategory.getCategoryFromDescription(string, "family");
                    TypeCategoryRec typeCategoryRec2 = TypeCategory.getCategory(typeCategoryRec.getParentCatInd());
                    bl = !GUISystem.printBox(Str.getStr(8), Str.getStr(15007) + " '" + typeCategoryRec2.toString() + "' " + Str.getStr(15008));
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
            string = null;
        }
        return string;
    }

    private final String getMachineName(String string, TypeCategoryRec typeCategoryRec) {
        boolean bl = true;
        while (bl) {
            string = new SingleEntryDlg((Frame)this.parentDefWin, Str.getStr(340), Str.getStr(15012), string == null ? "" : string).getResult();
            if (string != null) {
                if (TypeCategory.getCategoryFromDescription(string, "machine", typeCategoryRec.getInd()) != null) {
                    GUISystem.printBox(7, 15010);
                    continue;
                }
                if (TypeCategory.getCategoryFromDescription(string, "machine") != null) {
                    TypeCategoryRec typeCategoryRec2 = TypeCategory.getCategoryFromDescription(string, "machine");
                    TypeCategoryRec typeCategoryRec3 = TypeCategory.getCategory(typeCategoryRec2.getParentCatInd());
                    bl = !GUISystem.printBox(Str.getStr(8), Str.getStr(15011) + " '" + typeCategoryRec3.toString() + "' " + Str.getStr(15009));
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
            string = null;
        }
        return string;
    }

    private final String getSubCategoryName(String string, TypeCategoryRec typeCategoryRec) {
        boolean bl = true;
        while (bl) {
            string = new SingleEntryDlg((Frame)this.parentDefWin, Str.getStr(1665), Str.getStr(15013), string == null ? "" : string).getResult();
            if (string != null) {
                if (TypeCategory.getCategoryFromDescription(string, "subcategory", typeCategoryRec.getInd()) != null) {
                    GUISystem.printBox(7, 15016);
                    continue;
                }
                if (TypeCategory.getCategoryFromDescription(string, "subcategory") != null) {
                    TypeCategoryRec typeCategoryRec2 = TypeCategory.getCategoryFromDescription(string, "subcategory");
                    TypeCategoryRec typeCategoryRec3 = TypeCategory.getCategory(typeCategoryRec2.getParentCatInd());
                    bl = !GUISystem.printBox(Str.getStr(8), Str.getStr(15015) + " '" + typeCategoryRec3.toString() + "' " + Str.getStr(15014));
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
            string = null;
        }
        return string;
    }

    private final void addCategory() {
        Vector vector = new JListDlg((Frame)this.parentDefWin, Str.getStr(289), TypeList.getInstance().getTypeList(10)).getResult();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (vector != null) {
            int n = 0;
            int n2 = vector.size();
            TypeDocCatRec typeDocCatRec = null;
            int n3 = 0;
            while (n < n2) {
                typeDocCatRec = (TypeDocCatRec)vector.elementAt(n);
                if (TypeCategory.getCategoryFromDescription(typeDocCatRec.toString(), "doccategory", this.brandRec.getInd()) == null) {
                    this.parentDefWin.setStatus(Str.getStr(707) + " " + typeDocCatRec.toString());
                    TypeCategory.createTypeCategory(this.brandRec.getInd(), typeDocCatRec.toString(), "doccategory", 1, "N", UserSystem.getUserId());
                }
                ++n;
            }
            n3 = TypeCategory.writeToDatabase();
            switch (n3) {
                case 0: {
                    this.refreshCategories();
                    break;
                }
                default: {
                    LogSystem.log(1, "Cannot save to TypeCategory. Return Code:" + n3);
                    GUISystem.printBox(6, 202);
                    break;
                }
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.parentDefWin.setStatus(Str.getStr(375), 2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void removeCategory() {
        Object[] objectArray = this.lb_CATEGORY.getSelectedValues();
        if (GUISystem.printBox(8, 15022)) {
            boolean bl = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.parentDefWin.setStatus(14);
            try {
                if (objectArray != null && objectArray.length > 0) {
                    int n = 0;
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        TypeCategoryRec typeCategoryRec = (TypeCategoryRec)objectArray[n2];
                        Vector vector = DocumentSQL.getDocumentsFromTypeCategory(typeCategoryRec.getInd());
                        if (vector != null && vector.size() > 0 && GUISystem.printBox(Str.getStr(8), Str.getStr(15023) + typeCategoryRec.toString())) {
                            new DocumentDlg((Frame)this.parentDefWin, vector);
                            bl = GUISystem.printBox(8, 15024);
                        }
                        if (bl) {
                            typeCategoryRec.updateRecStatus(3);
                        }
                        bl = true;
                        ++n2;
                    }
                    this.parentDefWin.setStatus(Str.getStr(239) + " " + objectArray.length);
                    n = TypeCategory.writeToDatabase();
                    switch (n) {
                        case 0: {
                            this.refreshCategories();
                            break;
                        }
                        default: {
                            LogSystem.log(1, "Cannot save to TypeCategory. Return Code:" + n);
                            GUISystem.printBox(6, 202);
                            break;
                        }
                    }
                }
                this.parentDefWin.setStatus(Str.getStr(375), 2);
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
                GUISystem.printBox(7, 202);
                this.parentDefWin.setStatus(null);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.parentDefWin.setStatus(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void removeFamily() {
        if (GUISystem.printBox(8, 15020)) {
            TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.lb_FAMILY.getSelectedValue();
            StatusWin statusWin = new StatusWin(this.parentDefWin);
            try {
                JDialog jDialog;
                Vector vector = null;
                Vector vector2 = null;
                if (GUISystem.printBox(8, 15021)) {
                    jDialog = null;
                    Vector vector3 = null;
                    Vector vector4 = null;
                    Vector vector5 = null;
                    Vector vector6 = null;
                    Vector vector7 = null;
                    Vector vector8 = null;
                    statusWin.setText(Str.getStr(142));
                    vector3 = DocumentSQL.getDocumentTemplatesFromFamily(typeCategoryRec.getInd());
                    vector4 = DocumentSQL.getDocumentHistoryFromFamily(typeCategoryRec.getInd());
                    vector8 = DocumentSQL.getDeletedDocumentsFromFamily(typeCategoryRec.getInd());
                    vector5 = ProductSQL.getProductTemplatesFromFamily(typeCategoryRec.getInd());
                    vector6 = ProductSQL.getProductHistoryFromFamily(typeCategoryRec.getInd());
                    vector7 = ProductSQL.getDeletedProductsFromFamily(typeCategoryRec.getInd());
                    if (vector3.size() > 0 || vector4.size() > 0 || vector8.size() > 0 || vector5.size() > 0 || vector6.size() > 0 || vector7.size() > 0) {
                        jDialog = new JTreeDlg((Frame)this.parentDefWin, Str.getStr(1666));
                        if (vector3.size() > 0) {
                            ((JTreeDlg)jDialog).addChild(Str.getStr(11011), vector3);
                        }
                        if (vector8.size() > 0) {
                            ((JTreeDlg)jDialog).addChild(Str.getStr(11012), vector8);
                        }
                        if (vector5.size() > 0) {
                            ((JTreeDlg)jDialog).addChild(Str.getStr(17001), vector5);
                        }
                        if (vector6.size() > 0) {
                            ((JTreeDlg)jDialog).addChild(Str.getStr(18000), vector6);
                        }
                        if (vector7.size() > 0) {
                            ((JTreeDlg)jDialog).addChild(Str.getStr(17003), vector7);
                        }
                        ((JTreeDlg)jDialog).getResult();
                    } else {
                        GUISystem.printBox(7, 15025);
                    }
                }
                statusWin.setText(Str.getStr(15018));
                vector = DocumentSQL.getDocumentsFromTypeCategory(typeCategoryRec.getInd());
                vector2 = ProductSQL.getProductsFromFamily(typeCategoryRec.getInd());
                if (vector.size() > 0 || vector2.size() > 0) {
                    jDialog = new ProductDocumentDlg((Frame)this.parentDefWin, vector2, vector);
                    ((ProductDocumentDlg)jDialog).setLargeTitle(Str.getStr(6));
                    ((ProductDocumentDlg)jDialog).setDescription(Str.getStr(15017));
                    ((Component)jDialog).setVisible(true);
                } else {
                    statusWin.setText(Str.getStr(15019));
                    typeCategoryRec.updateRecStatus(3);
                    TypeCategory.writeToDatabase();
                    this.refreshFamilies();
                }
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
                GUISystem.printBox(7, 202);
            }
            statusWin.dispose();
        }
    }

    public void userSelected(UserRec userRec) {
        String string = this.brandRec.getOwner();
        int n = 0;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.brandRec.setOwner(userRec.getUserId());
        n = TypeCategory.writeToDatabase();
        if (n != 0) {
            this.ef_BPM.setText(string);
            LogSystem.log(1, "Could not change BPM to " + userRec.getUserId() + ". SQLCode:" + n);
            GUISystem.printBox(7, 202);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean copyText() {
        return false;
    }

    public boolean cutText() {
        return false;
    }

    public boolean pasteText() {
        return false;
    }

    public NavPanel getDefaultNavPanel() {
        return null;
    }

    public void panelSelected() {
    }

    public void panelDeselected() {
    }

    public boolean bookmark() {
        return false;
    }

    public BrandMgmtPanel(TypeCategoryRec typeCategoryRec) {
        this.brandRec = typeCategoryRec;
    }
}

