/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.admin.stats;

import com.ibm.nzna.projects.qit.admin.stats.StatsExport;
import com.ibm.nzna.projects.qit.admin.stats.StatsNavPanel;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.gui.ActionButton;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.Browser;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class StatsPanel
extends JPanel
implements Runnable,
ActionListener,
AppConst,
QuestPanel {
    private static final int EXPORT_HTML = 1;
    private static final int EXPORT_COMMA = 2;
    protected static final int EXPORT_DOCUMENT_CHANGES = 1;
    protected static final int EXPORT_DOCUMENT_NOCHANGES = 2;
    protected static final int EXPORT_PRODUCTS = 3;
    private String template = "<html><body bgcolor=\"#FFFFFF\"><p><font face=\"Arial, Helvetica, sans-serif\" size=\"4\">STR_STATISTICS</font><font face=\"Arial, Helvetica, sans-serif\" size=\"2\"><br>  <font color=\"800080\">STR_DATE:</font> VALUE_DATE</font></p><p><font face=\"Arial, Helvetica, sans-serif\" size=\"2\" color=\"800080\">STR_EXPORTNAME:</font><font face=\"Arial, Helvetica, sans-serif\" size=\"2\">   VALUE_EXPORTNAME<br>  <font color=\"800080\">STR_RUNBY:</font> VALUE_DBUSER</font></p><p><font face=\"Arial, Helvetica, sans-serif\" size=\"2\" color=\"800080\">STR_ROWS_EXPORTED:</font><font face=\"Arial, Helvetica, sans-serif\" size=\"2\">   VALUE_ROWS_EXPORTED</font></p><p><font face=\"Arial, Helvetica, sans-serif\" size=\"2\" color=\"800080\">STR_ABOUT:</font><font face=\"Arial, Helvetica, sans-serif\" size=\"2\"><br>  VALUE_ABOUT</font> </p><p><font face=\"Arial, Helvetica, sans-serif\" size=\"2\"><br>  </font> </p>";
    private String waitTemplate = "<html><body bgcolor=\"#FFFFFF\"><p><font face=\"Arial, Helvetica, sans-serif\" size=\"4\">STR_STATISTICS</font><font face=\"Arial, Helvetica, sans-serif\" size=\"2\"><br>  <font color=\"800080\">Please wait, your statistics are being exported:</font></p>";
    private Browser browser = null;
    private ActionButton pb_CLOSE = null;
    private String currentOutput = "";
    private JTextArea mle_OUTPUT = new JTextArea();
    private JScrollPane scr_OUTPUT = new JScrollPane(this.mle_OUTPUT);
    private boolean oddLine = false;
    private int currentExport = 0;
    private int rowsExported = 0;
    private StatsNavPanel navPanel = null;
    private boolean threadRunning = false;
    private AppDefaultWin parentWin = null;
    private String userId = null;
    private int exportType = 2;

    public boolean initialize() {
        this.navPanel = new StatsNavPanel();
        this.browser = GUISystem.createBrowser();
        this.pb_CLOSE = new ActionButton(Str.getStr(28), ImageSystem.getImageIcon((Object)this, 8), Str.getStr(28));
        this.pb_CLOSE.addActionListener(this);
        this.navPanel.addActionListener(this);
        this.setOpaque(false);
        this.mle_OUTPUT.setEditable(false);
        this.setLayout(null);
        this.add(this.browser.getComponent(), "Center");
        this.add(this.scr_OUTPUT);
        return true;
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        super.doLayout();
        this.browser.getComponent().setBounds(0, 0, dimension.width, dimension.height / 2);
        this.scr_OUTPUT.setBounds(0, dimension.height / 2, dimension.width, dimension.height / 2);
    }

    public void start() {
        this.parentWin = GUISystem.getParentDefWin(this);
        this.parentWin.addActionComponent(this, this.pb_CLOSE);
    }

    public ImageIcon getIcon() {
        return ImageSystem.getImageIcon((Object)this, 31);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_CLOSE) {
            this.parentWin.closePanel(this, null);
        } else if (actionEvent.getSource() == this.navPanel && !this.threadRunning) {
            this.currentExport = this.navPanel.getSelectedExport();
            this.browser.setPageContent(this.populateWaitTemplate());
            new Thread(this).start();
        }
    }

    public String getName() {
        return Str.getStr(136);
    }

    public boolean bookmark() {
        return false;
    }

    public void panelSelected() {
    }

    public void panelDeselected() {
    }

    public NavPanel getDefaultNavPanel() {
        return this.navPanel;
    }

    public boolean cutText() {
        return false;
    }

    public boolean pasteText() {
        return false;
    }

    public boolean copyText() {
        return false;
    }

    public void refresh() {
        String string = null;
        this.currentExport = 1;
        string = this.populateTemplate();
        this.browser.setPageContent(string + "</body></html>");
        this.currentOutput = string;
    }

    public boolean shutdown() {
        return !this.threadRunning;
    }

    public boolean stop() {
        if (!this.threadRunning) {
            this.panelDeselected();
        }
        return !this.threadRunning;
    }

    public JComponent getJComponent() {
        return this;
    }

    private String populateWaitTemplate() {
        String string = this.waitTemplate;
        string = Text.replaceInStr(string, "STR_DATE", Str.getStr(412));
        string = Text.replaceInStr(string, "STR_EXPORTNAME", Str.getStr(1257));
        string = Text.replaceInStr(string, "STR_PLEASEWAIT", Str.getStr(14));
        string = Text.replaceInStr(string, "STR_ABOUT", Str.getStr(62));
        string = Text.replaceInStr(string, "STR_STATISTICS", Str.getStr(136));
        string = Text.replaceInStr(string, "VALUE_DATE", DateSystem.getDate(2));
        switch (this.currentExport) {
            case 1: {
                string = Text.replaceInStr(string, "VALUE_EXPORTNAME", Str.getStr(1254));
                string = Text.replaceInStr(string, "VALUE_ABOUT", Str.getStr(1260));
                break;
            }
            case 2: {
                string = Text.replaceInStr(string, "VALUE_EXPORTNAME", Str.getStr(1255));
                string = Text.replaceInStr(string, "VALUE_ABOUT", Str.getStr(1261));
                break;
            }
            case 3: {
                string = Text.replaceInStr(string, "VALUE_EXPORTNAME", Str.getStr(299));
                string = Text.replaceInStr(string, "VALUE_ABOUT", Str.getStr(1262));
                break;
            }
        }
        return string;
    }

    private String populateTemplate() {
        String string = this.template;
        string = Text.replaceInStr(string, "STR_DATE", Str.getStr(412));
        string = Text.replaceInStr(string, "STR_EXPORTNAME", Str.getStr(1257));
        string = Text.replaceInStr(string, "STR_RUNBY", Str.getStr(1258));
        string = Text.replaceInStr(string, "STR_ROWS_EXPORTED", Str.getStr(1259));
        string = Text.replaceInStr(string, "STR_ABOUT", Str.getStr(62));
        string = Text.replaceInStr(string, "STR_STATISTICS", Str.getStr(136));
        string = Text.replaceInStr(string, "VALUE_DBUSER", UserSystem.getUserName());
        string = Text.replaceInStr(string, "VALUE_DATE", DateSystem.getDate(2));
        string = Text.replaceInStr(string, "VALUE_ROWS_EXPORTED", "" + this.rowsExported);
        switch (this.currentExport) {
            case 1: {
                string = Text.replaceInStr(string, "VALUE_EXPORTNAME", Str.getStr(1254));
                string = Text.replaceInStr(string, "VALUE_ABOUT", Str.getStr(1260));
                break;
            }
            case 2: {
                string = Text.replaceInStr(string, "VALUE_EXPORTNAME", Str.getStr(1255));
                string = Text.replaceInStr(string, "VALUE_ABOUT", Str.getStr(1261));
                break;
            }
            case 3: {
                string = Text.replaceInStr(string, "VALUE_EXPORTNAME", Str.getStr(299));
                string = Text.replaceInStr(string, "VALUE_ABOUT", Str.getStr(1262));
                break;
            }
        }
        return string;
    }

    public void run() {
        this.threadRunning = true;
        try {
            String string = null;
            String string2 = this.navPanel.getDate();
            String string3 = this.navPanel.getToDate();
            System.out.println("Date:" + string2);
            if (string2 == null || CDate.checkDate(string2, 2) != 0) {
                GUISystem.printBox(Str.getStr(7), "You must enter a valid 'From' Date to export data since");
            } else if (string3 == null || CDate.checkDate(string3, 2) != 0) {
                GUISystem.printBox(Str.getStr(7), "You must enter a valid 'To' Date to export data since");
            } else {
                string = this.getSaveFilename();
                this.userId = this.navPanel.getUserId();
                if (this.navPanel.getExportType().equals(Str.getStr(1279))) {
                    this.exportType = 1;
                } else if (this.navPanel.getExportType().equals(Str.getStr(1195))) {
                    this.exportType = 2;
                }
                if (string != null) {
                    switch (this.currentExport) {
                        case 1: {
                            StatsExport statsExport = new StatsExport(this.parentWin, this, string, this.exportType);
                            statsExport.setDBUser(this.navPanel.getUserId());
                            statsExport.setDate(string2);
                            statsExport.setToDate(string3);
                            this.rowsExported = statsExport.exportChangedBodyDocuments();
                            break;
                        }
                        case 2: {
                            StatsExport statsExport = new StatsExport(this.parentWin, this, string, this.exportType);
                            statsExport.setDBUser(this.navPanel.getUserId());
                            statsExport.setDate(string2);
                            statsExport.setToDate(string3);
                            this.rowsExported = statsExport.exportAllDocuments();
                            break;
                        }
                        case 3: {
                            StatsExport statsExport = new StatsExport(this.parentWin, this, string, this.exportType);
                            statsExport.setDBUser(this.navPanel.getUserId());
                            statsExport.setDate(string2);
                            statsExport.setToDate(string3);
                            this.rowsExported = statsExport.exportProducts();
                            break;
                        }
                    }
                }
            }
            this.browser.setPageContent(this.populateTemplate());
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        this.threadRunning = false;
    }

    private String getSaveFilename() throws Exception {
        File[] fileArray = GUISystem.getFileOpen(GUISystem.getParentDefWin(this), Str.getStr(515), PropertySystem.getString(56), false);
        String string = null;
        String string2 = null;
        if (fileArray != null && fileArray[0] != null && fileArray[1] != null) {
            string = fileArray[0].getName();
            string2 = fileArray[1].getAbsolutePath();
            if (string != null && string2 != null) {
                PropertySystem.put(56, string2);
                return string2 + File.separator + string;
            }
        }
        return null;
    }

    protected void appendOutput(String string) {
        this.currentOutput = this.mle_OUTPUT.getText() + string;
        this.mle_OUTPUT.setText(this.currentOutput);
    }
}

