/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.app;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.QuestApplet;
import com.ibm.nzna.projects.qit.app.QuestAppletNotFoundException;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.gui.MultiListSort;
import com.ibm.nzna.shared.util.LogSystem;
import java.io.Serializable;
import javax.swing.ImageIcon;

public class AppletRec
implements AppConst,
Serializable,
MultiListRow,
MultiListSort {
    static final long serialVersionUID = 1000001L;
    private String className = null;
    private QuestApplet applet = null;

    public String getClassName() {
        return this.className;
    }

    public QuestApplet createQuestApplet() throws QuestAppletNotFoundException {
        QuestApplet questApplet = null;
        try {
            questApplet = (QuestApplet)Class.forName(this.className).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new QuestAppletNotFoundException("Cannot Find Quest Applet", this.className);
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return questApplet;
    }

    public Object getColumnData(int n) {
        Object object = null;
        try {
            if (this.applet == null) {
                this.applet = this.createQuestApplet();
            }
            switch (n) {
                case 0: {
                    object = this.applet.getSmallIcon();
                    break;
                }
                case 1: {
                    object = this.applet.getName();
                    break;
                }
                case 2: {
                    object = this.applet.getDescription();
                    break;
                }
            }
        }
        catch (QuestAppletNotFoundException questAppletNotFoundException) {
            switch (n) {
                case 0: {
                    object = ImageSystem.getImageIcon((Object)MainWindow.getInstance(), 181);
                    break;
                }
                case 1: {
                    object = questAppletNotFoundException.toString();
                    break;
                }
                case 2: {
                    object = "";
                    break;
                }
            }
        }
        return object;
    }

    public int compareTo(MultiListSort multiListSort, int n) {
        AppletRec appletRec = (AppletRec)multiListSort;
        int n2 = 0;
        try {
            if (this.applet == null) {
                this.applet = this.createQuestApplet();
            }
            switch (n) {
                case 1: {
                    n2 = appletRec.applet.getDescription().compareTo(this.applet.getDescription());
                    break;
                }
                case 2: {
                    n2 = appletRec.applet.getName().compareTo(this.applet.getName());
                    break;
                }
            }
        }
        catch (Exception exception) {
            n2 = 0;
        }
        return n2;
    }

    protected void prepareForSerialization() {
        this.applet = null;
    }

    public boolean equals(Object object) {
        if (object instanceof AppletRec) {
            return ((AppletRec)object).className.equals(this.className);
        }
        if (object instanceof String) {
            return ((String)object).equals(this.className);
        }
        return false;
    }

    public String getName() {
        try {
            if (this.applet == null) {
                this.applet = this.createQuestApplet();
            }
            return this.applet.getName();
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    public ImageIcon getIcon() {
        try {
            if (this.applet == null) {
                this.applet = this.createQuestApplet();
            }
            return this.applet.getIcon();
        }
        catch (Exception exception) {
            return ImageSystem.getImageIcon((Object)MainWindow.getInstance(), 181);
        }
    }

    public AppletRec(String string) {
        this.className = string;
    }
}

