/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.app;

import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.LogSystem;
import java.io.File;
import java.sql.ResultSet;
import java.sql.Statement;

public class CacheSystem
implements Runnable {
    private static String cacheDir = null;
    private static boolean enabled = false;
    private static String currentDBTimestamp = null;
    private static int second = 0;
    private static int minute = 0;
    private static int hour = 0;
    private static int month = 0;
    private static int day = 0;
    private static int year = 0;

    public static boolean cacheObject(String string, Object object) {
        boolean bl = false;
        if (enabled) {
            String string2 = CacheSystem.getDBTimestamp();
            QuestUtil.writeObjectToDisk(cacheDir + File.separator + string, object);
            QuestUtil.writeObjectToDisk(cacheDir + File.separator + string + ".cached_time", string2);
            bl = true;
        }
        return bl;
    }

    public static Object getCachedObject(String string) {
        Object object = null;
        if (enabled) {
            LogSystem.log(1, "Reading Cache Object:" + cacheDir + File.separator + string);
            object = QuestUtil.readObjectFromDisk(cacheDir + File.separator + string);
        }
        return object;
    }

    public static String getCacheTime(String string) {
        String string2 = null;
        try {
            string2 = (String)QuestUtil.readObjectFromDisk(cacheDir + File.separator + string + ".cached_time");
            if (string2 == null) {
                string2 = "1980-01-01-07.00.00.000000";
            }
            string2 = CDate.createDate(CDate.parse(string2, 7, 1), CDate.parse(string2, 8, 1), CDate.parse(string2, 9, 1), CDate.parse(string2, 4, 1), CDate.parse(string2, 5, 1), 0, 1);
        }
        catch (Exception exception) {
            string2 = "1980-01-01-07.00.00.000000";
        }
        return string2;
    }

    private static String getDBTimestamp() {
        if (currentDBTimestamp != null) {
            return currentDBTimestamp;
        }
        return CacheSystem.getDBTimestampFromDatabase();
    }

    private static String getDBTimestampFromDatabase() {
        String string = null;
        SQLMethod sQLMethod = null;
        try {
            Statement statement = null;
            ResultSet resultSet = null;
            sQLMethod = new SQLMethod(1, "getDBTimestamp", 5);
            if (sQLMethod != null) {
                statement = sQLMethod.createStatement();
                resultSet = statement.executeQuery("SELECT CURRENT TIMESTAMP FROM TIGRIS.USERID FETCH FIRST 1 ROWS ONLY");
                if (resultSet.next()) {
                    string = resultSet.getString(1).trim();
                }
                resultSet.close();
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
        }
        if (sQLMethod != null) {
            sQLMethod.close();
        }
        return string;
    }

    public void run() {
        while (currentDBTimestamp == null) {
            try {
                Thread.currentThread();
                Thread.sleep(60000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            currentDBTimestamp = CacheSystem.getDBTimestampFromDatabase();
        }
        this.parseTimestamp(currentDBTimestamp);
        ++minute;
        while (true) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
                if (++second > 59) {
                    second = 0;
                    ++minute;
                }
                if (minute > 59) {
                    minute = 0;
                    ++hour;
                }
                if (hour > 24) {
                    String string = year + "-" + month + "-" + day + "-" + hour + "." + minute + "." + second + ".999999";
                    CDate.addDaysToDate(string, 1, 1);
                    this.parseTimestamp(string);
                }
                currentDBTimestamp = "" + year + "-" + month + "-" + day + "-" + hour + "." + minute + "." + second + ".999999";
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private void parseTimestamp(String string) {
        year = CDate.parse(string, 7, 1);
        month = CDate.parse(string, 8, 1);
        day = CDate.parse(string, 9, 1);
        hour = CDate.parse(string, 4, 1);
        minute = CDate.parse(string, 5, 1);
        second = CDate.parse(string, 6, 1);
    }

    public static String getCacheDir() {
        return cacheDir;
    }

    public CacheSystem() {
        try {
            String string = PropertySystem.getString(13);
            String string2 = PropertySystem.getString(11);
            String string3 = PropertySystem.getString(23);
            File file = null;
            new Thread(this).start();
            cacheDir = string3 + File.separator + string2 + "." + string;
            file = new File(cacheDir);
            if (!file.exists()) {
                file.mkdirs();
                LogSystem.log(1, "Caching enabled, Creating Cache Directory:" + cacheDir);
            } else {
                LogSystem.log(1, "Caching enabled, Cache Directory:" + cacheDir);
            }
            enabled = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox("Info", "Could not find cache directory of '" + cacheDir + "', caching is disabled");
            enabled = false;
        }
    }
}

