/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.app;

import com.ibm.nzna.projects.common.quest.Constants;
import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.Qit;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.CacheSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.InitializeWindow;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.QuestUpdater;
import com.ibm.nzna.projects.qit.app.ShutdownThread;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.app.WindowSystem;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.projects.qit.bookmark.BookmarkSystem;
import com.ibm.nzna.projects.qit.customview.CustomViewSystem;
import com.ibm.nzna.projects.qit.gui.UserLogonDlg;
import com.ibm.nzna.projects.qit.setup.SetupWizard;
import com.ibm.nzna.projects.qit.type.QITTypeList;
import com.ibm.nzna.shared.db.Database;
import com.ibm.nzna.shared.db.DatabaseDlg;
import com.ibm.nzna.shared.db.DatabaseStatusListener;
import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Frame;
import java.io.File;
import javax.swing.JList;

public class InitializeThread
implements DatabaseStatusListener,
Runnable,
AppConst {
    private InitializeWindow initWindow = null;
    private Qit qit = null;
    private boolean connectingShown = false;

    public void run() {
        boolean bl = false;
        boolean bl2 = !PropertySystem.getBool(15);
        String string = "quest";
        String string2 = bl2 ? "k1ngarthur" : "j0hnny";
        DatabaseSystem.addStatusListener(this);
        Frame frame = new Frame();
        try {
            if (new UserLogonDlg(frame).getResponse()) {
                bl = true;
            } else {
                bl = false;
                new ShutdownThread(false).run();
            }
            frame.dispose();
            if (bl) {
                Qit.setEnabled(false);
                LogSystem.beginLogSection("Initialization");
                if (PropertySystem.getBool(72)) {
                    this.initWindow = this.createInitializeWindow();
                }
                if (PropertySystem.getBool(71)) {
                    QuestUtil.clearTempDir();
                }
                QuestUtil.populateTempDir();
                bl = InitializeThread.loadExternalClasses();
                LogSystem.log(1, "Connecting to database: ");
                bl = DatabaseSystem.createConnection(1, PropertySystem.getString(11), PropertySystem.getString(13), PropertySystem.getString(12), string, string2);
                if (PropertySystem.getBool(60)) {
                    new DatabaseDlg();
                }
                if (!bl) {
                    GUISystem.printBox(6, 129);
                }
                if (bl) {
                    LogSystem.log(1, "Reading Constants");
                    if (this.initWindow != null) {
                        this.initWindow.setText(1615);
                    }
                    bl = Constants.refreshConstants(LogSystem.getInstance());
                }
                if (bl && 43 != Constants.getIntConst("IT_VERSION")) {
                    LogSystem.log(1, "Checked Application Version. Software Version:" + 43 + "  Database Version:" + Constants.getIntConst("IT_VER"));
                    bl = false;
                    if (this.initWindow != null) {
                        this.initWindow.dispose();
                    }
                    this.updateApplication();
                }
                if (bl) {
                    LogSystem.log(1, "Creating Type Lists");
                    if (this.initWindow != null) {
                        this.initWindow.setText(Str.getStr(1633));
                    }
                    new QITTypeList();
                }
                if (bl) {
                    LogSystem.log(1, "Reading user information");
                    if (this.initWindow != null) {
                        this.initWindow.setText(Str.getStr(139));
                    }
                    bl = UserSystem.logonUser(PropertySystem.getString(10), PropertySystem.getString(18));
                }
                PropertySystem.putString(18, "");
                if (bl) {
                    LogSystem.log(1, "Reading Start up lists");
                    if (this.initWindow != null) {
                        this.initWindow.setText(170);
                    }
                    TypeList.getInstance();
                    TypeList.refreshList(new JList(), 15, null);
                    TypeList.getInstance();
                    TypeList.refreshList(new JList(), 10, null);
                }
                if (bl) {
                    LogSystem.log(1, "Reading all users");
                    if (this.initWindow != null) {
                        this.initWindow.setText(1664);
                    }
                    bl = UserSystem.refreshAllUsers();
                }
                if (bl) {
                    LogSystem.log(1, "Reading all brand and family information");
                    if (this.initWindow != null) {
                        this.initWindow.setText(626);
                    }
                    new Brands(PropertySystem.getBool(79));
                    Brands.setCacheDir(CacheSystem.getCacheDir());
                    bl = Brands.readAssociations(LogSystem.getInstance());
                }
                if (bl && InitializeThread.getRunSetup() && !new SetupWizard().getResult()) {
                    System.exit(0);
                }
                if (bl) {
                    LogSystem.log(1, "Reading all Custom views");
                    if (this.initWindow != null) {
                        this.initWindow.setText(1006);
                    }
                    CustomViewSystem.readViews();
                }
                if (bl) {
                    LogSystem.log(1, "Reading all Bookmarks");
                    if (this.initWindow != null) {
                        this.initWindow.setText(1016);
                    }
                    BookmarkSystem.readBookmarks();
                }
                if (bl) {
                    LogSystem.log(1, "Initialization Complete, bringing Workspace up");
                    WindowSystem.createMainWindow();
                    MainWindow.createWorkspace();
                    MainWindow.getInstance().setApplicationInstance(this.qit);
                }
                LogSystem.endLogSection();
                if (!bl) {
                    LogSystem.log(1, "Initialization Failed. Bringing up Logon Screen Again");
                    if (this.initWindow != null) {
                        this.initWindow.dispose();
                    }
                    Qit.setEnabled(true);
                    PropertySystem.putString(18, "");
                    this.run();
                } else {
                    Qit.setEnabled(true);
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
            Qit.setEnabled(true);
            this.run();
        }
        DatabaseSystem.removeStatusListener(this);
        if (this.initWindow != null) {
            this.initWindow.dispose();
        }
    }

    private static boolean loadExternalClasses() {
        boolean bl = false;
        String string = "";
        boolean bl2 = PropertySystem.getBool(17);
        if (bl2) {
            bl = InitializeThread.loadClass("COM.ibm.db2.jdbc.app.DB2Driver") != null;
        } else {
            boolean bl3 = bl = InitializeThread.loadClass("COM.ibm.db2.jdbc.net.DB2Driver") != null;
        }
        if (bl) {
            LogSystem.log(1, "All External Classes Loaded");
        }
        return bl;
    }

    private static Class loadClass(String string) {
        Class<?> clazz = null;
        try {
            LogSystem.log(1, "Loading Class " + string);
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Frame frame = new Frame("");
            LogSystem.log(1, classNotFoundException, false);
            GUISystem.printBox(frame, "Fatal Error", "Cannot load Class:" + string);
            frame.dispose();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return clazz;
    }

    private static Class loadClassNoError(String string) {
        Class<?> clazz = null;
        try {
            LogSystem.log(1, "Loading Class " + string);
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return clazz;
    }

    public void databaseStatusChange(int n, Database database) {
        switch (n) {
            case 1: {
                if (this.initWindow == null || this.connectingShown) break;
                this.connectingShown = true;
                this.initWindow.setText(Str.getStr(625) + " " + database.getName());
                break;
            }
        }
    }

    private void updateApplication() {
        GUISystem.printBox(7, 955);
        new QuestUpdater();
    }

    private InitializeWindow createInitializeWindow() {
        InitializeWindow initializeWindow = null;
        try {
            String string = "com.ibm.nzna.projects.qit.skins." + PropertySystem.getString(21) + ".";
            String string2 = string + "SkinInitializeWindow";
            Class clazz = InitializeThread.loadClassNoError(string2);
            if (clazz == null) {
                clazz = InitializeThread.loadClassNoError("com.ibm.nzna.projects.qit.skins.Default.SkinInitializeWindow");
            }
            if (clazz != null) {
                initializeWindow = (InitializeWindow)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            initializeWindow = null;
        }
        return initializeWindow;
    }

    private static boolean getRunSetup() {
        boolean bl = true;
        try {
            boolean bl2 = bl = !PropertySystem.getBool(29);
            if (!bl) {
                File file = new File(PropertySystem.getString(30));
                bl = !file.exists();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public InitializeThread(Qit qit, boolean bl) {
        this.qit = qit;
        if (bl) {
            new Thread(this).start();
        }
    }
}

