/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.app;

import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeGeoRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.LocaleGeoRec;
import com.ibm.nzna.projects.qit.app.QITRec;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.doc.storedProc.docReader.DocReaderBuffer;
import com.ibm.nzna.projects.qit.type.QITTypeList;
import com.ibm.nzna.shared.db.SQLParse;
import com.ibm.nzna.shared.util.LogSystem;
import java.io.Serializable;
import java.util.Vector;

public class LocaleRec
extends QITRec
implements Serializable,
AppConst {
    private boolean worldWide = false;
    private Vector geoVec = null;

    private void createGeoVec() {
        Vector vector = QITTypeList.getInstance().getTypeList(6);
        int n = 0;
        int n2 = 0;
        try {
            n2 = vector.size();
            this.geoVec = new Vector(vector.size());
            while (n < n2) {
                this.geoVec.addElement(new LocaleGeoRec((TypeGeoRec)vector.elementAt(n++)));
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public int geoCount() {
        int n = 0;
        try {
            LocaleGeoRec localeGeoRec = null;
            int n2 = 0;
            int n3 = this.geoVec.size();
            while (n2 < n3) {
                localeGeoRec = (LocaleGeoRec)this.geoVec.elementAt(n2);
                if (localeGeoRec.isAll() || localeGeoRec.countryCount() > 0) {
                    ++n;
                }
                ++n2;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return n;
    }

    public int countryCount() {
        int n = 0;
        try {
            LocaleGeoRec localeGeoRec = null;
            int n2 = 0;
            int n3 = this.geoVec.size();
            while (n2 < n3) {
                localeGeoRec = (LocaleGeoRec)this.geoVec.elementAt(n2);
                n += localeGeoRec.countryCount();
                ++n2;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return n;
    }

    private LocaleGeoRec localeGeoRecFromGeo(TypeGeoRec typeGeoRec) {
        int n = 0;
        int n2 = this.geoVec.size();
        LocaleGeoRec localeGeoRec = null;
        while (n < n2 && localeGeoRec == null) {
            if (((LocaleGeoRec)this.geoVec.elementAt(n)).equals(typeGeoRec)) {
                localeGeoRec = (LocaleGeoRec)this.geoVec.elementAt(n);
            }
            ++n;
        }
        return localeGeoRec;
    }

    private void validateWorldWide() {
        int n = 0;
        int n2 = this.geoVec.size();
        boolean bl = true;
        while (n < n2 && bl) {
            bl = ((LocaleGeoRec)this.geoVec.elementAt(n++)).isAll();
        }
        this.worldWide = bl;
    }

    public void addCountry(TypeCountryCodeRec typeCountryCodeRec) {
        LocaleGeoRec localeGeoRec;
        if (typeCountryCodeRec != null && (localeGeoRec = this.localeGeoRecFromGeo((TypeGeoRec)QITTypeList.getInstance().objectFromInd(typeCountryCodeRec.getGeoInd(), 6))) != null) {
            localeGeoRec.addCountry(typeCountryCodeRec);
            if (localeGeoRec.isAll()) {
                this.validateWorldWide();
            }
        }
    }

    public void removeCountry(TypeCountryCodeRec typeCountryCodeRec) {
        LocaleGeoRec localeGeoRec;
        if (typeCountryCodeRec != null && (localeGeoRec = this.localeGeoRecFromGeo((TypeGeoRec)QITTypeList.getInstance().objectFromInd(typeCountryCodeRec.getGeoInd(), 6))) != null) {
            localeGeoRec.removeCountry(typeCountryCodeRec);
            this.worldWide = false;
        }
    }

    public void removeGeography(TypeGeoRec typeGeoRec) {
        LocaleGeoRec localeGeoRec = this.localeGeoRecFromGeo(typeGeoRec);
        localeGeoRec.removeAll();
        this.worldWide = false;
    }

    public void addGeography(TypeGeoRec typeGeoRec) {
        LocaleGeoRec localeGeoRec = this.localeGeoRecFromGeo(typeGeoRec);
        localeGeoRec.associateAll();
        this.validateWorldWide();
    }

    public void addGeography(int n) {
        this.addGeography((TypeGeoRec)TypeList.getInstance().objectFromInd(n, 6));
    }

    public void addCountry(int n) {
        this.addCountry((TypeCountryCodeRec)TypeList.getInstance().objectFromInd(n, 3));
    }

    public boolean isWorldWide() {
        this.validateWorldWide();
        return this.worldWide;
    }

    public Vector getCountryList() {
        Vector vector = null;
        if (this.worldWide) {
            vector = QITTypeList.getInstance().getTypeList(3);
        } else {
            LocaleGeoRec localeGeoRec = null;
            Vector vector2 = null;
            int n = 0;
            int n2 = this.geoVec.size();
            int n3 = 0;
            int n4 = 0;
            vector = new Vector(100, 10);
            while (n < n2) {
                localeGeoRec = (LocaleGeoRec)this.geoVec.elementAt(n);
                if (localeGeoRec.countryCount() > 0 && (vector2 = localeGeoRec.getCountryList()) != null) {
                    n3 = 0;
                    n4 = vector2.size();
                    while (n3 < n4) {
                        vector.addElement(vector2.elementAt(n3++));
                    }
                }
                ++n;
            }
        }
        return vector;
    }

    public Vector getSingleCountryList() {
        Vector vector = null;
        LocaleGeoRec localeGeoRec = null;
        Vector vector2 = null;
        int n = 0;
        int n2 = this.geoVec.size();
        int n3 = 0;
        int n4 = 0;
        vector = new Vector(100, 10);
        while (n < n2) {
            localeGeoRec = (LocaleGeoRec)this.geoVec.elementAt(n);
            if (!localeGeoRec.isAll() && localeGeoRec.countryCount() > 0 && (vector2 = localeGeoRec.getCountryList()) != null) {
                n3 = 0;
                n4 = vector2.size();
                while (n3 < n4) {
                    vector.addElement(vector2.elementAt(n3++));
                }
            }
            ++n;
        }
        return vector;
    }

    public void setWorldWide() {
        int n = 0;
        int n2 = this.geoVec.size();
        boolean bl = true;
        while (n < n2 && bl) {
            ((LocaleGeoRec)this.geoVec.elementAt(n++)).associateAll();
        }
        this.worldWide = true;
    }

    public void setDataFromDatabase(String string, String string2) {
        try {
            SQLParse sQLParse;
            QITTypeList qITTypeList = (QITTypeList)QITTypeList.getInstance();
            if (string != null && string.length() > 0 && string.indexOf("6") != -1) {
                this.setWorldWide();
            }
            if (!this.worldWide && string != null && string.length() > 0) {
                sQLParse = new SQLParse(string);
                if (sQLParse.getRecordCount() > 0) {
                    while (sQLParse.next()) {
                        this.addGeography((TypeGeoRec)qITTypeList.objectFromInd(sQLParse.readInt(0), 6));
                    }
                }
                sQLParse.close();
                sQLParse = null;
            }
            if (!this.worldWide && string2 != null && string2.length() > 0) {
                sQLParse = new SQLParse(string2);
                if (sQLParse.getRecordCount() > 0) {
                    while (sQLParse.next()) {
                        this.addCountry((TypeCountryCodeRec)qITTypeList.objectFromInd(sQLParse.readInt(0), 3));
                    }
                }
                sQLParse.close();
                sQLParse = null;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public void setDataFromDatabase(DocReaderBuffer docReaderBuffer) {
        block11: {
            try {
                int n = 0;
                int n2 = docReaderBuffer.geoVec.size();
                int n3 = docReaderBuffer.countryVec.size();
                while (n < n2) {
                    try {
                        if ((Integer)docReaderBuffer.geoVec.elementAt(n) == 6) {
                            this.setWorldWide();
                            n = n2;
                        } else {
                            this.addGeography((TypeGeoRec)QITTypeList.getInstance().objectFromInd((Integer)docReaderBuffer.geoVec.elementAt(n), 6));
                        }
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    ++n;
                }
                if (this.isWorldWide()) break block11;
                n = 0;
                while (n < n3) {
                    try {
                        this.addCountry((TypeCountryCodeRec)QITTypeList.getInstance().objectFromInd((Integer)docReaderBuffer.countryVec.elementAt(n), 3));
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    ++n;
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        }
    }

    public Vector getGeoListContainingAll() {
        Vector<TypeGeoRec> vector = new Vector<TypeGeoRec>(6);
        try {
            int n = 0;
            int n2 = this.geoVec.size();
            while (n < n2) {
                if (((LocaleGeoRec)this.geoVec.elementAt(n)).isAll()) {
                    vector.addElement(((LocaleGeoRec)this.geoVec.elementAt(n)).getTypeGeoRec());
                }
                ++n;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return vector;
    }

    public Object clone() {
        LocaleRec localeRec = new LocaleRec(this);
        return localeRec;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof LocaleRec) {
            LocaleRec localeRec = (LocaleRec)object;
            bl = this.worldWide && localeRec.isWorldWide() ? true : localeRec.countryCount() == this.countryCount();
        }
        return bl;
    }

    public String getLocaleList() {
        String string = Str.getStr(198);
        if (this.isWorldWide()) {
            string = Str.getStr(210);
        } else {
            Vector vector = this.getCountryList();
            if (vector != null && vector.size() > 0) {
                int n = 0;
                int n2 = vector.size();
                string = "";
                while (n < n2) {
                    string = string + ((TypeCountryCodeRec)vector.elementAt(n++)).toString() + ", ";
                }
                string = string.substring(0, string.length() - 2);
            }
        }
        return string;
    }

    public LocaleRec() {
        this.createGeoVec();
    }

    public LocaleRec(LocaleRec localeRec) {
        this.worldWide = localeRec.worldWide;
        if (localeRec.geoVec != null) {
            this.geoVec = (Vector)localeRec.geoVec.clone();
        }
    }
}

