/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.app;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.PropertyListener;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.StringTokenizer;

public class ThemeSystem
implements AppConst,
PropertyListener {
    private static Properties themeProperties = null;

    private static void reloadThemeProperty() {
        String string = PropertySystem.getString(21);
        String string2 = PropertySystem.getString(23);
        themeProperties = new Properties();
        if (string != null) {
            string = string2 + File.separator + "skins" + File.separator + string + File.separator + "theme.property";
            LogSystem.log(1, "Trying to load property file:" + string);
            try {
                themeProperties.load(new FileInputStream(new File(string)));
            }
            catch (Exception exception) {
                LogSystem.log(1, "Cannot load theme properties for filename:" + string);
                LogSystem.log(1, exception, false);
                try {
                    themeProperties.load(new FileInputStream(new File("skins" + File.separator + "Default" + File.separator + "theme.property")));
                }
                catch (Exception exception2) {
                    LogSystem.log(1, "Cannot load Default Theme after previous Exception");
                    LogSystem.log(1, exception2, false);
                }
            }
        }
    }

    public void propertyChanged(int n, Object object) {
        if (n == 21) {
            ThemeSystem.reloadThemeProperty();
        }
    }

    public static final Color getColor(String string) {
        String string2 = themeProperties.getProperty(string, "0,0,0");
        return ThemeSystem.getColorFromRGBString(string2);
    }

    private static Color getColorFromRGBString(String string) {
        Color color = Color.black;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            String string2 = null;
            string2 = stringTokenizer.nextToken();
            if (string2 != null) {
                n = new Integer(string2);
            }
            if ((string2 = stringTokenizer.nextToken()) != null) {
                n2 = new Integer(string2);
            }
            if ((string2 = stringTokenizer.nextToken()) != null) {
                n3 = new Integer(string2);
            }
            color = n == -1 || n2 == -1 || n3 == -1 ? null : new Color(n, n2, n3);
        }
        catch (Exception exception) {
            LogSystem.log(1, "Cannot parse RGB Value from :" + string);
            LogSystem.log(1, exception, false);
        }
        return color;
    }

    public static final Object getThemeProperty(String string) {
        return themeProperties.getProperty(string);
    }

    public static final boolean getBoolean(String string) {
        boolean bl = false;
        String string2 = themeProperties.getProperty(string);
        if (string2.equalsIgnoreCase("TRUE")) {
            bl = true;
        }
        return bl;
    }

    public static void texturePanel(Graphics graphics, Image image, Image image2, Image image3, Image image4, Image image5) {
    }

    public ThemeSystem() {
        ThemeSystem.reloadThemeProperty();
        PropertySystem.addPropertyListener(21, this);
    }
}

