/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.app.appProp;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.AppletRec;
import com.ibm.nzna.projects.qit.app.AppletSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertyListener;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.QuestApplet;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.gui.SingleEntryDlg;
import com.ibm.nzna.projects.qit.help.HelpSystem;
import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.gui.wizard.WizardStep;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.StoreUtil;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JLabel;

public class AppletsPage
extends WizardStep
implements ActionListener,
PropertyListener,
AppConst {
    private static String[] cnrTitle = null;
    private JLabel st_HELP = null;
    private MultiList cnr_APPLETS = null;
    private DButton pb_ADD = null;
    private DButton pb_REMOVE = null;
    private DButton pb_HELP = null;
    private ButtonPanel buttonPanel = null;
    private Vector addAppletVec = new Vector(1, 1);
    private Vector removeAppletVec = new Vector(1, 1);

    public void doLayout() {
        Dimension dimension = this.getSize();
        this.st_HELP.setBounds(5, 5, dimension.width - 5, 125);
        this.cnr_APPLETS.setBounds(10, 150, dimension.width - 20, 200);
        this.buttonPanel.setBounds(10, dimension.height - 50, dimension.width - 20, 25);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.pb_HELP) {
            HelpSystem.showHelp("app" + File.separator + "quest_applet.html");
        } else if (object == this.pb_ADD) {
            this.add();
        } else if (object == this.pb_REMOVE) {
            this.remove();
        }
    }

    public void propertyChanged(int n, Object object) {
        if (n == 1) {
            this.setText();
        }
    }

    private void setText() {
        this.pb_ADD.setText(Str.getStr(95));
        this.pb_REMOVE.setText(Str.getStr(96));
        this.pb_HELP.setText(Str.getStr(10));
        this.st_HELP.setText(Str.getStr(97));
        cnrTitle = new String[3];
        AppletsPage.cnrTitle[0] = "";
        AppletsPage.cnrTitle[1] = Str.getStr(99);
        AppletsPage.cnrTitle[2] = Str.getStr(100);
        this.cnr_APPLETS.setColumnHeadings(cnrTitle);
        this.cnr_APPLETS.setColumnWidth(0, 22);
        this.cnr_APPLETS.setColumnWidth(2, 455);
        this.cnr_APPLETS.setBackground(Color.white);
        this.cnr_APPLETS.setOddLinesColor(GUISystem.oddLinesColor);
    }

    private void refreshData() {
        Vector vector = AppletSystem.getAppletList();
        if (vector != null) {
            this.cnr_APPLETS.removeAll();
            this.cnr_APPLETS.add(vector);
        }
    }

    private void add() {
        String string = new SingleEntryDlg(WinUtil.getParentDialog(this), Str.getStr(101), Str.getStr(102), "com.ibm.nzna.projects.qit.").getResult();
        if (string != null && string.length() > 0) {
            try {
                QuestApplet questApplet = (QuestApplet)Class.forName(string).newInstance();
                AppletRec appletRec = new AppletRec(string);
                this.cnr_APPLETS.add(appletRec);
                this.addAppletVec.addElement(appletRec);
                if (StoreUtil.vectorContains(this.removeAppletVec, appletRec)) {
                    this.removeAppletVec.removeElement(appletRec);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                GUISystem.printBox(WinUtil.getParentJDialog(this), Str.getStr(7), Str.getStr(103));
            }
            catch (IllegalAccessException illegalAccessException) {
                LogSystem.log(1, illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                LogSystem.log(1, instantiationException);
            }
        }
    }

    private void remove() {
        AppletRec appletRec = (AppletRec)this.cnr_APPLETS.getSelectedItem();
        if (appletRec != null) {
            this.cnr_APPLETS.remove(appletRec);
            this.removeAppletVec.addElement(appletRec);
            if (StoreUtil.vectorContains(this.addAppletVec, appletRec)) {
                this.addAppletVec.removeElement(appletRec);
            }
        }
    }

    public boolean saveInfo() {
        int n;
        int n2;
        if (this.addAppletVec.size() > 0) {
            n2 = 0;
            n = this.addAppletVec.size();
            while (n2 < n) {
                AppletSystem.addApplet((AppletRec)this.addAppletVec.elementAt(n2));
                ++n2;
            }
        }
        if (this.removeAppletVec.size() > 0) {
            n2 = 0;
            n = this.removeAppletVec.size();
            while (n2 < n) {
                AppletSystem.removeApplet((AppletRec)this.removeAppletVec.elementAt(n2));
                ++n2;
            }
        }
        return true;
    }

    protected void free() {
        PropertySystem.removePropertyListener(1, this);
    }

    public String getTitle() {
        return Str.getStr(97);
    }

    public AppletsPage() {
        this.st_HELP = new JLabel();
        this.pb_ADD = new DButton("");
        this.pb_REMOVE = new DButton("");
        this.pb_HELP = new DButton("");
        this.cnr_APPLETS = new MultiList(GUISystem.getFontUtil());
        this.buttonPanel = new ButtonPanel();
        this.st_HELP.setVerticalAlignment(1);
        GUISystem.setPreferredButton(this.pb_ADD);
        GUISystem.setPreferredButton(this.pb_REMOVE);
        GUISystem.setPreferredButton(this.pb_HELP);
        this.cnr_APPLETS.setOddLinesColor(new Color(240, 240, 240));
        this.setText();
        PropertySystem.addPropertyListener(1, this);
        this.pb_HELP.addActionListener(this);
        this.pb_ADD.addActionListener(this);
        this.pb_REMOVE.addActionListener(this);
        this.setLayout(null);
        this.add(this.st_HELP);
        this.add(this.cnr_APPLETS);
        this.add(this.buttonPanel);
        this.buttonPanel.add(this.pb_ADD);
        this.buttonPanel.add(this.pb_REMOVE);
        this.buttonPanel.add(this.pb_HELP);
        this.refreshData();
    }
}

