/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.app.appProp;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertyListener;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.shared.gui.wizard.WizardStep;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontPage
extends WizardStep
implements ActionListener,
AppConst,
PropertyListener,
ListSelectionListener {
    private Font defaultFont = null;
    private Font largeTitleFont = null;
    private Font smallTitleFont = null;
    private Font buttonFont = null;
    private Font listFont = null;
    private Font textFont = null;
    private Font smallFont = null;
    private Font panelTitleFont = null;
    private JLabel st_HELP = null;
    private JList lb_CONTROLS = null;
    private JLabel st_SAMPLE = null;
    private JScrollPane scr_CONTROLS = null;
    private JComboBox cb_FONTS = null;
    private JComboBox cb_SIZES = null;
    private JCheckBox ck_BOLD = null;
    private JCheckBox ck_ITALIC = null;
    private Vector fontVec = null;
    private String currentControl = null;

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = dimension.width / 2;
        int n2 = GUISystem.getRowHeight();
        int n3 = 110 + n2;
        super.doLayout();
        this.st_HELP.setBounds(5, 5, dimension.width - 10, 100);
        this.scr_CONTROLS.setBounds(5, 110, n - 5, 100);
        this.cb_FONTS.setBounds(n + 5, 110, n - 50, n2);
        this.cb_SIZES.setBounds(dimension.width - 40, 110, 35, n2);
        this.ck_BOLD.setBounds(n + 5, n3 += n2, n - 10, n2);
        this.ck_ITALIC.setBounds(n + 5, n3 += n2, n - 10, n2);
        this.st_SAMPLE.setBounds(5, 220, dimension.width - 10, 50);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.st_SAMPLE.setFont(this.fontFromGUI());
    }

    public void setText() {
        try {
            int n = PropertySystem.getInt(1);
            Vector<String> vector = new Vector<String>(1, 1);
            this.st_HELP.setText(Str.getStr(639));
            vector.addElement(Str.getStr(640));
            vector.addElement(Str.getStr(641));
            vector.addElement(Str.getStr(642));
            vector.addElement(Str.getStr(643));
            vector.addElement(Str.getStr(644));
            vector.addElement(Str.getStr(647));
            vector.addElement(Str.getStr(648));
            this.lb_CONTROLS.removeAll();
            this.lb_CONTROLS.setListData(vector);
            this.ck_BOLD.setText(Str.getStr(570));
            this.ck_ITALIC.setText(Str.getStr(571));
            this.st_SAMPLE.setText(Str.getStr(645));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        try {
            String string = (String)this.lb_CONTROLS.getSelectedValue();
            if (this.currentControl != null && string != this.currentControl) {
                this.saveData();
            }
            this.currentControl = string;
            this.refreshData(this.fontFromControl(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean saveInfo() {
        this.saveData();
        if (!this.defaultFont.equals(FontSystem.defaultFont)) {
            PropertySystem.put(5, this.defaultFont);
        }
        if (!this.largeTitleFont.equals(FontSystem.largeTitleFont)) {
            PropertySystem.put(3, this.largeTitleFont);
        }
        if (!this.smallTitleFont.equals(FontSystem.smallTitleFont)) {
            PropertySystem.put(4, this.smallTitleFont);
        }
        if (!this.buttonFont.equals(FontSystem.buttonFont)) {
            PropertySystem.put(7, this.buttonFont);
        }
        if (!this.listFont.equals(FontSystem.listFont)) {
            PropertySystem.put(6, this.listFont);
        }
        if (!this.textFont.equals(FontSystem.textFont)) {
            PropertySystem.put(5, this.textFont);
        }
        if (!this.smallFont.equals(FontSystem.smallFont)) {
            PropertySystem.put(25, this.smallFont);
        }
        if (!this.panelTitleFont.equals(FontSystem.panelTitleFont.getName())) {
            PropertySystem.put(37, this.panelTitleFont);
        }
        this.setTempFonts();
        return true;
    }

    public void propertyChanged(int n, Object object) {
        this.setText();
    }

    protected void free() {
        PropertySystem.removePropertyListener(1, this);
    }

    private void refreshData(Font font) {
        String string = font.getName();
        int n = font.getSize();
        boolean bl = font.isBold();
        boolean bl2 = font.isItalic();
        this.cb_FONTS.setSelectedItem(string);
        this.ck_BOLD.setSelected(bl);
        this.ck_ITALIC.setSelected(bl2);
        this.cb_SIZES.setSelectedItem(n + "");
        this.st_SAMPLE.setFont(font);
    }

    private Font fontFromControl(String string) {
        if (string.equals(Str.getStr(640))) {
            return this.buttonFont;
        }
        if (string.equals(Str.getStr(641))) {
            return this.listFont;
        }
        if (string.equals(Str.getStr(643))) {
            return this.textFont;
        }
        if (string.equals(Str.getStr(642))) {
            return this.largeTitleFont;
        }
        if (string.equals(Str.getStr(644))) {
            return this.smallTitleFont;
        }
        if (string.equals(Str.getStr(647))) {
            return this.smallFont;
        }
        if (string.equals(Str.getStr(648))) {
            return this.panelTitleFont;
        }
        return null;
    }

    private void saveData() {
        if (this.currentControl != null) {
            if (this.currentControl.equals(Str.getStr(640))) {
                this.buttonFont = this.fontFromGUI();
            } else if (this.currentControl.equals(Str.getStr(641))) {
                this.listFont = this.fontFromGUI();
            } else if (this.currentControl.equals(Str.getStr(643))) {
                this.textFont = this.fontFromGUI();
            } else if (this.currentControl.equals(Str.getStr(642))) {
                this.largeTitleFont = this.fontFromGUI();
            } else if (this.currentControl.equals(Str.getStr(644))) {
                this.smallTitleFont = this.fontFromGUI();
            } else if (this.currentControl.equals(Str.getStr(647))) {
                this.smallFont = this.fontFromGUI();
            } else if (this.currentControl.equals(Str.getStr(648))) {
                this.panelTitleFont = this.fontFromGUI();
            }
        }
    }

    private Font fontFromGUI() {
        Font font = null;
        int n = 0;
        if (this.ck_BOLD.isSelected() && this.ck_ITALIC.isSelected()) {
            n = 3;
        } else if (!this.ck_BOLD.isSelected() && this.ck_ITALIC.isSelected()) {
            n = 2;
        } else if (this.ck_BOLD.isSelected() && !this.ck_ITALIC.isSelected()) {
            n = 1;
        }
        font = new Font(this.cb_FONTS.getSelectedItem().toString(), n, new Integer(this.cb_SIZES.getSelectedItem().toString()));
        return font;
    }

    private void setTempFonts() {
        this.defaultFont = new Font(FontSystem.defaultFont.getName(), FontSystem.defaultFont.getStyle(), FontSystem.defaultFont.getSize());
        this.largeTitleFont = new Font(FontSystem.largeTitleFont.getName(), FontSystem.largeTitleFont.getStyle(), FontSystem.largeTitleFont.getSize());
        this.smallTitleFont = new Font(FontSystem.smallTitleFont.getName(), FontSystem.smallTitleFont.getStyle(), FontSystem.smallTitleFont.getSize());
        this.buttonFont = new Font(FontSystem.buttonFont.getName(), FontSystem.buttonFont.getStyle(), FontSystem.buttonFont.getSize());
        this.listFont = new Font(FontSystem.listFont.getName(), FontSystem.listFont.getStyle(), FontSystem.listFont.getSize());
        this.textFont = new Font(FontSystem.textFont.getName(), FontSystem.textFont.getStyle(), FontSystem.textFont.getSize());
        this.smallFont = new Font(FontSystem.smallFont.getName(), FontSystem.smallFont.getStyle(), FontSystem.smallFont.getSize());
        this.panelTitleFont = new Font(FontSystem.panelTitleFont.getName(), FontSystem.panelTitleFont.getStyle(), FontSystem.panelTitleFont.getSize());
    }

    public String getTitle() {
        return Str.getStr(1432);
    }

    public FontPage() {
        Vector<String> vector = new Vector<String>(3, 1);
        Vector<String> vector2 = new Vector<String>(6, 1);
        vector.addElement("Helvetica");
        vector.addElement("Serif");
        vector.addElement("Courier");
        int n = 8;
        while (n < 32) {
            vector2.addElement(n + "");
            n += 2;
        }
        this.st_HELP = new JLabel();
        this.lb_CONTROLS = new JList();
        this.st_SAMPLE = new JLabel();
        this.cb_FONTS = new JComboBox(vector);
        this.cb_SIZES = new JComboBox(vector2);
        this.ck_BOLD = new JCheckBox();
        this.ck_ITALIC = new JCheckBox();
        this.scr_CONTROLS = new JScrollPane(this.lb_CONTROLS);
        this.st_HELP.setVerticalAlignment(1);
        this.st_SAMPLE.setBorder(GUISystem.loweredBorder);
        this.lb_CONTROLS.setBorder(GUISystem.loweredBorder);
        PropertySystem.addPropertyListener(1, this);
        this.lb_CONTROLS.addListSelectionListener(this);
        this.cb_SIZES.addActionListener(this);
        this.cb_FONTS.addActionListener(this);
        this.ck_BOLD.addActionListener(this);
        this.ck_ITALIC.addActionListener(this);
        this.setLayout(null);
        this.add(this.st_HELP);
        this.add(this.scr_CONTROLS);
        this.add(this.cb_FONTS);
        this.add(this.cb_SIZES);
        this.add(this.ck_BOLD);
        this.add(this.ck_ITALIC);
        this.add(this.st_SAMPLE);
        this.setText();
        this.setTempFonts();
    }
}

