/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.app.userProp;

import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.quest.type.TypeFamilyRec;
import com.ibm.nzna.projects.common.quest.type.TypeGroupRec;
import com.ibm.nzna.projects.common.quest.type.TypeListListener;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.shared.gui.wizard.WizardStep;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BrandFamilyPage
extends WizardStep
implements AppConst,
ActionListener,
ListSelectionListener,
TypeListListener {
    private JLabel st_HELP = null;
    private JLabel st_BRAND = null;
    private JLabel st_FAMILY = null;
    private JList lb_BRAND = null;
    private JList lb_FAMILY = null;
    private JScrollPane scr_BRAND = null;
    private JScrollPane scr_FAMILY = null;
    private JCheckBox ck_NO_BRAND = null;
    private JCheckBox ck_NO_FAMILY = null;

    private void initialize() {
        this.st_HELP = new JLabel(Str.getStr(654));
        this.st_BRAND = new JLabel(Str.getStr(145));
        this.st_FAMILY = new JLabel(Str.getStr(149));
        this.lb_BRAND = new JList();
        this.lb_FAMILY = new JList();
        this.scr_BRAND = new JScrollPane(this.lb_BRAND);
        this.scr_FAMILY = new JScrollPane(this.lb_FAMILY);
        this.ck_NO_BRAND = new JCheckBox(Str.getStr(198));
        this.ck_NO_FAMILY = new JCheckBox(Str.getStr(198));
        this.lb_BRAND.addListSelectionListener(this);
        this.ck_NO_BRAND.addActionListener(this);
        this.ck_NO_FAMILY.addActionListener(this);
        this.st_HELP.setVerticalAlignment(1);
        this.setLayout(null);
        this.add(this.st_HELP);
        this.add(this.st_BRAND);
        this.add(this.st_FAMILY);
        this.add(this.scr_BRAND);
        this.add(this.scr_FAMILY);
        this.add(this.ck_NO_BRAND);
        this.add(this.ck_NO_FAMILY);
        this.refreshData();
    }

    private void refreshData() {
        this.lb_BRAND.setListData(Brands.getBrands());
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 5;
        int n2 = 25;
        int n3 = GUISystem.getRowHeight();
        super.doLayout();
        this.st_HELP.setBounds(n2, n, dimension.width - n2, 100);
        this.st_BRAND.setBounds(n2, n += 100, 150, n3);
        this.st_FAMILY.setBounds(n2 + 200, n, 150, n3);
        this.scr_BRAND.setBounds(n2, n += n3, 150, dimension.height - n - n3 - 5);
        this.scr_FAMILY.setBounds(n2 + 200, n, 150, dimension.height - n - n3 - 5);
        this.ck_NO_BRAND.setBounds(n2, dimension.height - n3 - 5, 150, n3);
        this.ck_NO_FAMILY.setBounds(n2 + 200, dimension.height - n3 - 5, 150, n3);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.lb_BRAND.getSelectedValue();
        if (typeCategoryRec != null) {
            this.lb_FAMILY.removeAll();
            this.lb_FAMILY.setListData(Brands.getFamilies(typeCategoryRec.getInd()));
        }
    }

    public void listRefreshed(int n) {
        try {
            int n2 = PropertySystem.getInt(38);
            int n3 = PropertySystem.getInt(39);
            TypeCategoryRec typeCategoryRec = Brands.getBrand(n2);
            TypeFamilyRec typeFamilyRec = Brands.getFamily(n3);
            if (typeCategoryRec != null) {
                this.lb_BRAND.setSelectedValue(typeCategoryRec, true);
                this.lb_FAMILY.removeAll();
                this.lb_FAMILY.setListData(Brands.getFamilies(typeCategoryRec));
                if (typeFamilyRec != null) {
                    this.lb_FAMILY.setSelectedValue(typeFamilyRec, true);
                }
            }
            this.ck_NO_BRAND.setSelected(n2 == -1);
            this.ck_NO_FAMILY.setSelected(n3 == -1);
            this.enableLists();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    private void enableLists() {
        this.lb_BRAND.setEnabled(!this.ck_NO_BRAND.isSelected());
        this.lb_FAMILY.setEnabled(!this.ck_NO_FAMILY.isSelected());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.enableLists();
    }

    public boolean saveInfo() {
        boolean bl = true;
        try {
            TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.lb_BRAND.getSelectedValue();
            TypeGroupRec typeGroupRec = (TypeGroupRec)this.lb_FAMILY.getSelectedValue();
            if (!this.ck_NO_BRAND.isSelected()) {
                if (typeCategoryRec == null) {
                    GUISystem.printBox(6, 358);
                    bl = false;
                } else {
                    PropertySystem.putInt(38, typeCategoryRec.getInd());
                }
            } else {
                PropertySystem.putInt(38, -1);
            }
            if (!this.ck_NO_FAMILY.isSelected()) {
                if (typeGroupRec == null) {
                    GUISystem.printBox(6, 358);
                    bl = false;
                } else {
                    PropertySystem.putInt(39, typeGroupRec.getInd());
                }
            } else {
                PropertySystem.putInt(39, -1);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        return bl;
    }

    public String getTitle() {
        return Str.getStr(1425);
    }

    public BrandFamilyPage() {
        this.initialize();
    }
}

