/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.base;

import com.ibm.nzna.projects.common.quest.oa.Action;
import com.ibm.nzna.projects.common.quest.oa.ActionDraft;
import com.ibm.nzna.projects.common.quest.oa.Title;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.avalon.base.ActionDisplayRec;
import com.ibm.nzna.projects.qit.avalon.base.ActionDraftDisplayRec;
import com.ibm.nzna.projects.qit.avalon.cache.AvalonCache;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.io.File;
import java.util.Vector;

public class ActionPreviewRec
implements AppConst {
    private static String previewTemplate = "<html><body bgcolor=\"#FFFFFF\"><p><font size=\"5\" face=\"Arial, Helvetica, sans-serif\">TITLE</font></p><p><font size=\"2\" face=\"Arial, Helvetica, sans-serif\">  <font color=\"#800080\">STR_TITLES</font><br>TITLE_TABLE\n  <font color=\"#800080\">STR_ADDITIONAL_INFO</font>:<br>ADDITIONAL_INFO<br><br>  <font color=\"#800080\">STR_GEOS</font>:<br>GEOS<br><br>  <font color=\"#800080\">STR_INTERNAL_NUM</font>:INTERNAL_NUM<br>  <font color=\"#800080\">STR_CREATE_DATE</font>:CREATEDATE<br>  <font color=\"#800080\">STR_LAST_TOUCHED_ON</font>:LAST_TOUCHED_ON<br>  <font color=\"#800080\">STR_LAST_TOUCHED_BY</font>:LAST_TOUCHED_BY<br>  <font color=\"#800080\">STR_START_DATE</font>:START_DATE<br>  <font color=\"#800080\">STR_STOP_DATE</font>:STOP_DATE</font><br></p></body></html>";
    private String qualifier = "oa";
    private int actionInd = 0;
    private String title = null;
    private String addInfo = null;
    private String prettyCreateDate = null;
    private String prettyChangedTime = null;
    private String prettyDbUser = null;
    private boolean dataValid = false;
    private String geos = null;
    private String startDate = null;
    private String stopDate = null;
    private String titleTable = null;

    public String getPreviewHTMLSource() {
        if (this.dataValid) {
            String string = Text.replaceInStr(previewTemplate, "TITLE", this.title);
            string = Text.replaceInStr(string, "STR_INTERNAL_NUM", Str.getStr(264));
            string = Text.replaceInStr(string, "STR_CREATE_DATE", Str.getStr(948));
            string = Text.replaceInStr(string, "STR_LAST_TOUCHED_ON", Str.getStr(267));
            string = Text.replaceInStr(string, "STR_LAST_TOUCHED_BY", Str.getStr(266));
            string = Text.replaceInStr(string, "STR_ADDITIONAL_INFO", Str.getStr(311));
            string = Text.replaceInStr(string, "STR_GEOS", Str.getStr(148));
            string = Text.replaceInStr(string, "STR_START_DATE", Str.getStr(287));
            string = Text.replaceInStr(string, "STR_STOP_DATE", Str.getStr(288));
            string = Text.replaceInStr(string, "STR_TITLES", Str.getStr(642));
            string = Text.replaceInStr(string, "CREATEDATE", this.prettyCreateDate);
            string = Text.replaceInStr(string, "LAST_TOUCHED_BY", this.prettyDbUser);
            string = Text.replaceInStr(string, "LAST_TOUCHED_ON", this.prettyChangedTime);
            string = Text.replaceInStr(string, "INTERNAL_NUM", "" + this.actionInd);
            string = Text.replaceInStr(string, "ADDITIONAL_INFO", this.addInfo);
            string = Text.replaceInStr(string, "GEOS", this.geos);
            string = Text.replaceInStr(string, "START_DATE", this.startDate);
            string = Text.replaceInStr(string, "STOP_DATE", this.stopDate);
            string = Text.replaceInStr(string, "TITLE_TABLE", this.titleTable);
            return string;
        }
        return "<html><body><center>" + Str.getStr(963) + "</center><br><br><b>ActionInd:</b>" + this.actionInd + "</body></html>";
    }

    private void readPreviewInfo() {
        MainWindow mainWindow = MainWindow.getInstance();
        try {
            Action action = null;
            mainWindow.setStatus(Str.getStr(142));
            action = AvalonCache.readAction(this.actionInd, false);
            if (action != null) {
                Vector vector = action.getTitles();
                Vector vector2 = action.getAdditionalInfo();
                Vector vector3 = action.getCountryList();
                this.title = vector != null && vector.size() > 0 ? vector.elementAt(vector.size() - 1).toString() : Str.getStr(958);
                this.addInfo = vector2 != null && vector2.size() > 0 ? vector2.elementAt(vector2.size() - 1).toString() : " ";
                if (vector3 != null && vector3.size() > 0) {
                    int n = 0;
                    int n2 = vector3.size();
                    this.geos = "";
                    while (n < n2) {
                        this.geos = this.geos + vector3.elementAt(n).toString();
                        if (n < n2 - 1) {
                            this.geos = this.geos + ", ";
                        }
                        ++n;
                    }
                } else {
                    this.geos = " ";
                }
                this.startDate = " ";
                this.stopDate = " ";
                this.prettyCreateDate = action.getCreationTime();
                this.prettyChangedTime = DateSystem.prettyDateFromStamp(action.getChangedTime());
                this.prettyDbUser = UserSystem.getNameFromUserId(action.getDbUser());
                this.formatTitleTable(action);
            }
            this.dataValid = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            this.dataValid = false;
        }
        mainWindow.setStatus(null);
    }

    private void readDraftPreviewInfo() {
        MainWindow mainWindow = MainWindow.getInstance();
        try {
            ActionDraft actionDraft = null;
            mainWindow.setStatus(Str.getStr(142));
            actionDraft = AvalonCache.readActionDraft(this.actionInd, false);
            if (actionDraft != null) {
                Vector vector = actionDraft.getTitles();
                Vector vector2 = actionDraft.getAdditionalInfo();
                Vector vector3 = actionDraft.getCountryList();
                this.title = vector != null && vector.size() > 0 ? vector.elementAt(vector.size() - 1).toString() : Str.getStr(958);
                this.addInfo = vector2 != null && vector2.size() > 0 ? vector2.elementAt(vector2.size() - 1).toString() : " ";
                if (vector3 != null && vector3.size() > 0) {
                    int n = 0;
                    int n2 = vector3.size();
                    this.geos = "";
                    while (n < n2) {
                        this.geos = this.geos + vector3.elementAt(n).toString();
                        if (n < n2 - 1) {
                            this.geos = this.geos + ", ";
                        }
                        ++n;
                    }
                } else {
                    this.geos = " ";
                }
                this.startDate = DateSystem.prettyDateFromDBDate(actionDraft.getStartDate());
                this.stopDate = DateSystem.prettyDateFromDBDate(actionDraft.getStopDate());
                this.prettyCreateDate = actionDraft.getCreationTime();
                this.prettyChangedTime = DateSystem.prettyDateFromStamp(actionDraft.getChangedTime());
                this.prettyDbUser = UserSystem.getNameFromUserId(actionDraft.getDbUser());
                if (this.stopDate == null) {
                    this.stopDate = "";
                }
                this.formatTitleTable(actionDraft);
            }
            this.dataValid = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            this.dataValid = false;
        }
        mainWindow.setStatus(null);
    }

    private void formatTitleTable(Action action) {
        if (action != null) {
            Vector vector = action.getTitles();
            if (vector != null && vector.size() > 0) {
                int n = 0;
                int n2 = vector.size();
                StringBuffer stringBuffer = new StringBuffer("</font><TABLE BORDER=0>");
                Title title = null;
                while (n < n2) {
                    title = (Title)vector.elementAt(n);
                    stringBuffer.append("<tr>");
                    stringBuffer.append("<td><img src=\"file:/");
                    stringBuffer.append(PropertySystem.getString(30));
                    stringBuffer.append(File.separator);
                    switch (title.getDocClass().getInd()) {
                        case 1: {
                            stringBuffer.append("ibm_confidential.gif");
                            break;
                        }
                        case 2: {
                            stringBuffer.append("ibm_dealer_confidential.gif");
                            break;
                        }
                        case 3: {
                            stringBuffer.append("unclassified.gif");
                            break;
                        }
                    }
                    stringBuffer.append("\"></td>");
                    stringBuffer.append("<td><font size=\"2\" face=\"Arial, Helvetica, sans-serif\">");
                    stringBuffer.append(title.toString());
                    stringBuffer.append("</td>");
                    stringBuffer.append("</tr>");
                    ++n;
                }
                stringBuffer.append("</table><br><font size=\"2\" face=\"Arial, Helvetica, sans-serif\">");
                this.titleTable = stringBuffer.toString();
            } else {
                this.titleTable = " ";
            }
        } else {
            this.titleTable = " ";
        }
    }

    public ActionPreviewRec(ActionDisplayRec actionDisplayRec) {
        this.actionInd = actionDisplayRec.getActionInd();
        this.readPreviewInfo();
    }

    public ActionPreviewRec(ActionDraftDisplayRec actionDraftDisplayRec) {
        this.actionInd = actionDraftDisplayRec.getActionInd();
        this.readDraftPreviewInfo();
    }
}

