/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.base;

import com.ibm.nzna.projects.common.quest.Counter;
import com.ibm.nzna.projects.common.quest.oa.AddtlInfo;
import com.ibm.nzna.projects.common.quest.oa.AddtlInfoGraphic;
import com.ibm.nzna.projects.common.quest.type.TypeDocClassRec;
import com.ibm.nzna.projects.common.quest.type.TypeLanguageRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class AddtlInfoImporter
implements AppConst {
    public static boolean importAddtlInfo(String string, AddtlInfo addtlInfo) {
        try {
            AddtlInfoImporter.parseGraphics(string, addtlInfo);
            addtlInfo.setAddtlInfo(string);
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox(7, 1304);
            return false;
        }
        return true;
    }

    public static AddtlInfo createAddtlInfo(String string) {
        AddtlInfo addtlInfo = new AddtlInfo();
        try {
            Vector vector = UserSystem.getUserCountries(UserSystem.getUserId());
            addtlInfo.setLanguage((TypeLanguageRec)TypeList.getInstance().objectFromInd(PropertySystem.getInt(1), 8));
            addtlInfo.setDocClass((TypeDocClassRec)TypeList.getInstance().objectFromInd(1, 5));
            addtlInfo.setCountryList(vector);
            if (!AddtlInfoImporter.importAddtlInfo(string, addtlInfo)) {
                addtlInfo = null;
            }
        }
        catch (Exception exception) {
            addtlInfo = null;
            LogSystem.log(1, exception);
        }
        return addtlInfo;
    }

    private static boolean prepareHTML(String string, AddtlInfo addtlInfo) {
        boolean bl = true;
        try {
            String string2 = string.toUpperCase();
            string = string.substring(0, string2.indexOf("</BODY"));
            string2 = string.toUpperCase();
            string = string.substring(string2.indexOf("<BODY"), string.length());
            string = string.substring(string.indexOf(">") + 1, string.length());
            AddtlInfoImporter.parseGraphics(string, addtlInfo);
            addtlInfo.setAddtlInfo(string);
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox(6, 986);
            bl = false;
        }
        return bl;
    }

    private static void parseGraphics(String string, AddtlInfo addtlInfo) throws Exception {
        Vector vector = addtlInfo.getEmbeddedGraphics();
        Vector vector2 = AddtlInfoImporter.getGraphicsFromHTML(string);
        if (vector2 != null) {
            if (vector == null) {
                vector = new Vector(1, 1);
            }
            AddtlInfoImporter.getNewGraphics(vector2, vector);
            AddtlInfoImporter.setGraphicsRecStatus(vector2, vector);
        }
        addtlInfo.setEmbeddedGraphics(vector);
    }

    private static AddtlInfoGraphic addtlInfoGraphicFromName(String string, Vector vector) {
        AddtlInfoGraphic addtlInfoGraphic = null;
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            AddtlInfoGraphic addtlInfoGraphic2 = null;
            while (n < n2 && vector == null) {
                addtlInfoGraphic2 = (AddtlInfoGraphic)vector.elementAt(n);
                ++n;
            }
        }
        return addtlInfoGraphic;
    }

    private static Vector getGraphicsFromHTML(String string) {
        Vector<String> vector = new Vector<String>(1, 1);
        String string2 = string.toUpperCase();
        if (string2.indexOf("<IMG") >= 0) {
            String string3 = null;
            int n = string2.length();
            int n2 = 0;
            boolean bl = true;
            while (n2 < n && bl) {
                if ((n2 = string2.indexOf("<IMG", n2)) >= 0 && n2 < n) {
                    try {
                        string3 = string.substring(n2, string.length());
                        if (string3.toUpperCase().indexOf("SRC") >= 0) {
                            string3 = string3.substring(string3.toUpperCase().indexOf("SRC") + 3, string3.length());
                        }
                        if (string3.indexOf(" ") >= 0) {
                            string3 = string3.substring(0, string3.indexOf(" ")).trim();
                        }
                        if (string3.indexOf(">") >= 0) {
                            string3 = string3.substring(0, string3.indexOf(">")).trim();
                        }
                        string3 = Text.replaceAllStrInStr(string3, "\"", "");
                        if ((string3 = Text.replaceAllStrInStr(string3, "=", "")).indexOf("http") == -1 && string3.indexOf("HTTP") == -1) {
                            if ((string3 = Text.replaceAllStrInStr(string3, "\\", "/")).indexOf("/") >= 0) {
                                string3 = string3.substring(string3.lastIndexOf("/") + 1);
                            }
                            vector.addElement(string3);
                        }
                    }
                    catch (Exception exception) {
                        LogSystem.log(1, exception, false);
                        LogSystem.log(1, "Received exception parsing token " + string3);
                    }
                } else {
                    bl = false;
                }
                ++n2;
            }
        }
        return vector;
    }

    private static void getNewGraphics(Vector vector, Vector vector2) {
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                if (vector.elementAt(n) instanceof String) {
                    if (!AddtlInfoImporter.findGraphicInVec((String)vector.elementAt(n), vector2)) {
                        LogSystem.log(1, "Found new graphic for additional info, Graphic Name:" + vector.elementAt(n));
                        vector2.addElement(AddtlInfoImporter.createAddtlInfoGraphic((String)vector.elementAt(n)));
                    }
                } else if (vector.elementAt(n) instanceof AddtlInfoGraphic && !AddtlInfoImporter.findGraphicInVec(((AddtlInfoGraphic)vector.elementAt(n)).getFilename(), vector2)) {
                    LogSystem.log(1, "Found new graphic for additional info, Graphic Name:" + ((AddtlInfoGraphic)vector.elementAt(n)).getFilename());
                    vector2.addElement(vector.elementAt(n));
                }
                ++n;
            }
        }
    }

    private static void setGraphicsRecStatus(Vector vector, Vector vector2) {
        if (vector2 != null && vector2.size() > 0) {
            int n = 0;
            int n2 = vector2.size();
            while (n < n2) {
                if (!AddtlInfoImporter.findGraphicInVec(((AddtlInfoGraphic)vector2.elementAt(n)).getFilename(), vector)) {
                    ((AddtlInfoGraphic)vector2.elementAt(n)).updateRecStatus(3);
                } else {
                    ((AddtlInfoGraphic)vector2.elementAt(n)).updateRecStatus(0);
                    ((AddtlInfoGraphic)vector2.elementAt(n)).updateRecStatus(1);
                }
                ++n;
            }
        }
    }

    private static boolean findGraphicInVec(String string, Vector vector) {
        boolean bl = false;
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (!bl && n < n2) {
                if (vector.elementAt(n) instanceof AddtlInfoGraphic) {
                    if (((AddtlInfoGraphic)vector.elementAt(n)).getFilename().equals(string)) {
                        bl = true;
                    }
                } else if (vector.elementAt(n) instanceof String) {
                    bl = ((String)vector.elementAt(n)).equals(string);
                }
                ++n;
            }
        }
        return bl;
    }

    private static AddtlInfoGraphic createAddtlInfoGraphic(String string) {
        AddtlInfoGraphic addtlInfoGraphic = null;
        LogSystem.log(1, "Creating AdditionalInfoGraphic for :" + string);
        if (string != null && string.length() < 50) {
            addtlInfoGraphic = new AddtlInfoGraphic(Counter.getCounter(LogSystem.getInstance(), "GRAPHICIND"));
            if (AddtlInfoImporter.saveGraphicToDatabase(addtlInfoGraphic.getGraphicInd(), string)) {
                addtlInfoGraphic.setFilename(string);
                addtlInfoGraphic.setDocClass((TypeDocClassRec)TypeList.getInstance().objectFromInd(3, 5));
                addtlInfoGraphic.setLanguage((TypeLanguageRec)TypeList.getInstance().objectFromInd(PropertySystem.getInt(1), 8));
            } else {
                addtlInfoGraphic = null;
            }
        } else {
            GUISystem.printBox(Str.getStr(7), Str.getStr(1309) + string);
        }
        return addtlInfoGraphic;
    }

    private static boolean saveGraphicToDatabase(int n, String string) {
        SQLMethod sQLMethod = new SQLMethod(1, "saveGraphicToDatabase", 5);
        boolean bl = false;
        LogSystem.log(1, "Saving graphic to database. Graphic Ind:" + n + "  Filename:" + string);
        try {
            Statement statement = sQLMethod.createStatement();
            if (statement != null) {
                statement.executeUpdate("INSERT INTO TIGRIS.GRAPHICS " + "( GRAPHICIND, GRAPHICNAME,    FILENAME, " + "  VIEWIND,    GRAPHICTYPEIND, DBUSER,   " + "  CHANGEDTIME ) values " + "( " + n + ", " + "  'Avalon Graphic'" + ", " + "  '" + string + "', " + "  0, " + "  1, " + "  '" + UserSystem.getUserId() + "', " + "  CURRENT TIMESTAMP )");
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            sQLMethod.rollBack();
            LogSystem.log(1, sQLException, false);
            GUISystem.printBox(Str.getStr(7), Str.getStr(1308) + string);
            bl = false;
        }
        sQLMethod.close();
        return bl;
    }
}

