/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.base;

import com.ibm.nzna.projects.common.quest.oa.ExternalLink;
import com.ibm.nzna.projects.common.quest.oa.Link;
import com.ibm.nzna.projects.common.quest.oa.QuestLink;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.DisplayRec;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.avalon.base.AvalonConst;
import com.ibm.nzna.projects.qit.avalon.base.OAObjectDisplayRec;
import com.ibm.nzna.projects.qit.avalon.base.OASort;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.sort.IQuickSort;
import com.ibm.nzna.shared.util.CDate;
import java.io.Serializable;
import java.util.Vector;

public class LinkDisplayRec
extends OAObjectDisplayRec
implements IQuickSort,
OASort,
DisplayRec,
MultiListRow,
Serializable,
AvalonConst,
AppConst {
    static final long serialVersionUID = 1000000L;
    private int linkInd = 0;
    private int linkTypeInd = 0;
    private int docInd = 0;
    private int docClassInd = 0;
    private boolean valid = false;
    private Object linkObject = null;
    private String title = null;
    private String docFilename = null;
    private String URL = null;
    private String dbUser = null;
    private String changedTime = null;
    private String prettyCreated = null;
    private String prettyChangedTime = null;
    private String prettyDBUser = null;
    private int sortOn = 0;

    public Object getColumnData(int n) {
        Object object = null;
        switch (n) {
            case 0: {
                object = "";
                break;
            }
            case 1: {
                object = this.valid ? ImageSystem.getImage((Object)MainWindow.getInstance(), 104) : ImageSystem.getImage((Object)MainWindow.getInstance(), 102);
                break;
            }
            case 2: {
                object = "" + this.linkInd;
                break;
            }
            case 3: {
                if (this.getTitleArray() == null) {
                    this.createTitleArray(this.title);
                }
                object = this.getTitleArray();
                break;
            }
            case 4: {
                if (this.prettyChangedTime == null) {
                    this.prettyChangedTime = DateSystem.prettyDateFromStamp(this.changedTime);
                }
                object = this.prettyChangedTime;
                break;
            }
            case 5: {
                if (this.prettyDBUser == null) {
                    this.prettyDBUser = UserSystem.getNameFromUserId(this.dbUser);
                }
                object = this.prettyDBUser;
                break;
            }
            case 6: {
                if (this.URL != null) {
                    object = this.URL;
                    break;
                }
                object = this.docFilename;
                break;
            }
            default: {
                object = "";
                break;
            }
        }
        return object;
    }

    public String toString() {
        return this.title;
    }

    public Object getData() {
        return this.linkObject;
    }

    public int getLinkInd() {
        return this.linkInd;
    }

    public static Vector convert(Vector vector) {
        int n = vector.size();
        Vector<LinkDisplayRec> vector2 = new Vector<LinkDisplayRec>(n);
        int n2 = 0;
        Object var4_4 = null;
        while (n2 < n) {
            Link link;
            var4_4 = vector.elementAt(n2);
            if (var4_4 instanceof ExternalLink) {
                link = var4_4;
                vector2.addElement(new LinkDisplayRec(link.getInd(), link.getLinkTitles().elementAt(0).toString(), ((ExternalLink)link).isUrlValid(), 0, 9, null, ((ExternalLink)link).getUrl(), link.getDbUser(), link.getChangedTime()));
            } else if (var4_4 instanceof QuestLink) {
                link = var4_4;
                vector2.addElement(new LinkDisplayRec(link.getInd(), link.getLinkTitles().elementAt(0).toString(), true, ((QuestLink)link).getDocInd(), 9, ((QuestLink)link).getLNDocId(), null, link.getDbUser(), link.getChangedTime()));
            }
            ++n2;
        }
        return vector2;
    }

    public int getLinkType() {
        return this.linkTypeInd;
    }

    public int compareTo(IQuickSort iQuickSort) {
        int n = 0;
        if (iQuickSort instanceof LinkDisplayRec) {
            LinkDisplayRec linkDisplayRec = (LinkDisplayRec)iQuickSort;
            switch (this.sortOn) {
                case 1: {
                    n = CDate.compareDate(this.changedTime, linkDisplayRec.changedTime, 1);
                    break;
                }
                case 2: {
                    n = CDate.compareDate(linkDisplayRec.changedTime, this.changedTime, 1);
                    break;
                }
                case 3: {
                    n = this.title.compareTo(linkDisplayRec.title);
                    break;
                }
                case 4: {
                    n = linkDisplayRec.title.compareTo(this.title);
                    break;
                }
                case 8: {
                    n = this.dbUser.compareTo(linkDisplayRec.dbUser);
                    break;
                }
                case 9: {
                    n = linkDisplayRec.dbUser.compareTo(this.dbUser);
                    break;
                }
                case 5: {
                    n = 0;
                    break;
                }
                case 6: {
                    if (this.linkInd < linkDisplayRec.linkInd) {
                        n = -1;
                        break;
                    }
                    if (this.linkInd > linkDisplayRec.linkInd) {
                        n = 1;
                        break;
                    }
                    n = 0;
                    break;
                }
                case 7: {
                    if (this.linkInd < linkDisplayRec.linkInd) {
                        n = 1;
                        break;
                    }
                    if (this.linkInd > linkDisplayRec.linkInd) {
                        n = -1;
                        break;
                    }
                    n = 0;
                    break;
                }
            }
        }
        if (n > 0) {
            n = 1;
        } else if (n < 0) {
            n = -1;
        }
        return n;
    }

    public void setSort(int n) {
        this.sortOn = n;
    }

    public Vector getChildren() {
        return null;
    }

    public boolean containsChildren() {
        return false;
    }

    public void addChild(DisplayRec displayRec) {
    }

    public void removeChild(DisplayRec displayRec) {
    }

    public int getDocInd() {
        return this.docInd;
    }

    public String getTitle() {
        return this.title;
    }

    public LinkDisplayRec(int n, String string, boolean bl, int n2, int n3, String string2, String string3, String string4, String string5) {
        this.valid = bl;
        this.title = string;
        this.linkInd = n;
        this.linkTypeInd = n2;
        this.docInd = n3;
        this.docFilename = string2;
        this.URL = string3;
        this.dbUser = string4;
        this.changedTime = string5;
        this.docClassInd = this.docClassInd;
        this.linkObject = n2 == 0 ? new QuestLink(n) : new ExternalLink(n);
    }

    public LinkDisplayRec() {
    }
}

